-- This file is automatically generated, do not edit!
-- Path of Building
--
-- Active Dexterity skill gems
-- Skill data (c) Grinding Gear Games
--
local skills, mod, flag, skill = ...

skills["AnimateWeapon"] = {
	name = "Animate Weapon",
	color = 2,
	description = "Animates a melee weapon to fight by your side. You cannot animate unidentified weapons.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Duration] = true, [SkillType.Minion] = true, [SkillType.CreateMinion] = true, [SkillType.Spell] = true, [SkillType.SkillCanTotem] = true, [SkillType.CreatesMinion] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.AttackCanRepeat] = true, [SkillType.Type54] = true, [SkillType.SkillCanVolley] = true, [SkillType.Type56] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 0.8,
	minionHasItemSet = true,
	minionUses = {
		["Weapon 1"] = true,
	},
	minionList = {
		"AnimatedWeapon",
	},
	statMap = {
		["base_movement_velocity_+%"] = {
			mod("MinionModifier", "LIST", { mod = mod("MovementSpeed", "INC", nil) }),
		},
		["active_skill_damage_+%_final"] = {
			mod("MinionModifier", "LIST", { mod = mod("Damage", "MORE", nil) }),
		},
		["attack_speed_+%"] = {
			mod("MinionModifier", "LIST", { mod = mod("Speed", "INC", nil, ModFlag.Attack) }),
		},
		["attack_minimum_added_physical_damage"] = {
			mod("MinionModifier", "LIST", { mod = mod("PhysicalMin", "BASE", nil, 0, KeywordFlag.Attack) }),
		},
		["attack_maximum_added_physical_damage"] = {
			mod("MinionModifier", "LIST", { mod = mod("PhysicalMax", "BASE", nil, 0, KeywordFlag.Attack) }),
		},
	},
	baseFlags = {
		spell = true,
		minion = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "base_movement_velocity_+%", 2 },
	},
	stats = {
		"emerge_speed_+%",
		"animate_item_maximum_level_requirement",
		"active_skill_damage_+%_final",
		"attack_speed_+%",
		"base_skill_effect_duration",
		"attack_minimum_added_physical_damage",
		"attack_maximum_added_physical_damage",
		"number_of_animated_weapons_allowed",
	},
	levels = {
		[1] = { 0, 9, 0, 0, 37500, 4, 6, 50, manaCost = 7, levelRequirement = 4, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[2] = { 0, 11, 8, 2, 37500, 5, 8, 50, manaCost = 8, levelRequirement = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[3] = { 0, 14, 16, 4, 37500, 7, 10, 50, manaCost = 9, levelRequirement = 9, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[4] = { 0, 18, 24, 6, 37500, 8, 12, 50, manaCost = 9, levelRequirement = 12, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[5] = { 0, 22, 32, 8, 37500, 10, 15, 50, manaCost = 11, levelRequirement = 16, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[6] = { 0, 26, 40, 10, 37500, 12, 18, 50, manaCost = 12, levelRequirement = 20, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[7] = { 0, 31, 48, 12, 37500, 14, 21, 50, manaCost = 13, levelRequirement = 24, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[8] = { 0, 35, 56, 14, 37500, 17, 25, 50, manaCost = 14, levelRequirement = 28, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[9] = { 0, 40, 64, 16, 37500, 19, 29, 50, manaCost = 15, levelRequirement = 32, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[10] = { 0, 44, 72, 18, 37500, 22, 34, 50, manaCost = 16, levelRequirement = 36, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[11] = { 0, 49, 80, 20, 37500, 24, 37, 50, manaCost = 18, levelRequirement = 40, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[12] = { 0, 53, 88, 22, 37500, 26, 39, 50, manaCost = 19, levelRequirement = 44, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[13] = { 0, 58, 96, 24, 37500, 28, 41, 50, manaCost = 20, levelRequirement = 48, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[14] = { 0, 62, 104, 26, 37500, 29, 44, 50, manaCost = 21, levelRequirement = 52, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[15] = { 0, 66, 112, 28, 37500, 31, 46, 50, manaCost = 22, levelRequirement = 55, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[16] = { 0, 70, 120, 30, 37500, 32, 49, 50, manaCost = 23, levelRequirement = 58, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[17] = { 0, 74, 128, 32, 37500, 34, 51, 50, manaCost = 24, levelRequirement = 61, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[18] = { 0, 78, 136, 34, 37500, 36, 53, 50, manaCost = 25, levelRequirement = 64, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[19] = { 0, 82, 144, 36, 37500, 37, 55, 50, manaCost = 25, levelRequirement = 67, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[20] = { 0, 100, 152, 38, 37500, 38, 56, 50, manaCost = 26, levelRequirement = 70, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[21] = { 0, 100, 160, 40, 37500, 39, 58, 50, manaCost = 27, levelRequirement = 72, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[22] = { 0, 100, 168, 42, 37500, 40, 60, 50, manaCost = 27, levelRequirement = 74, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[23] = { 0, 100, 176, 44, 37500, 41, 61, 50, manaCost = 28, levelRequirement = 76, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[24] = { 0, 100, 184, 46, 37500, 42, 63, 50, manaCost = 29, levelRequirement = 78, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[25] = { 0, 100, 192, 48, 37500, 43, 64, 50, manaCost = 29, levelRequirement = 80, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[26] = { 0, 100, 200, 50, 37500, 44, 66, 50, manaCost = 30, levelRequirement = 82, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[27] = { 0, 100, 208, 52, 37500, 45, 67, 50, manaCost = 30, levelRequirement = 84, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[28] = { 0, 100, 216, 54, 37500, 46, 69, 50, manaCost = 31, levelRequirement = 86, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[29] = { 0, 100, 224, 56, 37500, 47, 71, 50, manaCost = 32, levelRequirement = 88, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[30] = { 0, 100, 232, 58, 37500, 48, 72, 50, manaCost = 32, levelRequirement = 90, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[31] = { 0, 100, 236, 59, 37500, 48, 73, 50, manaCost = 32, levelRequirement = 91, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[32] = { 0, 100, 240, 60, 37500, 49, 74, 50, manaCost = 33, levelRequirement = 92, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[33] = { 0, 100, 244, 61, 37500, 49, 75, 50, manaCost = 33, levelRequirement = 93, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[34] = { 0, 100, 248, 62, 37500, 50, 76, 50, manaCost = 33, levelRequirement = 94, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[35] = { 0, 100, 252, 63, 37500, 50, 76, 50, manaCost = 34, levelRequirement = 95, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[36] = { 0, 100, 256, 64, 37500, 51, 77, 50, manaCost = 34, levelRequirement = 96, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[37] = { 0, 100, 260, 65, 37500, 51, 78, 50, manaCost = 34, levelRequirement = 97, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[38] = { 0, 100, 264, 66, 37500, 52, 78, 50, manaCost = 34, levelRequirement = 98, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[39] = { 0, 100, 268, 67, 37500, 52, 79, 50, manaCost = 35, levelRequirement = 99, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[40] = { 0, 100, 272, 68, 37500, 53, 80, 50, manaCost = 35, levelRequirement = 100, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
	},
}
skills["ArcticArmour"] = {
	name = "Arctic Armour",
	color = 2,
	baseEffectiveness = 1,
	incrementalEffectiveness = 0.029999999329448,
	description = "Conjures an icy barrier that chills enemies when they hit you. You drop chilled ground while moving, and take less Fire and Physical damage while stationary.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.SkillCanTotem] = true, [SkillType.Duration] = true, [SkillType.ManaCostReserved] = true, [SkillType.Type27] = true, [SkillType.ColdSkill] = true, [SkillType.ManaCostPercent] = true, [SkillType.CauseElementalStatus] = true, [SkillType.Instant] = true, [SkillType.NonHitChill] = true, [SkillType.ChillingArea] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0,
	statMap = {
		["new_arctic_armour_physical_damage_taken_when_hit_+%_final"] = {
			mod("PhysicalDamageTakenWhenHit", "MORE", nil, 0, 0, { type = "Condition", var = "Stationary" }, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["new_arctic_armour_fire_damage_taken_when_hit_+%_final"] = {
			mod("FireDamageTakenWhenHit", "MORE", nil, 0, 0, { type = "Condition", var = "Stationary" }, { type = "GlobalEffect", effectType = "Buff" }),
		},
	},
	baseFlags = {
		spell = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "skill_effect_duration_+%", 1 },
	},
	stats = {
		"arctic_armour_chill_when_hit_duration",
		"new_arctic_armour_physical_damage_taken_when_hit_+%_final",
		"new_arctic_armour_fire_damage_taken_when_hit_+%_final",
		"base_skill_effect_duration",
	},
	levels = {
		[1] = { 500, -8, -8, 2500, cooldown = 1, levelRequirement = 16, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[2] = { 500, -8, -8, 2600, cooldown = 1, levelRequirement = 20, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[3] = { 500, -9, -8, 2700, cooldown = 1, levelRequirement = 24, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[4] = { 500, -9, -8, 2800, cooldown = 1, levelRequirement = 28, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[5] = { 500, -9, -9, 2900, cooldown = 1, levelRequirement = 31, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[6] = { 500, -9, -9, 3000, cooldown = 1, levelRequirement = 34, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[7] = { 500, -10, -9, 3100, cooldown = 1, levelRequirement = 37, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[8] = { 500, -10, -9, 3200, cooldown = 1, levelRequirement = 40, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[9] = { 500, -10, -10, 3300, cooldown = 1, levelRequirement = 43, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[10] = { 500, -10, -10, 3400, cooldown = 1, levelRequirement = 46, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[11] = { 500, -11, -10, 3500, cooldown = 1, levelRequirement = 49, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[12] = { 500, -11, -10, 3600, cooldown = 1, levelRequirement = 52, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[13] = { 500, -11, -11, 3700, cooldown = 1, levelRequirement = 55, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[14] = { 500, -11, -11, 3800, cooldown = 1, levelRequirement = 58, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[15] = { 500, -12, -11, 3900, cooldown = 1, levelRequirement = 60, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[16] = { 500, -12, -11, 4000, cooldown = 1, levelRequirement = 62, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[17] = { 500, -12, -12, 4100, cooldown = 1, levelRequirement = 64, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[18] = { 500, -12, -12, 4200, cooldown = 1, levelRequirement = 66, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[19] = { 500, -13, -12, 4300, cooldown = 1, levelRequirement = 68, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[20] = { 500, -13, -12, 4400, cooldown = 1, levelRequirement = 70, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[21] = { 500, -13, -13, 4500, cooldown = 1, levelRequirement = 72, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[22] = { 500, -13, -13, 4600, cooldown = 1, levelRequirement = 74, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[23] = { 500, -14, -13, 4700, cooldown = 1, levelRequirement = 76, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[24] = { 500, -14, -13, 4800, cooldown = 1, levelRequirement = 78, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[25] = { 500, -14, -14, 4900, cooldown = 1, levelRequirement = 80, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[26] = { 500, -14, -14, 5000, cooldown = 1, levelRequirement = 82, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[27] = { 500, -15, -14, 5100, cooldown = 1, levelRequirement = 84, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[28] = { 500, -15, -14, 5200, cooldown = 1, levelRequirement = 86, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[29] = { 500, -15, -15, 5300, cooldown = 1, levelRequirement = 88, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[30] = { 500, -15, -15, 5400, cooldown = 1, levelRequirement = 90, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[31] = { 500, -15, -15, 5450, cooldown = 1, levelRequirement = 91, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[32] = { 500, -16, -15, 5500, cooldown = 1, levelRequirement = 92, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[33] = { 500, -16, -15, 5550, cooldown = 1, levelRequirement = 93, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[34] = { 500, -16, -15, 5600, cooldown = 1, levelRequirement = 94, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[35] = { 500, -16, -15, 5650, cooldown = 1, levelRequirement = 95, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[36] = { 500, -16, -16, 5700, cooldown = 1, levelRequirement = 96, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[37] = { 500, -16, -16, 5750, cooldown = 1, levelRequirement = 97, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[38] = { 500, -16, -16, 5800, cooldown = 1, levelRequirement = 98, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[39] = { 500, -16, -16, 5850, cooldown = 1, levelRequirement = 99, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[40] = { 500, -17, -16, 5900, cooldown = 1, levelRequirement = 100, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
	},
}
skills["Barrage"] = {
	name = "Barrage",
	color = 2,
	description = "After a short preparation time, you attack repeatedly with a ranged weapon. These attacks have a small randomised spread. Only works with Bows and Wands.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.ProjectileAttack] = true, [SkillType.SkillCanMirageArcher] = true, [SkillType.Projectile] = true, [SkillType.SkillCanVolley] = true, [SkillType.SkillCanTotem] = true, [SkillType.SkillCanTrap] = true, [SkillType.SkillCanMine] = true, },
	weaponTypes = {
		["Wand"] = true,
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "1 Projectile",
		},
		{
			name = "All Projectiles",
		},
	},
	preDamageFunc = function(activeSkill, output)
		if activeSkill.skillPart == 2 then
			activeSkill.skillData.dpsMultiplier = output.ProjectileCount
		end
	end,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "projectile_damage_+%", 0.5 },
	},
	stats = {
		"number_of_additional_projectiles",
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
	},
	levels = {
		[1] = { 4, damageEffectiveness = 0.4, baseMultiplier = 0.4, levelRequirement = 12, manaCost = 7, statInterpolation = { 1, }, },
		[2] = { 4, damageEffectiveness = 0.4, baseMultiplier = 0.404, levelRequirement = 15, manaCost = 7, statInterpolation = { 1, }, },
		[3] = { 4, damageEffectiveness = 0.41, baseMultiplier = 0.408, levelRequirement = 19, manaCost = 7, statInterpolation = { 1, }, },
		[4] = { 4, damageEffectiveness = 0.41, baseMultiplier = 0.412, levelRequirement = 23, manaCost = 8, statInterpolation = { 1, }, },
		[5] = { 4, damageEffectiveness = 0.42, baseMultiplier = 0.416, levelRequirement = 27, manaCost = 8, statInterpolation = { 1, }, },
		[6] = { 4, damageEffectiveness = 0.42, baseMultiplier = 0.42, levelRequirement = 31, manaCost = 8, statInterpolation = { 1, }, },
		[7] = { 4, damageEffectiveness = 0.42, baseMultiplier = 0.424, levelRequirement = 35, manaCost = 8, statInterpolation = { 1, }, },
		[8] = { 4, damageEffectiveness = 0.43, baseMultiplier = 0.428, levelRequirement = 38, manaCost = 8, statInterpolation = { 1, }, },
		[9] = { 4, damageEffectiveness = 0.43, baseMultiplier = 0.432, levelRequirement = 41, manaCost = 9, statInterpolation = { 1, }, },
		[10] = { 4, damageEffectiveness = 0.44, baseMultiplier = 0.436, levelRequirement = 44, manaCost = 9, statInterpolation = { 1, }, },
		[11] = { 4, damageEffectiveness = 0.44, baseMultiplier = 0.44, levelRequirement = 47, manaCost = 9, statInterpolation = { 1, }, },
		[12] = { 4, damageEffectiveness = 0.44, baseMultiplier = 0.444, levelRequirement = 50, manaCost = 9, statInterpolation = { 1, }, },
		[13] = { 4, damageEffectiveness = 0.45, baseMultiplier = 0.448, levelRequirement = 53, manaCost = 9, statInterpolation = { 1, }, },
		[14] = { 4, damageEffectiveness = 0.45, baseMultiplier = 0.452, levelRequirement = 56, manaCost = 10, statInterpolation = { 1, }, },
		[15] = { 4, damageEffectiveness = 0.46, baseMultiplier = 0.456, levelRequirement = 59, manaCost = 10, statInterpolation = { 1, }, },
		[16] = { 4, damageEffectiveness = 0.46, baseMultiplier = 0.46, levelRequirement = 62, manaCost = 10, statInterpolation = { 1, }, },
		[17] = { 4, damageEffectiveness = 0.46, baseMultiplier = 0.464, levelRequirement = 64, manaCost = 10, statInterpolation = { 1, }, },
		[18] = { 4, damageEffectiveness = 0.47, baseMultiplier = 0.468, levelRequirement = 66, manaCost = 10, statInterpolation = { 1, }, },
		[19] = { 4, damageEffectiveness = 0.47, baseMultiplier = 0.472, levelRequirement = 68, manaCost = 11, statInterpolation = { 1, }, },
		[20] = { 4, damageEffectiveness = 0.48, baseMultiplier = 0.476, levelRequirement = 70, manaCost = 11, statInterpolation = { 1, }, },
		[21] = { 4, damageEffectiveness = 0.48, baseMultiplier = 0.48, levelRequirement = 72, manaCost = 11, statInterpolation = { 1, }, },
		[22] = { 4, damageEffectiveness = 0.48, baseMultiplier = 0.484, levelRequirement = 74, manaCost = 11, statInterpolation = { 1, }, },
		[23] = { 4, damageEffectiveness = 0.49, baseMultiplier = 0.488, levelRequirement = 76, manaCost = 11, statInterpolation = { 1, }, },
		[24] = { 4, damageEffectiveness = 0.49, baseMultiplier = 0.492, levelRequirement = 78, manaCost = 11, statInterpolation = { 1, }, },
		[25] = { 4, damageEffectiveness = 0.5, baseMultiplier = 0.496, levelRequirement = 80, manaCost = 11, statInterpolation = { 1, }, },
		[26] = { 4, damageEffectiveness = 0.5, baseMultiplier = 0.5, levelRequirement = 82, manaCost = 12, statInterpolation = { 1, }, },
		[27] = { 4, damageEffectiveness = 0.5, baseMultiplier = 0.504, levelRequirement = 84, manaCost = 12, statInterpolation = { 1, }, },
		[28] = { 4, damageEffectiveness = 0.51, baseMultiplier = 0.508, levelRequirement = 86, manaCost = 12, statInterpolation = { 1, }, },
		[29] = { 4, damageEffectiveness = 0.51, baseMultiplier = 0.512, levelRequirement = 88, manaCost = 12, statInterpolation = { 1, }, },
		[30] = { 4, damageEffectiveness = 0.52, baseMultiplier = 0.516, levelRequirement = 90, manaCost = 12, statInterpolation = { 1, }, },
		[31] = { 4, damageEffectiveness = 0.52, baseMultiplier = 0.518, levelRequirement = 91, manaCost = 13, statInterpolation = { 1, }, },
		[32] = { 4, damageEffectiveness = 0.52, baseMultiplier = 0.52, levelRequirement = 92, manaCost = 13, statInterpolation = { 1, }, },
		[33] = { 4, damageEffectiveness = 0.52, baseMultiplier = 0.522, levelRequirement = 93, manaCost = 13, statInterpolation = { 1, }, },
		[34] = { 4, damageEffectiveness = 0.52, baseMultiplier = 0.524, levelRequirement = 94, manaCost = 13, statInterpolation = { 1, }, },
		[35] = { 4, damageEffectiveness = 0.53, baseMultiplier = 0.526, levelRequirement = 95, manaCost = 13, statInterpolation = { 1, }, },
		[36] = { 4, damageEffectiveness = 0.53, baseMultiplier = 0.528, levelRequirement = 96, manaCost = 14, statInterpolation = { 1, }, },
		[37] = { 4, damageEffectiveness = 0.53, baseMultiplier = 0.53, levelRequirement = 97, manaCost = 14, statInterpolation = { 1, }, },
		[38] = { 4, damageEffectiveness = 0.53, baseMultiplier = 0.532, levelRequirement = 98, manaCost = 14, statInterpolation = { 1, }, },
		[39] = { 4, damageEffectiveness = 0.53, baseMultiplier = 0.534, levelRequirement = 99, manaCost = 14, statInterpolation = { 1, }, },
		[40] = { 4, damageEffectiveness = 0.54, baseMultiplier = 0.536, levelRequirement = 100, manaCost = 14, statInterpolation = { 1, }, },
	},
}
skills["BearTrap"] = {
	name = "Bear Trap",
	color = 2,
	baseEffectiveness = 2.8499999046326,
	incrementalEffectiveness = 0.042500000447035,
	description = "Throws a trap that damages and immobilises a single enemy for a duration based on how much damage was dealt. After the immobilise expires, a debuff remains on the enemy for a duration, lowering their movement speed by an amount which lessens over time. The affected enemy will take increased damage from traps and mines until the debuff expires. Modifiers to spell damage do not affect this skill's damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Duration] = true, [SkillType.SkillCanMine] = true, [SkillType.Trap] = true, [SkillType.Hit] = true, [SkillType.PhysicalSkill] = true, },
	statDescriptionScope = "debuff_skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["bear_trap_damage_taken_+%_from_traps_and_mines"] = {
			mod("TrapMineDamageTaken", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Debuff" }),
		},
	},
	baseFlags = {
		cast = true,
		trap = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "physical_damage_+%", 1 },
	},
	stats = {
		"is_trap",
		"base_trap_duration",
		"trap_override_pvp_scaling_time_ms",
		"secondary_minimum_base_physical_damage",
		"secondary_maximum_base_physical_damage",
		"bear_trap_damage_taken_+%_from_traps_and_mines",
		"bear_trap_movement_speed_+%_final",
		"base_skill_effect_duration",
		"base_skill_is_trapped",
		"display_skill_deals_secondary_damage",
		"base_skill_show_average_damage_instead_of_dps",
		"no_movement_speed",
		"traps_do_not_explode_on_timeout",
	},
	levels = {
		[1] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 6, damageEffectiveness = 2, cooldown = 4, levelRequirement = 4, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[2] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 7, damageEffectiveness = 2, cooldown = 4, levelRequirement = 6, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[3] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 7, damageEffectiveness = 2, cooldown = 4, levelRequirement = 9, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[4] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 8, damageEffectiveness = 2, cooldown = 4, levelRequirement = 12, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[5] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 9, damageEffectiveness = 2, cooldown = 4, levelRequirement = 16, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[6] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 11, damageEffectiveness = 2, cooldown = 4, levelRequirement = 20, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[7] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 12, damageEffectiveness = 2, cooldown = 4, levelRequirement = 24, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[8] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 13, damageEffectiveness = 2, cooldown = 4, levelRequirement = 28, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[9] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 14, damageEffectiveness = 2, cooldown = 4, levelRequirement = 32, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[10] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 16, damageEffectiveness = 2, cooldown = 4, levelRequirement = 36, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[11] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 17, damageEffectiveness = 2, cooldown = 4, levelRequirement = 40, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[12] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 19, damageEffectiveness = 2, cooldown = 4, levelRequirement = 44, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[13] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 20, damageEffectiveness = 2, cooldown = 4, levelRequirement = 48, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[14] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 20, damageEffectiveness = 2, cooldown = 4, levelRequirement = 52, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[15] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 21, damageEffectiveness = 2, cooldown = 4, levelRequirement = 55, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[16] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 22, damageEffectiveness = 2, cooldown = 4, levelRequirement = 58, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[17] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 23, damageEffectiveness = 2, cooldown = 4, levelRequirement = 61, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[18] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 23, damageEffectiveness = 2, cooldown = 4, levelRequirement = 64, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[19] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 23, damageEffectiveness = 2, cooldown = 4, levelRequirement = 67, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[20] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 23, damageEffectiveness = 2, cooldown = 4, levelRequirement = 70, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[21] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 24, damageEffectiveness = 2, cooldown = 4, levelRequirement = 72, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[22] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 25, damageEffectiveness = 2, cooldown = 4, levelRequirement = 74, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[23] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 25, damageEffectiveness = 2, cooldown = 4, levelRequirement = 76, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[24] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 25, damageEffectiveness = 2, cooldown = 4, levelRequirement = 78, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[25] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 25, damageEffectiveness = 2, cooldown = 4, levelRequirement = 80, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[26] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 26, damageEffectiveness = 2, cooldown = 4, levelRequirement = 82, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[27] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 27, damageEffectiveness = 2, cooldown = 4, levelRequirement = 84, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[28] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 27, damageEffectiveness = 2, cooldown = 4, levelRequirement = 86, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[29] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 27, damageEffectiveness = 2, cooldown = 4, levelRequirement = 88, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[30] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 28, damageEffectiveness = 2, cooldown = 4, levelRequirement = 90, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[31] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 29, damageEffectiveness = 2, cooldown = 4, levelRequirement = 91, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[32] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 29, damageEffectiveness = 2, cooldown = 4, levelRequirement = 92, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[33] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 29, damageEffectiveness = 2, cooldown = 4, levelRequirement = 93, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[34] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 29, damageEffectiveness = 2, cooldown = 4, levelRequirement = 94, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[35] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 30, damageEffectiveness = 2, cooldown = 4, levelRequirement = 95, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[36] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 31, damageEffectiveness = 2, cooldown = 4, levelRequirement = 96, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[37] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 31, damageEffectiveness = 2, cooldown = 4, levelRequirement = 97, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[38] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 31, damageEffectiveness = 2, cooldown = 4, levelRequirement = 98, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[39] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 32, damageEffectiveness = 2, cooldown = 4, levelRequirement = 99, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[40] = { 1, 4000, 750, 1, 1.3999999761581, 15, -80, 3000, critChance = 6, manaCost = 33, damageEffectiveness = 2, cooldown = 4, levelRequirement = 100, statInterpolation = { 1, 1, 1, 3, 3, 1, 1, 1, }, },
	},
}
skills["ChargedAttack"] = {
	name = "Blade Flurry",
	color = 2,
	baseEffectiveness = 0.6700000166893,
	incrementalEffectiveness = 0.023299999535084,
	description = "Repeatedly hit enemies in a circle in front of you while channelling, dealing damage to and around the enemy. The damage is continually boosted while channelling. You unleash an additional hit for each stage reached once the channelling ends. Requires a Dagger, Claw or One-Handed Sword.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Channelled] = true, [SkillType.Melee] = true, [SkillType.PhysicalSkill] = true, },
	weaponTypes = {
		["Thrusting One Handed Sword"] = true,
		["One Handed Sword"] = true,
		["Dagger"] = true,
		["Claw"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "1 Stage",
		},
		{
			name = "6 Stages",
		},
		{
			name = "Release at 6 Stages",
		},
	},
	statMap = {
		["base_skill_show_average_damage_instead_of_dps"] = {
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("radius", 14),
		mod("Damage", "MORE", 120, 0, bit.bor(KeywordFlag.Hit, KeywordFlag.Ailment), { type = "SkillPart", skillPart = 2 }),
		skill("dpsMultiplier", 3, { type = "SkillPart", skillPart = 3 }),
	},
	qualityStats = {
		{ "attack_speed_+%", 0.5 },
	},
	stats = {
		"charged_attack_damage_per_stack_+%_final",
		"attack_minimum_added_physical_damage",
		"attack_maximum_added_physical_damage",
		"is_area_damage",
		"base_skill_show_average_damage_instead_of_dps",
		"skill_can_add_multiple_charges_per_action",
	},
	levels = {
		[1] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.32, manaCost = 4, damageEffectiveness = 0.32, attackSpeedMultiplier = 60, levelRequirement = 28, statInterpolation = { 1, 3, 3, }, },
		[2] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.327, manaCost = 4, damageEffectiveness = 0.33, attackSpeedMultiplier = 60, levelRequirement = 31, statInterpolation = { 1, 3, 3, }, },
		[3] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.334, manaCost = 4, damageEffectiveness = 0.33, attackSpeedMultiplier = 60, levelRequirement = 34, statInterpolation = { 1, 3, 3, }, },
		[4] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.341, manaCost = 4, damageEffectiveness = 0.34, attackSpeedMultiplier = 60, levelRequirement = 37, statInterpolation = { 1, 3, 3, }, },
		[5] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.347, manaCost = 4, damageEffectiveness = 0.35, attackSpeedMultiplier = 60, levelRequirement = 40, statInterpolation = { 1, 3, 3, }, },
		[6] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.354, manaCost = 4, damageEffectiveness = 0.35, attackSpeedMultiplier = 60, levelRequirement = 42, statInterpolation = { 1, 3, 3, }, },
		[7] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.361, manaCost = 4, damageEffectiveness = 0.36, attackSpeedMultiplier = 60, levelRequirement = 44, statInterpolation = { 1, 3, 3, }, },
		[8] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.368, manaCost = 4, damageEffectiveness = 0.37, attackSpeedMultiplier = 60, levelRequirement = 46, statInterpolation = { 1, 3, 3, }, },
		[9] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.375, manaCost = 4, damageEffectiveness = 0.37, attackSpeedMultiplier = 60, levelRequirement = 48, statInterpolation = { 1, 3, 3, }, },
		[10] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.382, manaCost = 4, damageEffectiveness = 0.38, attackSpeedMultiplier = 60, levelRequirement = 50, statInterpolation = { 1, 3, 3, }, },
		[11] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.388, manaCost = 4, damageEffectiveness = 0.39, attackSpeedMultiplier = 60, levelRequirement = 52, statInterpolation = { 1, 3, 3, }, },
		[12] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.395, manaCost = 4, damageEffectiveness = 0.4, attackSpeedMultiplier = 60, levelRequirement = 54, statInterpolation = { 1, 3, 3, }, },
		[13] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.402, manaCost = 4, damageEffectiveness = 0.4, attackSpeedMultiplier = 60, levelRequirement = 56, statInterpolation = { 1, 3, 3, }, },
		[14] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.409, manaCost = 4, damageEffectiveness = 0.41, attackSpeedMultiplier = 60, levelRequirement = 58, statInterpolation = { 1, 3, 3, }, },
		[15] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.416, manaCost = 4, damageEffectiveness = 0.42, attackSpeedMultiplier = 60, levelRequirement = 60, statInterpolation = { 1, 3, 3, }, },
		[16] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.423, manaCost = 4, damageEffectiveness = 0.42, attackSpeedMultiplier = 60, levelRequirement = 62, statInterpolation = { 1, 3, 3, }, },
		[17] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.429, manaCost = 4, damageEffectiveness = 0.43, attackSpeedMultiplier = 60, levelRequirement = 64, statInterpolation = { 1, 3, 3, }, },
		[18] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.436, manaCost = 4, damageEffectiveness = 0.44, attackSpeedMultiplier = 60, levelRequirement = 66, statInterpolation = { 1, 3, 3, }, },
		[19] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.443, manaCost = 4, damageEffectiveness = 0.44, attackSpeedMultiplier = 60, levelRequirement = 68, statInterpolation = { 1, 3, 3, }, },
		[20] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.45, manaCost = 4, damageEffectiveness = 0.45, attackSpeedMultiplier = 60, levelRequirement = 70, statInterpolation = { 1, 3, 3, }, },
		[21] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.457, manaCost = 4, damageEffectiveness = 0.46, attackSpeedMultiplier = 60, levelRequirement = 72, statInterpolation = { 1, 3, 3, }, },
		[22] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.464, manaCost = 4, damageEffectiveness = 0.46, attackSpeedMultiplier = 60, levelRequirement = 74, statInterpolation = { 1, 3, 3, }, },
		[23] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.471, manaCost = 4, damageEffectiveness = 0.47, attackSpeedMultiplier = 60, levelRequirement = 76, statInterpolation = { 1, 3, 3, }, },
		[24] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.477, manaCost = 4, damageEffectiveness = 0.48, attackSpeedMultiplier = 60, levelRequirement = 78, statInterpolation = { 1, 3, 3, }, },
		[25] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.484, manaCost = 4, damageEffectiveness = 0.48, attackSpeedMultiplier = 60, levelRequirement = 80, statInterpolation = { 1, 3, 3, }, },
		[26] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.491, manaCost = 4, damageEffectiveness = 0.49, attackSpeedMultiplier = 60, levelRequirement = 82, statInterpolation = { 1, 3, 3, }, },
		[27] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.498, manaCost = 4, damageEffectiveness = 0.5, attackSpeedMultiplier = 60, levelRequirement = 84, statInterpolation = { 1, 3, 3, }, },
		[28] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.505, manaCost = 4, damageEffectiveness = 0.5, attackSpeedMultiplier = 60, levelRequirement = 86, statInterpolation = { 1, 3, 3, }, },
		[29] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.512, manaCost = 4, damageEffectiveness = 0.51, attackSpeedMultiplier = 60, levelRequirement = 88, statInterpolation = { 1, 3, 3, }, },
		[30] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.518, manaCost = 4, damageEffectiveness = 0.52, attackSpeedMultiplier = 60, levelRequirement = 90, statInterpolation = { 1, 3, 3, }, },
		[31] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.522, manaCost = 4, damageEffectiveness = 0.52, attackSpeedMultiplier = 60, levelRequirement = 91, statInterpolation = { 1, 3, 3, }, },
		[32] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.525, manaCost = 4, damageEffectiveness = 0.53, attackSpeedMultiplier = 60, levelRequirement = 92, statInterpolation = { 1, 3, 3, }, },
		[33] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.529, manaCost = 4, damageEffectiveness = 0.53, attackSpeedMultiplier = 60, levelRequirement = 93, statInterpolation = { 1, 3, 3, }, },
		[34] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.532, manaCost = 4, damageEffectiveness = 0.53, attackSpeedMultiplier = 60, levelRequirement = 94, statInterpolation = { 1, 3, 3, }, },
		[35] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.536, manaCost = 4, damageEffectiveness = 0.54, attackSpeedMultiplier = 60, levelRequirement = 95, statInterpolation = { 1, 3, 3, }, },
		[36] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.539, manaCost = 4, damageEffectiveness = 0.54, attackSpeedMultiplier = 60, levelRequirement = 96, statInterpolation = { 1, 3, 3, }, },
		[37] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.542, manaCost = 4, damageEffectiveness = 0.54, attackSpeedMultiplier = 60, levelRequirement = 97, statInterpolation = { 1, 3, 3, }, },
		[38] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.546, manaCost = 4, damageEffectiveness = 0.55, attackSpeedMultiplier = 60, levelRequirement = 98, statInterpolation = { 1, 3, 3, }, },
		[39] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.549, manaCost = 4, damageEffectiveness = 0.55, attackSpeedMultiplier = 60, levelRequirement = 99, statInterpolation = { 1, 3, 3, }, },
		[40] = { 20, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.553, manaCost = 4, damageEffectiveness = 0.55, attackSpeedMultiplier = 60, levelRequirement = 100, statInterpolation = { 1, 3, 3, }, },
	},
}
skills["BladeVortex"] = {
	name = "Blade Vortex",
	color = 2,
	baseEffectiveness = 0.32150000333786,
	incrementalEffectiveness = 0.038600001484156,
	description = "This spell creates ethereal blades which orbit in an area around you, dealing damage every 0.6 seconds to all enemies in their radius. As more blades are added, the damage becomes greater and more frequent.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Hit] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.SkillCanTotem] = true, [SkillType.SpellCanRepeat] = true, [SkillType.Triggerable] = true, [SkillType.Type27] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.PhysicalSkill] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.5,
	parts = {
		{
			name = "0 Blades",
		},
		{
			name = "5 Blades",
		},
		{
			name = "10 Blades",
		},
	},
	statMap = {
		["blade_vortex_damage_+%_per_blade_final"] = {
			mod("Damage", "MORE", nil, 0, bit.bor(KeywordFlag.Hit, KeywordFlag.Ailment), { type = "Multiplier", var = "BladeVortexBlade" }),
		},
		["blade_vortex_ailment_damage_+%_per_blade_final"] = {
			mod("Damage", "MORE", nil, 0, KeywordFlag.Ailment, { type = "Multiplier", var = "BladeVortexBlade" }),
		},
		["blade_vortex_critical_strike_chance_+%_per_blade"] = {
			mod("CritChance", "INC", nil, 0, 0, { type = "Multiplier", var = "BladeVortexBlade" }),
		},
		["base_skill_show_average_damage_instead_of_dps"] = {
		},
	},
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 15),
		mod("Multiplier:BladeVortexBlade", "BASE", 5, 0, 0, { type = "SkillPart", skillPart = 2 }),
		mod("Multiplier:BladeVortexBlade", "BASE", 10, 0, 0, { type = "SkillPart", skillPart = 3 }),
		skill("hitTimeOverride", 0.6, { type = "SkillPart", skillPart = 1 }),
		skill("hitTimeOverride", 0.6 / (1+5*0.35), { type = "SkillPart", skillPart = 2 }),
		skill("hitTimeOverride", 0.6 / (1+10*0.35), { type = "SkillPart", skillPart = 3 }),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 0.5 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_skill_effect_duration",
		"maximum_number_of_spinning_blades",
		"blade_vortex_critical_strike_chance_+%_per_blade",
		"blade_vortex_hit_rate_+%_per_blade",
		"blade_vortex_damage_+%_per_blade_final",
		"active_skill_base_radius_+",
		"is_area_damage",
		"skill_can_add_multiple_charges_per_action",
		"action_ignores_crit_tracking",
		"base_skill_show_average_damage_instead_of_dps",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 0, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 12, manaCost = 6, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[2] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 0, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 15, manaCost = 6, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[3] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 0, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 19, manaCost = 7, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[4] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 0, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 23, manaCost = 8, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[5] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 1, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 27, manaCost = 9, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[6] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 1, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 31, manaCost = 9, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[7] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 1, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 35, manaCost = 10, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[8] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 1, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 38, manaCost = 11, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[9] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 1, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 41, manaCost = 11, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[10] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 2, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 44, manaCost = 12, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[11] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 2, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 47, manaCost = 12, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[12] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 2, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 50, manaCost = 13, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[13] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 2, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 53, manaCost = 13, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[14] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 2, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 56, manaCost = 14, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[15] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 3, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 59, manaCost = 14, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[16] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 3, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 62, manaCost = 15, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[17] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 3, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 64, manaCost = 15, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[18] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 3, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 66, manaCost = 16, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[19] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 3, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 68, manaCost = 16, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 4, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 70, manaCost = 16, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 4, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 72, manaCost = 17, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 4, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 74, manaCost = 17, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 4, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 76, manaCost = 18, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 4, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 78, manaCost = 18, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 5, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 80, manaCost = 18, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 5, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 82, manaCost = 19, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 5, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 84, manaCost = 19, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 5, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 86, manaCost = 19, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 5, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 88, manaCost = 20, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 6, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 90, manaCost = 20, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 6, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 91, manaCost = 20, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 6, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 92, manaCost = 20, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 6, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 93, manaCost = 21, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[34] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 6, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 94, manaCost = 21, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[35] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 6, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 95, manaCost = 21, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[36] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 6, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 96, manaCost = 21, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[37] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 6, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 97, manaCost = 21, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[38] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 6, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 98, manaCost = 22, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[39] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 6, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 99, manaCost = 22, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[40] = { 0.80000001192093, 1.2000000476837, 5000, 10, 10, 35, 35, 7, damageEffectiveness = 0.25, critChance = 6, levelRequirement = 100, manaCost = 22, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
	},
}
skills["VaalBladeVortex"] = {
	name = "Vaal Blade Vortex",
	color = 2,
	baseEffectiveness = 1.5,
	incrementalEffectiveness = 0.033300001174212,
	description = "Creates an independently-moving vortex of ethereal blades which lasts for a duration. The vortex moves toward nearby enemies, repeatedly damaging enemies that it passes through.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Hit] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.SkillCanTotem] = true, [SkillType.Type27] = true, [SkillType.Vaal] = true, [SkillType.AreaSpell] = true, [SkillType.PhysicalSkill] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.8,
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("hitTimeOverride", 0.133),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 0.5 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_skill_effect_duration",
		"extra_gore_chance_override_%",
		"active_skill_base_radius_+",
		"base_blade_vortex_hit_rate_ms",
		"critical_strike_chance_+%",
		"is_area_damage",
		"skill_can_add_multiple_charges_per_action",
		"vaal_blade_vortex_has_10_spinning_blades",
		"modifiers_to_skill_effect_duration_also_affect_soul_prevention_duration",
		"cannot_cancel_skill_before_contact_point",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 3000, 15, 8, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 12, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[2] = { 0.80000001192093, 1.2000000476837, 3000, 15, 8, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 15, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[3] = { 0.80000001192093, 1.2000000476837, 3000, 15, 8, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 19, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[4] = { 0.80000001192093, 1.2000000476837, 3000, 15, 8, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 23, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[5] = { 0.80000001192093, 1.2000000476837, 3000, 15, 9, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 27, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[6] = { 0.80000001192093, 1.2000000476837, 3000, 15, 9, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 31, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[7] = { 0.80000001192093, 1.2000000476837, 3000, 15, 9, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 35, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[8] = { 0.80000001192093, 1.2000000476837, 3000, 15, 9, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 38, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[9] = { 0.80000001192093, 1.2000000476837, 3000, 15, 10, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 41, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[10] = { 0.80000001192093, 1.2000000476837, 3000, 15, 10, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 44, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[11] = { 0.80000001192093, 1.2000000476837, 3000, 15, 10, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 47, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[12] = { 0.80000001192093, 1.2000000476837, 3000, 15, 10, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 50, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[13] = { 0.80000001192093, 1.2000000476837, 3000, 15, 11, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 53, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[14] = { 0.80000001192093, 1.2000000476837, 3000, 15, 11, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 56, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[15] = { 0.80000001192093, 1.2000000476837, 3000, 15, 11, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 59, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[16] = { 0.80000001192093, 1.2000000476837, 3000, 15, 11, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 62, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[17] = { 0.80000001192093, 1.2000000476837, 3000, 15, 12, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 64, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[18] = { 0.80000001192093, 1.2000000476837, 3000, 15, 12, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 66, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[19] = { 0.80000001192093, 1.2000000476837, 3000, 15, 12, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 68, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 3000, 15, 12, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 70, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 3000, 15, 13, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 72, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 3000, 15, 13, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 74, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 3000, 15, 13, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 76, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 3000, 15, 13, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 78, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 3000, 15, 14, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 80, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 3000, 15, 14, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 82, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 3000, 15, 14, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 84, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 3000, 15, 14, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 86, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 3000, 15, 15, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 88, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 3000, 15, 15, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 90, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 3000, 15, 15, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 91, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 3000, 15, 15, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 92, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 3000, 15, 15, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 93, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[34] = { 0.80000001192093, 1.2000000476837, 3000, 15, 15, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 94, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[35] = { 0.80000001192093, 1.2000000476837, 3000, 15, 15, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 95, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[36] = { 0.80000001192093, 1.2000000476837, 3000, 15, 16, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 96, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[37] = { 0.80000001192093, 1.2000000476837, 3000, 15, 16, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 97, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[38] = { 0.80000001192093, 1.2000000476837, 3000, 15, 16, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 98, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[39] = { 0.80000001192093, 1.2000000476837, 3000, 15, 16, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 99, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[40] = { 0.80000001192093, 1.2000000476837, 3000, 15, 16, 133, 100, damageEffectiveness = 0.75, critChance = 6, levelRequirement = 100, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
	},
}
skills["Bladefall"] = {
	name = "Bladefall",
	color = 2,
	baseEffectiveness = 1.5471999645233,
	incrementalEffectiveness = 0.036100000143051,
	description = "Ethereal weapons rain from the sky, dealing damage to enemies in a sequence of volleys, each wider but less damaging than the last. Enemies can be hit multiple times where these overlap.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.SkillCanTrap] = true, [SkillType.SkillCanMine] = true, [SkillType.SkillCanTotem] = true, [SkillType.Hit] = true, [SkillType.Triggerable] = true, [SkillType.SpellCanRepeat] = true, [SkillType.SpellCanCascade] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.PhysicalSkill] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.7,
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 0.5 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"bladefall_damage_per_stage_+%_final",
		"critical_strike_chance_+%",
		"bladefall_critical_strike_chance_+%_per_stage",
		"bladefall_number_of_volleys",
		"is_area_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 28, manaCost = 12, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[2] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 31, manaCost = 13, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[3] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 34, manaCost = 14, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[4] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 37, manaCost = 15, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[5] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 40, manaCost = 15, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[6] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 42, manaCost = 16, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[7] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 44, manaCost = 16, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[8] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 46, manaCost = 17, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[9] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 48, manaCost = 17, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[10] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 50, manaCost = 18, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[11] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 52, manaCost = 18, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[12] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 54, manaCost = 19, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[13] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 56, manaCost = 19, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[14] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 58, manaCost = 20, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[15] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 60, manaCost = 20, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[16] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 62, manaCost = 21, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[17] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 64, manaCost = 21, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[18] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 66, manaCost = 22, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[19] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 68, manaCost = 22, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[20] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 70, manaCost = 23, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[21] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 72, manaCost = 24, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[22] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 74, manaCost = 24, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[23] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 76, manaCost = 25, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[24] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 78, manaCost = 25, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[25] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 80, manaCost = 26, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[26] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 82, manaCost = 26, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[27] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 84, manaCost = 27, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[28] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 86, manaCost = 27, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[29] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 88, manaCost = 28, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[30] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 90, manaCost = 28, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[31] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 91, manaCost = 28, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[32] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 92, manaCost = 29, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[33] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 93, manaCost = 29, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[34] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 94, manaCost = 29, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[35] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 95, manaCost = 29, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[36] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 96, manaCost = 30, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[37] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 97, manaCost = 30, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[38] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 98, manaCost = 30, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[39] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 99, manaCost = 30, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
		[40] = { 0.80000001192093, 1.2000000476837, -6, 100, -20, 5, damageEffectiveness = 0.9, critChance = 6, levelRequirement = 100, manaCost = 31, statInterpolation = { 3, 3, 1, 1, 1, 1, }, },
	},
}
skills["BlastRain"] = {
	name = "Blast Rain",
	color = 2,
	description = "Fires an arrow up in the air, which splits and rains down in a series of explosions over an area. The explosions will always overlap on the targeted area.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.ProjectileDamage] = true, [SkillType.SkillCanTotem] = true, [SkillType.SkillCanTrap] = true, [SkillType.SkillCanMine] = true, [SkillType.FireSkill] = true, [SkillType.ProjectileAttack] = true, [SkillType.SkillCanMirageArcher] = true, [SkillType.Triggerable] = true, [SkillType.Triggerable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "1 explosion",
		},
		{
			name = "4 explosions",
		},
	},
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
	},
	baseMods = {
		skill("radius", 24),
		skill("dpsMultiplier", 4, { type = "SkillPart", skillPart = 2 }),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 0.5 },
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_fire",
		"base_skill_area_of_effect_+%",
		"blast_rain_number_of_blasts",
		"blast_rain_arrow_delay_ms",
		"base_reduce_enemy_fire_resistance_%",
		"base_is_projectile",
		"is_area_damage",
	},
	levels = {
		[1] = { 100, 0, 4, 80, 15, damageEffectiveness = 0.4, baseMultiplier = 0.4, levelRequirement = 28, manaCost = 8, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[2] = { 100, 0, 4, 80, 16, damageEffectiveness = 0.4, baseMultiplier = 0.404, levelRequirement = 31, manaCost = 8, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[3] = { 100, 0, 4, 80, 16, damageEffectiveness = 0.41, baseMultiplier = 0.408, levelRequirement = 34, manaCost = 8, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[4] = { 100, 0, 4, 80, 17, damageEffectiveness = 0.41, baseMultiplier = 0.412, levelRequirement = 37, manaCost = 8, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[5] = { 100, 0, 4, 80, 17, damageEffectiveness = 0.42, baseMultiplier = 0.416, levelRequirement = 40, manaCost = 9, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[6] = { 100, 0, 4, 80, 18, damageEffectiveness = 0.42, baseMultiplier = 0.42, levelRequirement = 42, manaCost = 9, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[7] = { 100, 0, 4, 80, 18, damageEffectiveness = 0.42, baseMultiplier = 0.424, levelRequirement = 44, manaCost = 9, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[8] = { 100, 0, 4, 80, 19, damageEffectiveness = 0.43, baseMultiplier = 0.428, levelRequirement = 46, manaCost = 9, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[9] = { 100, 0, 4, 80, 19, damageEffectiveness = 0.43, baseMultiplier = 0.432, levelRequirement = 48, manaCost = 9, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[10] = { 100, 0, 4, 80, 20, damageEffectiveness = 0.44, baseMultiplier = 0.436, levelRequirement = 50, manaCost = 9, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[11] = { 100, 0, 4, 80, 20, damageEffectiveness = 0.44, baseMultiplier = 0.44, levelRequirement = 52, manaCost = 9, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[12] = { 100, 0, 4, 80, 21, damageEffectiveness = 0.44, baseMultiplier = 0.444, levelRequirement = 54, manaCost = 10, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[13] = { 100, 0, 4, 80, 21, damageEffectiveness = 0.45, baseMultiplier = 0.448, levelRequirement = 56, manaCost = 10, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[14] = { 100, 0, 4, 80, 22, damageEffectiveness = 0.45, baseMultiplier = 0.452, levelRequirement = 58, manaCost = 10, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[15] = { 100, 0, 4, 80, 22, damageEffectiveness = 0.46, baseMultiplier = 0.456, levelRequirement = 60, manaCost = 10, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[16] = { 100, 0, 4, 80, 23, damageEffectiveness = 0.46, baseMultiplier = 0.46, levelRequirement = 62, manaCost = 10, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[17] = { 100, 0, 4, 80, 23, damageEffectiveness = 0.46, baseMultiplier = 0.464, levelRequirement = 64, manaCost = 10, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[18] = { 100, 0, 4, 80, 24, damageEffectiveness = 0.47, baseMultiplier = 0.468, levelRequirement = 66, manaCost = 10, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[19] = { 100, 0, 4, 80, 24, damageEffectiveness = 0.47, baseMultiplier = 0.472, levelRequirement = 68, manaCost = 10, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[20] = { 100, 0, 4, 80, 25, damageEffectiveness = 0.48, baseMultiplier = 0.476, levelRequirement = 70, manaCost = 10, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[21] = { 100, 0, 4, 80, 25, damageEffectiveness = 0.48, baseMultiplier = 0.48, levelRequirement = 72, manaCost = 10, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[22] = { 100, 0, 4, 80, 26, damageEffectiveness = 0.48, baseMultiplier = 0.484, levelRequirement = 74, manaCost = 10, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[23] = { 100, 0, 4, 80, 26, damageEffectiveness = 0.49, baseMultiplier = 0.488, levelRequirement = 76, manaCost = 11, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[24] = { 100, 0, 4, 80, 27, damageEffectiveness = 0.49, baseMultiplier = 0.492, levelRequirement = 78, manaCost = 11, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[25] = { 100, 0, 4, 80, 27, damageEffectiveness = 0.5, baseMultiplier = 0.496, levelRequirement = 80, manaCost = 11, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[26] = { 100, 0, 4, 80, 28, damageEffectiveness = 0.5, baseMultiplier = 0.5, levelRequirement = 82, manaCost = 11, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[27] = { 100, 0, 4, 80, 28, damageEffectiveness = 0.5, baseMultiplier = 0.504, levelRequirement = 84, manaCost = 11, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[28] = { 100, 0, 4, 80, 29, damageEffectiveness = 0.51, baseMultiplier = 0.508, levelRequirement = 86, manaCost = 12, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[29] = { 100, 0, 4, 80, 29, damageEffectiveness = 0.51, baseMultiplier = 0.512, levelRequirement = 88, manaCost = 12, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[30] = { 100, 0, 4, 80, 30, damageEffectiveness = 0.52, baseMultiplier = 0.516, levelRequirement = 90, manaCost = 12, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[31] = { 100, 0, 4, 80, 30, damageEffectiveness = 0.52, baseMultiplier = 0.518, levelRequirement = 91, manaCost = 12, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[32] = { 100, 0, 4, 80, 30, damageEffectiveness = 0.52, baseMultiplier = 0.52, levelRequirement = 92, manaCost = 12, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[33] = { 100, 0, 4, 80, 30, damageEffectiveness = 0.52, baseMultiplier = 0.522, levelRequirement = 93, manaCost = 12, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[34] = { 100, 0, 4, 80, 31, damageEffectiveness = 0.52, baseMultiplier = 0.524, levelRequirement = 94, manaCost = 12, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[35] = { 100, 0, 4, 80, 31, damageEffectiveness = 0.53, baseMultiplier = 0.526, levelRequirement = 95, manaCost = 12, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[36] = { 100, 0, 4, 80, 31, damageEffectiveness = 0.53, baseMultiplier = 0.528, levelRequirement = 96, manaCost = 12, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[37] = { 100, 0, 4, 80, 31, damageEffectiveness = 0.53, baseMultiplier = 0.53, levelRequirement = 97, manaCost = 13, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[38] = { 100, 0, 4, 80, 32, damageEffectiveness = 0.53, baseMultiplier = 0.532, levelRequirement = 98, manaCost = 13, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[39] = { 100, 0, 4, 80, 32, damageEffectiveness = 0.53, baseMultiplier = 0.534, levelRequirement = 99, manaCost = 13, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[40] = { 100, 0, 4, 80, 32, damageEffectiveness = 0.54, baseMultiplier = 0.536, levelRequirement = 100, manaCost = 13, statInterpolation = { 1, 1, 1, 1, 1, }, },
	},
}
skills["BlinkArrow"] = {
	name = "Blink Arrow",
	color = 2,
	description = "Fires an arrow at the target destination. When the arrow lands, you are teleported to it and a clone is summoned at your old location. The clone is a minion that uses your bow and quiver.",
	skillTypes = { [SkillType.ProjectileDamage] = true, [SkillType.Attack] = true, [SkillType.Minion] = true, [SkillType.ProjectileAttack] = true, [SkillType.CreateMinion] = true, [SkillType.Duration] = true, [SkillType.SkillCanTotem] = true, [SkillType.SkillCanTrap] = true, [SkillType.SkillCanMine] = true, [SkillType.MovementSkill] = true, [SkillType.Triggerable] = true, [SkillType.SkillCanVolley] = true, [SkillType.CreatesMinion] = true, [SkillType.TravelSkill] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.ProjectileAttack] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "minion_attack_skill_stat_descriptions",
	castTime = 1,
	minionList = {
		"Clone",
	},
	baseFlags = {
		attack = true,
		projectile = true,
		minion = true,
		duration = true,
	},
	baseMods = {
		skill("minionUseBowAndQuiver", true),
	},
	qualityStats = {
		{ "base_arrow_speed_+%", 1.5 },
	},
	stats = {
		"base_skill_effect_duration",
		"number_of_monsters_to_summon",
		"minion_damage_+%",
		"minion_maximum_life_+%",
		"active_skill_minion_damage_+%_final",
		"display_minion_monster_type",
		"display_minion_monster_level",
		"base_number_of_clones_allowed",
		"base_is_projectile",
	},
	levels = {
		[1] = { 3000, 1, 0, 0, 75, 4, 24, 0, cooldown = 3, levelRequirement = 10, manaCost = 14, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[2] = { 3000, 1, 6, 3, 75, 4, 27, 0, cooldown = 3, levelRequirement = 13, manaCost = 14, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[3] = { 3000, 1, 12, 6, 75, 4, 30, 0, cooldown = 3, levelRequirement = 17, manaCost = 15, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[4] = { 3000, 1, 18, 9, 75, 4, 33, 0, cooldown = 3, levelRequirement = 21, manaCost = 15, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[5] = { 3000, 1, 24, 12, 75, 4, 35, 0, cooldown = 3, levelRequirement = 25, manaCost = 15, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[6] = { 3000, 1, 30, 15, 75, 4, 38, 0, cooldown = 3, levelRequirement = 29, manaCost = 16, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[7] = { 3000, 1, 36, 18, 75, 4, 40, 0, cooldown = 3, levelRequirement = 33, manaCost = 16, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[8] = { 3000, 1, 42, 21, 75, 4, 43, 0, cooldown = 3, levelRequirement = 36, manaCost = 16, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[9] = { 3000, 1, 48, 24, 75, 4, 46, 0, cooldown = 3, levelRequirement = 39, manaCost = 16, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[10] = { 3000, 1, 54, 27, 75, 4, 48, 0, cooldown = 3, levelRequirement = 42, manaCost = 17, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[11] = { 3000, 1, 60, 30, 75, 4, 50, 0, cooldown = 3, levelRequirement = 45, manaCost = 17, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[12] = { 3000, 1, 66, 33, 75, 4, 52, 0, cooldown = 3, levelRequirement = 48, manaCost = 17, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[13] = { 3000, 1, 72, 36, 75, 4, 54, 0, cooldown = 3, levelRequirement = 51, manaCost = 17, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[14] = { 3000, 1, 78, 39, 75, 4, 56, 0, cooldown = 3, levelRequirement = 54, manaCost = 18, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[15] = { 3000, 1, 84, 42, 75, 4, 58, 0, cooldown = 3, levelRequirement = 57, manaCost = 18, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[16] = { 3000, 1, 90, 45, 75, 4, 60, 0, cooldown = 3, levelRequirement = 60, manaCost = 18, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[17] = { 3000, 1, 96, 48, 75, 4, 62, 0, cooldown = 3, levelRequirement = 63, manaCost = 19, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[18] = { 3000, 1, 102, 51, 75, 4, 64, 0, cooldown = 3, levelRequirement = 66, manaCost = 19, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[19] = { 3000, 1, 108, 54, 75, 4, 66, 0, cooldown = 3, levelRequirement = 68, manaCost = 20, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[20] = { 3000, 1, 114, 57, 75, 4, 68, 0, cooldown = 3, levelRequirement = 70, manaCost = 20, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[21] = { 3000, 1, 120, 60, 75, 4, 70, 0, cooldown = 3, levelRequirement = 72, manaCost = 21, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[22] = { 3000, 1, 126, 63, 75, 4, 72, 0, cooldown = 3, levelRequirement = 74, manaCost = 21, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[23] = { 3000, 1, 132, 66, 75, 4, 74, 0, cooldown = 3, levelRequirement = 76, manaCost = 22, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[24] = { 3000, 1, 138, 69, 75, 4, 76, 0, cooldown = 3, levelRequirement = 78, manaCost = 22, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[25] = { 3000, 1, 144, 72, 75, 4, 78, 0, cooldown = 3, levelRequirement = 80, manaCost = 22, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[26] = { 3000, 1, 150, 75, 75, 4, 80, 0, cooldown = 3, levelRequirement = 82, manaCost = 23, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[27] = { 3000, 1, 156, 78, 75, 4, 82, 0, cooldown = 3, levelRequirement = 84, manaCost = 23, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[28] = { 3000, 1, 162, 81, 75, 4, 84, 0, cooldown = 3, levelRequirement = 86, manaCost = 23, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[29] = { 3000, 1, 168, 84, 75, 4, 86, 0, cooldown = 3, levelRequirement = 88, manaCost = 23, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[30] = { 3000, 1, 174, 87, 75, 4, 88, 0, cooldown = 3, levelRequirement = 90, manaCost = 24, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[31] = { 3000, 1, 177, 88, 75, 4, 89, 0, cooldown = 3, levelRequirement = 91, manaCost = 24, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[32] = { 3000, 1, 180, 90, 75, 4, 90, 0, cooldown = 3, levelRequirement = 92, manaCost = 24, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[33] = { 3000, 1, 183, 92, 75, 4, 91, 0, cooldown = 3, levelRequirement = 93, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[34] = { 3000, 1, 186, 93, 75, 4, 92, 0, cooldown = 3, levelRequirement = 94, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[35] = { 3000, 1, 189, 94, 75, 4, 93, 0, cooldown = 3, levelRequirement = 95, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[36] = { 3000, 1, 192, 96, 75, 4, 94, 0, cooldown = 3, levelRequirement = 96, manaCost = 26, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[37] = { 3000, 1, 195, 98, 75, 4, 95, 0, cooldown = 3, levelRequirement = 97, manaCost = 26, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[38] = { 3000, 1, 198, 99, 75, 4, 96, 0, cooldown = 3, levelRequirement = 98, manaCost = 27, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[39] = { 3000, 1, 201, 100, 75, 4, 97, 0, cooldown = 3, levelRequirement = 99, manaCost = 27, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[40] = { 3000, 1, 204, 102, 75, 4, 98, 0, cooldown = 3, levelRequirement = 100, manaCost = 27, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
	},
}
skills["BloodRage"] = {
	name = "Blood Rage",
	color = 2,
	description = "Adds a buff that deals Physical Damage over time, while increasing Attack Speed and Life Leech. Killing an enemy while this buff is active refreshes the buff duration, and can grant a Frenzy Charge.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Duration] = true, [SkillType.SkillCanTotem] = true, [SkillType.Triggerable] = true, [SkillType.Instant] = true, [SkillType.PhysicalSkill] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0,
	statMap = {
		["life_leech_from_physical_attack_damage_permyriad"] = {
			mod("PhysicalDamageLifeLeech", "BASE", nil, ModFlag.Attack, 0, { type = "GlobalEffect", effectType = "Buff" }),
			div = 100,
		},
		["base_physical_damage_%_of_maximum_life_to_deal_per_minute"] = {
			mod("PhysicalDegen", "BASE", nil, 0, 0, { type = "PerStat", stat = "Life", div = 1}, { type = "GlobalEffect", effectType = "Buff" }),
			div = 6000,
		},
		["base_physical_damage_%_of_maximum_energy_shield_to_deal_per_minute"] = {
			mod("PhysicalDegen", "BASE", nil, 0, 0, { type = "PerStat", stat = "EnergyShield", div = 1}, { type = "GlobalEffect", effectType = "Buff" }),
			div = 6000,
		},
		["attack_speed_+%_granted_from_skill"] = {
			mod("Speed", "INC", nil, ModFlag.Attack, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
	},
	baseFlags = {
		spell = true,
		duration = true,
	},
	baseMods = {
		skill("thisIsNotABuff", true),
	},
	qualityStats = {
		{ "attack_speed_+%_granted_from_skill", 0.25 },
	},
	stats = {
		"attack_speed_+%_granted_from_skill",
		"life_leech_from_physical_attack_damage_permyriad",
		"base_physical_damage_%_of_maximum_life_to_deal_per_minute",
		"base_physical_damage_%_of_maximum_energy_shield_to_deal_per_minute",
		"add_frenzy_charge_on_kill_%_chance",
		"base_skill_effect_duration",
		"skill_level",
		"instant_skill_is_added_to_held_skills_list",
	},
	levels = {
		[1] = { 5, 120, 240, 240, 25, 7000, 1, cooldown = 1, levelRequirement = 16, manaCost = 7, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[2] = { 6, 120, 240, 240, 25, 7200, 2, cooldown = 1, levelRequirement = 20, manaCost = 7, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[3] = { 6, 120, 240, 240, 25, 7400, 3, cooldown = 1, levelRequirement = 24, manaCost = 8, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[4] = { 7, 120, 240, 240, 25, 7600, 4, cooldown = 1, levelRequirement = 28, manaCost = 9, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[5] = { 7, 120, 240, 240, 25, 7800, 5, cooldown = 1, levelRequirement = 31, manaCost = 9, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[6] = { 8, 120, 240, 240, 25, 8000, 6, cooldown = 1, levelRequirement = 34, manaCost = 10, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[7] = { 8, 120, 240, 240, 25, 8200, 7, cooldown = 1, levelRequirement = 37, manaCost = 10, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[8] = { 9, 120, 240, 240, 25, 8400, 8, cooldown = 1, levelRequirement = 40, manaCost = 11, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[9] = { 9, 120, 240, 240, 25, 8600, 9, cooldown = 1, levelRequirement = 43, manaCost = 12, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[10] = { 10, 120, 240, 240, 25, 8800, 10, cooldown = 1, levelRequirement = 46, manaCost = 12, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[11] = { 10, 120, 240, 240, 25, 9000, 11, cooldown = 1, levelRequirement = 49, manaCost = 13, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[12] = { 11, 120, 240, 240, 25, 9200, 12, cooldown = 1, levelRequirement = 52, manaCost = 13, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[13] = { 11, 120, 240, 240, 25, 9400, 13, cooldown = 1, levelRequirement = 55, manaCost = 14, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[14] = { 12, 120, 240, 240, 25, 9600, 14, cooldown = 1, levelRequirement = 58, manaCost = 14, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[15] = { 12, 120, 240, 240, 25, 9800, 15, cooldown = 1, levelRequirement = 60, manaCost = 15, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[16] = { 13, 120, 240, 240, 25, 10000, 16, cooldown = 1, levelRequirement = 62, manaCost = 15, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[17] = { 13, 120, 240, 240, 25, 10200, 17, cooldown = 1, levelRequirement = 64, manaCost = 15, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[18] = { 14, 120, 240, 240, 25, 10400, 18, cooldown = 1, levelRequirement = 66, manaCost = 16, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[19] = { 14, 120, 240, 240, 25, 10600, 19, cooldown = 1, levelRequirement = 68, manaCost = 16, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[20] = { 15, 120, 240, 240, 25, 10800, 20, cooldown = 1, levelRequirement = 70, manaCost = 16, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[21] = { 15, 120, 240, 240, 25, 11000, 21, cooldown = 1, levelRequirement = 72, manaCost = 17, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[22] = { 16, 120, 240, 240, 25, 11200, 22, cooldown = 1, levelRequirement = 74, manaCost = 17, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[23] = { 16, 120, 240, 240, 25, 11400, 23, cooldown = 1, levelRequirement = 76, manaCost = 18, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[24] = { 17, 120, 240, 240, 25, 11600, 24, cooldown = 1, levelRequirement = 78, manaCost = 18, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[25] = { 17, 120, 240, 240, 25, 11800, 25, cooldown = 1, levelRequirement = 80, manaCost = 18, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[26] = { 18, 120, 240, 240, 25, 12000, 26, cooldown = 1, levelRequirement = 82, manaCost = 19, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[27] = { 18, 120, 240, 240, 25, 12200, 27, cooldown = 1, levelRequirement = 84, manaCost = 19, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[28] = { 19, 120, 240, 240, 25, 12400, 28, cooldown = 1, levelRequirement = 86, manaCost = 19, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[29] = { 19, 120, 240, 240, 25, 12600, 29, cooldown = 1, levelRequirement = 88, manaCost = 20, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[30] = { 20, 120, 240, 240, 25, 12800, 30, cooldown = 1, levelRequirement = 90, manaCost = 20, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[31] = { 20, 120, 240, 240, 25, 12900, 31, cooldown = 1, levelRequirement = 91, manaCost = 20, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[32] = { 20, 120, 240, 240, 25, 13000, 32, cooldown = 1, levelRequirement = 92, manaCost = 20, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[33] = { 20, 120, 240, 240, 25, 13100, 33, cooldown = 1, levelRequirement = 93, manaCost = 21, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[34] = { 21, 120, 240, 240, 25, 13200, 34, cooldown = 1, levelRequirement = 94, manaCost = 21, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[35] = { 21, 120, 240, 240, 25, 13300, 35, cooldown = 1, levelRequirement = 95, manaCost = 21, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[36] = { 21, 120, 240, 240, 25, 13400, 36, cooldown = 1, levelRequirement = 96, manaCost = 21, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[37] = { 21, 120, 240, 240, 25, 13500, 37, cooldown = 1, levelRequirement = 97, manaCost = 21, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[38] = { 22, 120, 240, 240, 25, 13600, 38, cooldown = 1, levelRequirement = 98, manaCost = 22, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[39] = { 22, 120, 240, 240, 25, 13700, 39, cooldown = 1, levelRequirement = 99, manaCost = 22, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[40] = { 22, 120, 240, 240, 25, 13800, 40, cooldown = 1, levelRequirement = 100, manaCost = 22, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
	},
}
skills["BurningArrow"] = {
	name = "Burning Arrow",
	color = 2,
	baseEffectiveness = 2.7778000831604,
	incrementalEffectiveness = 0.050000000745058,
	description = "Fires an arrow that deals fire damage to its target and has an increased chance of igniting it.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.ProjectileAttack] = true, [SkillType.SkillCanMirageArcher] = true, [SkillType.Projectile] = true, [SkillType.SkillCanVolley] = true, [SkillType.SkillCanTotem] = true, [SkillType.SkillCanTrap] = true, [SkillType.SkillCanMine] = true, [SkillType.FireSkill] = true, [SkillType.Type53] = true, [SkillType.Type55] = true, [SkillType.Triggerable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "ignite_duration_+%", 3 },
	},
	stats = {
		"base_chance_to_ignite_%",
		"active_skill_ignite_damage_+%_final",
		"skill_physical_damage_%_to_convert_to_fire",
		"ignite_triggered_ground_fire_base_damage_per_minute",
		"skill_can_fire_arrows",
	},
	levels = {
		[1] = { 30, 30, 50, 16.666667039196, damageEffectiveness = 1.5, baseMultiplier = 1.5, levelRequirement = 1, manaCost = 5, statInterpolation = { 1, 1, 1, 3, }, },
		[2] = { 31, 32, 50, 16.666667039196, damageEffectiveness = 1.52, baseMultiplier = 1.518, levelRequirement = 2, manaCost = 5, statInterpolation = { 1, 1, 1, 3, }, },
		[3] = { 32, 34, 50, 16.666667039196, damageEffectiveness = 1.54, baseMultiplier = 1.536, levelRequirement = 4, manaCost = 5, statInterpolation = { 1, 1, 1, 3, }, },
		[4] = { 33, 36, 50, 16.666667039196, damageEffectiveness = 1.55, baseMultiplier = 1.554, levelRequirement = 7, manaCost = 5, statInterpolation = { 1, 1, 1, 3, }, },
		[5] = { 34, 38, 50, 16.666667039196, damageEffectiveness = 1.57, baseMultiplier = 1.572, levelRequirement = 11, manaCost = 5, statInterpolation = { 1, 1, 1, 3, }, },
		[6] = { 35, 40, 50, 16.666667039196, damageEffectiveness = 1.59, baseMultiplier = 1.59, levelRequirement = 16, manaCost = 6, statInterpolation = { 1, 1, 1, 3, }, },
		[7] = { 36, 42, 50, 16.666667039196, damageEffectiveness = 1.61, baseMultiplier = 1.608, levelRequirement = 20, manaCost = 6, statInterpolation = { 1, 1, 1, 3, }, },
		[8] = { 37, 44, 50, 16.666667039196, damageEffectiveness = 1.63, baseMultiplier = 1.626, levelRequirement = 24, manaCost = 6, statInterpolation = { 1, 1, 1, 3, }, },
		[9] = { 38, 46, 50, 16.666667039196, damageEffectiveness = 1.64, baseMultiplier = 1.644, levelRequirement = 28, manaCost = 6, statInterpolation = { 1, 1, 1, 3, }, },
		[10] = { 39, 48, 50, 16.666667039196, damageEffectiveness = 1.66, baseMultiplier = 1.662, levelRequirement = 32, manaCost = 6, statInterpolation = { 1, 1, 1, 3, }, },
		[11] = { 40, 50, 50, 16.666667039196, damageEffectiveness = 1.68, baseMultiplier = 1.68, levelRequirement = 36, manaCost = 7, statInterpolation = { 1, 1, 1, 3, }, },
		[12] = { 41, 52, 50, 16.666667039196, damageEffectiveness = 1.7, baseMultiplier = 1.698, levelRequirement = 40, manaCost = 7, statInterpolation = { 1, 1, 1, 3, }, },
		[13] = { 42, 54, 50, 16.666667039196, damageEffectiveness = 1.72, baseMultiplier = 1.716, levelRequirement = 44, manaCost = 7, statInterpolation = { 1, 1, 1, 3, }, },
		[14] = { 43, 56, 50, 16.666667039196, damageEffectiveness = 1.73, baseMultiplier = 1.734, levelRequirement = 48, manaCost = 7, statInterpolation = { 1, 1, 1, 3, }, },
		[15] = { 44, 58, 50, 16.666667039196, damageEffectiveness = 1.75, baseMultiplier = 1.752, levelRequirement = 52, manaCost = 7, statInterpolation = { 1, 1, 1, 3, }, },
		[16] = { 45, 60, 50, 16.666667039196, damageEffectiveness = 1.77, baseMultiplier = 1.77, levelRequirement = 56, manaCost = 8, statInterpolation = { 1, 1, 1, 3, }, },
		[17] = { 46, 62, 50, 16.666667039196, damageEffectiveness = 1.79, baseMultiplier = 1.788, levelRequirement = 60, manaCost = 8, statInterpolation = { 1, 1, 1, 3, }, },
		[18] = { 47, 64, 50, 16.666667039196, damageEffectiveness = 1.81, baseMultiplier = 1.806, levelRequirement = 64, manaCost = 8, statInterpolation = { 1, 1, 1, 3, }, },
		[19] = { 48, 66, 50, 16.666667039196, damageEffectiveness = 1.82, baseMultiplier = 1.824, levelRequirement = 67, manaCost = 8, statInterpolation = { 1, 1, 1, 3, }, },
		[20] = { 49, 68, 50, 16.666667039196, damageEffectiveness = 1.84, baseMultiplier = 1.842, levelRequirement = 70, manaCost = 8, statInterpolation = { 1, 1, 1, 3, }, },
		[21] = { 50, 70, 50, 16.666667039196, damageEffectiveness = 1.86, baseMultiplier = 1.86, levelRequirement = 72, manaCost = 9, statInterpolation = { 1, 1, 1, 3, }, },
		[22] = { 51, 72, 50, 16.666667039196, damageEffectiveness = 1.88, baseMultiplier = 1.878, levelRequirement = 74, manaCost = 9, statInterpolation = { 1, 1, 1, 3, }, },
		[23] = { 52, 74, 50, 16.666667039196, damageEffectiveness = 1.9, baseMultiplier = 1.896, levelRequirement = 76, manaCost = 9, statInterpolation = { 1, 1, 1, 3, }, },
		[24] = { 53, 76, 50, 16.666667039196, damageEffectiveness = 1.91, baseMultiplier = 1.914, levelRequirement = 78, manaCost = 9, statInterpolation = { 1, 1, 1, 3, }, },
		[25] = { 54, 78, 50, 16.666667039196, damageEffectiveness = 1.93, baseMultiplier = 1.932, levelRequirement = 80, manaCost = 9, statInterpolation = { 1, 1, 1, 3, }, },
		[26] = { 55, 80, 50, 16.666667039196, damageEffectiveness = 1.95, baseMultiplier = 1.95, levelRequirement = 82, manaCost = 10, statInterpolation = { 1, 1, 1, 3, }, },
		[27] = { 56, 82, 50, 16.666667039196, damageEffectiveness = 1.97, baseMultiplier = 1.968, levelRequirement = 84, manaCost = 10, statInterpolation = { 1, 1, 1, 3, }, },
		[28] = { 57, 84, 50, 16.666667039196, damageEffectiveness = 1.99, baseMultiplier = 1.986, levelRequirement = 86, manaCost = 10, statInterpolation = { 1, 1, 1, 3, }, },
		[29] = { 58, 86, 50, 16.666667039196, damageEffectiveness = 2, baseMultiplier = 2.004, levelRequirement = 88, manaCost = 10, statInterpolation = { 1, 1, 1, 3, }, },
		[30] = { 59, 88, 50, 16.666667039196, damageEffectiveness = 2.02, baseMultiplier = 2.022, levelRequirement = 90, manaCost = 10, statInterpolation = { 1, 1, 1, 3, }, },
		[31] = { 59, 89, 50, 16.666667039196, damageEffectiveness = 2.03, baseMultiplier = 2.031, levelRequirement = 91, manaCost = 11, statInterpolation = { 1, 1, 1, 3, }, },
		[32] = { 60, 90, 50, 16.666667039196, damageEffectiveness = 2.04, baseMultiplier = 2.04, levelRequirement = 92, manaCost = 11, statInterpolation = { 1, 1, 1, 3, }, },
		[33] = { 60, 91, 50, 16.666667039196, damageEffectiveness = 2.05, baseMultiplier = 2.049, levelRequirement = 93, manaCost = 11, statInterpolation = { 1, 1, 1, 3, }, },
		[34] = { 61, 92, 50, 16.666667039196, damageEffectiveness = 2.06, baseMultiplier = 2.058, levelRequirement = 94, manaCost = 11, statInterpolation = { 1, 1, 1, 3, }, },
		[35] = { 61, 93, 50, 16.666667039196, damageEffectiveness = 2.07, baseMultiplier = 2.067, levelRequirement = 95, manaCost = 11, statInterpolation = { 1, 1, 1, 3, }, },
		[36] = { 62, 94, 50, 16.666667039196, damageEffectiveness = 2.08, baseMultiplier = 2.076, levelRequirement = 96, manaCost = 11, statInterpolation = { 1, 1, 1, 3, }, },
		[37] = { 62, 95, 50, 16.666667039196, damageEffectiveness = 2.09, baseMultiplier = 2.085, levelRequirement = 97, manaCost = 12, statInterpolation = { 1, 1, 1, 3, }, },
		[38] = { 63, 96, 50, 16.666667039196, damageEffectiveness = 2.09, baseMultiplier = 2.094, levelRequirement = 98, manaCost = 12, statInterpolation = { 1, 1, 1, 3, }, },
		[39] = { 63, 97, 50, 16.666667039196, damageEffectiveness = 2.1, baseMultiplier = 2.103, levelRequirement = 99, manaCost = 12, statInterpolation = { 1, 1, 1, 3, }, },
		[40] = { 64, 98, 50, 16.666667039196, damageEffectiveness = 2.11, baseMultiplier = 2.112, levelRequirement = 100, manaCost = 12, statInterpolation = { 1, 1, 1, 3, }, },
	},
}
skills["VaalBurningArrow"] = {
	name = "Vaal Burning Arrow",
	color = 2,
	baseEffectiveness = 2.9667000770569,
	incrementalEffectiveness = 0.050000000745058,
	description = "Fires an arrow that explodes, dealing fire damage to its target and other nearby enemies, with an increased chance of igniting them.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.ProjectileAttack] = true, [SkillType.Projectile] = true, [SkillType.SkillCanVolley] = true, [SkillType.SkillCanTotem] = true, [SkillType.SkillCanTrap] = true, [SkillType.SkillCanMine] = true, [SkillType.Area] = true, [SkillType.Vaal] = true, [SkillType.FireSkill] = true, [SkillType.Type55] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
		vaal = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "ignite_duration_+%", 3 },
	},
	stats = {
		"base_chance_to_ignite_%",
		"active_skill_ignite_damage_+%_final",
		"skill_physical_damage_%_to_convert_to_fire",
		"ignite_triggered_ground_fire_base_damage_per_minute",
		"projectile_base_number_of_targets_to_pierce",
		"vaal_burning_arrow_explode_on_hit",
		"global_always_hit",
		"skill_can_fire_arrows",
		"cannot_cancel_skill_before_contact_point",
	},
	levels = {
		[1] = { 30, 30, 50, 16.666667039196, 3, damageEffectiveness = 1.6, baseMultiplier = 1.6, levelRequirement = 1, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[2] = { 31, 32, 50, 16.666667039196, 3, damageEffectiveness = 1.62, baseMultiplier = 1.62, levelRequirement = 2, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[3] = { 32, 34, 50, 16.666667039196, 3, damageEffectiveness = 1.64, baseMultiplier = 1.64, levelRequirement = 4, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[4] = { 33, 36, 50, 16.666667039196, 3, damageEffectiveness = 1.66, baseMultiplier = 1.66, levelRequirement = 7, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[5] = { 34, 38, 50, 16.666667039196, 3, damageEffectiveness = 1.68, baseMultiplier = 1.68, levelRequirement = 11, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[6] = { 35, 40, 50, 16.666667039196, 3, damageEffectiveness = 1.7, baseMultiplier = 1.7, levelRequirement = 16, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[7] = { 36, 42, 50, 16.666667039196, 3, damageEffectiveness = 1.72, baseMultiplier = 1.72, levelRequirement = 20, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[8] = { 37, 44, 50, 16.666667039196, 3, damageEffectiveness = 1.74, baseMultiplier = 1.74, levelRequirement = 24, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[9] = { 38, 46, 50, 16.666667039196, 3, damageEffectiveness = 1.76, baseMultiplier = 1.76, levelRequirement = 28, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[10] = { 39, 48, 50, 16.666667039196, 3, damageEffectiveness = 1.78, baseMultiplier = 1.78, levelRequirement = 32, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[11] = { 40, 50, 50, 16.666667039196, 3, damageEffectiveness = 1.8, baseMultiplier = 1.8, levelRequirement = 36, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[12] = { 41, 52, 50, 16.666667039196, 3, damageEffectiveness = 1.82, baseMultiplier = 1.82, levelRequirement = 40, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[13] = { 42, 54, 50, 16.666667039196, 3, damageEffectiveness = 1.84, baseMultiplier = 1.84, levelRequirement = 44, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[14] = { 43, 56, 50, 16.666667039196, 3, damageEffectiveness = 1.86, baseMultiplier = 1.86, levelRequirement = 48, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[15] = { 44, 58, 50, 16.666667039196, 3, damageEffectiveness = 1.88, baseMultiplier = 1.88, levelRequirement = 52, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[16] = { 45, 60, 50, 16.666667039196, 3, damageEffectiveness = 1.9, baseMultiplier = 1.9, levelRequirement = 56, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[17] = { 46, 62, 50, 16.666667039196, 3, damageEffectiveness = 1.92, baseMultiplier = 1.92, levelRequirement = 60, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[18] = { 47, 64, 50, 16.666667039196, 3, damageEffectiveness = 1.94, baseMultiplier = 1.94, levelRequirement = 64, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[19] = { 48, 66, 50, 16.666667039196, 3, damageEffectiveness = 1.96, baseMultiplier = 1.96, levelRequirement = 67, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[20] = { 49, 68, 50, 16.666667039196, 3, damageEffectiveness = 1.98, baseMultiplier = 1.98, levelRequirement = 70, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[21] = { 50, 70, 50, 16.666667039196, 3, damageEffectiveness = 2, baseMultiplier = 2, levelRequirement = 72, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[22] = { 51, 72, 50, 16.666667039196, 3, damageEffectiveness = 2.02, baseMultiplier = 2.02, levelRequirement = 74, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[23] = { 52, 74, 50, 16.666667039196, 3, damageEffectiveness = 2.04, baseMultiplier = 2.04, levelRequirement = 76, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[24] = { 53, 76, 50, 16.666667039196, 3, damageEffectiveness = 2.06, baseMultiplier = 2.06, levelRequirement = 78, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[25] = { 54, 78, 50, 16.666667039196, 3, damageEffectiveness = 2.08, baseMultiplier = 2.08, levelRequirement = 80, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[26] = { 55, 80, 50, 16.666667039196, 3, damageEffectiveness = 2.1, baseMultiplier = 2.1, levelRequirement = 82, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[27] = { 56, 82, 50, 16.666667039196, 3, damageEffectiveness = 2.12, baseMultiplier = 2.12, levelRequirement = 84, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[28] = { 57, 84, 50, 16.666667039196, 3, damageEffectiveness = 2.14, baseMultiplier = 2.14, levelRequirement = 86, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[29] = { 58, 86, 50, 16.666667039196, 3, damageEffectiveness = 2.16, baseMultiplier = 2.16, levelRequirement = 88, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[30] = { 59, 88, 50, 16.666667039196, 3, damageEffectiveness = 2.18, baseMultiplier = 2.18, levelRequirement = 90, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[31] = { 59, 89, 50, 16.666667039196, 3, damageEffectiveness = 2.19, baseMultiplier = 2.19, levelRequirement = 91, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[32] = { 60, 90, 50, 16.666667039196, 3, damageEffectiveness = 2.2, baseMultiplier = 2.2, levelRequirement = 92, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[33] = { 60, 91, 50, 16.666667039196, 3, damageEffectiveness = 2.21, baseMultiplier = 2.21, levelRequirement = 93, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[34] = { 61, 92, 50, 16.666667039196, 3, damageEffectiveness = 2.22, baseMultiplier = 2.22, levelRequirement = 94, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[35] = { 61, 93, 50, 16.666667039196, 3, damageEffectiveness = 2.23, baseMultiplier = 2.23, levelRequirement = 95, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[36] = { 62, 94, 50, 16.666667039196, 3, damageEffectiveness = 2.24, baseMultiplier = 2.24, levelRequirement = 96, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[37] = { 62, 95, 50, 16.666667039196, 3, damageEffectiveness = 2.25, baseMultiplier = 2.25, levelRequirement = 97, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[38] = { 63, 96, 50, 16.666667039196, 3, damageEffectiveness = 2.26, baseMultiplier = 2.26, levelRequirement = 98, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[39] = { 63, 97, 50, 16.666667039196, 3, damageEffectiveness = 2.27, baseMultiplier = 2.27, levelRequirement = 99, statInterpolation = { 1, 1, 1, 3, 1, }, },
		[40] = { 64, 98, 50, 16.666667039196, 3, damageEffectiveness = 2.28, baseMultiplier = 2.28, levelRequirement = 100, statInterpolation = { 1, 1, 1, 3, 1, }, },
	},
}
skills["PoisonArrow"] = {
	name = "Caustic Arrow",
	color = 2,
	baseEffectiveness = 6.5,
	incrementalEffectiveness = 0.052000001072884,
	description = "Fires an arrow which deals chaos damage in an area on impact, and spreads caustic ground. Enemies standing on the caustic ground take chaos damage over time.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.ProjectileAttack] = true, [SkillType.SkillCanMirageArcher] = true, [SkillType.Projectile] = true, [SkillType.SkillCanVolley] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.SkillCanTrap] = true, [SkillType.SkillCanMine] = true, [SkillType.SkillCanTotem] = true, [SkillType.DamageOverTime] = true, [SkillType.ChaosSkill] = true, [SkillType.Triggerable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
		duration = true,
		chaos = true,
	},
	baseMods = {
		skill("radius", 20),
		skill("radiusSecondary", 12),
		skill("dotIsArea", true),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 0.5 },
	},
	stats = {
		"base_skill_effect_duration",
		"base_chaos_damage_to_deal_per_minute",
		"skill_physical_damage_%_to_convert_to_chaos",
		"caustic_arrow_explode_on_hit_base_area_of_effect_radius",
		"active_skill_base_radius_+",
		"skill_can_fire_arrows",
		"projectile_damage_modifiers_apply_to_skill_dot",
	},
	levels = {
		[1] = { 2000, 16.666667039196, 60, 12, 0, damageEffectiveness = 0.55, baseMultiplier = 0.55, levelRequirement = 1, manaCost = 6, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[2] = { 2000, 16.666667039196, 60, 12, 0, damageEffectiveness = 0.55, baseMultiplier = 0.555, levelRequirement = 2, manaCost = 6, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[3] = { 2000, 16.666667039196, 60, 12, 0, damageEffectiveness = 0.56, baseMultiplier = 0.56, levelRequirement = 4, manaCost = 6, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[4] = { 2000, 16.666667039196, 60, 12, 0, damageEffectiveness = 0.56, baseMultiplier = 0.565, levelRequirement = 7, manaCost = 6, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[5] = { 2000, 16.666667039196, 60, 12, 0, damageEffectiveness = 0.57, baseMultiplier = 0.57, levelRequirement = 11, manaCost = 7, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[6] = { 2000, 16.666667039196, 60, 12, 1, damageEffectiveness = 0.57, baseMultiplier = 0.575, levelRequirement = 16, manaCost = 7, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[7] = { 2000, 16.666667039196, 60, 12, 1, damageEffectiveness = 0.58, baseMultiplier = 0.58, levelRequirement = 20, manaCost = 7, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[8] = { 2000, 16.666667039196, 60, 12, 1, damageEffectiveness = 0.58, baseMultiplier = 0.585, levelRequirement = 24, manaCost = 7, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[9] = { 2000, 16.666667039196, 60, 12, 1, damageEffectiveness = 0.59, baseMultiplier = 0.59, levelRequirement = 28, manaCost = 8, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[10] = { 2000, 16.666667039196, 60, 12, 1, damageEffectiveness = 0.59, baseMultiplier = 0.595, levelRequirement = 32, manaCost = 8, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[11] = { 2000, 16.666667039196, 60, 12, 1, damageEffectiveness = 0.6, baseMultiplier = 0.599, levelRequirement = 36, manaCost = 8, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[12] = { 2000, 16.666667039196, 60, 12, 2, damageEffectiveness = 0.6, baseMultiplier = 0.604, levelRequirement = 40, manaCost = 8, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[13] = { 2000, 16.666667039196, 60, 12, 2, damageEffectiveness = 0.61, baseMultiplier = 0.609, levelRequirement = 44, manaCost = 9, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[14] = { 2000, 16.666667039196, 60, 12, 2, damageEffectiveness = 0.61, baseMultiplier = 0.614, levelRequirement = 48, manaCost = 9, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[15] = { 2000, 16.666667039196, 60, 12, 2, damageEffectiveness = 0.62, baseMultiplier = 0.619, levelRequirement = 52, manaCost = 9, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[16] = { 2000, 16.666667039196, 60, 12, 2, damageEffectiveness = 0.62, baseMultiplier = 0.624, levelRequirement = 56, manaCost = 9, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[17] = { 2000, 16.666667039196, 60, 12, 2, damageEffectiveness = 0.63, baseMultiplier = 0.629, levelRequirement = 60, manaCost = 10, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[18] = { 2000, 16.666667039196, 60, 12, 3, damageEffectiveness = 0.63, baseMultiplier = 0.634, levelRequirement = 64, manaCost = 10, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[19] = { 2000, 16.666667039196, 60, 12, 3, damageEffectiveness = 0.64, baseMultiplier = 0.639, levelRequirement = 67, manaCost = 10, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[20] = { 2000, 16.666667039196, 60, 12, 3, damageEffectiveness = 0.64, baseMultiplier = 0.644, levelRequirement = 70, manaCost = 10, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[21] = { 2000, 16.666667039196, 60, 12, 3, damageEffectiveness = 0.65, baseMultiplier = 0.649, levelRequirement = 72, manaCost = 11, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[22] = { 2000, 16.666667039196, 60, 12, 3, damageEffectiveness = 0.65, baseMultiplier = 0.654, levelRequirement = 74, manaCost = 11, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[23] = { 2000, 16.666667039196, 60, 12, 3, damageEffectiveness = 0.66, baseMultiplier = 0.659, levelRequirement = 76, manaCost = 11, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[24] = { 2000, 16.666667039196, 60, 12, 4, damageEffectiveness = 0.66, baseMultiplier = 0.664, levelRequirement = 78, manaCost = 11, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[25] = { 2000, 16.666667039196, 60, 12, 4, damageEffectiveness = 0.67, baseMultiplier = 0.669, levelRequirement = 80, manaCost = 12, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[26] = { 2000, 16.666667039196, 60, 12, 4, damageEffectiveness = 0.67, baseMultiplier = 0.674, levelRequirement = 82, manaCost = 12, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[27] = { 2000, 16.666667039196, 60, 12, 4, damageEffectiveness = 0.68, baseMultiplier = 0.679, levelRequirement = 84, manaCost = 12, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[28] = { 2000, 16.666667039196, 60, 12, 4, damageEffectiveness = 0.68, baseMultiplier = 0.684, levelRequirement = 86, manaCost = 12, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[29] = { 2000, 16.666667039196, 60, 12, 4, damageEffectiveness = 0.69, baseMultiplier = 0.689, levelRequirement = 88, manaCost = 13, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[30] = { 2000, 16.666667039196, 60, 12, 5, damageEffectiveness = 0.69, baseMultiplier = 0.694, levelRequirement = 90, manaCost = 13, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[31] = { 2000, 16.666667039196, 60, 12, 5, damageEffectiveness = 0.7, baseMultiplier = 0.698, levelRequirement = 91, manaCost = 13, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[32] = { 2000, 16.666667039196, 60, 12, 5, damageEffectiveness = 0.7, baseMultiplier = 0.703, levelRequirement = 92, manaCost = 13, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[33] = { 2000, 16.666667039196, 60, 12, 5, damageEffectiveness = 0.71, baseMultiplier = 0.708, levelRequirement = 93, manaCost = 14, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[34] = { 2000, 16.666667039196, 60, 12, 5, damageEffectiveness = 0.71, baseMultiplier = 0.713, levelRequirement = 94, manaCost = 14, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[35] = { 2000, 16.666667039196, 60, 12, 5, damageEffectiveness = 0.72, baseMultiplier = 0.718, levelRequirement = 95, manaCost = 14, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[36] = { 2000, 16.666667039196, 60, 12, 6, damageEffectiveness = 0.72, baseMultiplier = 0.723, levelRequirement = 96, manaCost = 14, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[37] = { 2000, 16.666667039196, 60, 12, 6, damageEffectiveness = 0.73, baseMultiplier = 0.728, levelRequirement = 97, manaCost = 15, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[38] = { 2000, 16.666667039196, 60, 12, 6, damageEffectiveness = 0.73, baseMultiplier = 0.733, levelRequirement = 98, manaCost = 15, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[39] = { 2000, 16.666667039196, 60, 12, 6, damageEffectiveness = 0.74, baseMultiplier = 0.738, levelRequirement = 99, manaCost = 15, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[40] = { 2000, 16.666667039196, 60, 12, 6, damageEffectiveness = 0.74, baseMultiplier = 0.743, levelRequirement = 100, manaCost = 15, statInterpolation = { 1, 3, 1, 1, 1, }, },
	},
}
skills["ChargedDash"] = {
	name = "Charged Dash",
	color = 2,
	description = "Channel to project an illusion which you steer. You gain stages while it moves, until it stops at a maximum total distance. Waves of area damage frequently pulse along its path, based on your attack speed. Stop channelling to teleport to the illusion, dealing a final wave of damage.",
	skillTypes = { [SkillType.MovementSkill] = true, [SkillType.Area] = true, [SkillType.Hit] = true, [SkillType.Channelled] = true, [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.LightningSkill] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["charged_dash_damage_+%_maximum"] = {
			mod("Damage", "MORE", nil, 0, bit.bor(KeywordFlag.Hit, KeywordFlag.Ailment), { type = "Multiplier", var = "ChargedDashDistance" }),
		},
		["base_skill_show_average_damage_instead_of_dps"] = {
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "attack_speed_+%", 0.5 },
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_lightning",
		"charged_dash_damage_+%_final",
		"charged_dash_damage_+%_final_per_stack",
		"charged_dash_channelling_damage_at_full_stacks_+%_final",
		"charged_dash_skill_inherent_movement_speed_+%_final",
		"is_area_damage",
		"base_skill_show_average_damage_instead_of_dps",
		"skill_can_add_multiple_charges_per_action",
	},
	levels = {
		[1] = { 50, -100, 75, 150, 30, baseMultiplier = 0.95, manaCost = 4, damageEffectiveness = 0.95, attackSpeedMultiplier = 60, levelRequirement = 28, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[2] = { 50, -100, 75, 150, 30, baseMultiplier = 0.958, manaCost = 4, damageEffectiveness = 0.96, attackSpeedMultiplier = 60, levelRequirement = 31, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[3] = { 50, -100, 75, 150, 30, baseMultiplier = 0.966, manaCost = 4, damageEffectiveness = 0.97, attackSpeedMultiplier = 60, levelRequirement = 34, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[4] = { 50, -100, 75, 150, 30, baseMultiplier = 0.974, manaCost = 4, damageEffectiveness = 0.97, attackSpeedMultiplier = 60, levelRequirement = 37, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[5] = { 50, -100, 75, 150, 30, baseMultiplier = 0.982, manaCost = 4, damageEffectiveness = 0.98, attackSpeedMultiplier = 60, levelRequirement = 40, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[6] = { 50, -100, 75, 150, 30, baseMultiplier = 0.989, manaCost = 4, damageEffectiveness = 0.99, attackSpeedMultiplier = 60, levelRequirement = 42, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[7] = { 50, -100, 75, 150, 30, baseMultiplier = 0.997, attackSpeedMultiplier = 60, levelRequirement = 44, manaCost = 4, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[8] = { 50, -100, 75, 150, 30, baseMultiplier = 1.005, manaCost = 4, damageEffectiveness = 1.01, attackSpeedMultiplier = 60, levelRequirement = 46, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[9] = { 50, -100, 75, 150, 30, baseMultiplier = 1.013, manaCost = 4, damageEffectiveness = 1.01, attackSpeedMultiplier = 60, levelRequirement = 48, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[10] = { 50, -100, 75, 150, 30, baseMultiplier = 1.021, manaCost = 4, damageEffectiveness = 1.02, attackSpeedMultiplier = 60, levelRequirement = 50, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[11] = { 50, -100, 75, 150, 30, baseMultiplier = 1.029, manaCost = 4, damageEffectiveness = 1.03, attackSpeedMultiplier = 60, levelRequirement = 52, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[12] = { 50, -100, 75, 150, 30, baseMultiplier = 1.037, manaCost = 4, damageEffectiveness = 1.04, attackSpeedMultiplier = 60, levelRequirement = 54, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[13] = { 50, -100, 75, 150, 30, baseMultiplier = 1.045, manaCost = 4, damageEffectiveness = 1.04, attackSpeedMultiplier = 60, levelRequirement = 56, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[14] = { 50, -100, 75, 150, 30, baseMultiplier = 1.053, manaCost = 4, damageEffectiveness = 1.05, attackSpeedMultiplier = 60, levelRequirement = 58, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[15] = { 50, -100, 75, 150, 30, baseMultiplier = 1.061, manaCost = 4, damageEffectiveness = 1.06, attackSpeedMultiplier = 60, levelRequirement = 60, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[16] = { 50, -100, 75, 150, 30, baseMultiplier = 1.068, manaCost = 4, damageEffectiveness = 1.07, attackSpeedMultiplier = 60, levelRequirement = 62, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[17] = { 50, -100, 75, 150, 30, baseMultiplier = 1.076, manaCost = 4, damageEffectiveness = 1.08, attackSpeedMultiplier = 60, levelRequirement = 64, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[18] = { 50, -100, 75, 150, 30, baseMultiplier = 1.084, manaCost = 4, damageEffectiveness = 1.08, attackSpeedMultiplier = 60, levelRequirement = 66, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[19] = { 50, -100, 75, 150, 30, baseMultiplier = 1.092, manaCost = 4, damageEffectiveness = 1.09, attackSpeedMultiplier = 60, levelRequirement = 68, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[20] = { 50, -100, 75, 150, 30, baseMultiplier = 1.1, manaCost = 4, damageEffectiveness = 1.1, attackSpeedMultiplier = 60, levelRequirement = 70, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[21] = { 50, -100, 75, 150, 30, baseMultiplier = 1.108, manaCost = 4, damageEffectiveness = 1.11, attackSpeedMultiplier = 60, levelRequirement = 72, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[22] = { 50, -100, 75, 150, 30, baseMultiplier = 1.116, manaCost = 4, damageEffectiveness = 1.12, attackSpeedMultiplier = 60, levelRequirement = 74, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[23] = { 50, -100, 75, 150, 30, baseMultiplier = 1.124, manaCost = 4, damageEffectiveness = 1.12, attackSpeedMultiplier = 60, levelRequirement = 76, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[24] = { 50, -100, 75, 150, 30, baseMultiplier = 1.132, manaCost = 4, damageEffectiveness = 1.13, attackSpeedMultiplier = 60, levelRequirement = 78, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[25] = { 50, -100, 75, 150, 30, baseMultiplier = 1.139, manaCost = 4, damageEffectiveness = 1.14, attackSpeedMultiplier = 60, levelRequirement = 80, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[26] = { 50, -100, 75, 150, 30, baseMultiplier = 1.147, manaCost = 4, damageEffectiveness = 1.15, attackSpeedMultiplier = 60, levelRequirement = 82, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[27] = { 50, -100, 75, 150, 30, baseMultiplier = 1.155, manaCost = 4, damageEffectiveness = 1.16, attackSpeedMultiplier = 60, levelRequirement = 84, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[28] = { 50, -100, 75, 150, 30, baseMultiplier = 1.163, manaCost = 4, damageEffectiveness = 1.16, attackSpeedMultiplier = 60, levelRequirement = 86, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[29] = { 50, -100, 75, 150, 30, baseMultiplier = 1.171, manaCost = 4, damageEffectiveness = 1.17, attackSpeedMultiplier = 60, levelRequirement = 88, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[30] = { 50, -100, 75, 150, 30, baseMultiplier = 1.179, manaCost = 4, damageEffectiveness = 1.18, attackSpeedMultiplier = 60, levelRequirement = 90, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[31] = { 50, -100, 75, 150, 30, baseMultiplier = 1.183, manaCost = 4, damageEffectiveness = 1.18, attackSpeedMultiplier = 60, levelRequirement = 91, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[32] = { 50, -100, 75, 150, 30, baseMultiplier = 1.187, manaCost = 4, damageEffectiveness = 1.19, attackSpeedMultiplier = 60, levelRequirement = 92, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[33] = { 50, -100, 75, 150, 30, baseMultiplier = 1.191, manaCost = 4, damageEffectiveness = 1.19, attackSpeedMultiplier = 60, levelRequirement = 93, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[34] = { 50, -100, 75, 150, 30, baseMultiplier = 1.195, manaCost = 4, damageEffectiveness = 1.19, attackSpeedMultiplier = 60, levelRequirement = 94, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[35] = { 50, -100, 75, 150, 30, baseMultiplier = 1.199, manaCost = 4, damageEffectiveness = 1.2, attackSpeedMultiplier = 60, levelRequirement = 95, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[36] = { 50, -100, 75, 150, 30, baseMultiplier = 1.203, manaCost = 4, damageEffectiveness = 1.2, attackSpeedMultiplier = 60, levelRequirement = 96, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[37] = { 50, -100, 75, 150, 30, baseMultiplier = 1.207, manaCost = 4, damageEffectiveness = 1.21, attackSpeedMultiplier = 60, levelRequirement = 97, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[38] = { 50, -100, 75, 150, 30, baseMultiplier = 1.211, manaCost = 4, damageEffectiveness = 1.21, attackSpeedMultiplier = 60, levelRequirement = 98, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[39] = { 50, -100, 75, 150, 30, baseMultiplier = 1.214, manaCost = 4, damageEffectiveness = 1.21, attackSpeedMultiplier = 60, levelRequirement = 99, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[40] = { 50, -100, 75, 150, 30, baseMultiplier = 1.218, manaCost = 4, damageEffectiveness = 1.22, attackSpeedMultiplier = 60, levelRequirement = 100, statInterpolation = { 1, 1, 1, 1, 1, }, },
	},
}
skills["CobraLash"] = {
	name = "Cobra Lash",
	color = 2,
	baseEffectiveness = 1,
	incrementalEffectiveness = 0.023299999535084,
	description = "Fires a poisonous projectile based on your weapon that will chain between enemies. Requires a Dagger or Claw.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.ProjectileAttack] = true, [SkillType.SkillCanMirageArcher] = true, [SkillType.Projectile] = true, [SkillType.SkillCanVolley] = true, [SkillType.Hit] = true, [SkillType.Triggerable] = true, [SkillType.ChaosSkill] = true, },
	weaponTypes = {
		["Dagger"] = true,
		["Claw"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "critical_strike_chance_+%", 1.5 },
	},
	stats = {
		"attack_minimum_added_chaos_damage",
		"attack_maximum_added_chaos_damage",
		"skill_physical_damage_%_to_convert_to_chaos",
		"number_of_chains",
		"projectile_speed_variation_+%",
		"projectile_angle_variance",
		"critical_poison_dot_multiplier_+",
		"base_chance_to_poison_on_hit_%",
		"base_is_projectile",
		"console_skill_dont_chase",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 50, 3, 15, 8, 50, 40, baseMultiplier = 0.75, manaCost = 5, damageEffectiveness = 0.75, attackSpeedMultiplier = 20, levelRequirement = 1, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[2] = { 0.80000001192093, 1.2000000476837, 50, 3, 15, 8, 50, 40, baseMultiplier = 0.777, manaCost = 5, damageEffectiveness = 0.78, attackSpeedMultiplier = 20, levelRequirement = 2, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[3] = { 0.80000001192093, 1.2000000476837, 50, 3, 15, 8, 50, 40, baseMultiplier = 0.803, manaCost = 5, damageEffectiveness = 0.8, attackSpeedMultiplier = 20, levelRequirement = 4, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[4] = { 0.80000001192093, 1.2000000476837, 50, 3, 15, 8, 50, 40, baseMultiplier = 0.83, manaCost = 5, damageEffectiveness = 0.83, attackSpeedMultiplier = 20, levelRequirement = 7, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[5] = { 0.80000001192093, 1.2000000476837, 50, 3, 15, 8, 50, 40, baseMultiplier = 0.856, manaCost = 6, damageEffectiveness = 0.86, attackSpeedMultiplier = 20, levelRequirement = 11, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[6] = { 0.80000001192093, 1.2000000476837, 50, 3, 15, 8, 50, 40, baseMultiplier = 0.883, manaCost = 6, damageEffectiveness = 0.88, attackSpeedMultiplier = 20, levelRequirement = 16, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[7] = { 0.80000001192093, 1.2000000476837, 50, 3, 15, 8, 50, 40, baseMultiplier = 0.909, manaCost = 6, damageEffectiveness = 0.91, attackSpeedMultiplier = 20, levelRequirement = 20, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[8] = { 0.80000001192093, 1.2000000476837, 50, 3, 15, 8, 50, 40, baseMultiplier = 0.936, manaCost = 6, damageEffectiveness = 0.94, attackSpeedMultiplier = 20, levelRequirement = 24, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[9] = { 0.80000001192093, 1.2000000476837, 50, 4, 15, 8, 50, 40, baseMultiplier = 0.962, manaCost = 6, damageEffectiveness = 0.96, attackSpeedMultiplier = 20, levelRequirement = 28, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[10] = { 0.80000001192093, 1.2000000476837, 50, 4, 15, 8, 50, 40, baseMultiplier = 0.989, manaCost = 6, damageEffectiveness = 0.99, attackSpeedMultiplier = 20, levelRequirement = 32, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[11] = { 0.80000001192093, 1.2000000476837, 50, 4, 15, 8, 50, 40, baseMultiplier = 1.016, manaCost = 6, damageEffectiveness = 1.02, attackSpeedMultiplier = 20, levelRequirement = 36, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[12] = { 0.80000001192093, 1.2000000476837, 50, 4, 15, 8, 50, 40, baseMultiplier = 1.042, manaCost = 6, damageEffectiveness = 1.04, attackSpeedMultiplier = 20, levelRequirement = 40, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[13] = { 0.80000001192093, 1.2000000476837, 50, 4, 15, 8, 50, 40, baseMultiplier = 1.069, manaCost = 7, damageEffectiveness = 1.07, attackSpeedMultiplier = 20, levelRequirement = 44, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[14] = { 0.80000001192093, 1.2000000476837, 50, 4, 15, 8, 50, 40, baseMultiplier = 1.095, manaCost = 7, damageEffectiveness = 1.1, attackSpeedMultiplier = 20, levelRequirement = 48, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[15] = { 0.80000001192093, 1.2000000476837, 50, 4, 15, 8, 50, 40, baseMultiplier = 1.122, manaCost = 7, damageEffectiveness = 1.12, attackSpeedMultiplier = 20, levelRequirement = 52, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[16] = { 0.80000001192093, 1.2000000476837, 50, 4, 15, 8, 50, 40, baseMultiplier = 1.148, manaCost = 7, damageEffectiveness = 1.15, attackSpeedMultiplier = 20, levelRequirement = 56, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[17] = { 0.80000001192093, 1.2000000476837, 50, 5, 15, 8, 50, 40, baseMultiplier = 1.175, manaCost = 7, damageEffectiveness = 1.18, attackSpeedMultiplier = 20, levelRequirement = 60, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[18] = { 0.80000001192093, 1.2000000476837, 50, 5, 15, 8, 50, 40, baseMultiplier = 1.201, manaCost = 7, damageEffectiveness = 1.2, attackSpeedMultiplier = 20, levelRequirement = 64, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[19] = { 0.80000001192093, 1.2000000476837, 50, 5, 15, 8, 50, 40, baseMultiplier = 1.228, manaCost = 7, damageEffectiveness = 1.23, attackSpeedMultiplier = 20, levelRequirement = 67, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 50, 5, 15, 8, 50, 40, baseMultiplier = 1.254, manaCost = 7, damageEffectiveness = 1.25, attackSpeedMultiplier = 20, levelRequirement = 70, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 50, 5, 15, 8, 50, 40, baseMultiplier = 1.281, manaCost = 8, damageEffectiveness = 1.28, attackSpeedMultiplier = 20, levelRequirement = 72, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 50, 5, 15, 8, 50, 40, baseMultiplier = 1.308, manaCost = 8, damageEffectiveness = 1.31, attackSpeedMultiplier = 20, levelRequirement = 74, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 50, 5, 15, 8, 50, 40, baseMultiplier = 1.334, manaCost = 8, damageEffectiveness = 1.33, attackSpeedMultiplier = 20, levelRequirement = 76, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 50, 5, 15, 8, 50, 40, baseMultiplier = 1.361, manaCost = 8, damageEffectiveness = 1.36, attackSpeedMultiplier = 20, levelRequirement = 78, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 50, 6, 15, 8, 50, 40, baseMultiplier = 1.387, manaCost = 8, damageEffectiveness = 1.39, attackSpeedMultiplier = 20, levelRequirement = 80, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 50, 6, 15, 8, 50, 40, baseMultiplier = 1.414, manaCost = 8, damageEffectiveness = 1.41, attackSpeedMultiplier = 20, levelRequirement = 82, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 50, 6, 15, 8, 50, 40, baseMultiplier = 1.44, manaCost = 8, damageEffectiveness = 1.44, attackSpeedMultiplier = 20, levelRequirement = 84, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 50, 6, 15, 8, 50, 40, baseMultiplier = 1.467, manaCost = 8, damageEffectiveness = 1.47, attackSpeedMultiplier = 20, levelRequirement = 86, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 50, 6, 15, 8, 50, 40, baseMultiplier = 1.493, manaCost = 9, damageEffectiveness = 1.49, attackSpeedMultiplier = 20, levelRequirement = 88, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 50, 6, 15, 8, 50, 40, baseMultiplier = 1.52, manaCost = 9, damageEffectiveness = 1.52, attackSpeedMultiplier = 20, levelRequirement = 90, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 50, 6, 15, 8, 50, 40, baseMultiplier = 1.52, manaCost = 9, damageEffectiveness = 1.52, attackSpeedMultiplier = 20, levelRequirement = 91, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 50, 6, 15, 8, 50, 40, baseMultiplier = 1.547, manaCost = 9, damageEffectiveness = 1.55, attackSpeedMultiplier = 20, levelRequirement = 92, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 50, 7, 15, 8, 50, 40, baseMultiplier = 1.573, manaCost = 9, damageEffectiveness = 1.57, attackSpeedMultiplier = 20, levelRequirement = 93, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[34] = { 0.80000001192093, 1.2000000476837, 50, 7, 15, 8, 50, 40, baseMultiplier = 1.6, manaCost = 9, damageEffectiveness = 1.6, attackSpeedMultiplier = 20, levelRequirement = 94, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[35] = { 0.80000001192093, 1.2000000476837, 50, 7, 15, 8, 50, 40, baseMultiplier = 1.626, manaCost = 9, damageEffectiveness = 1.63, attackSpeedMultiplier = 20, levelRequirement = 95, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[36] = { 0.80000001192093, 1.2000000476837, 50, 7, 15, 8, 50, 40, baseMultiplier = 1.653, manaCost = 9, damageEffectiveness = 1.65, attackSpeedMultiplier = 20, levelRequirement = 96, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[37] = { 0.80000001192093, 1.2000000476837, 50, 7, 15, 8, 50, 40, baseMultiplier = 1.679, manaCost = 10, damageEffectiveness = 1.68, attackSpeedMultiplier = 20, levelRequirement = 97, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[38] = { 0.80000001192093, 1.2000000476837, 50, 7, 15, 8, 50, 40, baseMultiplier = 1.706, manaCost = 10, damageEffectiveness = 1.71, attackSpeedMultiplier = 20, levelRequirement = 98, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[39] = { 0.80000001192093, 1.2000000476837, 50, 7, 15, 8, 50, 40, baseMultiplier = 1.732, manaCost = 10, damageEffectiveness = 1.73, attackSpeedMultiplier = 20, levelRequirement = 99, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[40] = { 0.80000001192093, 1.2000000476837, 50, 7, 15, 8, 50, 40, baseMultiplier = 1.759, manaCost = 10, damageEffectiveness = 1.76, attackSpeedMultiplier = 20, levelRequirement = 100, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
	},
}
skills["CorpseEruption"] = {
	name = "Cremation",
	color = 2,
	baseEffectiveness = 1.8178999423981,
	incrementalEffectiveness = 0.034499999135733,
	description = "A targeted corpse explodes, dealing area damage and turning into a volcanic geyser, which will repeatedly unleash projectiles sequentially over the surrounding area for a duration. The explosion of the corpse is not affected by modifiers to spell damage, and cannot be reflected.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.FireSkill] = true, [SkillType.Duration] = true, [SkillType.Projectile] = true, [SkillType.SpellCanRepeat] = true, [SkillType.SkillCanTrap] = true, [SkillType.SkillCanTotem] = true, [SkillType.SkillCanMine] = true, [SkillType.Triggerable] = true, [SkillType.Hit] = true, [SkillType.SpellCanCascade] = true, [SkillType.Projectile] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.6,
	parts = {
		{
			name = "Spell",
			spell = true,
			cast = false,
		},
		{
			name = "Corpse Explosion",
			spell = false,
			cast =  true,
		},
	},
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	baseMods = {
		skill("explodeCorpse", true, { type = "SkillPart", skillPart = 2 }),
	},
	qualityStats = {
		{ "fire_damage_+%", 1 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"base_skill_effect_duration",
		"corpse_erruption_base_maximum_number_of_geyers",
		"corpse_explosion_monster_life_%",
		"number_of_additional_projectiles",
		"active_skill_base_radius_+",
		"is_area_damage",
		"show_number_of_projectiles",
		"base_skill_show_average_damage_instead_of_dps",
		"base_is_projectile",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 0, critChance = 5, levelRequirement = 28, manaCost = 11, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[2] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 0, critChance = 5, levelRequirement = 31, manaCost = 11, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[3] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 0, critChance = 5, levelRequirement = 34, manaCost = 12, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[4] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 0, critChance = 5, levelRequirement = 37, manaCost = 13, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[5] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 0, critChance = 5, levelRequirement = 40, manaCost = 13, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[6] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 1, critChance = 5, levelRequirement = 42, manaCost = 14, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[7] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 1, critChance = 5, levelRequirement = 44, manaCost = 14, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[8] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 1, critChance = 5, levelRequirement = 46, manaCost = 15, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[9] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 1, critChance = 5, levelRequirement = 48, manaCost = 15, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[10] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 1, critChance = 5, levelRequirement = 50, manaCost = 15, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[11] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 2, critChance = 5, levelRequirement = 52, manaCost = 16, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[12] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 2, critChance = 5, levelRequirement = 54, manaCost = 16, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[13] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 2, critChance = 5, levelRequirement = 56, manaCost = 17, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[14] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 2, critChance = 5, levelRequirement = 58, manaCost = 17, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[15] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 2, critChance = 5, levelRequirement = 60, manaCost = 18, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[16] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 3, critChance = 5, levelRequirement = 62, manaCost = 18, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[17] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 3, critChance = 5, levelRequirement = 64, manaCost = 18, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[18] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 3, critChance = 5, levelRequirement = 66, manaCost = 19, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[19] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 3, critChance = 5, levelRequirement = 68, manaCost = 19, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 3, critChance = 5, levelRequirement = 70, manaCost = 20, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 4, critChance = 5, levelRequirement = 72, manaCost = 20, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 4, critChance = 5, levelRequirement = 74, manaCost = 21, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 4, critChance = 5, levelRequirement = 76, manaCost = 21, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 4, critChance = 5, levelRequirement = 78, manaCost = 21, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 4, critChance = 5, levelRequirement = 80, manaCost = 22, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 5, critChance = 5, levelRequirement = 82, manaCost = 22, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 5, critChance = 5, levelRequirement = 84, manaCost = 23, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 5, critChance = 5, levelRequirement = 86, manaCost = 23, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 5, critChance = 5, levelRequirement = 88, manaCost = 24, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 5, critChance = 5, levelRequirement = 90, manaCost = 24, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 5, critChance = 5, levelRequirement = 91, manaCost = 24, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 6, critChance = 5, levelRequirement = 92, manaCost = 25, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 6, critChance = 5, levelRequirement = 93, manaCost = 25, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[34] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 6, critChance = 5, levelRequirement = 94, manaCost = 25, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[35] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 6, critChance = 5, levelRequirement = 95, manaCost = 25, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[36] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 6, critChance = 5, levelRequirement = 96, manaCost = 25, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[37] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 6, critChance = 5, levelRequirement = 97, manaCost = 26, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[38] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 6, critChance = 5, levelRequirement = 98, manaCost = 26, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[39] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 6, critChance = 5, levelRequirement = 99, manaCost = 26, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
		[40] = { 0.80000001192093, 1.2000000476837, 8000, 3, 4, 3, 6, critChance = 5, levelRequirement = 100, manaCost = 26, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, },
	},
}
skills["Cyclone"] = {
	name = "Cyclone",
	color = 2,
	baseEffectiveness = 0.25,
	incrementalEffectiveness = 0.023299999535084,
	description = "Channel this skill to move towards a targeted location while spinning, building up stages while constantly attacking enemies in an area around you. While channelling this skill, you cannot be stunned or knocked back.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.MovementSkill] = true, [SkillType.Type65] = true, [SkillType.Channelled] = true, [SkillType.PhysicalSkill] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "No Stages",
		},
		{
			name = "Max Stages",
		},
	},
	statMap = {
		["cyclone_max_number_of_stages"] = {
			mod("Multiplier:CycloneMaxStages", "BASE", nil),
		},
		["cyclone_area_of_effect_+%_per_additional_melee_range"] = {
			mod("AreaOfEffect", "INC", nil, 0, 0, { type = "Multiplier", var = "AdditionalMeleeRange"}),
		},
	},
	initialFunc = function(activeSkill, output)
		local rangePlus = 0
		if activeSkill.skillFlags.weapon1Attack then
			rangePlus = math.max(rangePlus, activeSkill.actor.weaponData1.range and activeSkill.skillModList:Sum("BASE", activeSkill.weapon1Cfg, "MeleeWeaponRange") or activeSkill.skillModList:Sum("BASE", activeSkill.skillCfg, "UnarmedRange"))
		end
		if activeSkill.skillFlags.weapon2Attack then
			rangePlus = math.max(rangePlus, activeSkill.actor.weaponData2.range and activeSkill.skillModList:Sum("BASE", activeSkill.weapon2Cfg, "MeleeWeaponRange") or activeSkill.skillModList:Sum("BASE", activeSkill.skillCfg, "UnarmedRange"))
		end
		activeSkill.skillModList:NewMod("Multiplier:AdditionalMeleeRange", "BASE", rangePlus, "Skill:Cyclone")
	end,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("radius", 11),
		mod("Multiplier:CycloneStage", "BASE", 1, 0, 0, { type = "Multiplier", var = "CycloneMaxStages" }, { type = "SkillPart", skillPart = 2 }),
		skill("radiusExtra", 1, { type = "Multiplier", var = "CycloneStage" }),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 0.5 },
	},
	stats = {
		"cyclone_movement_speed_+%_final",
		"cyclone_first_hit_damage_+%_final",
		"cyclone_gain_stage_every_x_ms_while_channelling",
		"cyclone_melee_weapon_range_+_per_stage",
		"cyclone_stage_decay_time_ms",
		"attack_minimum_added_physical_damage",
		"attack_maximum_added_physical_damage",
		"cyclone_max_number_of_stages",
		"cyclone_area_of_effect_+%_per_additional_melee_range",
		"is_area_damage",
		"skill_can_add_multiple_charges_per_action",
	},
	levels = {
		[1] = { -30, -50, 330, 1, 330, 0.80000001192093, 1.2000000476837, 3, 8, baseMultiplier = 0.44, manaCost = 2, damageEffectiveness = 0.44, attackSpeedMultiplier = 200, levelRequirement = 28, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[2] = { -30, -50, 330, 1, 330, 0.80000001192093, 1.2000000476837, 3, 8, baseMultiplier = 0.445, manaCost = 2, damageEffectiveness = 0.45, attackSpeedMultiplier = 200, levelRequirement = 31, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[3] = { -30, -50, 330, 1, 330, 0.80000001192093, 1.2000000476837, 3, 8, baseMultiplier = 0.451, manaCost = 2, damageEffectiveness = 0.45, attackSpeedMultiplier = 200, levelRequirement = 34, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[4] = { -30, -50, 330, 1, 330, 0.80000001192093, 1.2000000476837, 3, 8, baseMultiplier = 0.456, manaCost = 2, damageEffectiveness = 0.46, attackSpeedMultiplier = 200, levelRequirement = 37, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[5] = { -30, -50, 330, 1, 330, 0.80000001192093, 1.2000000476837, 3, 8, baseMultiplier = 0.461, manaCost = 2, damageEffectiveness = 0.46, attackSpeedMultiplier = 200, levelRequirement = 40, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[6] = { -30, -50, 250, 1, 330, 0.80000001192093, 1.2000000476837, 4, 8, baseMultiplier = 0.466, manaCost = 2, damageEffectiveness = 0.47, attackSpeedMultiplier = 200, levelRequirement = 42, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[7] = { -30, -50, 250, 1, 330, 0.80000001192093, 1.2000000476837, 4, 8, baseMultiplier = 0.472, manaCost = 2, damageEffectiveness = 0.47, attackSpeedMultiplier = 200, levelRequirement = 44, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[8] = { -30, -50, 250, 1, 330, 0.80000001192093, 1.2000000476837, 4, 8, baseMultiplier = 0.477, manaCost = 2, damageEffectiveness = 0.48, attackSpeedMultiplier = 200, levelRequirement = 46, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[9] = { -30, -50, 250, 1, 330, 0.80000001192093, 1.2000000476837, 4, 8, baseMultiplier = 0.482, manaCost = 2, damageEffectiveness = 0.48, attackSpeedMultiplier = 200, levelRequirement = 48, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[10] = { -30, -50, 250, 1, 330, 0.80000001192093, 1.2000000476837, 4, 8, baseMultiplier = 0.487, manaCost = 2, damageEffectiveness = 0.49, attackSpeedMultiplier = 200, levelRequirement = 50, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[11] = { -30, -50, 200, 1, 330, 0.80000001192093, 1.2000000476837, 5, 8, baseMultiplier = 0.493, manaCost = 2, damageEffectiveness = 0.49, attackSpeedMultiplier = 200, levelRequirement = 52, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[12] = { -30, -50, 200, 1, 330, 0.80000001192093, 1.2000000476837, 5, 8, baseMultiplier = 0.498, manaCost = 2, damageEffectiveness = 0.5, attackSpeedMultiplier = 200, levelRequirement = 54, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[13] = { -30, -50, 200, 1, 330, 0.80000001192093, 1.2000000476837, 5, 8, baseMultiplier = 0.503, manaCost = 2, damageEffectiveness = 0.5, attackSpeedMultiplier = 200, levelRequirement = 56, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[14] = { -30, -50, 200, 1, 330, 0.80000001192093, 1.2000000476837, 5, 8, baseMultiplier = 0.508, manaCost = 2, damageEffectiveness = 0.51, attackSpeedMultiplier = 200, levelRequirement = 58, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[15] = { -30, -50, 200, 1, 330, 0.80000001192093, 1.2000000476837, 5, 8, baseMultiplier = 0.514, manaCost = 2, damageEffectiveness = 0.51, attackSpeedMultiplier = 200, levelRequirement = 60, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[16] = { -30, -50, 170, 1, 330, 0.80000001192093, 1.2000000476837, 6, 8, baseMultiplier = 0.519, manaCost = 2, damageEffectiveness = 0.52, attackSpeedMultiplier = 200, levelRequirement = 62, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[17] = { -30, -50, 170, 1, 330, 0.80000001192093, 1.2000000476837, 6, 8, baseMultiplier = 0.524, manaCost = 2, damageEffectiveness = 0.52, attackSpeedMultiplier = 200, levelRequirement = 64, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[18] = { -30, -50, 170, 1, 330, 0.80000001192093, 1.2000000476837, 6, 8, baseMultiplier = 0.529, manaCost = 2, damageEffectiveness = 0.53, attackSpeedMultiplier = 200, levelRequirement = 66, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[19] = { -30, -50, 170, 1, 330, 0.80000001192093, 1.2000000476837, 6, 8, baseMultiplier = 0.535, manaCost = 2, damageEffectiveness = 0.53, attackSpeedMultiplier = 200, levelRequirement = 68, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[20] = { -30, -50, 170, 1, 330, 0.80000001192093, 1.2000000476837, 6, 8, baseMultiplier = 0.54, manaCost = 2, damageEffectiveness = 0.54, attackSpeedMultiplier = 200, levelRequirement = 70, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[21] = { -30, -50, 140, 1, 330, 0.80000001192093, 1.2000000476837, 7, 8, baseMultiplier = 0.545, manaCost = 2, damageEffectiveness = 0.55, attackSpeedMultiplier = 200, levelRequirement = 72, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[22] = { -30, -50, 140, 1, 330, 0.80000001192093, 1.2000000476837, 7, 8, baseMultiplier = 0.551, manaCost = 2, damageEffectiveness = 0.55, attackSpeedMultiplier = 200, levelRequirement = 74, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[23] = { -30, -50, 140, 1, 330, 0.80000001192093, 1.2000000476837, 7, 8, baseMultiplier = 0.556, manaCost = 2, damageEffectiveness = 0.56, attackSpeedMultiplier = 200, levelRequirement = 76, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[24] = { -30, -50, 140, 1, 330, 0.80000001192093, 1.2000000476837, 7, 8, baseMultiplier = 0.561, manaCost = 2, damageEffectiveness = 0.56, attackSpeedMultiplier = 200, levelRequirement = 78, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[25] = { -30, -50, 140, 1, 330, 0.80000001192093, 1.2000000476837, 7, 8, baseMultiplier = 0.566, manaCost = 2, damageEffectiveness = 0.57, attackSpeedMultiplier = 200, levelRequirement = 80, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[26] = { -30, -50, 125, 1, 330, 0.80000001192093, 1.2000000476837, 8, 8, baseMultiplier = 0.572, manaCost = 2, damageEffectiveness = 0.57, attackSpeedMultiplier = 200, levelRequirement = 82, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[27] = { -30, -50, 125, 1, 330, 0.80000001192093, 1.2000000476837, 8, 8, baseMultiplier = 0.577, manaCost = 2, damageEffectiveness = 0.58, attackSpeedMultiplier = 200, levelRequirement = 84, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[28] = { -30, -50, 125, 1, 330, 0.80000001192093, 1.2000000476837, 8, 8, baseMultiplier = 0.582, manaCost = 2, damageEffectiveness = 0.58, attackSpeedMultiplier = 200, levelRequirement = 86, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[29] = { -30, -50, 125, 1, 330, 0.80000001192093, 1.2000000476837, 8, 8, baseMultiplier = 0.587, manaCost = 2, damageEffectiveness = 0.59, attackSpeedMultiplier = 200, levelRequirement = 88, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[30] = { -30, -50, 125, 1, 330, 0.80000001192093, 1.2000000476837, 8, 8, baseMultiplier = 0.593, manaCost = 2, damageEffectiveness = 0.59, attackSpeedMultiplier = 200, levelRequirement = 90, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[31] = { -30, -50, 125, 1, 330, 0.80000001192093, 1.2000000476837, 8, 8, baseMultiplier = 0.595, manaCost = 2, damageEffectiveness = 0.6, attackSpeedMultiplier = 200, levelRequirement = 91, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[32] = { -30, -50, 110, 1, 330, 0.80000001192093, 1.2000000476837, 9, 8, baseMultiplier = 0.598, manaCost = 2, damageEffectiveness = 0.6, attackSpeedMultiplier = 200, levelRequirement = 92, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[33] = { -30, -50, 110, 1, 330, 0.80000001192093, 1.2000000476837, 9, 8, baseMultiplier = 0.601, manaCost = 2, damageEffectiveness = 0.6, attackSpeedMultiplier = 200, levelRequirement = 93, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[34] = { -30, -50, 110, 1, 330, 0.80000001192093, 1.2000000476837, 9, 8, baseMultiplier = 0.603, manaCost = 2, damageEffectiveness = 0.6, attackSpeedMultiplier = 200, levelRequirement = 94, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[35] = { -30, -50, 110, 1, 330, 0.80000001192093, 1.2000000476837, 9, 8, baseMultiplier = 0.606, manaCost = 2, damageEffectiveness = 0.61, attackSpeedMultiplier = 200, levelRequirement = 95, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[36] = { -30, -50, 110, 1, 330, 0.80000001192093, 1.2000000476837, 9, 8, baseMultiplier = 0.608, manaCost = 2, damageEffectiveness = 0.61, attackSpeedMultiplier = 200, levelRequirement = 96, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[37] = { -30, -50, 110, 1, 330, 0.80000001192093, 1.2000000476837, 9, 8, baseMultiplier = 0.611, manaCost = 2, damageEffectiveness = 0.61, attackSpeedMultiplier = 200, levelRequirement = 97, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[38] = { -30, -50, 110, 1, 330, 0.80000001192093, 1.2000000476837, 9, 8, baseMultiplier = 0.614, manaCost = 2, damageEffectiveness = 0.61, attackSpeedMultiplier = 200, levelRequirement = 98, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[39] = { -30, -50, 110, 1, 330, 0.80000001192093, 1.2000000476837, 9, 8, baseMultiplier = 0.616, manaCost = 2, damageEffectiveness = 0.62, attackSpeedMultiplier = 200, levelRequirement = 99, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[40] = { -30, -50, 110, 1, 330, 0.80000001192093, 1.2000000476837, 9, 8, baseMultiplier = 0.619, manaCost = 2, damageEffectiveness = 0.62, attackSpeedMultiplier = 200, levelRequirement = 100, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 1, 1, }, },
	},
}
skills["VaalCyclone"] = {
	name = "Vaal Cyclone",
	color = 2,
	baseEffectiveness = 0.25,
	incrementalEffectiveness = 0.023299999535084,
	description = "Spin and attack in place, damaging nearby enemies and pulling others towards you. While using this skill, you cannot be stunned or knocked back. Cannot be supported by Ruthless.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Duration] = true, [SkillType.Vaal] = true, [SkillType.Type65] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["cyclone_area_of_effect_+%_per_additional_melee_range"] = {
			mod("AreaOfEffect", "INC", nil, 0, 0, { type = "Multiplier", var = "AdditionalMeleeRange"}),
		},
	},
	initialFunc = function(activeSkill, output)
		local rangePlus = 0
		if activeSkill.skillFlags.weapon1Attack then
			rangePlus = math.max(rangePlus, activeSkill.actor.weaponData1.range and activeSkill.skillModList:Sum("BASE", activeSkill.weapon1Cfg, "MeleeWeaponRange") or activeSkill.skillModList:Sum("BASE", activeSkill.skillCfg, "UnarmedRange"))
		end
		if activeSkill.skillFlags.weapon2Attack then
			rangePlus = math.max(rangePlus, activeSkill.actor.weaponData2.range and activeSkill.skillModList:Sum("BASE", activeSkill.weapon2Cfg, "MeleeWeaponRange") or activeSkill.skillModList:Sum("BASE", activeSkill.skillCfg, "UnarmedRange"))
		end
		activeSkill.skillModList:NewMod("Multiplier:AdditionalMeleeRange", "BASE", rangePlus, "Skill:Cyclone")
	end,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
		duration = true,
		vaal = true,
	},
	baseMods = {
		skill("radius", 24),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 0.5 },
	},
	stats = {
		"base_skill_effect_duration",
		"base_skill_number_of_additional_hits",
		"base_skill_area_of_effect_+%",
		"melee_range_+",
		"attack_minimum_added_physical_damage",
		"attack_maximum_added_physical_damage",
		"cyclone_area_of_effect_+%_per_additional_melee_range",
		"is_area_damage",
		"global_always_hit",
		"modifiers_to_skill_effect_duration_also_affect_soul_prevention_duration",
		"cannot_cancel_skill_before_contact_point",
		"skill_can_add_multiple_charges_per_action",
	},
	levels = {
		[1] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.5, attackSpeedMultiplier = 300, baseMultiplier = 0.5, levelRequirement = 28, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[2] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.51, attackSpeedMultiplier = 300, baseMultiplier = 0.506, levelRequirement = 31, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[3] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.51, attackSpeedMultiplier = 300, baseMultiplier = 0.512, levelRequirement = 34, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[4] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.52, attackSpeedMultiplier = 300, baseMultiplier = 0.518, levelRequirement = 37, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[5] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.52, attackSpeedMultiplier = 300, baseMultiplier = 0.524, levelRequirement = 40, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[6] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.53, attackSpeedMultiplier = 300, baseMultiplier = 0.53, levelRequirement = 42, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[7] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.54, attackSpeedMultiplier = 300, baseMultiplier = 0.536, levelRequirement = 44, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[8] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.54, attackSpeedMultiplier = 300, baseMultiplier = 0.542, levelRequirement = 46, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[9] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.55, attackSpeedMultiplier = 300, baseMultiplier = 0.548, levelRequirement = 48, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[10] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.55, attackSpeedMultiplier = 300, baseMultiplier = 0.554, levelRequirement = 50, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[11] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.56, attackSpeedMultiplier = 300, baseMultiplier = 0.56, levelRequirement = 52, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[12] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.57, attackSpeedMultiplier = 300, baseMultiplier = 0.566, levelRequirement = 54, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[13] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.57, attackSpeedMultiplier = 300, baseMultiplier = 0.572, levelRequirement = 56, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[14] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.58, attackSpeedMultiplier = 300, baseMultiplier = 0.578, levelRequirement = 58, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[15] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.58, attackSpeedMultiplier = 300, baseMultiplier = 0.584, levelRequirement = 60, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[16] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.59, attackSpeedMultiplier = 300, baseMultiplier = 0.59, levelRequirement = 62, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[17] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.6, attackSpeedMultiplier = 300, baseMultiplier = 0.596, levelRequirement = 64, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[18] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.6, attackSpeedMultiplier = 300, baseMultiplier = 0.602, levelRequirement = 66, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[19] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.61, attackSpeedMultiplier = 300, baseMultiplier = 0.608, levelRequirement = 68, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[20] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.61, attackSpeedMultiplier = 300, baseMultiplier = 0.614, levelRequirement = 70, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[21] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.62, attackSpeedMultiplier = 300, baseMultiplier = 0.62, levelRequirement = 72, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[22] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.63, attackSpeedMultiplier = 300, baseMultiplier = 0.626, levelRequirement = 74, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[23] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.63, attackSpeedMultiplier = 300, baseMultiplier = 0.632, levelRequirement = 76, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[24] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.64, attackSpeedMultiplier = 300, baseMultiplier = 0.638, levelRequirement = 78, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[25] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.64, attackSpeedMultiplier = 300, baseMultiplier = 0.644, levelRequirement = 80, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[26] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.65, attackSpeedMultiplier = 300, baseMultiplier = 0.65, levelRequirement = 82, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[27] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.66, attackSpeedMultiplier = 300, baseMultiplier = 0.656, levelRequirement = 84, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[28] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.66, attackSpeedMultiplier = 300, baseMultiplier = 0.662, levelRequirement = 86, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[29] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.67, attackSpeedMultiplier = 300, baseMultiplier = 0.668, levelRequirement = 88, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[30] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.67, attackSpeedMultiplier = 300, baseMultiplier = 0.674, levelRequirement = 90, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[31] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.68, attackSpeedMultiplier = 300, baseMultiplier = 0.677, levelRequirement = 91, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[32] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.68, attackSpeedMultiplier = 300, baseMultiplier = 0.68, levelRequirement = 92, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[33] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.68, attackSpeedMultiplier = 300, baseMultiplier = 0.683, levelRequirement = 93, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[34] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.69, attackSpeedMultiplier = 300, baseMultiplier = 0.686, levelRequirement = 94, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[35] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.69, attackSpeedMultiplier = 300, baseMultiplier = 0.689, levelRequirement = 95, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[36] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.69, attackSpeedMultiplier = 300, baseMultiplier = 0.692, levelRequirement = 96, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[37] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.69, attackSpeedMultiplier = 300, baseMultiplier = 0.695, levelRequirement = 97, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[38] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.7, attackSpeedMultiplier = 300, baseMultiplier = 0.698, levelRequirement = 98, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[39] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.7, attackSpeedMultiplier = 300, baseMultiplier = 0.701, levelRequirement = 99, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[40] = { 5000, 0, 0, 0, 0.80000001192093, 1.2000000476837, 8, damageEffectiveness = 0.7, attackSpeedMultiplier = 300, baseMultiplier = 0.704, levelRequirement = 100, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
	},
}
skills["QuickDodge"] = {
	name = "Dash",
	color = 2,
	description = "Performs a series of quick teleports towards a targeted location. If using the \"Attack in Place\" option, the direction is reversed. Shares a cooldown with other Blink skills.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.MovementSkill] = true, [SkillType.TravelSkill] = true, [SkillType.BlinkSkill] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.15,
	baseFlags = {
		spell = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "base_cooldown_speed_+%", 0.5 },
	},
	stats = {
		"base_cooldown_speed_+%",
		"base_deal_no_damage",
		"skill_cannot_be_interrupted",
		"skill_cannot_be_knocked_back",
		"skill_cannot_be_stunned",
		"spell_cast_time_cannot_be_modified",
	},
	levels = {
		[1] = { 0, cooldown = 2, levelRequirement = 4, manaCost = 4, statInterpolation = { 1, }, },
		[2] = { 3, cooldown = 2, levelRequirement = 6, manaCost = 5, statInterpolation = { 1, }, },
		[3] = { 6, cooldown = 2, levelRequirement = 9, manaCost = 5, statInterpolation = { 1, }, },
		[4] = { 9, cooldown = 2, levelRequirement = 12, manaCost = 6, statInterpolation = { 1, }, },
		[5] = { 12, cooldown = 2, levelRequirement = 16, manaCost = 7, statInterpolation = { 1, }, },
		[6] = { 15, cooldown = 2, levelRequirement = 20, manaCost = 7, statInterpolation = { 1, }, },
		[7] = { 18, cooldown = 2, levelRequirement = 24, manaCost = 8, statInterpolation = { 1, }, },
		[8] = { 21, cooldown = 2, levelRequirement = 28, manaCost = 9, statInterpolation = { 1, }, },
		[9] = { 24, cooldown = 2, levelRequirement = 32, manaCost = 10, statInterpolation = { 1, }, },
		[10] = { 27, cooldown = 2, levelRequirement = 36, manaCost = 10, statInterpolation = { 1, }, },
		[11] = { 30, cooldown = 2, levelRequirement = 40, manaCost = 11, statInterpolation = { 1, }, },
		[12] = { 33, cooldown = 2, levelRequirement = 44, manaCost = 12, statInterpolation = { 1, }, },
		[13] = { 36, cooldown = 2, levelRequirement = 48, manaCost = 12, statInterpolation = { 1, }, },
		[14] = { 39, cooldown = 2, levelRequirement = 52, manaCost = 13, statInterpolation = { 1, }, },
		[15] = { 42, cooldown = 2, levelRequirement = 55, manaCost = 14, statInterpolation = { 1, }, },
		[16] = { 45, cooldown = 2, levelRequirement = 58, manaCost = 14, statInterpolation = { 1, }, },
		[17] = { 48, cooldown = 2, levelRequirement = 61, manaCost = 15, statInterpolation = { 1, }, },
		[18] = { 51, cooldown = 2, levelRequirement = 64, manaCost = 15, statInterpolation = { 1, }, },
		[19] = { 54, cooldown = 2, levelRequirement = 67, manaCost = 16, statInterpolation = { 1, }, },
		[20] = { 57, cooldown = 2, levelRequirement = 70, manaCost = 16, statInterpolation = { 1, }, },
		[21] = { 60, cooldown = 2, levelRequirement = 72, manaCost = 17, statInterpolation = { 1, }, },
		[22] = { 63, cooldown = 2, levelRequirement = 74, manaCost = 17, statInterpolation = { 1, }, },
		[23] = { 66, cooldown = 2, levelRequirement = 76, manaCost = 18, statInterpolation = { 1, }, },
		[24] = { 69, cooldown = 2, levelRequirement = 78, manaCost = 18, statInterpolation = { 1, }, },
		[25] = { 72, cooldown = 2, levelRequirement = 80, manaCost = 18, statInterpolation = { 1, }, },
		[26] = { 75, cooldown = 2, levelRequirement = 82, manaCost = 19, statInterpolation = { 1, }, },
		[27] = { 78, cooldown = 2, levelRequirement = 84, manaCost = 19, statInterpolation = { 1, }, },
		[28] = { 81, cooldown = 2, levelRequirement = 86, manaCost = 19, statInterpolation = { 1, }, },
		[29] = { 84, cooldown = 2, levelRequirement = 88, manaCost = 20, statInterpolation = { 1, }, },
		[30] = { 87, cooldown = 2, levelRequirement = 90, manaCost = 20, statInterpolation = { 1, }, },
		[31] = { 88, cooldown = 2, levelRequirement = 91, manaCost = 20, statInterpolation = { 1, }, },
		[32] = { 90, cooldown = 2, levelRequirement = 92, manaCost = 20, statInterpolation = { 1, }, },
		[33] = { 91, cooldown = 2, levelRequirement = 93, manaCost = 21, statInterpolation = { 1, }, },
		[34] = { 93, cooldown = 2, levelRequirement = 94, manaCost = 21, statInterpolation = { 1, }, },
		[35] = { 94, cooldown = 2, levelRequirement = 95, manaCost = 21, statInterpolation = { 1, }, },
		[36] = { 96, cooldown = 2, levelRequirement = 96, manaCost = 21, statInterpolation = { 1, }, },
		[37] = { 97, cooldown = 2, levelRequirement = 97, manaCost = 21, statInterpolation = { 1, }, },
		[38] = { 99, cooldown = 2, levelRequirement = 98, manaCost = 22, statInterpolation = { 1, }, },
		[39] = { 100, cooldown = 2, levelRequirement = 99, manaCost = 22, statInterpolation = { 1, }, },
		[40] = { 102, cooldown = 2, levelRequirement = 100, manaCost = 22, statInterpolation = { 1, }, },
	},
}
skills["Desecrate"] = {
	name = "Desecrate",
	color = 2,
	baseEffectiveness = 1.6000000238419,
	incrementalEffectiveness = 0.046500001102686,
	description = "Desecrates the ground, summoning corpses and dealing chaos damage to all enemies in the area. The corpses will be chosen from the monsters in the current area and any Spectres that have existed in this instance.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.SkillCanTrap] = true, [SkillType.SkillCanTotem] = true, [SkillType.SkillCanMine] = true, [SkillType.Triggerable] = true, [SkillType.DamageOverTime] = true, [SkillType.SpellCanRepeat] = true, [SkillType.ChaosSkill] = true, [SkillType.SpellCanCascade] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.6,
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
		chaos = true,
	},
	baseMods = {
		skill("dotIsArea", true),
	},
	qualityStats = {
		{ "base_cast_speed_+%", 1 },
	},
	stats = {
		"base_skill_effect_duration",
		"base_chaos_damage_to_deal_per_minute",
		"desecrate_number_of_corpses_to_create",
		"desecrate_corpse_level",
		"desecrate_maximum_number_of_corpses",
		"is_area_damage",
	},
	levels = {
		[1] = { 4000, 16.666667039196, 5, 20, 10, manaCost = 11, levelRequirement = 16, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[2] = { 4000, 16.666667039196, 5, 24, 10, manaCost = 12, levelRequirement = 20, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[3] = { 4000, 16.666667039196, 5, 28, 10, manaCost = 13, levelRequirement = 24, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[4] = { 4000, 16.666667039196, 5, 32, 10, manaCost = 14, levelRequirement = 28, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[5] = { 4000, 16.666667039196, 5, 35, 10, manaCost = 15, levelRequirement = 31, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[6] = { 4000, 16.666667039196, 5, 38, 10, manaCost = 16, levelRequirement = 34, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[7] = { 4000, 16.666667039196, 5, 41, 10, manaCost = 17, levelRequirement = 37, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[8] = { 4000, 16.666667039196, 5, 44, 10, manaCost = 18, levelRequirement = 40, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[9] = { 4000, 16.666667039196, 5, 47, 10, manaCost = 18, levelRequirement = 43, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[10] = { 4000, 16.666667039196, 5, 50, 10, manaCost = 19, levelRequirement = 46, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[11] = { 4000, 16.666667039196, 5, 53, 10, manaCost = 20, levelRequirement = 49, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[12] = { 4000, 16.666667039196, 5, 56, 10, manaCost = 21, levelRequirement = 52, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[13] = { 4000, 16.666667039196, 5, 59, 10, manaCost = 22, levelRequirement = 55, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[14] = { 4000, 16.666667039196, 5, 62, 10, manaCost = 23, levelRequirement = 58, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[15] = { 4000, 16.666667039196, 5, 65, 10, manaCost = 23, levelRequirement = 60, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[16] = { 4000, 16.666667039196, 5, 69, 10, manaCost = 24, levelRequirement = 62, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[17] = { 4000, 16.666667039196, 5, 73, 10, manaCost = 25, levelRequirement = 64, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[18] = { 4000, 16.666667039196, 5, 77, 10, manaCost = 25, levelRequirement = 66, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[19] = { 4000, 16.666667039196, 5, 81, 10, manaCost = 26, levelRequirement = 68, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[20] = { 4000, 16.666667039196, 5, 100, 10, manaCost = 26, levelRequirement = 70, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[21] = { 4000, 16.666667039196, 5, 100, 10, manaCost = 27, levelRequirement = 72, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[22] = { 4000, 16.666667039196, 5, 100, 10, manaCost = 27, levelRequirement = 74, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[23] = { 4000, 16.666667039196, 5, 100, 10, manaCost = 28, levelRequirement = 76, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[24] = { 4000, 16.666667039196, 5, 100, 10, manaCost = 29, levelRequirement = 78, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[25] = { 4000, 16.666667039196, 5, 100, 10, manaCost = 29, levelRequirement = 80, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[26] = { 4000, 16.666667039196, 5, 100, 10, manaCost = 30, levelRequirement = 82, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[27] = { 4000, 16.666667039196, 5, 100, 10, manaCost = 30, levelRequirement = 84, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[28] = { 4000, 16.666667039196, 5, 100, 10, manaCost = 31, levelRequirement = 86, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[29] = { 4000, 16.666667039196, 5, 100, 10, manaCost = 32, levelRequirement = 88, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[30] = { 4000, 16.666667039196, 5, 100, 10, manaCost = 32, levelRequirement = 90, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[31] = { 4000, 16.666667039196, 5, 100, 10, manaCost = 32, levelRequirement = 91, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[32] = { 4000, 16.666667039196, 5, 100, 10, manaCost = 33, levelRequirement = 92, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[33] = { 4000, 16.666667039196, 5, 100, 10, manaCost = 33, levelRequirement = 93, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[34] = { 4000, 16.666667039196, 5, 100, 10, manaCost = 33, levelRequirement = 94, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[35] = { 4000, 16.666667039196, 5, 100, 10, manaCost = 34, levelRequirement = 95, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[36] = { 4000, 16.666667039196, 5, 100, 10, manaCost = 34, levelRequirement = 96, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[37] = { 4000, 16.666667039196, 5, 100, 10, manaCost = 34, levelRequirement = 97, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[38] = { 4000, 16.666667039196, 5, 100, 10, manaCost = 34, levelRequirement = 98, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[39] = { 4000, 16.666667039196, 5, 100, 10, manaCost = 35, levelRequirement = 99, statInterpolation = { 1, 3, 1, 1, 1, }, },
		[40] = { 4000, 16.666667039196, 5, 100, 10, manaCost = 35, levelRequirement = 100, statInterpolation = { 1, 3, 1, 1, 1, }, },
	},
}
skills["DetonateDead"] = {
	name = "Detonate Dead",
	color = 2,
	baseEffectiveness = 4.0300002098083,
	incrementalEffectiveness = 0.031700000166893,
	description = "Targets a corpse, and deals spell damage to enemies around the corpse, as well as causing the corpse to explode, dealing fire damage. The explosion is not affected by modifiers to spell damage and cannot be reflected.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Hit] = true, [SkillType.Area] = true, [SkillType.SkillCanTrap] = true, [SkillType.SkillCanTotem] = true, [SkillType.SkillCanMine] = true, [SkillType.SpellCanRepeat] = true, [SkillType.Triggerable] = true, [SkillType.FireSkill] = true, [SkillType.SpellCanCascade] = true, [SkillType.DestroysCorpse] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.6,
	parts = {
		{
			name = "Spell",
			spell = true,
			cast = false,
		},
		{
			name = "Corpse Explosion",
			spell = false,
			cast =  true,
		},
	},
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
		skill("radius", 22),
		skill("explodeCorpse", true, { type = "SkillPart", skillPart = 2 }),
	},
	qualityStats = {
		{ "base_cast_speed_+%", 0.5 },
	},
	stats = {
		"corpse_explosion_monster_life_%",
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"active_skill_base_radius_+",
		"is_area_damage",
	},
	levels = {
		[1] = { 6, 0.69999998807907, 1, 0, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 4, manaCost = 5, statInterpolation = { 1, 3, 3, 1, }, },
		[2] = { 6, 0.80000001192093, 1.2000000476837, 0, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 6, manaCost = 6, statInterpolation = { 1, 3, 3, 1, }, },
		[3] = { 6, 0.89999997615814, 1.2000000476837, 0, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 9, manaCost = 6, statInterpolation = { 1, 3, 3, 1, }, },
		[4] = { 6, 0.80000001192093, 1.2000000476837, 0, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 12, manaCost = 7, statInterpolation = { 1, 3, 3, 1, }, },
		[5] = { 6, 0.80000001192093, 1.2000000476837, 1, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 16, manaCost = 8, statInterpolation = { 1, 3, 3, 1, }, },
		[6] = { 6, 0.80000001192093, 1.2000000476837, 1, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 20, manaCost = 9, statInterpolation = { 1, 3, 3, 1, }, },
		[7] = { 6, 0.80000001192093, 1.2000000476837, 1, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 24, manaCost = 10, statInterpolation = { 1, 3, 3, 1, }, },
		[8] = { 6, 0.80000001192093, 1.2000000476837, 1, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 28, manaCost = 11, statInterpolation = { 1, 3, 3, 1, }, },
		[9] = { 6, 0.80000001192093, 1.2000000476837, 1, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 32, manaCost = 11, statInterpolation = { 1, 3, 3, 1, }, },
		[10] = { 6, 0.80000001192093, 1.2000000476837, 2, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 36, manaCost = 12, statInterpolation = { 1, 3, 3, 1, }, },
		[11] = { 6, 0.80000001192093, 1.2000000476837, 2, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 40, manaCost = 13, statInterpolation = { 1, 3, 3, 1, }, },
		[12] = { 6, 0.80000001192093, 1.2000000476837, 2, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 44, manaCost = 14, statInterpolation = { 1, 3, 3, 1, }, },
		[13] = { 6, 0.80000001192093, 1.2000000476837, 2, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 48, manaCost = 15, statInterpolation = { 1, 3, 3, 1, }, },
		[14] = { 6, 0.80000001192093, 1.2000000476837, 2, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 52, manaCost = 16, statInterpolation = { 1, 3, 3, 1, }, },
		[15] = { 6, 0.80000001192093, 1.2000000476837, 3, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 55, manaCost = 16, statInterpolation = { 1, 3, 3, 1, }, },
		[16] = { 6, 0.80000001192093, 1.2000000476837, 3, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 58, manaCost = 17, statInterpolation = { 1, 3, 3, 1, }, },
		[17] = { 6, 0.80000001192093, 1.2000000476837, 3, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 61, manaCost = 18, statInterpolation = { 1, 3, 3, 1, }, },
		[18] = { 6, 0.80000001192093, 1.2000000476837, 3, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 64, manaCost = 18, statInterpolation = { 1, 3, 3, 1, }, },
		[19] = { 6, 0.80000001192093, 1.2000000476837, 3, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 67, manaCost = 19, statInterpolation = { 1, 3, 3, 1, }, },
		[20] = { 6, 0.80000001192093, 1.2000000476837, 4, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 70, manaCost = 20, statInterpolation = { 1, 3, 3, 1, }, },
		[21] = { 6, 0.80000001192093, 1.2000000476837, 4, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 72, manaCost = 20, statInterpolation = { 1, 3, 3, 1, }, },
		[22] = { 6, 0.80000001192093, 1.2000000476837, 4, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 74, manaCost = 21, statInterpolation = { 1, 3, 3, 1, }, },
		[23] = { 6, 0.80000001192093, 1.2000000476837, 4, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 76, manaCost = 21, statInterpolation = { 1, 3, 3, 1, }, },
		[24] = { 6, 0.80000001192093, 1.2000000476837, 4, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 78, manaCost = 21, statInterpolation = { 1, 3, 3, 1, }, },
		[25] = { 6, 0.80000001192093, 1.2000000476837, 5, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 80, manaCost = 22, statInterpolation = { 1, 3, 3, 1, }, },
		[26] = { 6, 0.80000001192093, 1.2000000476837, 5, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 82, manaCost = 22, statInterpolation = { 1, 3, 3, 1, }, },
		[27] = { 6, 0.80000001192093, 1.2000000476837, 5, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 84, manaCost = 23, statInterpolation = { 1, 3, 3, 1, }, },
		[28] = { 6, 0.80000001192093, 1.2000000476837, 5, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 86, manaCost = 23, statInterpolation = { 1, 3, 3, 1, }, },
		[29] = { 6, 0.80000001192093, 1.2000000476837, 5, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 88, manaCost = 24, statInterpolation = { 1, 3, 3, 1, }, },
		[30] = { 6, 0.80000001192093, 1.2000000476837, 6, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 90, manaCost = 24, statInterpolation = { 1, 3, 3, 1, }, },
		[31] = { 6, 0.80000001192093, 1.2000000476837, 6, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 91, manaCost = 24, statInterpolation = { 1, 3, 3, 1, }, },
		[32] = { 6, 0.80000001192093, 1.2000000476837, 6, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 92, manaCost = 25, statInterpolation = { 1, 3, 3, 1, }, },
		[33] = { 6, 0.80000001192093, 1.2000000476837, 6, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 93, manaCost = 25, statInterpolation = { 1, 3, 3, 1, }, },
		[34] = { 6, 0.80000001192093, 1.2000000476837, 6, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 94, manaCost = 25, statInterpolation = { 1, 3, 3, 1, }, },
		[35] = { 6, 0.80000001192093, 1.2000000476837, 7, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 95, manaCost = 25, statInterpolation = { 1, 3, 3, 1, }, },
		[36] = { 6, 0.80000001192093, 1.2000000476837, 7, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 96, manaCost = 25, statInterpolation = { 1, 3, 3, 1, }, },
		[37] = { 6, 0.80000001192093, 1.2000000476837, 7, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 97, manaCost = 26, statInterpolation = { 1, 3, 3, 1, }, },
		[38] = { 6, 0.80000001192093, 1.2000000476837, 7, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 98, manaCost = 26, statInterpolation = { 1, 3, 3, 1, }, },
		[39] = { 6, 0.80000001192093, 1.2000000476837, 7, damageEffectiveness = 1.6, critChance = 6, levelRequirement = 99, manaCost = 26, statInterpolation = { 1, 3, 3, 1, }, },
		[40] = { 6, 0.80000001192093, 1.2000000476837, 8, critChance = 6, levelRequirement = 100, manaCost = 26, statInterpolation = { 1, 3, 3, 1, }, },
	},
}
skills["VaalDetonateDead"] = {
	name = "Vaal Detonate Dead",
	color = 2,
	baseEffectiveness = 6.039999961853,
	incrementalEffectiveness = 0.034000001847744,
	description = "Targets a corpse, and deals spell damage to enemies around the corpse, as well as causing the corpse to explode, dealing fire damage. The explosion is not affected by modifiers to spell damage and cannot be reflected. This will continue to target other corpses in the area, with an increasing delay between each one, until it runs out of corpses or has destroyed 22 corpses.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Hit] = true, [SkillType.Area] = true, [SkillType.SkillCanTrap] = true, [SkillType.SkillCanTotem] = true, [SkillType.SkillCanMine] = true, [SkillType.Vaal] = true, [SkillType.FireSkill] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.6,
	parts = {
		{
			name = "Spell",
			spell = true,
			cast = false,
		},
		{
			name = "Corpse Explosion",
			spell = false,
			cast =  true,
		},
	},
	baseFlags = {
		cast = true,
		area = true,
	},
	baseMods = {
		skill("explodeCorpse", true, { type = "SkillPart", skillPart = 2 }),
	},
	qualityStats = {
		{ "area_damage_+%", 1 },
	},
	stats = {
		"corpse_explosion_monster_life_%",
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"active_skill_base_radius_+",
		"cannot_cancel_skill_before_contact_point",
	},
	levels = {
		[1] = { 9, 0.69999998807907, 1, 0, damageEffectiveness = 2, critChance = 5, levelRequirement = 4, statInterpolation = { 1, 3, 3, 1, }, },
		[2] = { 9, 0.80000001192093, 1.2000000476837, 0, damageEffectiveness = 2, critChance = 5, levelRequirement = 6, statInterpolation = { 1, 3, 3, 1, }, },
		[3] = { 9, 0.89999997615814, 1.2000000476837, 0, damageEffectiveness = 2, critChance = 5, levelRequirement = 9, statInterpolation = { 1, 3, 3, 1, }, },
		[4] = { 9, 0.80000001192093, 1.2000000476837, 0, damageEffectiveness = 2, critChance = 5, levelRequirement = 12, statInterpolation = { 1, 3, 3, 1, }, },
		[5] = { 9, 0.80000001192093, 1.2000000476837, 1, damageEffectiveness = 2, critChance = 5, levelRequirement = 16, statInterpolation = { 1, 3, 3, 1, }, },
		[6] = { 9, 0.80000001192093, 1.2000000476837, 1, damageEffectiveness = 2, critChance = 5, levelRequirement = 20, statInterpolation = { 1, 3, 3, 1, }, },
		[7] = { 9, 0.80000001192093, 1.2000000476837, 1, damageEffectiveness = 2, critChance = 5, levelRequirement = 24, statInterpolation = { 1, 3, 3, 1, }, },
		[8] = { 9, 0.80000001192093, 1.2000000476837, 1, damageEffectiveness = 2, critChance = 5, levelRequirement = 28, statInterpolation = { 1, 3, 3, 1, }, },
		[9] = { 9, 0.80000001192093, 1.2000000476837, 1, damageEffectiveness = 2, critChance = 5, levelRequirement = 32, statInterpolation = { 1, 3, 3, 1, }, },
		[10] = { 9, 0.80000001192093, 1.2000000476837, 2, damageEffectiveness = 2, critChance = 5, levelRequirement = 36, statInterpolation = { 1, 3, 3, 1, }, },
		[11] = { 9, 0.80000001192093, 1.2000000476837, 2, damageEffectiveness = 2, critChance = 5, levelRequirement = 40, statInterpolation = { 1, 3, 3, 1, }, },
		[12] = { 9, 0.80000001192093, 1.2000000476837, 2, damageEffectiveness = 2, critChance = 5, levelRequirement = 44, statInterpolation = { 1, 3, 3, 1, }, },
		[13] = { 9, 0.80000001192093, 1.2000000476837, 2, damageEffectiveness = 2, critChance = 5, levelRequirement = 48, statInterpolation = { 1, 3, 3, 1, }, },
		[14] = { 9, 0.80000001192093, 1.2000000476837, 2, damageEffectiveness = 2, critChance = 5, levelRequirement = 52, statInterpolation = { 1, 3, 3, 1, }, },
		[15] = { 9, 0.80000001192093, 1.2000000476837, 3, damageEffectiveness = 2, critChance = 5, levelRequirement = 55, statInterpolation = { 1, 3, 3, 1, }, },
		[16] = { 9, 0.80000001192093, 1.2000000476837, 3, damageEffectiveness = 2, critChance = 5, levelRequirement = 58, statInterpolation = { 1, 3, 3, 1, }, },
		[17] = { 9, 0.80000001192093, 1.2000000476837, 3, damageEffectiveness = 2, critChance = 5, levelRequirement = 61, statInterpolation = { 1, 3, 3, 1, }, },
		[18] = { 9, 0.80000001192093, 1.2000000476837, 3, damageEffectiveness = 2, critChance = 5, levelRequirement = 64, statInterpolation = { 1, 3, 3, 1, }, },
		[19] = { 9, 0.80000001192093, 1.2000000476837, 3, damageEffectiveness = 2, critChance = 5, levelRequirement = 67, statInterpolation = { 1, 3, 3, 1, }, },
		[20] = { 9, 0.80000001192093, 1.2000000476837, 4, damageEffectiveness = 2, critChance = 5, levelRequirement = 70, statInterpolation = { 1, 3, 3, 1, }, },
		[21] = { 9, 0.80000001192093, 1.2000000476837, 4, damageEffectiveness = 2, critChance = 5, levelRequirement = 72, statInterpolation = { 1, 3, 3, 1, }, },
		[22] = { 9, 0.80000001192093, 1.2000000476837, 4, damageEffectiveness = 2, critChance = 5, levelRequirement = 74, statInterpolation = { 1, 3, 3, 1, }, },
		[23] = { 9, 0.80000001192093, 1.2000000476837, 4, damageEffectiveness = 2, critChance = 5, levelRequirement = 76, statInterpolation = { 1, 3, 3, 1, }, },
		[24] = { 9, 0.80000001192093, 1.2000000476837, 4, damageEffectiveness = 2, critChance = 5, levelRequirement = 78, statInterpolation = { 1, 3, 3, 1, }, },
		[25] = { 9, 0.80000001192093, 1.2000000476837, 5, damageEffectiveness = 2, critChance = 5, levelRequirement = 80, statInterpolation = { 1, 3, 3, 1, }, },
		[26] = { 9, 0.80000001192093, 1.2000000476837, 5, damageEffectiveness = 2, critChance = 5, levelRequirement = 82, statInterpolation = { 1, 3, 3, 1, }, },
		[27] = { 9, 0.80000001192093, 1.2000000476837, 5, damageEffectiveness = 2, critChance = 5, levelRequirement = 84, statInterpolation = { 1, 3, 3, 1, }, },
		[28] = { 9, 0.80000001192093, 1.2000000476837, 5, damageEffectiveness = 2, critChance = 5, levelRequirement = 86, statInterpolation = { 1, 3, 3, 1, }, },
		[29] = { 9, 0.80000001192093, 1.2000000476837, 5, damageEffectiveness = 2, critChance = 5, levelRequirement = 88, statInterpolation = { 1, 3, 3, 1, }, },
		[30] = { 9, 0.80000001192093, 1.2000000476837, 6, damageEffectiveness = 2, critChance = 5, levelRequirement = 90, statInterpolation = { 1, 3, 3, 1, }, },
		[31] = { 9, 0.80000001192093, 1.2000000476837, 6, damageEffectiveness = 2, critChance = 5, levelRequirement = 91, statInterpolation = { 1, 3, 3, 1, }, },
		[32] = { 9, 0.80000001192093, 1.2000000476837, 6, damageEffectiveness = 2, critChance = 5, levelRequirement = 92, statInterpolation = { 1, 3, 3, 1, }, },
		[33] = { 9, 0.80000001192093, 1.2000000476837, 6, damageEffectiveness = 2, critChance = 5, levelRequirement = 93, statInterpolation = { 1, 3, 3, 1, }, },
		[34] = { 9, 0.80000001192093, 1.2000000476837, 6, damageEffectiveness = 2, critChance = 5, levelRequirement = 94, statInterpolation = { 1, 3, 3, 1, }, },
		[35] = { 9, 0.80000001192093, 1.2000000476837, 6, damageEffectiveness = 2, critChance = 5, levelRequirement = 95, statInterpolation = { 1, 3, 3, 1, }, },
		[36] = { 9, 0.80000001192093, 1.2000000476837, 6, damageEffectiveness = 2, critChance = 5, levelRequirement = 96, statInterpolation = { 1, 3, 3, 1, }, },
		[37] = { 9, 0.80000001192093, 1.2000000476837, 6, damageEffectiveness = 2, critChance = 5, levelRequirement = 97, statInterpolation = { 1, 3, 3, 1, }, },
		[38] = { 9, 0.80000001192093, 1.2000000476837, 6, damageEffectiveness = 2, critChance = 5, levelRequirement = 98, statInterpolation = { 1, 3, 3, 1, }, },
		[39] = { 9, 0.80000001192093, 1.2000000476837, 6, damageEffectiveness = 2, critChance = 5, levelRequirement = 99, statInterpolation = { 1, 3, 3, 1, }, },
		[40] = { 9, 0.80000001192093, 1.2000000476837, 7, damageEffectiveness = 2, critChance = 5, levelRequirement = 100, statInterpolation = { 1, 3, 3, 1, }, },
	},
}
skills["DoubleStrike"] = {
	name = "Double Strike",
	color = 2,
	baseEffectiveness = 1,
	incrementalEffectiveness = 0.023299999535084,
	description = "Performs two fast strikes with a melee weapon.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.AttackCanRepeat] = true, [SkillType.Melee] = true, [SkillType.PhysicalSkill] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
	},
	baseMods = {
		skill("dpsMultiplier", 2),
	},
	qualityStats = {
		{ "attack_speed_+%", 0.5 },
	},
	stats = {
		"base_skill_number_of_additional_hits",
		"global_minimum_added_physical_damage_vs_bleeding_enemies",
		"global_maximum_added_physical_damage_vs_bleeding_enemies",
		"melee_range_+",
		"bleed_on_hit_with_attacks_%",
	},
	levels = {
		[1] = { 1, 0.80000001192093, 1.2000000476837, 0, 25, baseMultiplier = 0.913, manaCost = 5, damageEffectiveness = 0.91, attackSpeedMultiplier = -20, levelRequirement = 1, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[2] = { 1, 0.80000001192093, 1.2000000476837, 0, 25, baseMultiplier = 0.924, manaCost = 5, damageEffectiveness = 0.92, attackSpeedMultiplier = -20, levelRequirement = 2, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[3] = { 1, 0.80000001192093, 1.2000000476837, 0, 25, baseMultiplier = 0.935, manaCost = 5, damageEffectiveness = 0.93, attackSpeedMultiplier = -20, levelRequirement = 4, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[4] = { 1, 0.80000001192093, 1.2000000476837, 0, 25, baseMultiplier = 0.945, manaCost = 5, damageEffectiveness = 0.95, attackSpeedMultiplier = -20, levelRequirement = 7, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[5] = { 1, 0.80000001192093, 1.2000000476837, 0, 25, baseMultiplier = 0.956, manaCost = 5, damageEffectiveness = 0.96, attackSpeedMultiplier = -20, levelRequirement = 11, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[6] = { 1, 0.80000001192093, 1.2000000476837, 0, 25, baseMultiplier = 0.967, manaCost = 5, damageEffectiveness = 0.97, attackSpeedMultiplier = -20, levelRequirement = 16, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[7] = { 1, 0.80000001192093, 1.2000000476837, 1, 25, baseMultiplier = 0.978, manaCost = 5, damageEffectiveness = 0.98, attackSpeedMultiplier = -20, levelRequirement = 20, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[8] = { 1, 0.80000001192093, 1.2000000476837, 1, 25, baseMultiplier = 0.989, manaCost = 5, damageEffectiveness = 0.99, attackSpeedMultiplier = -20, levelRequirement = 24, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[9] = { 1, 0.80000001192093, 1.2000000476837, 1, 25, attackSpeedMultiplier = -20, levelRequirement = 28, manaCost = 5, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[10] = { 1, 0.80000001192093, 1.2000000476837, 1, 25, baseMultiplier = 1.011, manaCost = 5, damageEffectiveness = 1.01, attackSpeedMultiplier = -20, levelRequirement = 32, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[11] = { 1, 0.80000001192093, 1.2000000476837, 1, 25, baseMultiplier = 1.022, manaCost = 5, damageEffectiveness = 1.02, attackSpeedMultiplier = -20, levelRequirement = 36, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[12] = { 1, 0.80000001192093, 1.2000000476837, 1, 25, baseMultiplier = 1.033, manaCost = 5, damageEffectiveness = 1.03, attackSpeedMultiplier = -20, levelRequirement = 40, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[13] = { 1, 0.80000001192093, 1.2000000476837, 1, 25, baseMultiplier = 1.044, manaCost = 5, damageEffectiveness = 1.04, attackSpeedMultiplier = -20, levelRequirement = 44, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[14] = { 1, 0.80000001192093, 1.2000000476837, 2, 25, baseMultiplier = 1.055, manaCost = 5, damageEffectiveness = 1.05, attackSpeedMultiplier = -20, levelRequirement = 48, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[15] = { 1, 0.80000001192093, 1.2000000476837, 2, 25, baseMultiplier = 1.065, manaCost = 5, damageEffectiveness = 1.07, attackSpeedMultiplier = -20, levelRequirement = 52, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[16] = { 1, 0.80000001192093, 1.2000000476837, 2, 25, baseMultiplier = 1.076, manaCost = 5, damageEffectiveness = 1.08, attackSpeedMultiplier = -20, levelRequirement = 56, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[17] = { 1, 0.80000001192093, 1.2000000476837, 2, 25, baseMultiplier = 1.087, manaCost = 5, damageEffectiveness = 1.09, attackSpeedMultiplier = -20, levelRequirement = 60, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[18] = { 1, 0.80000001192093, 1.2000000476837, 2, 25, baseMultiplier = 1.098, manaCost = 5, damageEffectiveness = 1.1, attackSpeedMultiplier = -20, levelRequirement = 64, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[19] = { 1, 0.80000001192093, 1.2000000476837, 2, 25, baseMultiplier = 1.109, manaCost = 5, damageEffectiveness = 1.11, attackSpeedMultiplier = -20, levelRequirement = 67, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[20] = { 1, 0.80000001192093, 1.2000000476837, 2, 25, baseMultiplier = 1.12, manaCost = 5, damageEffectiveness = 1.12, attackSpeedMultiplier = -20, levelRequirement = 70, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[21] = { 1, 0.80000001192093, 1.2000000476837, 3, 25, baseMultiplier = 1.131, manaCost = 5, damageEffectiveness = 1.13, attackSpeedMultiplier = -20, levelRequirement = 72, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[22] = { 1, 0.80000001192093, 1.2000000476837, 3, 25, baseMultiplier = 1.142, manaCost = 5, damageEffectiveness = 1.14, attackSpeedMultiplier = -20, levelRequirement = 74, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[23] = { 1, 0.80000001192093, 1.2000000476837, 3, 25, baseMultiplier = 1.153, manaCost = 5, damageEffectiveness = 1.15, attackSpeedMultiplier = -20, levelRequirement = 76, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[24] = { 1, 0.80000001192093, 1.2000000476837, 3, 25, baseMultiplier = 1.164, manaCost = 5, damageEffectiveness = 1.16, attackSpeedMultiplier = -20, levelRequirement = 78, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[25] = { 1, 0.80000001192093, 1.2000000476837, 3, 25, baseMultiplier = 1.175, manaCost = 5, damageEffectiveness = 1.17, attackSpeedMultiplier = -20, levelRequirement = 80, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[26] = { 1, 0.80000001192093, 1.2000000476837, 3, 25, baseMultiplier = 1.185, manaCost = 5, damageEffectiveness = 1.19, attackSpeedMultiplier = -20, levelRequirement = 82, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[27] = { 1, 0.80000001192093, 1.2000000476837, 3, 25, baseMultiplier = 1.196, manaCost = 5, damageEffectiveness = 1.2, attackSpeedMultiplier = -20, levelRequirement = 84, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[28] = { 1, 0.80000001192093, 1.2000000476837, 4, 25, baseMultiplier = 1.207, manaCost = 5, damageEffectiveness = 1.21, attackSpeedMultiplier = -20, levelRequirement = 86, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[29] = { 1, 0.80000001192093, 1.2000000476837, 4, 25, baseMultiplier = 1.218, manaCost = 5, damageEffectiveness = 1.22, attackSpeedMultiplier = -20, levelRequirement = 88, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[30] = { 1, 0.80000001192093, 1.2000000476837, 4, 25, baseMultiplier = 1.229, manaCost = 5, damageEffectiveness = 1.23, attackSpeedMultiplier = -20, levelRequirement = 90, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[31] = { 1, 0.80000001192093, 1.2000000476837, 4, 25, baseMultiplier = 1.235, manaCost = 5, damageEffectiveness = 1.23, attackSpeedMultiplier = -20, levelRequirement = 91, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[32] = { 1, 0.80000001192093, 1.2000000476837, 4, 25, baseMultiplier = 1.24, manaCost = 5, damageEffectiveness = 1.24, attackSpeedMultiplier = -20, levelRequirement = 92, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[33] = { 1, 0.80000001192093, 1.2000000476837, 4, 25, baseMultiplier = 1.245, manaCost = 5, damageEffectiveness = 1.25, attackSpeedMultiplier = -20, levelRequirement = 93, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[34] = { 1, 0.80000001192093, 1.2000000476837, 4, 25, baseMultiplier = 1.251, manaCost = 5, damageEffectiveness = 1.25, attackSpeedMultiplier = -20, levelRequirement = 94, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[35] = { 1, 0.80000001192093, 1.2000000476837, 5, 25, baseMultiplier = 1.256, manaCost = 5, damageEffectiveness = 1.26, attackSpeedMultiplier = -20, levelRequirement = 95, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[36] = { 1, 0.80000001192093, 1.2000000476837, 5, 25, baseMultiplier = 1.262, manaCost = 5, damageEffectiveness = 1.26, attackSpeedMultiplier = -20, levelRequirement = 96, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[37] = { 1, 0.80000001192093, 1.2000000476837, 5, 25, baseMultiplier = 1.267, manaCost = 5, damageEffectiveness = 1.27, attackSpeedMultiplier = -20, levelRequirement = 97, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[38] = { 1, 0.80000001192093, 1.2000000476837, 5, 25, baseMultiplier = 1.273, manaCost = 5, damageEffectiveness = 1.27, attackSpeedMultiplier = -20, levelRequirement = 98, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[39] = { 1, 0.80000001192093, 1.2000000476837, 5, 25, baseMultiplier = 1.278, manaCost = 5, damageEffectiveness = 1.28, attackSpeedMultiplier = -20, levelRequirement = 99, statInterpolation = { 1, 3, 3, 1, 1, }, },
		[40] = { 1, 0.80000001192093, 1.2000000476837, 5, 25, baseMultiplier = 1.284, manaCost = 5, damageEffectiveness = 1.28, attackSpeedMultiplier = -20, levelRequirement = 100, statInterpolation = { 1, 3, 3, 1, 1, }, },
	},
}
skills["VaalDoubleStrike"] = {
	name = "Vaal Double Strike",
	color = 2,
	baseEffectiveness = 1,
	incrementalEffectiveness = 0.023299999535084,
	description = "Performs two fast strikes with a melee weapon, each of which summons a double of you for a duration to continuously attack monsters in this fashion.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Melee] = true, [SkillType.Duration] = true, [SkillType.Vaal] = true, [SkillType.PhysicalSkill] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		duration = true,
		vaal = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "attack_speed_+%", 0.5 },
	},
	stats = {
		"base_skill_number_of_additional_hits",
		"base_skill_effect_duration",
		"number_of_monsters_to_summon",
		"doubles_have_movement_speed_+%",
		"global_minimum_added_physical_damage_vs_bleeding_enemies",
		"global_maximum_added_physical_damage_vs_bleeding_enemies",
		"melee_range_+",
		"bleed_on_hit_with_attacks_%",
		"global_always_hit",
		"modifiers_to_skill_effect_duration_also_affect_soul_prevention_duration",
		"cannot_cancel_skill_before_contact_point",
	},
	levels = {
		[1] = { 1, 6000, 1, 0, 0.80000001192093, 1.2000000476837, 0, 25, damageEffectiveness = 0.28, baseMultiplier = 0.28, levelRequirement = 1, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[2] = { 1, 6000, 1, 3, 0.80000001192093, 1.2000000476837, 0, 25, damageEffectiveness = 0.28, baseMultiplier = 0.283, levelRequirement = 2, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[3] = { 1, 6000, 1, 6, 0.80000001192093, 1.2000000476837, 0, 25, damageEffectiveness = 0.29, baseMultiplier = 0.285, levelRequirement = 4, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[4] = { 1, 6000, 1, 9, 0.80000001192093, 1.2000000476837, 0, 25, damageEffectiveness = 0.29, baseMultiplier = 0.288, levelRequirement = 7, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[5] = { 1, 6000, 1, 12, 0.80000001192093, 1.2000000476837, 0, 25, damageEffectiveness = 0.29, baseMultiplier = 0.291, levelRequirement = 11, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[6] = { 1, 6000, 1, 15, 0.80000001192093, 1.2000000476837, 0, 25, damageEffectiveness = 0.29, baseMultiplier = 0.293, levelRequirement = 16, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[7] = { 1, 6000, 1, 18, 0.80000001192093, 1.2000000476837, 1, 25, damageEffectiveness = 0.3, baseMultiplier = 0.296, levelRequirement = 20, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[8] = { 1, 6000, 1, 21, 0.80000001192093, 1.2000000476837, 1, 25, damageEffectiveness = 0.3, baseMultiplier = 0.298, levelRequirement = 24, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[9] = { 1, 6000, 1, 24, 0.80000001192093, 1.2000000476837, 1, 25, damageEffectiveness = 0.3, baseMultiplier = 0.301, levelRequirement = 28, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[10] = { 1, 6000, 1, 27, 0.80000001192093, 1.2000000476837, 1, 25, damageEffectiveness = 0.3, baseMultiplier = 0.304, levelRequirement = 32, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[11] = { 1, 6000, 1, 30, 0.80000001192093, 1.2000000476837, 1, 25, damageEffectiveness = 0.31, baseMultiplier = 0.306, levelRequirement = 36, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[12] = { 1, 6000, 1, 33, 0.80000001192093, 1.2000000476837, 1, 25, damageEffectiveness = 0.31, baseMultiplier = 0.309, levelRequirement = 40, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[13] = { 1, 6000, 1, 36, 0.80000001192093, 1.2000000476837, 1, 25, damageEffectiveness = 0.31, baseMultiplier = 0.312, levelRequirement = 44, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[14] = { 1, 6000, 1, 39, 0.80000001192093, 1.2000000476837, 2, 25, damageEffectiveness = 0.31, baseMultiplier = 0.314, levelRequirement = 48, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[15] = { 1, 6000, 1, 42, 0.80000001192093, 1.2000000476837, 2, 25, damageEffectiveness = 0.32, baseMultiplier = 0.317, levelRequirement = 52, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[16] = { 1, 6000, 1, 45, 0.80000001192093, 1.2000000476837, 2, 25, damageEffectiveness = 0.32, baseMultiplier = 0.319, levelRequirement = 56, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[17] = { 1, 6000, 1, 48, 0.80000001192093, 1.2000000476837, 2, 25, damageEffectiveness = 0.32, baseMultiplier = 0.322, levelRequirement = 60, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[18] = { 1, 6000, 1, 51, 0.80000001192093, 1.2000000476837, 2, 25, damageEffectiveness = 0.32, baseMultiplier = 0.325, levelRequirement = 64, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[19] = { 1, 6000, 1, 54, 0.80000001192093, 1.2000000476837, 2, 25, damageEffectiveness = 0.33, baseMultiplier = 0.327, levelRequirement = 67, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[20] = { 1, 6000, 1, 57, 0.80000001192093, 1.2000000476837, 2, 25, damageEffectiveness = 0.33, baseMultiplier = 0.33, levelRequirement = 70, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[21] = { 1, 6000, 1, 60, 0.80000001192093, 1.2000000476837, 3, 25, damageEffectiveness = 0.33, baseMultiplier = 0.333, levelRequirement = 72, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[22] = { 1, 6000, 1, 63, 0.80000001192093, 1.2000000476837, 3, 25, damageEffectiveness = 0.34, baseMultiplier = 0.335, levelRequirement = 74, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[23] = { 1, 6000, 1, 66, 0.80000001192093, 1.2000000476837, 3, 25, damageEffectiveness = 0.34, baseMultiplier = 0.338, levelRequirement = 76, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[24] = { 1, 6000, 1, 69, 0.80000001192093, 1.2000000476837, 3, 25, damageEffectiveness = 0.34, baseMultiplier = 0.341, levelRequirement = 78, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[25] = { 1, 6000, 1, 72, 0.80000001192093, 1.2000000476837, 3, 25, damageEffectiveness = 0.34, baseMultiplier = 0.343, levelRequirement = 80, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[26] = { 1, 6000, 1, 75, 0.80000001192093, 1.2000000476837, 3, 25, damageEffectiveness = 0.35, baseMultiplier = 0.346, levelRequirement = 82, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[27] = { 1, 6000, 1, 78, 0.80000001192093, 1.2000000476837, 3, 25, damageEffectiveness = 0.35, baseMultiplier = 0.348, levelRequirement = 84, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[28] = { 1, 6000, 1, 81, 0.80000001192093, 1.2000000476837, 4, 25, damageEffectiveness = 0.35, baseMultiplier = 0.351, levelRequirement = 86, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[29] = { 1, 6000, 1, 84, 0.80000001192093, 1.2000000476837, 4, 25, damageEffectiveness = 0.35, baseMultiplier = 0.354, levelRequirement = 88, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[30] = { 1, 6000, 1, 87, 0.80000001192093, 1.2000000476837, 4, 25, damageEffectiveness = 0.36, baseMultiplier = 0.356, levelRequirement = 90, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[31] = { 1, 6000, 1, 88, 0.80000001192093, 1.2000000476837, 4, 25, damageEffectiveness = 0.36, baseMultiplier = 0.358, levelRequirement = 91, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[32] = { 1, 6000, 1, 90, 0.80000001192093, 1.2000000476837, 4, 25, damageEffectiveness = 0.36, baseMultiplier = 0.359, levelRequirement = 92, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[33] = { 1, 6000, 1, 92, 0.80000001192093, 1.2000000476837, 4, 25, damageEffectiveness = 0.36, baseMultiplier = 0.36, levelRequirement = 93, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[34] = { 1, 6000, 1, 93, 0.80000001192093, 1.2000000476837, 4, 25, damageEffectiveness = 0.36, baseMultiplier = 0.362, levelRequirement = 94, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[35] = { 1, 6000, 1, 94, 0.80000001192093, 1.2000000476837, 5, 25, damageEffectiveness = 0.36, baseMultiplier = 0.363, levelRequirement = 95, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[36] = { 1, 6000, 1, 96, 0.80000001192093, 1.2000000476837, 5, 25, damageEffectiveness = 0.36, baseMultiplier = 0.364, levelRequirement = 96, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[37] = { 1, 6000, 1, 98, 0.80000001192093, 1.2000000476837, 5, 25, damageEffectiveness = 0.37, baseMultiplier = 0.366, levelRequirement = 97, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[38] = { 1, 6000, 1, 99, 0.80000001192093, 1.2000000476837, 5, 25, damageEffectiveness = 0.37, baseMultiplier = 0.367, levelRequirement = 98, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[39] = { 1, 6000, 1, 100, 0.80000001192093, 1.2000000476837, 5, 25, damageEffectiveness = 0.37, baseMultiplier = 0.368, levelRequirement = 99, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
		[40] = { 1, 6000, 1, 102, 0.80000001192093, 1.2000000476837, 5, 25, damageEffectiveness = 0.37, baseMultiplier = 0.369, levelRequirement = 100, statInterpolation = { 1, 1, 1, 1, 3, 3, 3, 1, }, },
	},
}
skills["DualStrike"] = {
	name = "Dual Strike",
	color = 2,
	description = "Attacks with both weapons, dealing the damage of both in one strike. Dual wield only. Does not work with wands.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.DualWield] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.AttackCanRepeat] = true, [SkillType.Melee] = true, [SkillType.Type53] = true, },
	weaponTypes = {
		["Two Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["One Handed Axe"] = true,
		["Dagger"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["dual_strike_critical_strike_chance_+%_final_against_enemies_on_full_life"] = {
			mod("CritChance", "MORE", nil, 0, 0, { type = "ActorCondition", actor = "enemy", var = "FullLife" })
		},
		["dual_strike_damage_+%_final_against_enemies_on_full_life"] = {
			mod("Damage", "MORE", nil, 0, bit.bor(KeywordFlag.Hit, KeywordFlag.Ailment), { type = "ActorCondition", actor = "enemy", var = "FullLife" })
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "critical_strike_chance_+%", 1 },
		{ "base_critical_strike_multiplier_+", 0.5 },
	},
	stats = {
		"melee_range_+",
		"critical_strike_chance_+%",
		"dual_strike_critical_strike_chance_+%_final_against_enemies_on_full_life",
		"dual_strike_damage_+%_final_against_enemies_on_full_life",
		"skill_double_hits_when_dual_wielding",
	},
	levels = {
		[1] = { 0, 50, 100, 30, baseMultiplier = 1.25, manaCost = 5, damageEffectiveness = 1.25, attackSpeedMultiplier = -30, levelRequirement = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[2] = { 0, 53, 100, 30, baseMultiplier = 1.274, manaCost = 5, damageEffectiveness = 1.27, attackSpeedMultiplier = -30, levelRequirement = 2, statInterpolation = { 1, 1, 1, 1, }, },
		[3] = { 0, 56, 100, 30, baseMultiplier = 1.297, manaCost = 5, damageEffectiveness = 1.3, attackSpeedMultiplier = -30, levelRequirement = 4, statInterpolation = { 1, 1, 1, 1, }, },
		[4] = { 0, 59, 100, 30, baseMultiplier = 1.321, manaCost = 5, damageEffectiveness = 1.32, attackSpeedMultiplier = -30, levelRequirement = 7, statInterpolation = { 1, 1, 1, 1, }, },
		[5] = { 0, 62, 100, 30, baseMultiplier = 1.345, manaCost = 5, damageEffectiveness = 1.34, attackSpeedMultiplier = -30, levelRequirement = 11, statInterpolation = { 1, 1, 1, 1, }, },
		[6] = { 0, 65, 100, 30, baseMultiplier = 1.368, manaCost = 5, damageEffectiveness = 1.37, attackSpeedMultiplier = -30, levelRequirement = 16, statInterpolation = { 1, 1, 1, 1, }, },
		[7] = { 1, 68, 100, 30, baseMultiplier = 1.392, manaCost = 5, damageEffectiveness = 1.39, attackSpeedMultiplier = -30, levelRequirement = 20, statInterpolation = { 1, 1, 1, 1, }, },
		[8] = { 1, 71, 100, 30, baseMultiplier = 1.416, manaCost = 5, damageEffectiveness = 1.42, attackSpeedMultiplier = -30, levelRequirement = 24, statInterpolation = { 1, 1, 1, 1, }, },
		[9] = { 1, 74, 100, 30, baseMultiplier = 1.439, manaCost = 5, damageEffectiveness = 1.44, attackSpeedMultiplier = -30, levelRequirement = 28, statInterpolation = { 1, 1, 1, 1, }, },
		[10] = { 1, 77, 100, 30, baseMultiplier = 1.463, manaCost = 5, damageEffectiveness = 1.46, attackSpeedMultiplier = -30, levelRequirement = 32, statInterpolation = { 1, 1, 1, 1, }, },
		[11] = { 1, 80, 100, 30, baseMultiplier = 1.487, manaCost = 5, damageEffectiveness = 1.49, attackSpeedMultiplier = -30, levelRequirement = 36, statInterpolation = { 1, 1, 1, 1, }, },
		[12] = { 1, 83, 100, 30, baseMultiplier = 1.511, manaCost = 5, damageEffectiveness = 1.51, attackSpeedMultiplier = -30, levelRequirement = 40, statInterpolation = { 1, 1, 1, 1, }, },
		[13] = { 1, 86, 100, 30, baseMultiplier = 1.534, manaCost = 5, damageEffectiveness = 1.53, attackSpeedMultiplier = -30, levelRequirement = 44, statInterpolation = { 1, 1, 1, 1, }, },
		[14] = { 2, 89, 100, 30, baseMultiplier = 1.558, manaCost = 5, damageEffectiveness = 1.56, attackSpeedMultiplier = -30, levelRequirement = 48, statInterpolation = { 1, 1, 1, 1, }, },
		[15] = { 2, 92, 100, 30, baseMultiplier = 1.582, manaCost = 5, damageEffectiveness = 1.58, attackSpeedMultiplier = -30, levelRequirement = 52, statInterpolation = { 1, 1, 1, 1, }, },
		[16] = { 2, 95, 100, 30, baseMultiplier = 1.605, manaCost = 5, damageEffectiveness = 1.61, attackSpeedMultiplier = -30, levelRequirement = 56, statInterpolation = { 1, 1, 1, 1, }, },
		[17] = { 2, 98, 100, 30, baseMultiplier = 1.629, manaCost = 5, damageEffectiveness = 1.63, attackSpeedMultiplier = -30, levelRequirement = 60, statInterpolation = { 1, 1, 1, 1, }, },
		[18] = { 2, 101, 100, 30, baseMultiplier = 1.653, manaCost = 5, damageEffectiveness = 1.65, attackSpeedMultiplier = -30, levelRequirement = 64, statInterpolation = { 1, 1, 1, 1, }, },
		[19] = { 2, 104, 100, 30, baseMultiplier = 1.676, manaCost = 5, damageEffectiveness = 1.68, attackSpeedMultiplier = -30, levelRequirement = 67, statInterpolation = { 1, 1, 1, 1, }, },
		[20] = { 2, 107, 100, 30, baseMultiplier = 1.7, manaCost = 5, damageEffectiveness = 1.7, attackSpeedMultiplier = -30, levelRequirement = 70, statInterpolation = { 1, 1, 1, 1, }, },
		[21] = { 3, 110, 100, 30, baseMultiplier = 1.724, manaCost = 5, damageEffectiveness = 1.72, attackSpeedMultiplier = -30, levelRequirement = 72, statInterpolation = { 1, 1, 1, 1, }, },
		[22] = { 3, 113, 100, 30, baseMultiplier = 1.747, manaCost = 5, damageEffectiveness = 1.75, attackSpeedMultiplier = -30, levelRequirement = 74, statInterpolation = { 1, 1, 1, 1, }, },
		[23] = { 3, 116, 100, 30, baseMultiplier = 1.771, manaCost = 5, damageEffectiveness = 1.77, attackSpeedMultiplier = -30, levelRequirement = 76, statInterpolation = { 1, 1, 1, 1, }, },
		[24] = { 3, 119, 100, 30, baseMultiplier = 1.795, manaCost = 5, damageEffectiveness = 1.79, attackSpeedMultiplier = -30, levelRequirement = 78, statInterpolation = { 1, 1, 1, 1, }, },
		[25] = { 3, 122, 100, 30, baseMultiplier = 1.818, manaCost = 5, damageEffectiveness = 1.82, attackSpeedMultiplier = -30, levelRequirement = 80, statInterpolation = { 1, 1, 1, 1, }, },
		[26] = { 3, 125, 100, 30, baseMultiplier = 1.842, manaCost = 5, damageEffectiveness = 1.84, attackSpeedMultiplier = -30, levelRequirement = 82, statInterpolation = { 1, 1, 1, 1, }, },
		[27] = { 3, 128, 100, 30, baseMultiplier = 1.866, manaCost = 5, damageEffectiveness = 1.87, attackSpeedMultiplier = -30, levelRequirement = 84, statInterpolation = { 1, 1, 1, 1, }, },
		[28] = { 4, 131, 100, 30, baseMultiplier = 1.889, manaCost = 5, damageEffectiveness = 1.89, attackSpeedMultiplier = -30, levelRequirement = 86, statInterpolation = { 1, 1, 1, 1, }, },
		[29] = { 4, 134, 100, 30, baseMultiplier = 1.913, manaCost = 5, damageEffectiveness = 1.91, attackSpeedMultiplier = -30, levelRequirement = 88, statInterpolation = { 1, 1, 1, 1, }, },
		[30] = { 4, 137, 100, 30, baseMultiplier = 1.937, manaCost = 5, damageEffectiveness = 1.94, attackSpeedMultiplier = -30, levelRequirement = 90, statInterpolation = { 1, 1, 1, 1, }, },
		[31] = { 4, 140, 100, 30, baseMultiplier = 1.949, manaCost = 5, damageEffectiveness = 1.95, attackSpeedMultiplier = -30, levelRequirement = 91, statInterpolation = { 1, 1, 1, 1, }, },
		[32] = { 4, 143, 100, 30, baseMultiplier = 1.961, manaCost = 5, damageEffectiveness = 1.96, attackSpeedMultiplier = -30, levelRequirement = 92, statInterpolation = { 1, 1, 1, 1, }, },
		[33] = { 4, 146, 100, 30, baseMultiplier = 1.972, manaCost = 5, damageEffectiveness = 1.97, attackSpeedMultiplier = -30, levelRequirement = 93, statInterpolation = { 1, 1, 1, 1, }, },
		[34] = { 4, 149, 100, 30, baseMultiplier = 1.984, manaCost = 5, damageEffectiveness = 1.98, attackSpeedMultiplier = -30, levelRequirement = 94, statInterpolation = { 1, 1, 1, 1, }, },
		[35] = { 5, 152, 100, 30, baseMultiplier = 1.996, manaCost = 5, damageEffectiveness = 2, attackSpeedMultiplier = -30, levelRequirement = 95, statInterpolation = { 1, 1, 1, 1, }, },
		[36] = { 5, 155, 100, 30, baseMultiplier = 2.008, manaCost = 5, damageEffectiveness = 2.01, attackSpeedMultiplier = -30, levelRequirement = 96, statInterpolation = { 1, 1, 1, 1, }, },
		[37] = { 5, 158, 100, 30, baseMultiplier = 2.02, manaCost = 5, damageEffectiveness = 2.02, attackSpeedMultiplier = -30, levelRequirement = 97, statInterpolation = { 1, 1, 1, 1, }, },
		[38] = { 5, 161, 100, 30, baseMultiplier = 2.032, manaCost = 5, damageEffectiveness = 2.03, attackSpeedMultiplier = -30, levelRequirement = 98, statInterpolation = { 1, 1, 1, 1, }, },
		[39] = { 5, 164, 100, 30, baseMultiplier = 2.043, manaCost = 5, damageEffectiveness = 2.04, attackSpeedMultiplier = -30, levelRequirement = 99, statInterpolation = { 1, 1, 1, 1, }, },
		[40] = { 5, 167, 100, 30, baseMultiplier = 2.055, manaCost = 5, damageEffectiveness = 2.06, attackSpeedMultiplier = -30, levelRequirement = 100, statInterpolation = { 1, 1, 1, 1, }, },
	},
}
skills["ElementalHit"] = {
	name = "Elemental Hit",
	color = 2,
	baseEffectiveness = 2.9000000953674,
	incrementalEffectiveness = 0.034099999815226,
	description = "Each attack with this skill will choose an element at random, and will only be able to deal damage of that element. If the attack hits an enemy, it will also deal damage in an area around them, with the radius being larger if that enemy is suffering from an ailment of the chosen element. It will avoid choosing the same element twice in a row.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.SkillCanVolley] = true, [SkillType.SkillCanTotem] = true, [SkillType.SkillCanTrap] = true, [SkillType.SkillCanMine] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.AttackCanRepeat] = true, [SkillType.Melee] = true, [SkillType.FireSkill] = true, [SkillType.ColdSkill] = true, [SkillType.LightningSkill] = true, [SkillType.ProjectileAttack] = true, [SkillType.SkillCanMirageArcher] = true, [SkillType.Area] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Fire",
		},
		{
			name = "Cold",
		},
		{
			name = "Lightning",
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
	},
	baseMods = {
		flag("DealNoPhysical"),
		flag("DealNoChaos"),
		flag("DealNoFire", { type = "SkillPart", skillPart = 2 }),
		flag("DealNoFire", { type = "SkillPart", skillPart = 3 }),
		flag("DealNoCold", { type = "SkillPart", skillPart = 1 }),
		flag("DealNoCold", { type = "SkillPart", skillPart = 3 }),
		flag("DealNoLightning", { type = "SkillPart", skillPart = 1 }),
		flag("DealNoLightning", { type = "SkillPart", skillPart = 2 }),
		mod("AreaOfEffect", "MORE", 80, 0, 0, { type = "ActorCondition", actor = "enemy", var = "Ignited" }, { type = "SkillPart", skillPart = 1 }),
		mod("AreaOfEffect", "MORE", 80, 0, 0, { type = "ActorCondition", actor = "enemy", var = "Chilled" }, { type = "SkillPart", skillPart = 2 }),
		mod("AreaOfEffect", "MORE", 80, 0, 0, { type = "ActorCondition", actor = "enemy", var = "Frozen" }, { type = "SkillPart", skillPart = 2 }),
		mod("AreaOfEffect", "MORE", 80, 0, 0, { type = "ActorCondition", actor = "enemy", var = "Shocked" }, { type = "SkillPart", skillPart = 3 }),
		mod("Multiplier:ElementalHitAilmentOnEnemy", "BASE", 1, 0, 0, { type = "ActorCondition", actor = "enemy", var = "Ignited" }),
		mod("Multiplier:ElementalHitAilmentOnEnemy", "BASE", 1, 0, 0, { type = "ActorCondition", actor = "enemy", var = "Chilled" }),
		mod("Multiplier:ElementalHitAilmentOnEnemy", "BASE", 1, 0, 0, { type = "ActorCondition", actor = "enemy", var = "Frozen" }),
		mod("Multiplier:ElementalHitAilmentOnEnemy", "BASE", 1, 0, 0, { type = "ActorCondition", actor = "enemy", var = "Shocked" }),
		mod("Damage", "MORE", 10, 0, 0, { type = "Multiplier", var = "ElementalHitAilmentOnEnemy" }),
	},
	qualityStats = {
		{ "elemental_damage_+%", 1 },
	},
	stats = {
		"attack_minimum_added_fire_damage",
		"attack_maximum_added_fire_damage",
		"attack_minimum_added_cold_damage",
		"attack_maximum_added_cold_damage",
		"attack_minimum_added_lightning_damage",
		"attack_maximum_added_lightning_damage",
		"chance_to_freeze_shock_ignite_%",
		"melee_range_+",
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
		"elemental_hit_damage_+10%_final_per_enemy_elemental_ailment",
		"elemental_hit_area_of_effect_+100%_final_vs_enemy_with_associated_ailment",
		"elemental_hit_no_physical_chaos_damage",
	},
	levels = {
		[1] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 30, 0, manaCost = 7, levelRequirement = 12, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[2] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 31, 0, manaCost = 7, levelRequirement = 15, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[3] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 32, 0, manaCost = 7, levelRequirement = 19, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[4] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 33, 0, manaCost = 8, levelRequirement = 23, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[5] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 34, 0, manaCost = 8, levelRequirement = 27, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[6] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 35, 0, manaCost = 8, levelRequirement = 31, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[7] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 36, 1, manaCost = 8, levelRequirement = 35, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[8] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 37, 1, manaCost = 8, levelRequirement = 38, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[9] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 38, 1, manaCost = 9, levelRequirement = 41, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[10] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 39, 1, manaCost = 9, levelRequirement = 44, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[11] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 40, 1, manaCost = 9, levelRequirement = 47, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[12] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 41, 1, manaCost = 9, levelRequirement = 50, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[13] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 42, 1, manaCost = 9, levelRequirement = 53, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[14] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 43, 2, manaCost = 10, levelRequirement = 56, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[15] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 44, 2, manaCost = 10, levelRequirement = 59, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[16] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 45, 2, manaCost = 10, levelRequirement = 62, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[17] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 46, 2, manaCost = 10, levelRequirement = 64, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[18] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 47, 2, manaCost = 10, levelRequirement = 66, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[19] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 48, 2, manaCost = 11, levelRequirement = 68, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[20] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 49, 2, manaCost = 11, levelRequirement = 70, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[21] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 50, 3, manaCost = 11, levelRequirement = 72, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[22] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 51, 3, manaCost = 11, levelRequirement = 74, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[23] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 52, 3, manaCost = 11, levelRequirement = 76, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[24] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 53, 3, manaCost = 11, levelRequirement = 78, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[25] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 54, 3, manaCost = 11, levelRequirement = 80, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[26] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 55, 3, manaCost = 12, levelRequirement = 82, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[27] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 56, 3, manaCost = 12, levelRequirement = 84, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[28] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 57, 4, manaCost = 12, levelRequirement = 86, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[29] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 58, 4, manaCost = 12, levelRequirement = 88, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[30] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 59, 4, manaCost = 12, levelRequirement = 90, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[31] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 59, 4, manaCost = 13, levelRequirement = 91, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[32] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 60, 4, manaCost = 13, levelRequirement = 92, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[33] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 60, 4, manaCost = 13, levelRequirement = 93, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[34] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 61, 4, manaCost = 13, levelRequirement = 94, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[35] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 61, 5, manaCost = 13, levelRequirement = 95, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[36] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 62, 5, manaCost = 14, levelRequirement = 96, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[37] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 62, 5, manaCost = 14, levelRequirement = 97, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[38] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 63, 5, manaCost = 14, levelRequirement = 98, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[39] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 63, 5, manaCost = 14, levelRequirement = 99, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
		[40] = { 0.69999998807907, 1.2999999523163, 0.57270002365112, 1.0635999441147, 0.11249999701977, 2.1375000476837, 64, 5, manaCost = 14, levelRequirement = 100, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, },
	},
}
skills["EtherealKnives"] = {
	name = "Ethereal Knives",
	color = 2,
	baseEffectiveness = 2.184700012207,
	incrementalEffectiveness = 0.037399999797344,
	description = "Fires an arc of knives in front of the caster which deals physical damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Hit] = true, [SkillType.Projectile] = true, [SkillType.SkillCanVolley] = true, [SkillType.SkillCanTotem] = true, [SkillType.SkillCanTrap] = true, [SkillType.SkillCanMine] = true, [SkillType.SpellCanRepeat] = true, [SkillType.Triggerable] = true, [SkillType.CanRapidFire] = true, [SkillType.PhysicalSkill] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.6,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "base_projectile_speed_+%", 1 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"number_of_additional_projectiles",
		"base_projectile_speed_+%",
		"base_is_projectile",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 9, 0, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 1, manaCost = 5, statInterpolation = { 3, 3, 1, 1, }, },
		[2] = { 0.89999997615814, 1.2000000476837, 9, 1, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 2, manaCost = 5, statInterpolation = { 3, 3, 1, 1, }, },
		[3] = { 0.80000001192093, 1.2000000476837, 9, 2, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 4, manaCost = 5, statInterpolation = { 3, 3, 1, 1, }, },
		[4] = { 0.80000001192093, 1.2000000476837, 9, 3, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 7, manaCost = 6, statInterpolation = { 3, 3, 1, 1, }, },
		[5] = { 0.80000001192093, 1.2000000476837, 9, 4, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 11, manaCost = 7, statInterpolation = { 3, 3, 1, 1, }, },
		[6] = { 0.80000001192093, 1.2000000476837, 9, 5, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 16, manaCost = 8, statInterpolation = { 3, 3, 1, 1, }, },
		[7] = { 0.80000001192093, 1.2000000476837, 9, 6, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 20, manaCost = 9, statInterpolation = { 3, 3, 1, 1, }, },
		[8] = { 0.80000001192093, 1.2000000476837, 9, 7, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 24, manaCost = 10, statInterpolation = { 3, 3, 1, 1, }, },
		[9] = { 0.80000001192093, 1.2000000476837, 9, 8, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 28, manaCost = 11, statInterpolation = { 3, 3, 1, 1, }, },
		[10] = { 0.80000001192093, 1.2000000476837, 9, 9, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 32, manaCost = 11, statInterpolation = { 3, 3, 1, 1, }, },
		[11] = { 0.80000001192093, 1.2000000476837, 9, 10, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 36, manaCost = 12, statInterpolation = { 3, 3, 1, 1, }, },
		[12] = { 0.80000001192093, 1.2000000476837, 9, 11, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 40, manaCost = 13, statInterpolation = { 3, 3, 1, 1, }, },
		[13] = { 0.80000001192093, 1.2000000476837, 9, 12, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 44, manaCost = 14, statInterpolation = { 3, 3, 1, 1, }, },
		[14] = { 0.80000001192093, 1.2000000476837, 9, 13, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 48, manaCost = 15, statInterpolation = { 3, 3, 1, 1, }, },
		[15] = { 0.80000001192093, 1.2000000476837, 9, 14, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 52, manaCost = 16, statInterpolation = { 3, 3, 1, 1, }, },
		[16] = { 0.80000001192093, 1.2000000476837, 9, 15, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 56, manaCost = 17, statInterpolation = { 3, 3, 1, 1, }, },
		[17] = { 0.80000001192093, 1.2000000476837, 9, 16, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 60, manaCost = 18, statInterpolation = { 3, 3, 1, 1, }, },
		[18] = { 0.80000001192093, 1.2000000476837, 9, 17, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 64, manaCost = 18, statInterpolation = { 3, 3, 1, 1, }, },
		[19] = { 0.80000001192093, 1.2000000476837, 9, 18, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 67, manaCost = 19, statInterpolation = { 3, 3, 1, 1, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 9, 19, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 70, manaCost = 20, statInterpolation = { 3, 3, 1, 1, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 9, 20, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 72, manaCost = 20, statInterpolation = { 3, 3, 1, 1, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 9, 21, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 74, manaCost = 21, statInterpolation = { 3, 3, 1, 1, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 9, 22, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 76, manaCost = 21, statInterpolation = { 3, 3, 1, 1, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 9, 23, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 78, manaCost = 21, statInterpolation = { 3, 3, 1, 1, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 9, 24, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 80, manaCost = 22, statInterpolation = { 3, 3, 1, 1, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 9, 25, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 82, manaCost = 22, statInterpolation = { 3, 3, 1, 1, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 9, 26, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 84, manaCost = 23, statInterpolation = { 3, 3, 1, 1, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 9, 27, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 86, manaCost = 23, statInterpolation = { 3, 3, 1, 1, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 9, 28, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 88, manaCost = 24, statInterpolation = { 3, 3, 1, 1, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 9, 29, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 90, manaCost = 24, statInterpolation = { 3, 3, 1, 1, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 9, 29, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 91, manaCost = 24, statInterpolation = { 3, 3, 1, 1, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 9, 30, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 92, manaCost = 25, statInterpolation = { 3, 3, 1, 1, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 9, 30, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 93, manaCost = 25, statInterpolation = { 3, 3, 1, 1, }, },
		[34] = { 0.80000001192093, 1.2000000476837, 9, 31, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 94, manaCost = 25, statInterpolation = { 3, 3, 1, 1, }, },
		[35] = { 0.80000001192093, 1.2000000476837, 9, 31, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 95, manaCost = 25, statInterpolation = { 3, 3, 1, 1, }, },
		[36] = { 0.80000001192093, 1.2000000476837, 9, 32, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 96, manaCost = 25, statInterpolation = { 3, 3, 1, 1, }, },
		[37] = { 0.80000001192093, 1.2000000476837, 9, 32, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 97, manaCost = 26, statInterpolation = { 3, 3, 1, 1, }, },
		[38] = { 0.80000001192093, 1.2000000476837, 9, 33, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 98, manaCost = 26, statInterpolation = { 3, 3, 1, 1, }, },
		[39] = { 0.80000001192093, 1.2000000476837, 9, 33, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 99, manaCost = 26, statInterpolation = { 3, 3, 1, 1, }, },
		[40] = { 0.80000001192093, 1.2000000476837, 9, 34, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 100, manaCost = 26, statInterpolation = { 3, 3, 1, 1, }, },
	},
}
skills["ExplosiveArrow"] = {
	name = "Explosive Arrow",
	color = 2,
	baseEffectiveness = 1.2222000360489,
	incrementalEffectiveness = 0.045000001788139,
	description = "Fires an arrow which acts as a short duration fuse. Applying additional arrows to an enemy extends the duration. When the target dies or the fuses expire, the arrows explode, dealing fire AoE damage to nearby enemies. The AoE radius is proportional to the number of arrows upon death.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.ProjectileAttack] = true, [SkillType.SkillCanMirageArcher] = true, [SkillType.Projectile] = true, [SkillType.SkillCanVolley] = true, [SkillType.Hit] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.SkillCanTotem] = true, [SkillType.SkillCanTrap] = true, [SkillType.SkillCanMine] = true, [SkillType.FireSkill] = true, [SkillType.Triggerable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Explosion (1 fuse)",
			attack = false,
			area = true,
			cast = true,
		},
		{
			name = "Explosion (5 fuses)",
			attack = false,
			area = true,
			cast = true,
		},
		{
			name = "Arrow",
			attack = true,
			area = false,
			cast = false,
		},
	},
	statMap = {
		["minimum_fire_damage_per_fuse_arrow_orb"] = {
			skill("FireMin", nil, { type = "Multiplier", var = "ExplosiveArrowFuse" }),
		},
		["maximum_fire_damage_per_fuse_arrow_orb"] = {
			skill("FireMax", nil, { type = "Multiplier", var = "ExplosiveArrowFuse" }),
		},
		["fuse_arrow_explosion_radius_+_per_fuse_arrow_orb"] = {
			skill("radiusExtra", nil, { type = "Multiplier", var = "ExplosiveArrowFuse" }),
		},
	},
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 15),
		skill("showAverage", true, { type = "SkillPart", skillPart = 1 }),
		skill("showAverage", true, { type = "SkillPart", skillPart = 2 }),
		mod("Multiplier:ExplosiveArrowFuse", "BASE", 1, 0, 0, { type = "SkillPart", skillPart = 1 }),
		mod("Multiplier:ExplosiveArrowFuse", "BASE", 5, 0, 0, { type = "SkillPart", skillPart = 2 }),
	},
	qualityStats = {
		{ "base_chance_to_ignite_%", 1 },
	},
	stats = {
		"base_skill_effect_duration",
		"minimum_fire_damage_per_fuse_arrow_orb",
		"maximum_fire_damage_per_fuse_arrow_orb",
		"fuse_arrow_explosion_radius_+_per_fuse_arrow_orb",
		"active_skill_attack_damage_+%_final",
		"skill_can_fire_arrows",
		"base_is_projectile",
	},
	levels = {
		[1] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 28, manaCost = 18, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[2] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 31, manaCost = 19, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[3] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 34, manaCost = 20, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[4] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 37, manaCost = 21, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[5] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 40, manaCost = 21, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[6] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 42, manaCost = 22, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[7] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 44, manaCost = 22, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[8] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 46, manaCost = 23, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[9] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 48, manaCost = 23, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[10] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 50, manaCost = 24, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[11] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 52, manaCost = 24, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[12] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 54, manaCost = 24, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[13] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 56, manaCost = 26, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[14] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 58, manaCost = 26, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[15] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 60, manaCost = 26, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[16] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 62, manaCost = 26, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[17] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 64, manaCost = 26, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[18] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 66, manaCost = 27, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[19] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 68, manaCost = 27, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[20] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 70, manaCost = 27, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[21] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 72, manaCost = 28, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[22] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 74, manaCost = 28, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[23] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 76, manaCost = 29, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[24] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 78, manaCost = 29, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[25] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 80, manaCost = 30, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[26] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 82, manaCost = 30, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[27] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 84, manaCost = 30, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[28] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 86, manaCost = 30, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[29] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 88, manaCost = 31, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[30] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 90, manaCost = 31, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[31] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 91, manaCost = 31, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[32] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 92, manaCost = 32, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[33] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 93, manaCost = 32, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[34] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 94, manaCost = 33, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[35] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 95, manaCost = 33, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[36] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 96, manaCost = 34, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[37] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 97, manaCost = 34, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[38] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 98, manaCost = 34, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[39] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 99, manaCost = 35, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
		[40] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, 1, 1, critChance = 6, levelRequirement = 100, manaCost = 35, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, },
	},
}
skills["ShrapnelTrap"] = {
	name = "Explosive Trap",
	color = 2,
	baseEffectiveness = 1.7621999979019,
	incrementalEffectiveness = 0.029899999499321,
	description = "Throws a trap that creates a large explosion when triggered, dealing spell damage in an area. A number of smaller explosions occur around this area in quick succession after the first.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Hit] = true, [SkillType.SkillCanMine] = true, [SkillType.Area] = true, [SkillType.Trap] = true, [SkillType.FireSkill] = true, [SkillType.AreaSpell] = true, [SkillType.PhysicalSkill] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		trap = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 0.5 },
	},
	stats = {
		"base_trap_duration",
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"skill_physical_damage_%_to_convert_to_fire",
		"shrapnel_trap_number_of_secondary_explosions",
		"active_skill_base_radius_+",
		"is_area_damage",
		"base_skill_is_trapped",
		"base_skill_show_average_damage_instead_of_dps",
		"is_trap",
	},
	levels = {
		[1] = { 4000, 0.56999999284744, 0.86000001430511, 50, 4, 0, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 1, manaCost = 6, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[2] = { 4000, 0.64999997615814, 0.97000002861023, 50, 4, 0, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 2, manaCost = 6, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[3] = { 4000, 0.72000002861023, 1.0800000429153, 50, 4, 1, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 4, manaCost = 7, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[4] = { 4000, 0.80000001192093, 1.2000000476837, 50, 4, 1, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 7, manaCost = 8, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[5] = { 4000, 0.80000001192093, 1.2000000476837, 50, 4, 1, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 11, manaCost = 9, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[6] = { 4000, 0.80000001192093, 1.2000000476837, 50, 5, 2, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 16, manaCost = 10, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[7] = { 4000, 0.80000001192093, 1.2000000476837, 50, 5, 2, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 20, manaCost = 11, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[8] = { 4000, 0.80000001192093, 1.2000000476837, 50, 5, 2, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 24, manaCost = 12, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[9] = { 4000, 0.80000001192093, 1.2000000476837, 50, 5, 3, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 28, manaCost = 13, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[10] = { 4000, 0.80000001192093, 1.2000000476837, 50, 5, 3, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 32, manaCost = 14, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[11] = { 4000, 0.80000001192093, 1.2000000476837, 50, 6, 3, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 36, manaCost = 14, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[12] = { 4000, 0.80000001192093, 1.2000000476837, 50, 6, 4, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 40, manaCost = 15, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[13] = { 4000, 0.80000001192093, 1.2000000476837, 50, 6, 4, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 44, manaCost = 16, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[14] = { 4000, 0.80000001192093, 1.2000000476837, 50, 6, 4, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 48, manaCost = 16, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[15] = { 4000, 0.80000001192093, 1.2000000476837, 50, 6, 5, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 52, manaCost = 17, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[16] = { 4000, 0.80000001192093, 1.2000000476837, 50, 7, 5, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 56, manaCost = 18, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[17] = { 4000, 0.80000001192093, 1.2000000476837, 50, 7, 5, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 60, manaCost = 18, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[18] = { 4000, 0.80000001192093, 1.2000000476837, 50, 7, 6, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 64, manaCost = 19, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[19] = { 4000, 0.80000001192093, 1.2000000476837, 50, 7, 6, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 67, manaCost = 19, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[20] = { 4000, 0.80000001192093, 1.2000000476837, 50, 7, 6, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 70, manaCost = 20, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[21] = { 4000, 0.80000001192093, 1.2000000476837, 50, 8, 7, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 72, manaCost = 20, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[22] = { 4000, 0.80000001192093, 1.2000000476837, 50, 8, 7, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 74, manaCost = 21, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[23] = { 4000, 0.80000001192093, 1.2000000476837, 50, 8, 7, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 76, manaCost = 21, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[24] = { 4000, 0.80000001192093, 1.2000000476837, 50, 8, 8, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 78, manaCost = 21, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[25] = { 4000, 0.80000001192093, 1.2000000476837, 50, 8, 8, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 80, manaCost = 22, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[26] = { 4000, 0.80000001192093, 1.2000000476837, 50, 9, 8, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 82, manaCost = 23, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[27] = { 4000, 0.80000001192093, 1.2000000476837, 50, 9, 9, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 84, manaCost = 23, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[28] = { 4000, 0.80000001192093, 1.2000000476837, 50, 9, 9, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 86, manaCost = 23, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[29] = { 4000, 0.80000001192093, 1.2000000476837, 50, 9, 9, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 88, manaCost = 24, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[30] = { 4000, 0.80000001192093, 1.2000000476837, 50, 9, 10, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 90, manaCost = 24, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[31] = { 4000, 0.80000001192093, 1.2000000476837, 50, 9, 10, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 91, manaCost = 25, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[32] = { 4000, 0.80000001192093, 1.2000000476837, 50, 10, 10, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 92, manaCost = 25, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[33] = { 4000, 0.80000001192093, 1.2000000476837, 50, 10, 10, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 93, manaCost = 25, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[34] = { 4000, 0.80000001192093, 1.2000000476837, 50, 10, 10, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 94, manaCost = 26, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[35] = { 4000, 0.80000001192093, 1.2000000476837, 50, 10, 11, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 95, manaCost = 27, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[36] = { 4000, 0.80000001192093, 1.2000000476837, 50, 10, 11, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 96, manaCost = 27, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[37] = { 4000, 0.80000001192093, 1.2000000476837, 50, 10, 11, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 97, manaCost = 27, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[38] = { 4000, 0.80000001192093, 1.2000000476837, 50, 10, 11, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 98, manaCost = 28, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[39] = { 4000, 0.80000001192093, 1.2000000476837, 50, 10, 11, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 99, manaCost = 28, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
		[40] = { 4000, 0.80000001192093, 1.2000000476837, 50, 10, 11, damageEffectiveness = 0.6, critChance = 6, levelRequirement = 100, manaCost = 29, statInterpolation = { 1, 3, 3, 1, 1, 1, }, },
	},
}
skills["FireTrap"] = {
	name = "Fire Trap",
	color = 2,
	baseEffectiveness = 2.7021999359131,
	incrementalEffectiveness = 0.048300001770258,
	description = "Throws a trap that explodes when triggered, dealing fire damage to surrounding enemies and leaving an area of burning ground that damages enemies who walk through it.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Duration] = true, [SkillType.Hit] = true, [SkillType.SkillCanMine] = true, [SkillType.Area] = true, [SkillType.CausesBurning] = true, [SkillType.Trap] = true, [SkillType.DamageOverTime] = true, [SkillType.FireSkill] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		trap = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("dotIsArea", true),
		skill("radius", 15),
	},
	qualityStats = {
		{ "fire_damage_+%", 1 },
	},
	stats = {
		"base_trap_duration",
		"base_skill_effect_duration",
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"base_fire_damage_to_deal_per_minute",
		"active_skill_base_radius_+",
		"global_minimum_added_fire_damage_vs_burning_enemies",
		"global_maximum_added_fire_damage_vs_burning_enemies",
		"is_area_damage",
		"base_skill_is_trapped",
		"base_skill_show_average_damage_instead_of_dps",
		"spell_damage_modifiers_apply_to_skill_dot",
		"is_trap",
	},
	levels = {
		[1] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 0, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 12, manaCost = 8, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[2] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 0, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 15, manaCost = 8, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[3] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 1, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 19, manaCost = 9, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[4] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 1, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 23, manaCost = 10, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[5] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 2, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 27, manaCost = 10, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[6] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 2, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 31, manaCost = 11, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[7] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 3, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 35, manaCost = 11, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[8] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 3, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 38, manaCost = 12, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[9] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 4, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 41, manaCost = 13, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[10] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 4, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 44, manaCost = 14, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[11] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 4, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 47, manaCost = 14, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[12] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 5, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 50, manaCost = 15, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[13] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 5, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 53, manaCost = 16, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[14] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 6, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 56, manaCost = 16, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[15] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 6, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 59, manaCost = 17, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[16] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 7, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 62, manaCost = 18, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[17] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 7, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 64, manaCost = 18, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[18] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 8, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 66, manaCost = 19, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[19] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 8, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 68, manaCost = 19, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[20] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 8, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 70, manaCost = 20, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[21] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 9, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 72, manaCost = 20, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[22] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 9, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 74, manaCost = 21, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[23] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 10, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 76, manaCost = 21, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[24] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 10, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 78, manaCost = 21, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[25] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 11, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 80, manaCost = 22, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[26] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 11, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 82, manaCost = 23, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[27] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 11, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 84, manaCost = 23, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[28] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 12, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 86, manaCost = 23, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[29] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 12, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 88, manaCost = 24, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[30] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 13, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 90, manaCost = 24, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[31] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 13, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 91, manaCost = 26, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[32] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 13, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 92, manaCost = 26, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[33] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 13, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 93, manaCost = 27, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[34] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 14, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 94, manaCost = 27, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[35] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 14, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 95, manaCost = 28, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[36] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 14, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 96, manaCost = 29, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[37] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 14, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 97, manaCost = 29, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[38] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 15, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 98, manaCost = 30, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[39] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 15, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 99, manaCost = 30, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
		[40] = { 4000, 1750, 0.31999999284744, 0.47999998927116, 54.643334179595, 15, 0.10000000149012, 0.15000000596046, damageEffectiveness = 2, critChance = 6, levelRequirement = 100, manaCost = 31, statInterpolation = { 1, 1, 3, 3, 3, 1, 3, 3, }, },
	},
}
skills["FlamethrowerTrap"] = {
	name = "Flamethrower Trap",
	color = 2,
	baseEffectiveness = 0.10270000249147,
	incrementalEffectiveness = 0.058899998664856,
	description = "Throws a trap that releases a number of flames in different directions around it when triggered. The flames last for a duration, rotating around the trap and repeatedly dealing damage. Burning enemies are dealt more damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Duration] = true, [SkillType.Hit] = true, [SkillType.SkillCanMine] = true, [SkillType.Area] = true, [SkillType.Trap] = true, [SkillType.FireSkill] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["flamethrower_trap_damage_+%_final_vs_burning_enemies"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "ActorCondition", actor = "enemy", var = "Burning" }),
		},
	},
	baseFlags = {
		spell = true,
		trap = true,
		area = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "fire_damage_+%", 1 },
	},
	stats = {
		"base_trap_duration",
		"base_skill_effect_duration",
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"flamethrower_trap_damage_+%_final_vs_burning_enemies",
		"flamethrower_tower_trap_number_of_flamethrowers",
		"is_area_damage",
		"base_skill_is_trapped",
		"base_skill_show_average_damage_instead_of_dps",
		"is_trap",
		"flamethrower_tower_trap_display_cast_speed_affects_rotation",
	},
	levels = {
		[1] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 25, 4, critChance = 5, manaCost = 13, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 28, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[2] = { 4000, 3500, 0.83050000667572, 1.2462999820709, 25, 4, critChance = 5, manaCost = 13, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 31, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[3] = { 4000, 3500, 0.86110001802444, 1.2926000356674, 25, 4, critChance = 5, manaCost = 14, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 34, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[4] = { 4000, 3500, 0.89160001277924, 1.3388999700546, 25, 4, critChance = 5, manaCost = 16, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 37, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[5] = { 4000, 3500, 0.92210000753403, 1.3853000402451, 25, 4, critChance = 5, manaCost = 17, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 40, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[6] = { 4000, 3500, 0.95260000228882, 1.4315999746323, 25, 4, critChance = 5, manaCost = 17, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 42, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[7] = { 4000, 3500, 0.98320001363754, 1.4779000282288, 25, 4, critChance = 5, manaCost = 18, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 44, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[8] = { 4000, 3500, 1.0137000083923, 1.524199962616, 25, 4, critChance = 5, manaCost = 18, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 46, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[9] = { 4000, 3500, 1.0441999435425, 1.5705000162125, 25, 4, critChance = 5, manaCost = 19, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 48, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[10] = { 4000, 3500, 1.0746999979019, 1.6167999505997, 25, 4, critChance = 5, manaCost = 19, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 50, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[11] = { 4000, 3500, 1.105299949646, 1.6632000207901, 25, 4, critChance = 5, manaCost = 19, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 52, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[12] = { 4000, 3500, 1.1358000040054, 1.7094999551773, 25, 4, critChance = 5, manaCost = 20, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 54, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[13] = { 4000, 3500, 1.1663000583649, 1.7558000087738, 25, 4, critChance = 5, manaCost = 20, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 56, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[14] = { 4000, 3500, 1.196799993515, 1.802099943161, 25, 4, critChance = 5, manaCost = 22, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 58, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[15] = { 4000, 3500, 1.2273999452591, 1.8483999967575, 25, 4, critChance = 5, manaCost = 22, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 60, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[16] = { 4000, 3500, 1.2578999996185, 1.894700050354, 25, 4, critChance = 5, manaCost = 23, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 62, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[17] = { 4000, 3500, 1.288400053978, 1.9411000013351, 25, 4, critChance = 5, manaCost = 23, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 64, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[18] = { 4000, 3500, 1.3188999891281, 1.9874000549316, 25, 4, critChance = 5, manaCost = 24, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 66, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[19] = { 4000, 3500, 1.3494999408722, 2.0336999893188, 25, 4, critChance = 5, manaCost = 24, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 68, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[20] = { 4000, 3500, 1.3799999952316, 2.0799999237061, 25, 4, critChance = 5, manaCost = 25, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 70, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[21] = { 4000, 3500, 1.3799999952316, 2.0799999237061, 25, 4, critChance = 5, manaCost = 25, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 72, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[22] = { 4000, 3500, 1.3799999952316, 2.0799999237061, 25, 4, critChance = 5, manaCost = 26, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 74, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[23] = { 4000, 3500, 1.3799999952316, 2.0799999237061, 25, 4, critChance = 5, manaCost = 26, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 76, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[24] = { 4000, 3500, 1.3799999952316, 2.0799999237061, 25, 4, critChance = 5, manaCost = 28, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 78, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[25] = { 4000, 3500, 1.3799999952316, 2.0799999237061, 25, 4, critChance = 5, manaCost = 28, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 80, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[26] = { 4000, 3500, 1.3799999952316, 2.0799999237061, 25, 4, critChance = 5, manaCost = 29, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 82, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[27] = { 4000, 3500, 1.3799999952316, 2.0799999237061, 25, 4, critChance = 5, manaCost = 29, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 84, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[28] = { 4000, 3500, 1.3799999952316, 2.0799999237061, 25, 4, critChance = 5, manaCost = 30, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 86, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[29] = { 4000, 3500, 1.3799999952316, 2.0799999237061, 25, 4, critChance = 5, manaCost = 30, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 88, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[30] = { 4000, 3500, 1.3799999952316, 2.0799999237061, 25, 4, critChance = 5, manaCost = 31, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 90, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[31] = { 4000, 3500, 1.3799999952316, 2.0799999237061, 25, 4, critChance = 5, manaCost = 32, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 91, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[32] = { 4000, 3500, 1.3799999952316, 2.0799999237061, 25, 4, critChance = 5, manaCost = 32, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 92, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[33] = { 4000, 3500, 1.3799999952316, 2.0799999237061, 25, 4, critChance = 5, manaCost = 33, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 93, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[34] = { 4000, 3500, 1.3799999952316, 2.0799999237061, 25, 4, critChance = 5, manaCost = 33, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 94, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[35] = { 4000, 3500, 1.3799999952316, 2.0799999237061, 25, 4, critChance = 5, manaCost = 34, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 95, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[36] = { 4000, 3500, 1.3799999952316, 2.0799999237061, 25, 4, critChance = 5, manaCost = 35, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 96, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[37] = { 4000, 3500, 1.3799999952316, 2.0799999237061, 25, 4, critChance = 5, manaCost = 35, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 97, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[38] = { 4000, 3500, 1.3799999952316, 2.0799999237061, 25, 4, critChance = 5, manaCost = 36, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 98, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[39] = { 4000, 3500, 1.3799999952316, 2.0799999237061, 25, 4, critChance = 5, manaCost = 36, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 99, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[40] = { 4000, 3500, 1.3799999952316, 2.0799999237061, 25, 4, critChance = 5, manaCost = 37, damageEffectiveness = 0.3, cooldown = 8, levelRequirement = 100, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
	},
}
skills["FlickerStrike"] = {
	name = "Flicker Strike",
	color = 2,
	description = "Teleports the character to a nearby monster and attacks with a melee weapon. If no specific monster is targeted, one is picked at random. Grants a buff that increases movement speed for a duration. The cooldown can be bypassed by expending a Frenzy Charge.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.AttackCanRepeat] = true, [SkillType.MovementSkill] = true, [SkillType.Duration] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["flicker_strike_more_attack_speed_+%_final"] = {
			mod("Speed", "MORE", nil, ModFlag.Attack),
		},
		["base_skill_show_average_damage_instead_of_dps"] = {
		},
		["flicker_strike_buff_movement_speed_+%"] = {
			mod("MovementSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["flicker_strike_buff_duration_ms"] = {
			skill("duration", nil),
			div = 1000,
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "add_frenzy_charge_on_skill_hit_%", 0.25 },
	},
	stats = {
		"base_attack_speed_+%_per_frenzy_charge",
		"add_frenzy_charge_on_skill_hit_%",
		"flicker_strike_buff_movement_speed_+%",
		"flicker_strike_buff_duration_ms",
		"ignores_proximity_shield",
		"base_skill_show_average_damage_instead_of_dps",
		"melee_defer_damage_prediction",
	},
	levels = {
		[1] = { 10, 15, 20, 3000, baseMultiplier = 1.422, manaCost = 10, damageEffectiveness = 1.42, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 10, statInterpolation = { 1, 1, 1, 1, }, },
		[2] = { 10, 15, 20, 3000, baseMultiplier = 1.436, manaCost = 10, damageEffectiveness = 1.44, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 13, statInterpolation = { 1, 1, 1, 1, }, },
		[3] = { 10, 15, 20, 3000, baseMultiplier = 1.449, manaCost = 10, damageEffectiveness = 1.45, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 17, statInterpolation = { 1, 1, 1, 1, }, },
		[4] = { 10, 15, 20, 3000, baseMultiplier = 1.463, manaCost = 10, damageEffectiveness = 1.46, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 21, statInterpolation = { 1, 1, 1, 1, }, },
		[5] = { 10, 15, 20, 3000, baseMultiplier = 1.476, manaCost = 10, damageEffectiveness = 1.48, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[6] = { 10, 15, 20, 3000, baseMultiplier = 1.49, manaCost = 10, damageEffectiveness = 1.49, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 29, statInterpolation = { 1, 1, 1, 1, }, },
		[7] = { 10, 15, 20, 3000, baseMultiplier = 1.504, manaCost = 10, damageEffectiveness = 1.5, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 33, statInterpolation = { 1, 1, 1, 1, }, },
		[8] = { 10, 15, 20, 3000, baseMultiplier = 1.517, manaCost = 10, damageEffectiveness = 1.52, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 36, statInterpolation = { 1, 1, 1, 1, }, },
		[9] = { 10, 15, 20, 3000, baseMultiplier = 1.531, manaCost = 10, damageEffectiveness = 1.53, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 39, statInterpolation = { 1, 1, 1, 1, }, },
		[10] = { 10, 15, 20, 3000, baseMultiplier = 1.544, manaCost = 10, damageEffectiveness = 1.54, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 42, statInterpolation = { 1, 1, 1, 1, }, },
		[11] = { 10, 15, 20, 3000, baseMultiplier = 1.558, manaCost = 10, damageEffectiveness = 1.56, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 45, statInterpolation = { 1, 1, 1, 1, }, },
		[12] = { 10, 15, 20, 3000, baseMultiplier = 1.571, manaCost = 10, damageEffectiveness = 1.57, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 48, statInterpolation = { 1, 1, 1, 1, }, },
		[13] = { 10, 15, 20, 3000, baseMultiplier = 1.585, manaCost = 10, damageEffectiveness = 1.59, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 51, statInterpolation = { 1, 1, 1, 1, }, },
		[14] = { 10, 15, 20, 3000, baseMultiplier = 1.599, manaCost = 10, damageEffectiveness = 1.6, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 54, statInterpolation = { 1, 1, 1, 1, }, },
		[15] = { 10, 15, 20, 3000, baseMultiplier = 1.612, manaCost = 10, damageEffectiveness = 1.61, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 57, statInterpolation = { 1, 1, 1, 1, }, },
		[16] = { 10, 15, 20, 3000, baseMultiplier = 1.626, manaCost = 10, damageEffectiveness = 1.63, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 60, statInterpolation = { 1, 1, 1, 1, }, },
		[17] = { 10, 15, 20, 3000, baseMultiplier = 1.639, manaCost = 10, damageEffectiveness = 1.64, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 63, statInterpolation = { 1, 1, 1, 1, }, },
		[18] = { 10, 15, 20, 3000, baseMultiplier = 1.653, manaCost = 10, damageEffectiveness = 1.65, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 66, statInterpolation = { 1, 1, 1, 1, }, },
		[19] = { 10, 15, 20, 3000, baseMultiplier = 1.666, manaCost = 10, damageEffectiveness = 1.67, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 68, statInterpolation = { 1, 1, 1, 1, }, },
		[20] = { 10, 15, 20, 3000, baseMultiplier = 1.68, manaCost = 10, damageEffectiveness = 1.68, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 70, statInterpolation = { 1, 1, 1, 1, }, },
		[21] = { 10, 15, 20, 3000, baseMultiplier = 1.694, manaCost = 10, damageEffectiveness = 1.69, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 72, statInterpolation = { 1, 1, 1, 1, }, },
		[22] = { 10, 15, 20, 3000, baseMultiplier = 1.707, manaCost = 10, damageEffectiveness = 1.71, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 74, statInterpolation = { 1, 1, 1, 1, }, },
		[23] = { 10, 15, 20, 3000, baseMultiplier = 1.721, manaCost = 10, damageEffectiveness = 1.72, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 76, statInterpolation = { 1, 1, 1, 1, }, },
		[24] = { 10, 15, 20, 3000, baseMultiplier = 1.734, manaCost = 10, damageEffectiveness = 1.73, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 78, statInterpolation = { 1, 1, 1, 1, }, },
		[25] = { 10, 15, 20, 3000, baseMultiplier = 1.748, manaCost = 10, damageEffectiveness = 1.75, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 80, statInterpolation = { 1, 1, 1, 1, }, },
		[26] = { 10, 15, 20, 3000, baseMultiplier = 1.761, manaCost = 10, damageEffectiveness = 1.76, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 82, statInterpolation = { 1, 1, 1, 1, }, },
		[27] = { 10, 15, 20, 3000, baseMultiplier = 1.775, manaCost = 10, damageEffectiveness = 1.78, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 84, statInterpolation = { 1, 1, 1, 1, }, },
		[28] = { 10, 15, 20, 3000, baseMultiplier = 1.789, manaCost = 10, damageEffectiveness = 1.79, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 86, statInterpolation = { 1, 1, 1, 1, }, },
		[29] = { 10, 15, 20, 3000, baseMultiplier = 1.802, manaCost = 10, damageEffectiveness = 1.8, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 88, statInterpolation = { 1, 1, 1, 1, }, },
		[30] = { 10, 15, 20, 3000, baseMultiplier = 1.816, manaCost = 10, damageEffectiveness = 1.82, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 90, statInterpolation = { 1, 1, 1, 1, }, },
		[31] = { 10, 15, 20, 3000, baseMultiplier = 1.823, manaCost = 10, damageEffectiveness = 1.82, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 91, statInterpolation = { 1, 1, 1, 1, }, },
		[32] = { 10, 15, 20, 3000, baseMultiplier = 1.829, manaCost = 10, damageEffectiveness = 1.83, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 92, statInterpolation = { 1, 1, 1, 1, }, },
		[33] = { 10, 15, 20, 3000, baseMultiplier = 1.836, manaCost = 10, damageEffectiveness = 1.84, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 93, statInterpolation = { 1, 1, 1, 1, }, },
		[34] = { 10, 15, 20, 3000, baseMultiplier = 1.843, manaCost = 10, damageEffectiveness = 1.84, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 94, statInterpolation = { 1, 1, 1, 1, }, },
		[35] = { 10, 15, 20, 3000, baseMultiplier = 1.85, manaCost = 10, damageEffectiveness = 1.85, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 95, statInterpolation = { 1, 1, 1, 1, }, },
		[36] = { 10, 15, 20, 3000, baseMultiplier = 1.856, manaCost = 10, damageEffectiveness = 1.86, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 96, statInterpolation = { 1, 1, 1, 1, }, },
		[37] = { 10, 15, 20, 3000, baseMultiplier = 1.863, manaCost = 10, damageEffectiveness = 1.86, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 97, statInterpolation = { 1, 1, 1, 1, }, },
		[38] = { 10, 15, 20, 3000, baseMultiplier = 1.87, manaCost = 10, damageEffectiveness = 1.87, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 98, statInterpolation = { 1, 1, 1, 1, }, },
		[39] = { 10, 15, 20, 3000, baseMultiplier = 1.877, manaCost = 10, damageEffectiveness = 1.88, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 99, statInterpolation = { 1, 1, 1, 1, }, },
		[40] = { 10, 15, 20, 3000, baseMultiplier = 1.884, manaCost = 10, damageEffectiveness = 1.88, cooldown = 2, attackSpeedMultiplier = 20, levelRequirement = 100, statInterpolation = { 1, 1, 1, 1, }, },
	},
}
skills["Frenzy"] = {
	name = "Frenzy",
	color = 2,
	description = "Performs an attack that gives the character a frenzy charge if it hits. Frenzy charges increase your attack speed.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.ProjectileAttack] = true, [SkillType.SkillCanMirageArcher] = true, [SkillType.Projectile] = true, [SkillType.SkillCanVolley] = true, [SkillType.SkillCanTotem] = true, [SkillType.SkillCanTrap] = true, [SkillType.SkillCanMine] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.AttackCanRepeat] = true, [SkillType.Melee] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["frenzy_skill_attack_damage_+%_final_per_frenzy_charge"] = {
			mod("Damage", "MORE", nil, ModFlag.Attack, 0, { type = "Multiplier", var = "FrenzyCharge" }),
		},
		["frenzy_skill_attack_speed_+%_final_per_frenzy_charge"] = {
			mod("Speed", "MORE", nil, ModFlag.Attack, 0, { type = "Multiplier", var = "FrenzyCharge" }),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "attack_speed_+%", 0.5 },
	},
	stats = {
		"frenzy_skill_attack_damage_+%_final_per_frenzy_charge",
		"frenzy_skill_attack_speed_+%_final_per_frenzy_charge",
		"melee_range_+",
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
	},
	levels = {
		[1] = { 5, 5, 0, damageEffectiveness = 1.15, baseMultiplier = 1.15, levelRequirement = 16, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[2] = { 5, 5, 0, damageEffectiveness = 1.16, baseMultiplier = 1.161, levelRequirement = 20, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[3] = { 5, 5, 0, damageEffectiveness = 1.17, baseMultiplier = 1.171, levelRequirement = 24, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[4] = { 5, 5, 0, damageEffectiveness = 1.18, baseMultiplier = 1.182, levelRequirement = 28, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[5] = { 5, 5, 0, damageEffectiveness = 1.19, baseMultiplier = 1.192, levelRequirement = 31, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[6] = { 5, 5, 0, damageEffectiveness = 1.2, baseMultiplier = 1.203, levelRequirement = 34, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[7] = { 5, 5, 1, damageEffectiveness = 1.21, baseMultiplier = 1.213, levelRequirement = 37, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[8] = { 5, 5, 1, damageEffectiveness = 1.22, baseMultiplier = 1.224, levelRequirement = 40, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[9] = { 5, 5, 1, damageEffectiveness = 1.23, baseMultiplier = 1.234, levelRequirement = 43, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[10] = { 5, 5, 1, damageEffectiveness = 1.24, baseMultiplier = 1.245, levelRequirement = 46, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[11] = { 5, 5, 1, damageEffectiveness = 1.26, baseMultiplier = 1.255, levelRequirement = 49, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[12] = { 5, 5, 1, damageEffectiveness = 1.27, baseMultiplier = 1.266, levelRequirement = 52, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[13] = { 5, 5, 1, damageEffectiveness = 1.28, baseMultiplier = 1.276, levelRequirement = 55, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[14] = { 5, 5, 2, damageEffectiveness = 1.29, baseMultiplier = 1.287, levelRequirement = 58, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[15] = { 5, 5, 2, damageEffectiveness = 1.3, baseMultiplier = 1.297, levelRequirement = 60, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[16] = { 5, 5, 2, damageEffectiveness = 1.31, baseMultiplier = 1.308, levelRequirement = 62, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[17] = { 5, 5, 2, damageEffectiveness = 1.32, baseMultiplier = 1.318, levelRequirement = 64, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[18] = { 5, 5, 2, damageEffectiveness = 1.33, baseMultiplier = 1.329, levelRequirement = 66, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[19] = { 5, 5, 2, damageEffectiveness = 1.34, baseMultiplier = 1.339, levelRequirement = 68, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[20] = { 5, 5, 2, damageEffectiveness = 1.35, baseMultiplier = 1.35, levelRequirement = 70, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[21] = { 5, 5, 3, damageEffectiveness = 1.36, baseMultiplier = 1.361, levelRequirement = 72, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[22] = { 5, 5, 3, damageEffectiveness = 1.37, baseMultiplier = 1.371, levelRequirement = 74, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[23] = { 5, 5, 3, damageEffectiveness = 1.38, baseMultiplier = 1.382, levelRequirement = 76, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[24] = { 5, 5, 3, damageEffectiveness = 1.39, baseMultiplier = 1.392, levelRequirement = 78, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[25] = { 5, 5, 3, damageEffectiveness = 1.4, baseMultiplier = 1.403, levelRequirement = 80, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[26] = { 5, 5, 3, damageEffectiveness = 1.41, baseMultiplier = 1.413, levelRequirement = 82, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[27] = { 5, 5, 3, damageEffectiveness = 1.42, baseMultiplier = 1.424, levelRequirement = 84, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[28] = { 5, 5, 4, damageEffectiveness = 1.43, baseMultiplier = 1.434, levelRequirement = 86, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[29] = { 5, 5, 4, damageEffectiveness = 1.44, baseMultiplier = 1.445, levelRequirement = 88, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[30] = { 5, 5, 4, damageEffectiveness = 1.46, baseMultiplier = 1.455, levelRequirement = 90, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[31] = { 5, 5, 4, damageEffectiveness = 1.46, baseMultiplier = 1.461, levelRequirement = 91, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[32] = { 5, 5, 4, damageEffectiveness = 1.47, baseMultiplier = 1.466, levelRequirement = 92, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[33] = { 5, 5, 4, damageEffectiveness = 1.47, baseMultiplier = 1.471, levelRequirement = 93, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[34] = { 5, 5, 4, damageEffectiveness = 1.48, baseMultiplier = 1.476, levelRequirement = 94, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[35] = { 5, 5, 5, damageEffectiveness = 1.48, baseMultiplier = 1.482, levelRequirement = 95, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[36] = { 5, 5, 5, damageEffectiveness = 1.49, baseMultiplier = 1.487, levelRequirement = 96, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[37] = { 5, 5, 5, damageEffectiveness = 1.49, baseMultiplier = 1.492, levelRequirement = 97, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[38] = { 5, 5, 5, damageEffectiveness = 1.5, baseMultiplier = 1.497, levelRequirement = 98, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[39] = { 5, 5, 5, damageEffectiveness = 1.5, baseMultiplier = 1.503, levelRequirement = 99, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[40] = { 5, 5, 5, damageEffectiveness = 1.51, baseMultiplier = 1.508, levelRequirement = 100, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
	},
}
skills["FrostBlades"] = {
	name = "Frost Blades",
	color = 2,
	baseEffectiveness = 0.6700000166893,
	incrementalEffectiveness = 0.023299999535084,
	description = "Attack enemies with increased range, releasing icy blades from the first enemy hit which fly at other enemies. Requires a Melee Weapon.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.AttackCanRepeat] = true, [SkillType.Melee] = true, [SkillType.ColdSkill] = true, [SkillType.ProjectileAttack] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Melee hit",
			melee = true,
			projectile = false,
		},
		{
			name = "Icy blades",
			melee = false,
			projectile = true,
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "damage_+%", 1 },
		{ "base_projectile_speed_+%", 1 },
	},
	stats = {
		"number_of_additional_projectiles",
		"melee_weapon_range_+",
		"skill_physical_damage_%_to_convert_to_cold",
		"total_projectile_spread_angle_override",
		"base_projectile_speed_+%",
		"attack_minimum_added_cold_damage",
		"attack_maximum_added_cold_damage",
		"show_number_of_projectiles",
	},
	levels = {
		[1] = { 4, 18, 60, 110, 0, 0.80000001192093, 1.2000000476837, manaCost = 6, levelRequirement = 1, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[2] = { 4, 18, 60, 110, 1, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.02, baseMultiplier = 1.021, levelRequirement = 2, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[3] = { 4, 18, 60, 110, 2, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.04, baseMultiplier = 1.042, levelRequirement = 4, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[4] = { 4, 18, 60, 110, 3, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.06, baseMultiplier = 1.063, levelRequirement = 7, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[5] = { 4, 18, 60, 110, 4, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.08, baseMultiplier = 1.084, levelRequirement = 11, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[6] = { 5, 19, 60, 110, 5, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.11, baseMultiplier = 1.105, levelRequirement = 16, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[7] = { 5, 19, 60, 110, 6, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.13, baseMultiplier = 1.126, levelRequirement = 20, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[8] = { 5, 19, 60, 110, 7, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.15, baseMultiplier = 1.147, levelRequirement = 24, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[9] = { 5, 19, 60, 110, 8, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.17, baseMultiplier = 1.168, levelRequirement = 28, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[10] = { 5, 19, 60, 110, 9, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.19, baseMultiplier = 1.189, levelRequirement = 32, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[11] = { 6, 20, 60, 110, 10, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.21, baseMultiplier = 1.211, levelRequirement = 36, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[12] = { 6, 20, 60, 110, 11, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.23, baseMultiplier = 1.232, levelRequirement = 40, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[13] = { 6, 20, 60, 110, 12, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.25, baseMultiplier = 1.253, levelRequirement = 44, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[14] = { 6, 20, 60, 110, 13, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.27, baseMultiplier = 1.274, levelRequirement = 48, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[15] = { 6, 20, 60, 110, 14, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.29, baseMultiplier = 1.295, levelRequirement = 52, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[16] = { 7, 21, 60, 110, 15, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.32, baseMultiplier = 1.316, levelRequirement = 56, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[17] = { 7, 21, 60, 110, 16, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.34, baseMultiplier = 1.337, levelRequirement = 60, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[18] = { 7, 21, 60, 110, 17, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.36, baseMultiplier = 1.358, levelRequirement = 64, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[19] = { 7, 21, 60, 110, 18, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.38, baseMultiplier = 1.379, levelRequirement = 67, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[20] = { 7, 21, 60, 110, 19, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.4, baseMultiplier = 1.4, levelRequirement = 70, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[21] = { 8, 22, 60, 110, 20, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.42, baseMultiplier = 1.421, levelRequirement = 72, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[22] = { 8, 22, 60, 110, 21, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.44, baseMultiplier = 1.442, levelRequirement = 74, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[23] = { 8, 22, 60, 110, 22, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.46, baseMultiplier = 1.463, levelRequirement = 76, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[24] = { 8, 22, 60, 110, 23, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.48, baseMultiplier = 1.484, levelRequirement = 78, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[25] = { 8, 22, 60, 110, 24, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.51, baseMultiplier = 1.505, levelRequirement = 80, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[26] = { 9, 23, 60, 110, 25, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.53, baseMultiplier = 1.526, levelRequirement = 82, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[27] = { 9, 23, 60, 110, 26, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.55, baseMultiplier = 1.547, levelRequirement = 84, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[28] = { 9, 23, 60, 110, 27, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.57, baseMultiplier = 1.568, levelRequirement = 86, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[29] = { 9, 23, 60, 110, 28, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.59, baseMultiplier = 1.589, levelRequirement = 88, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[30] = { 9, 23, 60, 110, 29, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.61, baseMultiplier = 1.611, levelRequirement = 90, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[31] = { 9, 23, 60, 110, 29, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.62, baseMultiplier = 1.621, levelRequirement = 91, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[32] = { 10, 24, 60, 110, 30, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.63, baseMultiplier = 1.632, levelRequirement = 92, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[33] = { 10, 24, 60, 110, 30, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.64, baseMultiplier = 1.642, levelRequirement = 93, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[34] = { 10, 24, 60, 110, 31, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.65, baseMultiplier = 1.653, levelRequirement = 94, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[35] = { 10, 24, 60, 110, 31, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.66, baseMultiplier = 1.663, levelRequirement = 95, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[36] = { 10, 24, 60, 110, 32, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.67, baseMultiplier = 1.674, levelRequirement = 96, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[37] = { 10, 24, 60, 110, 32, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.68, baseMultiplier = 1.684, levelRequirement = 97, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[38] = { 10, 24, 60, 110, 33, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.69, baseMultiplier = 1.695, levelRequirement = 98, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[39] = { 10, 24, 60, 110, 33, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.71, baseMultiplier = 1.705, levelRequirement = 99, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[40] = { 10, 24, 60, 110, 34, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.72, baseMultiplier = 1.716, levelRequirement = 100, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
	},
}
skills["Grace"] = {
	name = "Grace",
	color = 2,
	description = "Casts an aura that grants evasion to you and your allies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Buff] = true, [SkillType.ManaCostReserved] = true, [SkillType.Type27] = true, [SkillType.ManaCostPercent] = true, [SkillType.SkillCanTotem] = true, [SkillType.Aura] = true, [SkillType.Instant] = true, [SkillType.AreaSpell] = true, [SkillType.CanHaveBlessing] = true, },
	statDescriptionScope = "aura_skill_stat_descriptions",
	castTime = 0,
	statMap = {
		["base_evasion_rating"] = {
			mod("Evasion", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
	},
	baseMods = {
		skill("radius", 40),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 2 },
	},
	stats = {
		"base_evasion_rating",
		"active_skill_base_radius_+",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 227, 0, cooldown = 1.2, levelRequirement = 24, manaCost = 50, statInterpolation = { 1, 1, }, },
		[2] = { 271, 1, cooldown = 1.2, levelRequirement = 27, manaCost = 50, statInterpolation = { 1, 1, }, },
		[3] = { 322, 2, cooldown = 1.2, levelRequirement = 30, manaCost = 50, statInterpolation = { 1, 1, }, },
		[4] = { 379, 3, cooldown = 1.2, levelRequirement = 33, manaCost = 50, statInterpolation = { 1, 1, }, },
		[5] = { 444, 4, cooldown = 1.2, levelRequirement = 36, manaCost = 50, statInterpolation = { 1, 1, }, },
		[6] = { 528, 5, cooldown = 1.2, levelRequirement = 39, manaCost = 50, statInterpolation = { 1, 1, }, },
		[7] = { 621, 6, cooldown = 1.2, levelRequirement = 42, manaCost = 50, statInterpolation = { 1, 1, }, },
		[8] = { 722, 7, cooldown = 1.2, levelRequirement = 45, manaCost = 50, statInterpolation = { 1, 1, }, },
		[9] = { 845, 8, cooldown = 1.2, levelRequirement = 48, manaCost = 50, statInterpolation = { 1, 1, }, },
		[10] = { 940, 9, cooldown = 1.2, levelRequirement = 50, manaCost = 50, statInterpolation = { 1, 1, }, },
		[11] = { 1043, 10, cooldown = 1.2, levelRequirement = 52, manaCost = 50, statInterpolation = { 1, 1, }, },
		[12] = { 1155, 11, cooldown = 1.2, levelRequirement = 54, manaCost = 50, statInterpolation = { 1, 1, }, },
		[13] = { 1283, 12, cooldown = 1.2, levelRequirement = 56, manaCost = 50, statInterpolation = { 1, 1, }, },
		[14] = { 1413, 13, cooldown = 1.2, levelRequirement = 58, manaCost = 50, statInterpolation = { 1, 1, }, },
		[15] = { 1567, 14, cooldown = 1.2, levelRequirement = 60, manaCost = 50, statInterpolation = { 1, 1, }, },
		[16] = { 1732, 15, cooldown = 1.2, levelRequirement = 62, manaCost = 50, statInterpolation = { 1, 1, }, },
		[17] = { 1914, 16, cooldown = 1.2, levelRequirement = 64, manaCost = 50, statInterpolation = { 1, 1, }, },
		[18] = { 2115, 17, cooldown = 1.2, levelRequirement = 66, manaCost = 50, statInterpolation = { 1, 1, }, },
		[19] = { 2335, 18, cooldown = 1.2, levelRequirement = 68, manaCost = 50, statInterpolation = { 1, 1, }, },
		[20] = { 2575, 19, cooldown = 1.2, levelRequirement = 70, manaCost = 50, statInterpolation = { 1, 1, }, },
		[21] = { 2700, 20, cooldown = 1.2, levelRequirement = 72, manaCost = 50, statInterpolation = { 1, 1, }, },
		[22] = { 2835, 21, cooldown = 1.2, levelRequirement = 74, manaCost = 50, statInterpolation = { 1, 1, }, },
		[23] = { 2979, 22, cooldown = 1.2, levelRequirement = 76, manaCost = 50, statInterpolation = { 1, 1, }, },
		[24] = { 3124, 23, cooldown = 1.2, levelRequirement = 78, manaCost = 50, statInterpolation = { 1, 1, }, },
		[25] = { 3279, 24, cooldown = 1.2, levelRequirement = 80, manaCost = 50, statInterpolation = { 1, 1, }, },
		[26] = { 3444, 25, cooldown = 1.2, levelRequirement = 82, manaCost = 50, statInterpolation = { 1, 1, }, },
		[27] = { 3611, 26, cooldown = 1.2, levelRequirement = 84, manaCost = 50, statInterpolation = { 1, 1, }, },
		[28] = { 3795, 27, cooldown = 1.2, levelRequirement = 86, manaCost = 50, statInterpolation = { 1, 1, }, },
		[29] = { 3982, 28, cooldown = 1.2, levelRequirement = 88, manaCost = 50, statInterpolation = { 1, 1, }, },
		[30] = { 4179, 29, cooldown = 1.2, levelRequirement = 90, manaCost = 50, statInterpolation = { 1, 1, }, },
		[31] = { 4282, 29, cooldown = 1.2, levelRequirement = 91, manaCost = 50, statInterpolation = { 1, 1, }, },
		[32] = { 4386, 30, cooldown = 1.2, levelRequirement = 92, manaCost = 50, statInterpolation = { 1, 1, }, },
		[33] = { 4494, 30, cooldown = 1.2, levelRequirement = 93, manaCost = 50, statInterpolation = { 1, 1, }, },
		[34] = { 4603, 31, cooldown = 1.2, levelRequirement = 94, manaCost = 50, statInterpolation = { 1, 1, }, },
		[35] = { 4716, 31, cooldown = 1.2, levelRequirement = 95, manaCost = 50, statInterpolation = { 1, 1, }, },
		[36] = { 4830, 32, cooldown = 1.2, levelRequirement = 96, manaCost = 50, statInterpolation = { 1, 1, }, },
		[37] = { 4948, 32, cooldown = 1.2, levelRequirement = 97, manaCost = 50, statInterpolation = { 1, 1, }, },
		[38] = { 5067, 33, cooldown = 1.2, levelRequirement = 98, manaCost = 50, statInterpolation = { 1, 1, }, },
		[39] = { 5190, 33, cooldown = 1.2, levelRequirement = 99, manaCost = 50, statInterpolation = { 1, 1, }, },
		[40] = { 5314, 34, cooldown = 1.2, levelRequirement = 100, manaCost = 50, statInterpolation = { 1, 1, }, },
	},
}
skills["VaalGrace"] = {
	name = "Vaal Grace",
	color = 2,
	description = "Casts a temporary aura that grants you and your allies the ability to dodge attacks and spells.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Area] = true, [SkillType.SkillCanTotem] = true, [SkillType.Type27] = true, [SkillType.Duration] = true, [SkillType.Vaal] = true, [SkillType.Aura] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "aura_skill_stat_descriptions",
	castTime = 0,
	statMap = {
		["base_chance_to_dodge_%"] = {
			mod("AttackDodgeChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["base_chance_to_dodge_spells_%"] = {
			mod("SpellDodgeChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
		duration = true,
		vaal = true,
	},
	baseMods = {
		skill("radius", 40),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 2 },
	},
	stats = {
		"base_chance_to_dodge_%",
		"base_chance_to_dodge_spells_%",
		"active_skill_base_radius_+",
		"base_skill_effect_duration",
		"base_deal_no_damage",
		"modifiers_to_buff_effect_duration_also_affect_soul_prevention_duration",
	},
	levels = {
		[1] = { 24, 24, 0, 6000, cooldown = 0.5, levelRequirement = 24, statInterpolation = { 1, 1, 1, 1, }, },
		[2] = { 25, 25, 1, 6000, cooldown = 0.5, levelRequirement = 27, statInterpolation = { 1, 1, 1, 1, }, },
		[3] = { 25, 25, 2, 6000, cooldown = 0.5, levelRequirement = 30, statInterpolation = { 1, 1, 1, 1, }, },
		[4] = { 26, 26, 3, 6000, cooldown = 0.5, levelRequirement = 33, statInterpolation = { 1, 1, 1, 1, }, },
		[5] = { 26, 26, 4, 6000, cooldown = 0.5, levelRequirement = 36, statInterpolation = { 1, 1, 1, 1, }, },
		[6] = { 27, 27, 5, 6000, cooldown = 0.5, levelRequirement = 39, statInterpolation = { 1, 1, 1, 1, }, },
		[7] = { 27, 27, 6, 6000, cooldown = 0.5, levelRequirement = 42, statInterpolation = { 1, 1, 1, 1, }, },
		[8] = { 28, 28, 7, 6000, cooldown = 0.5, levelRequirement = 45, statInterpolation = { 1, 1, 1, 1, }, },
		[9] = { 28, 28, 8, 6000, cooldown = 0.5, levelRequirement = 48, statInterpolation = { 1, 1, 1, 1, }, },
		[10] = { 29, 29, 9, 6000, cooldown = 0.5, levelRequirement = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[11] = { 29, 29, 10, 6000, cooldown = 0.5, levelRequirement = 52, statInterpolation = { 1, 1, 1, 1, }, },
		[12] = { 30, 30, 11, 6000, cooldown = 0.5, levelRequirement = 54, statInterpolation = { 1, 1, 1, 1, }, },
		[13] = { 30, 30, 12, 6000, cooldown = 0.5, levelRequirement = 56, statInterpolation = { 1, 1, 1, 1, }, },
		[14] = { 31, 31, 13, 6000, cooldown = 0.5, levelRequirement = 58, statInterpolation = { 1, 1, 1, 1, }, },
		[15] = { 31, 31, 14, 6000, cooldown = 0.5, levelRequirement = 60, statInterpolation = { 1, 1, 1, 1, }, },
		[16] = { 32, 32, 15, 6000, cooldown = 0.5, levelRequirement = 62, statInterpolation = { 1, 1, 1, 1, }, },
		[17] = { 32, 32, 16, 6000, cooldown = 0.5, levelRequirement = 64, statInterpolation = { 1, 1, 1, 1, }, },
		[18] = { 33, 33, 17, 6000, cooldown = 0.5, levelRequirement = 66, statInterpolation = { 1, 1, 1, 1, }, },
		[19] = { 33, 33, 18, 6000, cooldown = 0.5, levelRequirement = 68, statInterpolation = { 1, 1, 1, 1, }, },
		[20] = { 34, 34, 19, 6000, cooldown = 0.5, levelRequirement = 70, statInterpolation = { 1, 1, 1, 1, }, },
		[21] = { 34, 34, 20, 6000, cooldown = 0.5, levelRequirement = 72, statInterpolation = { 1, 1, 1, 1, }, },
		[22] = { 35, 35, 21, 6000, cooldown = 0.5, levelRequirement = 74, statInterpolation = { 1, 1, 1, 1, }, },
		[23] = { 35, 35, 22, 6000, cooldown = 0.5, levelRequirement = 76, statInterpolation = { 1, 1, 1, 1, }, },
		[24] = { 36, 36, 23, 6000, cooldown = 0.5, levelRequirement = 78, statInterpolation = { 1, 1, 1, 1, }, },
		[25] = { 36, 36, 24, 6000, cooldown = 0.5, levelRequirement = 80, statInterpolation = { 1, 1, 1, 1, }, },
		[26] = { 37, 37, 25, 6000, cooldown = 0.5, levelRequirement = 82, statInterpolation = { 1, 1, 1, 1, }, },
		[27] = { 37, 37, 26, 6000, cooldown = 0.5, levelRequirement = 84, statInterpolation = { 1, 1, 1, 1, }, },
		[28] = { 38, 38, 27, 6000, cooldown = 0.5, levelRequirement = 86, statInterpolation = { 1, 1, 1, 1, }, },
		[29] = { 38, 38, 28, 6000, cooldown = 0.5, levelRequirement = 88, statInterpolation = { 1, 1, 1, 1, }, },
		[30] = { 39, 39, 29, 6000, cooldown = 0.5, levelRequirement = 90, statInterpolation = { 1, 1, 1, 1, }, },
		[31] = { 39, 39, 29, 6000, cooldown = 0.5, levelRequirement = 91, statInterpolation = { 1, 1, 1, 1, }, },
		[32] = { 39, 39, 30, 6000, cooldown = 0.5, levelRequirement = 92, statInterpolation = { 1, 1, 1, 1, }, },
		[33] = { 39, 39, 30, 6000, cooldown = 0.5, levelRequirement = 93, statInterpolation = { 1, 1, 1, 1, }, },
		[34] = { 40, 40, 31, 6000, cooldown = 0.5, levelRequirement = 94, statInterpolation = { 1, 1, 1, 1, }, },
		[35] = { 40, 40, 31, 6000, cooldown = 0.5, levelRequirement = 95, statInterpolation = { 1, 1, 1, 1, }, },
		[36] = { 40, 40, 32, 6000, cooldown = 0.5, levelRequirement = 96, statInterpolation = { 1, 1, 1, 1, }, },
		[37] = { 40, 40, 32, 6000, cooldown = 0.5, levelRequirement = 97, statInterpolation = { 1, 1, 1, 1, }, },
		[38] = { 41, 41, 33, 6000, cooldown = 0.5, levelRequirement = 98, statInterpolation = { 1, 1, 1, 1, }, },
		[39] = { 41, 41, 33, 6000, cooldown = 0.5, levelRequirement = 99, statInterpolation = { 1, 1, 1, 1, }, },
		[40] = { 41, 41, 34, 6000, cooldown = 0.5, levelRequirement = 100, statInterpolation = { 1, 1, 1, 1, }, },
	},
}
skills["Haste"] = {
	name = "Haste",
	color = 2,
	description = "Casts an aura that increases the movement speed, attack speed and cast speed of you and your allies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Buff] = true, [SkillType.ManaCostReserved] = true, [SkillType.Type27] = true, [SkillType.ManaCostPercent] = true, [SkillType.SkillCanTotem] = true, [SkillType.Aura] = true, [SkillType.Instant] = true, [SkillType.AreaSpell] = true, [SkillType.CanHaveBlessing] = true, },
	statDescriptionScope = "aura_skill_stat_descriptions",
	castTime = 0,
	statMap = {
		["cast_speed_+%_granted_from_skill"] = {
			mod("Speed", "INC", nil, ModFlag.Cast, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["attack_speed_+%_granted_from_skill"] = {
			mod("Speed", "INC", nil, ModFlag.Attack, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["base_movement_velocity_+%"] = {
			mod("MovementSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
	},
	baseMods = {
		skill("radius", 40),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 2 },
	},
	stats = {
		"attack_speed_+%_granted_from_skill",
		"cast_speed_+%_granted_from_skill",
		"base_movement_velocity_+%",
		"active_skill_base_radius_+",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 9, 9, 4, 0, cooldown = 1.2, levelRequirement = 24, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[2] = { 10, 9, 4, 1, cooldown = 1.2, levelRequirement = 27, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[3] = { 10, 10, 4, 2, cooldown = 1.2, levelRequirement = 30, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[4] = { 10, 10, 5, 3, cooldown = 1.2, levelRequirement = 33, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[5] = { 11, 10, 5, 4, cooldown = 1.2, levelRequirement = 36, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[6] = { 11, 11, 5, 5, cooldown = 1.2, levelRequirement = 39, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[7] = { 11, 11, 6, 6, cooldown = 1.2, levelRequirement = 42, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[8] = { 12, 11, 6, 7, cooldown = 1.2, levelRequirement = 45, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[9] = { 12, 12, 6, 8, cooldown = 1.2, levelRequirement = 48, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[10] = { 12, 12, 7, 9, cooldown = 1.2, levelRequirement = 50, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[11] = { 13, 12, 7, 10, cooldown = 1.2, levelRequirement = 52, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[12] = { 13, 13, 7, 11, cooldown = 1.2, levelRequirement = 54, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[13] = { 13, 13, 8, 12, cooldown = 1.2, levelRequirement = 56, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[14] = { 14, 13, 8, 13, cooldown = 1.2, levelRequirement = 58, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[15] = { 14, 14, 8, 14, cooldown = 1.2, levelRequirement = 60, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[16] = { 15, 14, 8, 15, cooldown = 1.2, levelRequirement = 62, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[17] = { 15, 15, 8, 16, cooldown = 1.2, levelRequirement = 64, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[18] = { 16, 15, 8, 17, cooldown = 1.2, levelRequirement = 66, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[19] = { 16, 16, 8, 18, cooldown = 1.2, levelRequirement = 68, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[20] = { 16, 16, 9, 19, cooldown = 1.2, levelRequirement = 70, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[21] = { 17, 16, 9, 20, cooldown = 1.2, levelRequirement = 72, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[22] = { 17, 17, 9, 21, cooldown = 1.2, levelRequirement = 74, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[23] = { 17, 17, 10, 22, cooldown = 1.2, levelRequirement = 76, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[24] = { 18, 17, 10, 23, cooldown = 1.2, levelRequirement = 78, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[25] = { 18, 18, 10, 24, cooldown = 1.2, levelRequirement = 80, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[26] = { 18, 18, 11, 25, cooldown = 1.2, levelRequirement = 82, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[27] = { 19, 18, 11, 26, cooldown = 1.2, levelRequirement = 84, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[28] = { 19, 19, 11, 27, cooldown = 1.2, levelRequirement = 86, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[29] = { 19, 19, 12, 28, cooldown = 1.2, levelRequirement = 88, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[30] = { 20, 19, 12, 29, cooldown = 1.2, levelRequirement = 90, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[31] = { 20, 19, 12, 29, cooldown = 1.2, levelRequirement = 91, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[32] = { 20, 20, 12, 30, cooldown = 1.2, levelRequirement = 92, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[33] = { 20, 20, 12, 30, cooldown = 1.2, levelRequirement = 93, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[34] = { 20, 20, 13, 31, cooldown = 1.2, levelRequirement = 94, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[35] = { 20, 20, 13, 31, cooldown = 1.2, levelRequirement = 95, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[36] = { 21, 20, 13, 32, cooldown = 1.2, levelRequirement = 96, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[37] = { 21, 20, 13, 32, cooldown = 1.2, levelRequirement = 97, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[38] = { 21, 21, 13, 33, cooldown = 1.2, levelRequirement = 98, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[39] = { 21, 21, 13, 33, cooldown = 1.2, levelRequirement = 99, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[40] = { 21, 21, 14, 34, cooldown = 1.2, levelRequirement = 100, manaCost = 50, statInterpolation = { 1, 1, 1, 1, }, },
	},
}
skills["VaalHaste"] = {
	name = "Vaal Haste",
	color = 2,
	description = "Casts a temporary aura that increases the movement speed, attack speed and cast speed of you and your allies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Area] = true, [SkillType.SkillCanTotem] = true, [SkillType.Type27] = true, [SkillType.Duration] = true, [SkillType.Vaal] = true, [SkillType.Aura] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "aura_skill_stat_descriptions",
	castTime = 0,
	statMap = {
		["cast_speed_+%_granted_from_skill"] = {
			mod("Speed", "INC", nil, ModFlag.Cast, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["attack_speed_+%_granted_from_skill"] = {
			mod("Speed", "INC", nil, ModFlag.Attack, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["base_movement_velocity_+%"] = {
			mod("MovementSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
		duration = true,
		vaal = true,
	},
	baseMods = {
		skill("radius", 40),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 2 },
	},
	stats = {
		"attack_speed_+%_granted_from_skill",
		"cast_speed_+%_granted_from_skill",
		"base_movement_velocity_+%",
		"active_skill_base_radius_+",
		"base_skill_effect_duration",
		"base_deal_no_damage",
		"modifiers_to_buff_effect_duration_also_affect_soul_prevention_duration",
	},
	levels = {
		[1] = { 25, 24, 10, 0, 4000, cooldown = 0.5, levelRequirement = 24, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[2] = { 25, 25, 10, 1, 4000, cooldown = 0.5, levelRequirement = 27, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[3] = { 25, 25, 10, 2, 4000, cooldown = 0.5, levelRequirement = 30, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[4] = { 26, 25, 10, 3, 4000, cooldown = 0.5, levelRequirement = 33, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[5] = { 26, 26, 10, 4, 4000, cooldown = 0.5, levelRequirement = 36, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[6] = { 26, 26, 11, 5, 4000, cooldown = 0.5, levelRequirement = 39, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[7] = { 27, 26, 11, 6, 4000, cooldown = 0.5, levelRequirement = 42, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[8] = { 27, 27, 11, 7, 4000, cooldown = 0.5, levelRequirement = 45, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[9] = { 27, 27, 11, 8, 4000, cooldown = 0.5, levelRequirement = 48, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[10] = { 28, 27, 11, 9, 4000, cooldown = 0.5, levelRequirement = 50, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[11] = { 28, 28, 12, 10, 4000, cooldown = 0.5, levelRequirement = 52, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[12] = { 28, 28, 12, 11, 4000, cooldown = 0.5, levelRequirement = 54, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[13] = { 29, 28, 12, 12, 4000, cooldown = 0.5, levelRequirement = 56, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[14] = { 29, 29, 12, 13, 4000, cooldown = 0.5, levelRequirement = 58, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[15] = { 29, 29, 12, 14, 4000, cooldown = 0.5, levelRequirement = 60, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[16] = { 30, 29, 13, 15, 4000, cooldown = 0.5, levelRequirement = 62, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[17] = { 30, 30, 13, 16, 4000, cooldown = 0.5, levelRequirement = 64, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[18] = { 30, 30, 13, 17, 4000, cooldown = 0.5, levelRequirement = 66, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[19] = { 31, 30, 13, 18, 4000, cooldown = 0.5, levelRequirement = 68, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[20] = { 31, 31, 13, 19, 4000, cooldown = 0.5, levelRequirement = 70, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[21] = { 31, 31, 14, 20, 4000, cooldown = 0.5, levelRequirement = 72, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[22] = { 32, 31, 14, 21, 4000, cooldown = 0.5, levelRequirement = 74, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[23] = { 32, 32, 14, 22, 4000, cooldown = 0.5, levelRequirement = 76, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[24] = { 32, 32, 14, 23, 4000, cooldown = 0.5, levelRequirement = 78, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[25] = { 33, 32, 14, 24, 4000, cooldown = 0.5, levelRequirement = 80, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[26] = { 33, 33, 15, 25, 4000, cooldown = 0.5, levelRequirement = 82, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[27] = { 33, 33, 15, 26, 4000, cooldown = 0.5, levelRequirement = 84, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[28] = { 34, 33, 15, 27, 4000, cooldown = 0.5, levelRequirement = 86, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[29] = { 34, 34, 15, 28, 4000, cooldown = 0.5, levelRequirement = 88, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[30] = { 34, 34, 15, 29, 4000, cooldown = 0.5, levelRequirement = 90, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[31] = { 34, 34, 15, 29, 4000, cooldown = 0.5, levelRequirement = 91, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[32] = { 35, 34, 16, 30, 4000, cooldown = 0.5, levelRequirement = 92, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[33] = { 35, 34, 16, 30, 4000, cooldown = 0.5, levelRequirement = 93, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[34] = { 35, 35, 16, 31, 4000, cooldown = 0.5, levelRequirement = 94, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[35] = { 35, 35, 16, 31, 4000, cooldown = 0.5, levelRequirement = 95, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[36] = { 35, 35, 16, 32, 4000, cooldown = 0.5, levelRequirement = 96, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[37] = { 35, 35, 16, 32, 4000, cooldown = 0.5, levelRequirement = 97, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[38] = { 36, 35, 16, 33, 4000, cooldown = 0.5, levelRequirement = 98, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[39] = { 36, 35, 16, 33, 4000, cooldown = 0.5, levelRequirement = 99, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[40] = { 36, 36, 16, 34, 4000, cooldown = 0.5, levelRequirement = 100, statInterpolation = { 1, 1, 1, 1, 1, }, },
	},
}
skills["Hatred"] = {
	name = "Hatred",
	color = 2,
	baseEffectiveness = 1.5,
	incrementalEffectiveness = 0.025000000372529,
	description = "Casts an aura that grants extra cold damage based on physical damage to you and your allies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Buff] = true, [SkillType.ManaCostReserved] = true, [SkillType.Type27] = true, [SkillType.ManaCostPercent] = true, [SkillType.SkillCanTotem] = true, [SkillType.Aura] = true, [SkillType.ColdSkill] = true, [SkillType.Instant] = true, [SkillType.AreaSpell] = true, [SkillType.CanHaveBlessing] = true, },
	statDescriptionScope = "aura_skill_stat_descriptions",
	castTime = 0,
	statMap = {
		["physical_damage_%_to_add_as_cold"] = {
			mod("PhysicalDamageGainAsCold", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["hatred_aura_cold_damage_+%_final"] = {
			mod("ColdDamage", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
	},
	baseMods = {
		skill("radius", 40),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 2 },
	},
	stats = {
		"physical_damage_%_to_add_as_cold",
		"active_skill_base_radius_+",
		"hatred_aura_cold_damage_+%_final",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 16, 0, 14, cooldown = 1.2, levelRequirement = 24, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[2] = { 16, 1, 14, cooldown = 1.2, levelRequirement = 27, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[3] = { 17, 2, 14, cooldown = 1.2, levelRequirement = 30, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[4] = { 17, 3, 14, cooldown = 1.2, levelRequirement = 33, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[5] = { 18, 4, 15, cooldown = 1.2, levelRequirement = 36, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[6] = { 18, 5, 15, cooldown = 1.2, levelRequirement = 39, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[7] = { 19, 6, 15, cooldown = 1.2, levelRequirement = 42, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[8] = { 19, 7, 15, cooldown = 1.2, levelRequirement = 45, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[9] = { 20, 8, 16, cooldown = 1.2, levelRequirement = 48, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[10] = { 20, 9, 16, cooldown = 1.2, levelRequirement = 50, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[11] = { 21, 10, 16, cooldown = 1.2, levelRequirement = 52, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[12] = { 21, 11, 16, cooldown = 1.2, levelRequirement = 54, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[13] = { 22, 12, 17, cooldown = 1.2, levelRequirement = 56, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[14] = { 22, 13, 17, cooldown = 1.2, levelRequirement = 58, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[15] = { 23, 14, 17, cooldown = 1.2, levelRequirement = 60, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[16] = { 23, 15, 17, cooldown = 1.2, levelRequirement = 62, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[17] = { 24, 16, 18, cooldown = 1.2, levelRequirement = 64, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[18] = { 24, 17, 18, cooldown = 1.2, levelRequirement = 66, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[19] = { 25, 18, 18, cooldown = 1.2, levelRequirement = 68, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[20] = { 25, 19, 18, cooldown = 1.2, levelRequirement = 70, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[21] = { 26, 20, 19, cooldown = 1.2, levelRequirement = 72, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[22] = { 26, 21, 19, cooldown = 1.2, levelRequirement = 74, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[23] = { 27, 22, 19, cooldown = 1.2, levelRequirement = 76, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[24] = { 27, 23, 19, cooldown = 1.2, levelRequirement = 78, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[25] = { 28, 24, 20, cooldown = 1.2, levelRequirement = 80, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[26] = { 28, 25, 20, cooldown = 1.2, levelRequirement = 82, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[27] = { 29, 26, 20, cooldown = 1.2, levelRequirement = 84, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[28] = { 29, 27, 20, cooldown = 1.2, levelRequirement = 86, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[29] = { 30, 28, 21, cooldown = 1.2, levelRequirement = 88, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[30] = { 30, 29, 21, cooldown = 1.2, levelRequirement = 90, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[31] = { 30, 29, 21, cooldown = 1.2, levelRequirement = 91, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[32] = { 31, 30, 21, cooldown = 1.2, levelRequirement = 92, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[33] = { 31, 30, 21, cooldown = 1.2, levelRequirement = 93, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[34] = { 31, 31, 21, cooldown = 1.2, levelRequirement = 94, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[35] = { 31, 31, 21, cooldown = 1.2, levelRequirement = 95, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[36] = { 32, 32, 22, cooldown = 1.2, levelRequirement = 96, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[37] = { 32, 32, 22, cooldown = 1.2, levelRequirement = 97, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[38] = { 32, 33, 22, cooldown = 1.2, levelRequirement = 98, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[39] = { 32, 33, 22, cooldown = 1.2, levelRequirement = 99, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[40] = { 33, 34, 22, cooldown = 1.2, levelRequirement = 100, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
	},
}
skills["HeraldOfAgony"] = {
	name = "Herald of Agony",
	color = 2,
	baseEffectiveness = 0.10999999940395,
	incrementalEffectiveness = 0.044700000435114,
	description = "Grants a buff giving more poison damage and a chance to inflict poison. When you poison an enemy while you have this buff, you gain Virulence, and summon an Agony Crawler minion that uses projectile and area attacks. You will lose Virulence over time, at a rate which increases the more Virulence you have. The minion will die when you have no Virulence.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.ManaCostReserved] = true, [SkillType.ManaCostPercent] = true, [SkillType.Herald] = true, [SkillType.Minion] = true, [SkillType.Instant] = true, [SkillType.ChaosSkill] = true, [SkillType.PhysicalSkill] = true, [SkillType.CreatesMinion] = true, },
	minionSkillTypes = { [SkillType.Hit] = true, [SkillType.Attack] = true, [SkillType.ChaosSkill] = true, [SkillType.Projectile] = true, [SkillType.ProjectileAttack] = true, },
	statDescriptionScope = "minion_skill_stat_descriptions",
	castTime = 0,
	minionList = {
		"HeraldOfAgonySpiderPlated",
	},
	statMap = {
		["skill_buff_grants_chance_to_poison_%"] = {
			mod("PoisonChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["herald_of_agony_poison_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, KeywordFlag.Poison, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["scorpion_minion_physical_damage_+%"] = {
			mod("MinionModifier", "LIST", { type = "HeraldOfAgonySpiderPlated", mod = mod("PhysicalDamage", "INC", nil, 0, 0, { type = "Multiplier", actor = "parent", var = "VirulenceStack" })})
		},
		["scorpion_minion_attack_speed_+%"] = {
			mod("MinionModifier", "LIST", { type = "HeraldOfAgonySpiderPlated", mod = mod("Speed", "INC", nil, 0, 0, { type = "Multiplier", actor = "parent", var = "VirulenceStack" })})
		},
		["scorpion_minion_minimum_added_physical_damage"] = {
			mod("MinionModifier", "LIST", { type = "HeraldOfAgonySpiderPlated", mod = mod("PhysicalMin", "BASE", nil, 0, 0, { type = "Multiplier", actor = "parent", var = "VirulenceStack" })})
		},
		["scorpion_minion_maximum_added_physical_damage"] = {
			mod("MinionModifier", "LIST", { type = "HeraldOfAgonySpiderPlated", mod = mod("PhysicalMax", "BASE", nil, 0, 0, { type = "Multiplier", actor = "parent", var = "VirulenceStack" })})
		},
	},
	baseFlags = {
		cast = true,
		minion = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "minion_movement_speed_+%", 1 },
	},
	stats = {
		"skill_buff_grants_chance_to_poison_%",
		"herald_of_agony_poison_damage_+%_final",
		"scorpion_minion_physical_damage_+%",
		"scorpion_minion_attack_speed_+%",
		"scorpion_minion_minimum_added_physical_damage",
		"scorpion_minion_maximum_added_physical_damage",
		"base_number_of_herald_scorpions_allowed",
		"herald_of_agony_add_stack_on_poison",
		"minions_cannot_taunt_enemies",
	},
	levels = {
		[1] = { 20, 10, 6, 2, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 16, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[2] = { 20, 10, 6, 2, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 20, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[3] = { 20, 10, 6, 2, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 24, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[4] = { 20, 10, 7, 2, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 28, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[5] = { 20, 10, 7, 2, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 31, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[6] = { 20, 10, 7, 2, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 34, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[7] = { 20, 10, 8, 2, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 37, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[8] = { 20, 10, 8, 2, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 40, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[9] = { 20, 10, 8, 2, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 43, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[10] = { 20, 10, 9, 2, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 46, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[11] = { 20, 10, 9, 3, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 49, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[12] = { 20, 10, 9, 3, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 52, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[13] = { 20, 10, 10, 3, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 55, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[14] = { 20, 10, 10, 3, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 58, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[15] = { 20, 10, 10, 3, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 60, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[16] = { 20, 10, 11, 3, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 62, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[17] = { 20, 10, 11, 3, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 64, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[18] = { 20, 10, 11, 3, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 66, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[19] = { 20, 10, 12, 3, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 68, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[20] = { 20, 10, 12, 3, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 70, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[21] = { 20, 10, 12, 4, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 72, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[22] = { 20, 10, 13, 4, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 74, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[23] = { 20, 10, 13, 4, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 76, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[24] = { 20, 10, 13, 4, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 78, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[25] = { 20, 10, 14, 4, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 80, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[26] = { 20, 10, 14, 4, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 82, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[27] = { 20, 10, 14, 4, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 84, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[28] = { 20, 10, 15, 4, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 86, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[29] = { 20, 10, 15, 4, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 88, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[30] = { 20, 10, 15, 4, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 90, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[31] = { 20, 10, 16, 5, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 91, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[32] = { 20, 10, 16, 5, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 92, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[33] = { 20, 10, 16, 5, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 93, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[34] = { 20, 10, 17, 5, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 94, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[35] = { 20, 10, 17, 5, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 95, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[36] = { 20, 10, 17, 5, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 96, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[37] = { 20, 10, 18, 5, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 97, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[38] = { 20, 10, 18, 5, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 98, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[39] = { 20, 10, 18, 5, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 99, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
		[40] = { 20, 10, 19, 5, 0.69999998807907, 1.2999999523163, 1, cooldown = 1, levelRequirement = 100, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, }, },
	},
}
skills["HeraldOfIce"] = {
	name = "Herald of Ice",
	color = 2,
	baseEffectiveness = 1.3636000156403,
	incrementalEffectiveness = 0.023000000044703,
	description = "Channel ice through your hands, adding cold damage to spells and attacks. If you shatter an enemy, they explode and deal AoE cold damage to enemies near them. The AoE cold damage inflicted by this skill is not affected by modifiers to spell damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.ManaCostReserved] = true, [SkillType.ManaCostPercent] = true, [SkillType.Hit] = true, [SkillType.Area] = true, [SkillType.ColdSkill] = true, [SkillType.Type27] = true, [SkillType.Herald] = true, [SkillType.Instant] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "buff_skill_stat_descriptions",
	castTime = 0,
	statMap = {
		["herald_of_ice_cold_damage_+%"] = {
			mod("ColdDamage", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["spell_minimum_added_cold_damage"] = {
			mod("ColdMin", "BASE", nil, 0, KeywordFlag.Spell, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["spell_maximum_added_cold_damage"] = {
			mod("ColdMax", "BASE", nil, 0, KeywordFlag.Spell, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["attack_minimum_added_cold_damage"] = {
			mod("ColdMin", "BASE", nil, 0, KeywordFlag.Attack, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["attack_maximum_added_cold_damage"] = {
			mod("ColdMax", "BASE", nil, 0, KeywordFlag.Attack, { type = "GlobalEffect", effectType = "Buff" }),
		},
	},
	baseFlags = {
		cast = true,
		area = true,
	},
	baseMods = {
		skill("radius", 12),
	},
	qualityStats = {
		{ "herald_of_ice_cold_damage_+%", 0.75 },
	},
	stats = {
		"spell_minimum_added_cold_damage",
		"spell_maximum_added_cold_damage",
		"attack_minimum_added_cold_damage",
		"attack_maximum_added_cold_damage",
		"secondary_minimum_base_cold_damage",
		"secondary_maximum_base_cold_damage",
		"skill_override_pvp_scaling_time_ms",
		"is_area_damage",
		"base_skill_show_average_damage_instead_of_dps",
		"display_skill_deals_secondary_damage",
		"damage_cannot_be_reflected",
		"skill_can_add_multiple_charges_per_action",
	},
	levels = {
		[1] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 18, 26, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 16, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[2] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 23, 35, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 20, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[3] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 30, 45, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 24, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[4] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 38, 57, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 28, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[5] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 45, 67, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 31, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[6] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 53, 80, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 34, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[7] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 62, 94, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 37, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[8] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 73, 110, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 40, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[9] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 85, 128, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 43, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[10] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 99, 149, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 46, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[11] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 115, 173, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 49, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[12] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 134, 200, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 52, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[13] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 154, 232, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 55, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[14] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 178, 267, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 58, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[15] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 195, 293, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 60, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[16] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 214, 321, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 62, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[17] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 235, 352, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 64, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[18] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 257, 386, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 66, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[19] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 282, 422, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 68, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[20] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 308, 462, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 70, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[21] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 337, 505, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 72, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[22] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 368, 552, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 74, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[23] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 402, 603, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 76, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[24] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 438, 658, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 78, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[25] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 478, 717, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 80, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[26] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 521, 782, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 82, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[27] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 568, 852, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 84, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[28] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 619, 928, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 86, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[29] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 674, 1010, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 88, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[30] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 733, 1100, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 90, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[31] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 764, 1149, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 91, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[32] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 796, 1198, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 92, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[33] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 830, 1251, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 93, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[34] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 863, 1304, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 94, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[35] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 898, 1361, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 95, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[36] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 934, 1418, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 96, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[37] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 971, 1479, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 97, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[38] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 1008, 1540, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 98, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[39] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 1046, 1605, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 99, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
		[40] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 1085, 1670, 1000, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 100, manaCost = 25, statInterpolation = { 3, 3, 3, 3, 1, 1, 1, }, },
	},
}
skills["IceShot"] = {
	name = "Ice Shot",
	color = 2,
	baseEffectiveness = 0.6700000166893,
	incrementalEffectiveness = 0.023299999535084,
	description = "Fires an arrow that converts some physical damage to cold on its target and converts all physical damage to cold in a cone behind that target. Creates a patch of ground ice under the target.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.ProjectileAttack] = true, [SkillType.SkillCanMirageArcher] = true, [SkillType.Projectile] = true, [SkillType.SkillCanVolley] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.SkillCanTotem] = true, [SkillType.SkillCanTrap] = true, [SkillType.SkillCanMine] = true, [SkillType.ColdSkill] = true, [SkillType.ChillingArea] = true, [SkillType.Triggerable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Arrow",
			area = false,
		},
		{
			name = "Cone",
			area = true,
		},
	},
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
		duration = true,
	},
	baseMods = {
		mod("SkillPhysicalDamageConvertToCold", "BASE", 40, 0, 0, { type = "SkillPart", skillPart = 2 }),
		skill("radius", 23),
	},
	qualityStats = {
		{ "cold_damage_+%", 1 },
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_cold",
		"base_skill_effect_duration",
		"attack_minimum_added_cold_damage",
		"attack_maximum_added_cold_damage",
		"skill_can_fire_arrows",
	},
	levels = {
		[1] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.2, baseMultiplier = 1.2, levelRequirement = 1, manaCost = 6, statInterpolation = { 1, 1, 3, 3, }, },
		[2] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.21, baseMultiplier = 1.214, levelRequirement = 2, manaCost = 6, statInterpolation = { 1, 1, 3, 3, }, },
		[3] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.23, baseMultiplier = 1.228, levelRequirement = 4, manaCost = 6, statInterpolation = { 1, 1, 3, 3, }, },
		[4] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.24, baseMultiplier = 1.242, levelRequirement = 7, manaCost = 7, statInterpolation = { 1, 1, 3, 3, }, },
		[5] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.26, baseMultiplier = 1.256, levelRequirement = 11, manaCost = 7, statInterpolation = { 1, 1, 3, 3, }, },
		[6] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.27, baseMultiplier = 1.27, levelRequirement = 16, manaCost = 7, statInterpolation = { 1, 1, 3, 3, }, },
		[7] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.28, baseMultiplier = 1.284, levelRequirement = 20, manaCost = 7, statInterpolation = { 1, 1, 3, 3, }, },
		[8] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.3, baseMultiplier = 1.298, levelRequirement = 24, manaCost = 8, statInterpolation = { 1, 1, 3, 3, }, },
		[9] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.31, baseMultiplier = 1.312, levelRequirement = 28, manaCost = 8, statInterpolation = { 1, 1, 3, 3, }, },
		[10] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.33, baseMultiplier = 1.326, levelRequirement = 32, manaCost = 8, statInterpolation = { 1, 1, 3, 3, }, },
		[11] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.34, baseMultiplier = 1.34, levelRequirement = 36, manaCost = 8, statInterpolation = { 1, 1, 3, 3, }, },
		[12] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.35, baseMultiplier = 1.354, levelRequirement = 40, manaCost = 8, statInterpolation = { 1, 1, 3, 3, }, },
		[13] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.37, baseMultiplier = 1.368, levelRequirement = 44, manaCost = 9, statInterpolation = { 1, 1, 3, 3, }, },
		[14] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.38, baseMultiplier = 1.382, levelRequirement = 48, manaCost = 9, statInterpolation = { 1, 1, 3, 3, }, },
		[15] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.4, baseMultiplier = 1.396, levelRequirement = 52, manaCost = 9, statInterpolation = { 1, 1, 3, 3, }, },
		[16] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.41, baseMultiplier = 1.41, levelRequirement = 56, manaCost = 9, statInterpolation = { 1, 1, 3, 3, }, },
		[17] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.42, baseMultiplier = 1.424, levelRequirement = 60, manaCost = 9, statInterpolation = { 1, 1, 3, 3, }, },
		[18] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.44, baseMultiplier = 1.438, levelRequirement = 64, manaCost = 10, statInterpolation = { 1, 1, 3, 3, }, },
		[19] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.45, baseMultiplier = 1.452, levelRequirement = 67, manaCost = 10, statInterpolation = { 1, 1, 3, 3, }, },
		[20] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.47, baseMultiplier = 1.466, levelRequirement = 70, manaCost = 10, statInterpolation = { 1, 1, 3, 3, }, },
		[21] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.48, baseMultiplier = 1.48, levelRequirement = 72, manaCost = 10, statInterpolation = { 1, 1, 3, 3, }, },
		[22] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.49, baseMultiplier = 1.494, levelRequirement = 74, manaCost = 10, statInterpolation = { 1, 1, 3, 3, }, },
		[23] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.51, baseMultiplier = 1.508, levelRequirement = 76, manaCost = 11, statInterpolation = { 1, 1, 3, 3, }, },
		[24] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.52, baseMultiplier = 1.522, levelRequirement = 78, manaCost = 11, statInterpolation = { 1, 1, 3, 3, }, },
		[25] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.54, baseMultiplier = 1.536, levelRequirement = 80, manaCost = 11, statInterpolation = { 1, 1, 3, 3, }, },
		[26] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.55, baseMultiplier = 1.55, levelRequirement = 82, manaCost = 11, statInterpolation = { 1, 1, 3, 3, }, },
		[27] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.56, baseMultiplier = 1.564, levelRequirement = 84, manaCost = 11, statInterpolation = { 1, 1, 3, 3, }, },
		[28] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.58, baseMultiplier = 1.578, levelRequirement = 86, manaCost = 12, statInterpolation = { 1, 1, 3, 3, }, },
		[29] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.59, baseMultiplier = 1.592, levelRequirement = 88, manaCost = 12, statInterpolation = { 1, 1, 3, 3, }, },
		[30] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.61, baseMultiplier = 1.606, levelRequirement = 90, manaCost = 12, statInterpolation = { 1, 1, 3, 3, }, },
		[31] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.61, baseMultiplier = 1.613, levelRequirement = 91, manaCost = 12, statInterpolation = { 1, 1, 3, 3, }, },
		[32] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.62, baseMultiplier = 1.62, levelRequirement = 92, manaCost = 13, statInterpolation = { 1, 1, 3, 3, }, },
		[33] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.63, baseMultiplier = 1.627, levelRequirement = 93, manaCost = 13, statInterpolation = { 1, 1, 3, 3, }, },
		[34] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.63, baseMultiplier = 1.634, levelRequirement = 94, manaCost = 13, statInterpolation = { 1, 1, 3, 3, }, },
		[35] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.64, baseMultiplier = 1.641, levelRequirement = 95, manaCost = 13, statInterpolation = { 1, 1, 3, 3, }, },
		[36] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.65, baseMultiplier = 1.648, levelRequirement = 96, manaCost = 13, statInterpolation = { 1, 1, 3, 3, }, },
		[37] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.66, baseMultiplier = 1.655, levelRequirement = 97, manaCost = 14, statInterpolation = { 1, 1, 3, 3, }, },
		[38] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.66, baseMultiplier = 1.662, levelRequirement = 98, manaCost = 14, statInterpolation = { 1, 1, 3, 3, }, },
		[39] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.67, baseMultiplier = 1.669, levelRequirement = 99, manaCost = 14, statInterpolation = { 1, 1, 3, 3, }, },
		[40] = { 60, 1500, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.68, baseMultiplier = 1.676, levelRequirement = 100, manaCost = 14, statInterpolation = { 1, 1, 3, 3, }, },
	},
}
skills["IceTrap"] = {
	name = "Ice Trap",
	color = 2,
	baseEffectiveness = 2.9586999416351,
	incrementalEffectiveness = 0.038100000470877,
	description = "Throws a trap that creates a series of icy runic explosions when triggered, dealing cold damage to all enemies caught in the blasts.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Hit] = true, [SkillType.SkillCanMine] = true, [SkillType.Area] = true, [SkillType.Trap] = true, [SkillType.ColdSkill] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		trap = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 0.5 },
	},
	stats = {
		"base_trap_duration",
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"is_area_damage",
		"base_skill_is_trapped",
		"base_skill_show_average_damage_instead_of_dps",
		"is_trap",
	},
	levels = {
		[1] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 28, manaCost = 13, statInterpolation = { 1, 3, 3, }, },
		[2] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 31, manaCost = 13, statInterpolation = { 1, 3, 3, }, },
		[3] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 34, manaCost = 14, statInterpolation = { 1, 3, 3, }, },
		[4] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 37, manaCost = 14, statInterpolation = { 1, 3, 3, }, },
		[5] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 40, manaCost = 15, statInterpolation = { 1, 3, 3, }, },
		[6] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 42, manaCost = 15, statInterpolation = { 1, 3, 3, }, },
		[7] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 44, manaCost = 16, statInterpolation = { 1, 3, 3, }, },
		[8] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 46, manaCost = 16, statInterpolation = { 1, 3, 3, }, },
		[9] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 48, manaCost = 17, statInterpolation = { 1, 3, 3, }, },
		[10] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 50, manaCost = 17, statInterpolation = { 1, 3, 3, }, },
		[11] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 52, manaCost = 18, statInterpolation = { 1, 3, 3, }, },
		[12] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 54, manaCost = 18, statInterpolation = { 1, 3, 3, }, },
		[13] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 56, manaCost = 19, statInterpolation = { 1, 3, 3, }, },
		[14] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 58, manaCost = 19, statInterpolation = { 1, 3, 3, }, },
		[15] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 60, manaCost = 20, statInterpolation = { 1, 3, 3, }, },
		[16] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 62, manaCost = 20, statInterpolation = { 1, 3, 3, }, },
		[17] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 64, manaCost = 21, statInterpolation = { 1, 3, 3, }, },
		[18] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 66, manaCost = 21, statInterpolation = { 1, 3, 3, }, },
		[19] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 68, manaCost = 22, statInterpolation = { 1, 3, 3, }, },
		[20] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 70, manaCost = 22, statInterpolation = { 1, 3, 3, }, },
		[21] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 72, manaCost = 23, statInterpolation = { 1, 3, 3, }, },
		[22] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 74, manaCost = 23, statInterpolation = { 1, 3, 3, }, },
		[23] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 76, manaCost = 24, statInterpolation = { 1, 3, 3, }, },
		[24] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 78, manaCost = 24, statInterpolation = { 1, 3, 3, }, },
		[25] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 80, manaCost = 25, statInterpolation = { 1, 3, 3, }, },
		[26] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 82, manaCost = 25, statInterpolation = { 1, 3, 3, }, },
		[27] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 84, manaCost = 26, statInterpolation = { 1, 3, 3, }, },
		[28] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 86, manaCost = 26, statInterpolation = { 1, 3, 3, }, },
		[29] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 88, manaCost = 27, statInterpolation = { 1, 3, 3, }, },
		[30] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 90, manaCost = 27, statInterpolation = { 1, 3, 3, }, },
		[31] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 91, manaCost = 28, statInterpolation = { 1, 3, 3, }, },
		[32] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 92, manaCost = 28, statInterpolation = { 1, 3, 3, }, },
		[33] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 93, manaCost = 29, statInterpolation = { 1, 3, 3, }, },
		[34] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 94, manaCost = 29, statInterpolation = { 1, 3, 3, }, },
		[35] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 95, manaCost = 30, statInterpolation = { 1, 3, 3, }, },
		[36] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 96, manaCost = 30, statInterpolation = { 1, 3, 3, }, },
		[37] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 97, manaCost = 31, statInterpolation = { 1, 3, 3, }, },
		[38] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 98, manaCost = 31, statInterpolation = { 1, 3, 3, }, },
		[39] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 99, manaCost = 32, statInterpolation = { 1, 3, 3, }, },
		[40] = { 4000, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, critChance = 5, levelRequirement = 100, manaCost = 32, statInterpolation = { 1, 3, 3, }, },
	},
}
skills["DoubleSlash"] = {
	name = "Lacerate",
	color = 2,
	baseEffectiveness = 0.6700000166893,
	incrementalEffectiveness = 0.023299999535084,
	description = "Slashes twice, releasing waves of force that damage enemies they hit. Enemies in the middle of the slashes can be hit by both. The slashes will have a chance to inflict bleeding in Blood Stance, or have a wider angle in Sand Stance, Can be used with Axes and Swords. You are in Blood Stance by default.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.AttackCanRepeat] = true, [SkillType.Melee] = true, [SkillType.PhysicalSkill] = true, },
	weaponTypes = {
		["Two Handed Axe"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["One Handed Axe"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "One slash",
		},
		{
			name = "Both slashes",
		},
	},
	statMap = {
		["double_slash_bleeding_damage_+%_final_in_blood_stance"] = {
			mod("Damage", "MORE", nil, 0, KeywordFlag.Bleed, { type = "Condition", var = "BloodStance" }),
		},
		["chance_to_bleed_on_hit_%_chance_in_blood_stance"] = {
			mod("BleedChance", "BASE", nil, ModFlag.Attack, 0, { type = "Condition", var = "BloodStance" }),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("radius", 38),
		skill("dpsMultiplier", 2, { type = "SkillPart", skillPart = 2 }),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 0.5 },
	},
	stats = {
		"active_skill_base_radius_+",
		"double_slash_bleeding_damage_+%_final_in_blood_stance",
		"chance_to_bleed_on_hit_%_chance_in_blood_stance",
		"attack_minimum_added_physical_damage",
		"attack_maximum_added_physical_damage",
		"skill_angle_+%_in_sand_stance",
		"is_area_damage",
		"console_skill_dont_chase",
	},
	levels = {
		[1] = { 0, 50, 25, 0.80000001192093, 1.2000000476837, 50, attackSpeedMultiplier = -40, levelRequirement = 12, manaCost = 8, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[2] = { 0, 52, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.0117, manaCost = 8, damageEffectiveness = 1.02, attackSpeedMultiplier = -40, levelRequirement = 15, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[3] = { 1, 54, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.0233, manaCost = 8, damageEffectiveness = 1.02, attackSpeedMultiplier = -40, levelRequirement = 19, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[4] = { 1, 56, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.0367, manaCost = 8, damageEffectiveness = 1.03, attackSpeedMultiplier = -40, levelRequirement = 23, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[5] = { 2, 58, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.0483, manaCost = 8, damageEffectiveness = 1.05, attackSpeedMultiplier = -40, levelRequirement = 27, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[6] = { 2, 60, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.06, manaCost = 8, damageEffectiveness = 1.07, attackSpeedMultiplier = -40, levelRequirement = 31, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[7] = { 3, 62, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.0717, manaCost = 8, damageEffectiveness = 1.07, attackSpeedMultiplier = -40, levelRequirement = 35, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[8] = { 3, 64, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.0833, manaCost = 8, damageEffectiveness = 1.08, attackSpeedMultiplier = -40, levelRequirement = 38, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[9] = { 4, 66, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.0967, manaCost = 8, damageEffectiveness = 1.1, attackSpeedMultiplier = -40, levelRequirement = 41, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[10] = { 4, 68, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.1083, manaCost = 8, damageEffectiveness = 1.1, attackSpeedMultiplier = -40, levelRequirement = 44, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[11] = { 5, 70, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.12, manaCost = 8, damageEffectiveness = 1.12, attackSpeedMultiplier = -40, levelRequirement = 47, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[12] = { 5, 72, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.1317, manaCost = 8, damageEffectiveness = 1.13, attackSpeedMultiplier = -40, levelRequirement = 50, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[13] = { 6, 74, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.1433, manaCost = 8, damageEffectiveness = 1.15, attackSpeedMultiplier = -40, levelRequirement = 53, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[14] = { 6, 76, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.1567, manaCost = 8, damageEffectiveness = 1.15, attackSpeedMultiplier = -40, levelRequirement = 56, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[15] = { 7, 78, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.1683, manaCost = 8, damageEffectiveness = 1.17, attackSpeedMultiplier = -40, levelRequirement = 59, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[16] = { 7, 80, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.18, manaCost = 8, damageEffectiveness = 1.18, attackSpeedMultiplier = -40, levelRequirement = 62, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[17] = { 8, 82, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.1917, manaCost = 8, damageEffectiveness = 1.18, attackSpeedMultiplier = -40, levelRequirement = 64, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[18] = { 8, 84, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.2033, manaCost = 8, damageEffectiveness = 1.2, attackSpeedMultiplier = -40, levelRequirement = 66, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[19] = { 9, 86, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.2167, manaCost = 8, damageEffectiveness = 1.22, attackSpeedMultiplier = -40, levelRequirement = 68, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[20] = { 9, 88, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.2283, manaCost = 8, damageEffectiveness = 1.23, attackSpeedMultiplier = -40, levelRequirement = 70, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[21] = { 10, 90, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.24, manaCost = 8, damageEffectiveness = 1.23, attackSpeedMultiplier = -40, levelRequirement = 72, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[22] = { 10, 92, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.2517, manaCost = 8, damageEffectiveness = 1.25, attackSpeedMultiplier = -40, levelRequirement = 74, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[23] = { 11, 94, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.2633, manaCost = 8, damageEffectiveness = 1.27, attackSpeedMultiplier = -40, levelRequirement = 76, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[24] = { 11, 96, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.2767, manaCost = 8, damageEffectiveness = 1.28, attackSpeedMultiplier = -40, levelRequirement = 78, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[25] = { 12, 98, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.2883, manaCost = 8, damageEffectiveness = 1.28, attackSpeedMultiplier = -40, levelRequirement = 80, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[26] = { 12, 100, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.3, manaCost = 8, damageEffectiveness = 1.3, attackSpeedMultiplier = -40, levelRequirement = 82, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[27] = { 13, 102, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.3117, manaCost = 8, damageEffectiveness = 1.32, attackSpeedMultiplier = -40, levelRequirement = 84, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[28] = { 13, 104, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.3233, manaCost = 8, damageEffectiveness = 1.32, attackSpeedMultiplier = -40, levelRequirement = 86, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[29] = { 14, 106, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.3367, manaCost = 8, damageEffectiveness = 1.33, attackSpeedMultiplier = -40, levelRequirement = 88, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[30] = { 14, 108, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.3483, manaCost = 8, damageEffectiveness = 1.35, attackSpeedMultiplier = -40, levelRequirement = 90, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[31] = { 14, 109, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.3542, manaCost = 8, damageEffectiveness = 1.35, attackSpeedMultiplier = -40, levelRequirement = 91, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[32] = { 15, 110, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.36, manaCost = 8, damageEffectiveness = 1.37, attackSpeedMultiplier = -40, levelRequirement = 92, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[33] = { 15, 111, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.3658, manaCost = 8, damageEffectiveness = 1.37, attackSpeedMultiplier = -40, levelRequirement = 93, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[34] = { 15, 112, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.3717, manaCost = 8, damageEffectiveness = 1.37, attackSpeedMultiplier = -40, levelRequirement = 94, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[35] = { 15, 113, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.3775, manaCost = 8, damageEffectiveness = 1.38, attackSpeedMultiplier = -40, levelRequirement = 95, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[36] = { 16, 114, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.3833, manaCost = 8, damageEffectiveness = 1.38, attackSpeedMultiplier = -40, levelRequirement = 96, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[37] = { 16, 115, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.3892, manaCost = 8, damageEffectiveness = 1.38, attackSpeedMultiplier = -40, levelRequirement = 97, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[38] = { 16, 116, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.395, manaCost = 8, damageEffectiveness = 1.4, attackSpeedMultiplier = -40, levelRequirement = 98, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[39] = { 16, 117, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.4008, manaCost = 8, damageEffectiveness = 1.4, attackSpeedMultiplier = -40, levelRequirement = 99, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
		[40] = { 17, 118, 25, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.4067, manaCost = 8, damageEffectiveness = 1.4, attackSpeedMultiplier = -40, levelRequirement = 100, statInterpolation = { 1, 1, 1, 3, 3, 1, }, },
	},
}
skills["LancingSteel"] = {
	name = "Lancing Steel",
	color = 2,
	baseEffectiveness = 1,
	incrementalEffectiveness = 0.023299999535084,
	description = "Thrust an Axe or Sword forward, releasing a primary projectile that impales all enemies it hits. Additional projectiles appear nearby as smaller metal shards that fly forward after a short delay. Each enemy can only be hit by one projectile from this skill.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.Hit] = true, [SkillType.ProjectileDamage] = true, [SkillType.ProjectileAttack] = true, [SkillType.PhysicalSkill] = true, },
	weaponTypes = {
		["Two Handed Axe"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["One Handed Axe"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "attacks_impale_on_hit_%_chance", 0.5 },
	},
	stats = {
		"active_skill_attack_speed_+%_final",
		"number_of_additional_projectiles",
		"projectile_base_number_of_targets_to_pierce",
		"primary_projectile_impale_chance_%",
		"attacks_impale_on_hit_%_chance",
		"attack_minimum_added_physical_damage",
		"attack_maximum_added_physical_damage",
		"base_is_projectile",
	},
	levels = {
		[1] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.3, manaCost = 8, damageEffectiveness = 1.3, attackSpeedMultiplier = -20, levelRequirement = 28, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[2] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.324, manaCost = 8, damageEffectiveness = 1.32, attackSpeedMultiplier = -20, levelRequirement = 31, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[3] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.347, manaCost = 8, damageEffectiveness = 1.35, attackSpeedMultiplier = -20, levelRequirement = 34, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[4] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.371, manaCost = 8, damageEffectiveness = 1.37, attackSpeedMultiplier = -20, levelRequirement = 37, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[5] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.395, manaCost = 9, damageEffectiveness = 1.39, attackSpeedMultiplier = -20, levelRequirement = 40, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[6] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.418, manaCost = 9, damageEffectiveness = 1.42, attackSpeedMultiplier = -20, levelRequirement = 42, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[7] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.442, manaCost = 9, damageEffectiveness = 1.44, attackSpeedMultiplier = -20, levelRequirement = 44, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[8] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.466, manaCost = 9, damageEffectiveness = 1.47, attackSpeedMultiplier = -20, levelRequirement = 46, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[9] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.489, manaCost = 9, damageEffectiveness = 1.49, attackSpeedMultiplier = -20, levelRequirement = 48, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[10] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.513, manaCost = 9, damageEffectiveness = 1.51, attackSpeedMultiplier = -20, levelRequirement = 50, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[11] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.537, manaCost = 9, damageEffectiveness = 1.54, attackSpeedMultiplier = -20, levelRequirement = 52, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[12] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.561, manaCost = 9, damageEffectiveness = 1.56, attackSpeedMultiplier = -20, levelRequirement = 54, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[13] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.584, manaCost = 9, damageEffectiveness = 1.58, attackSpeedMultiplier = -20, levelRequirement = 56, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[14] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.608, manaCost = 9, damageEffectiveness = 1.61, attackSpeedMultiplier = -20, levelRequirement = 58, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[15] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.632, manaCost = 10, damageEffectiveness = 1.63, attackSpeedMultiplier = -20, levelRequirement = 60, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[16] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.655, manaCost = 10, damageEffectiveness = 1.66, attackSpeedMultiplier = -20, levelRequirement = 62, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[17] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.679, manaCost = 10, damageEffectiveness = 1.68, attackSpeedMultiplier = -20, levelRequirement = 64, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[18] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.703, manaCost = 10, damageEffectiveness = 1.7, attackSpeedMultiplier = -20, levelRequirement = 66, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[19] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.726, manaCost = 10, damageEffectiveness = 1.73, attackSpeedMultiplier = -20, levelRequirement = 68, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[20] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.75, manaCost = 10, damageEffectiveness = 1.75, attackSpeedMultiplier = -20, levelRequirement = 70, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[21] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.774, manaCost = 10, damageEffectiveness = 1.77, attackSpeedMultiplier = -20, levelRequirement = 72, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[22] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.797, manaCost = 10, damageEffectiveness = 1.8, attackSpeedMultiplier = -20, levelRequirement = 74, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[23] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.821, manaCost = 10, damageEffectiveness = 1.82, attackSpeedMultiplier = -20, levelRequirement = 76, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[24] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.845, manaCost = 10, damageEffectiveness = 1.84, attackSpeedMultiplier = -20, levelRequirement = 78, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[25] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.868, manaCost = 11, damageEffectiveness = 1.87, attackSpeedMultiplier = -20, levelRequirement = 80, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[26] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.892, manaCost = 11, damageEffectiveness = 1.89, attackSpeedMultiplier = -20, levelRequirement = 82, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[27] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.916, manaCost = 11, damageEffectiveness = 1.92, attackSpeedMultiplier = -20, levelRequirement = 84, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[28] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.939, manaCost = 11, damageEffectiveness = 1.94, attackSpeedMultiplier = -20, levelRequirement = 86, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[29] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.963, manaCost = 11, damageEffectiveness = 1.96, attackSpeedMultiplier = -20, levelRequirement = 88, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[30] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.987, manaCost = 11, damageEffectiveness = 1.99, attackSpeedMultiplier = -20, levelRequirement = 90, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[31] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.999, manaCost = 11, damageEffectiveness = 2, attackSpeedMultiplier = -20, levelRequirement = 91, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[32] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 2.011, manaCost = 11, damageEffectiveness = 2.01, attackSpeedMultiplier = -20, levelRequirement = 92, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[33] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 2.022, manaCost = 11, damageEffectiveness = 2.02, attackSpeedMultiplier = -20, levelRequirement = 93, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[34] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 2.034, manaCost = 11, damageEffectiveness = 2.03, attackSpeedMultiplier = -20, levelRequirement = 94, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[35] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 2.046, manaCost = 11, damageEffectiveness = 2.05, attackSpeedMultiplier = -20, levelRequirement = 95, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[36] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 2.058, manaCost = 11, damageEffectiveness = 2.06, attackSpeedMultiplier = -20, levelRequirement = 96, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[37] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 2.07, manaCost = 11, damageEffectiveness = 2.07, attackSpeedMultiplier = -20, levelRequirement = 97, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[38] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 2.082, manaCost = 11, damageEffectiveness = 2.08, attackSpeedMultiplier = -20, levelRequirement = 98, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[39] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 2.093, manaCost = 11, damageEffectiveness = 2.09, attackSpeedMultiplier = -20, levelRequirement = 99, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[40] = { 0, 4, 0, 100, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 2.105, manaCost = 8, damageEffectiveness = 2.11, attackSpeedMultiplier = -20, levelRequirement = 100, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
	},
}
skills["LightningArrow"] = {
	name = "Lightning Arrow",
	color = 2,
	baseEffectiveness = 0.6700000166893,
	incrementalEffectiveness = 0.023299999535084,
	description = "Fires a charged arrow at the target, causing them to be struck by a bolt of lightning which damages nearby enemies.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.ProjectileAttack] = true, [SkillType.SkillCanMirageArcher] = true, [SkillType.Area] = true, [SkillType.Projectile] = true, [SkillType.SkillCanVolley] = true, [SkillType.SkillCanTotem] = true, [SkillType.SkillCanTrap] = true, [SkillType.SkillCanMine] = true, [SkillType.LightningSkill] = true, [SkillType.Triggerable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "base_chance_to_shock_%", 1 },
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_lightning",
		"lightning_arrow_maximum_number_of_extra_targets",
		"attack_minimum_added_lightning_damage",
		"attack_maximum_added_lightning_damage",
		"skill_can_fire_arrows",
	},
	levels = {
		[1] = { 50, 3, 0.10000000149012, 1.8999999761581, manaCost = 7, levelRequirement = 12, statInterpolation = { 1, 1, 3, 3, }, },
		[2] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.01, baseMultiplier = 1.01, levelRequirement = 15, manaCost = 7, statInterpolation = { 1, 1, 3, 3, }, },
		[3] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.02, baseMultiplier = 1.02, levelRequirement = 19, manaCost = 7, statInterpolation = { 1, 1, 3, 3, }, },
		[4] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.03, baseMultiplier = 1.03, levelRequirement = 23, manaCost = 8, statInterpolation = { 1, 1, 3, 3, }, },
		[5] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.04, baseMultiplier = 1.04, levelRequirement = 27, manaCost = 8, statInterpolation = { 1, 1, 3, 3, }, },
		[6] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.05, baseMultiplier = 1.05, levelRequirement = 31, manaCost = 8, statInterpolation = { 1, 1, 3, 3, }, },
		[7] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.06, baseMultiplier = 1.06, levelRequirement = 35, manaCost = 8, statInterpolation = { 1, 1, 3, 3, }, },
		[8] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.07, baseMultiplier = 1.07, levelRequirement = 38, manaCost = 8, statInterpolation = { 1, 1, 3, 3, }, },
		[9] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.08, baseMultiplier = 1.08, levelRequirement = 41, manaCost = 9, statInterpolation = { 1, 1, 3, 3, }, },
		[10] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.09, baseMultiplier = 1.09, levelRequirement = 44, manaCost = 9, statInterpolation = { 1, 1, 3, 3, }, },
		[11] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.1, baseMultiplier = 1.1, levelRequirement = 47, manaCost = 9, statInterpolation = { 1, 1, 3, 3, }, },
		[12] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.11, baseMultiplier = 1.11, levelRequirement = 50, manaCost = 9, statInterpolation = { 1, 1, 3, 3, }, },
		[13] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.12, baseMultiplier = 1.12, levelRequirement = 53, manaCost = 9, statInterpolation = { 1, 1, 3, 3, }, },
		[14] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.13, baseMultiplier = 1.13, levelRequirement = 56, manaCost = 10, statInterpolation = { 1, 1, 3, 3, }, },
		[15] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.14, baseMultiplier = 1.14, levelRequirement = 59, manaCost = 10, statInterpolation = { 1, 1, 3, 3, }, },
		[16] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.15, baseMultiplier = 1.15, levelRequirement = 62, manaCost = 10, statInterpolation = { 1, 1, 3, 3, }, },
		[17] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.16, baseMultiplier = 1.16, levelRequirement = 64, manaCost = 10, statInterpolation = { 1, 1, 3, 3, }, },
		[18] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.17, baseMultiplier = 1.17, levelRequirement = 66, manaCost = 10, statInterpolation = { 1, 1, 3, 3, }, },
		[19] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.18, baseMultiplier = 1.18, levelRequirement = 68, manaCost = 11, statInterpolation = { 1, 1, 3, 3, }, },
		[20] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.19, baseMultiplier = 1.19, levelRequirement = 70, manaCost = 11, statInterpolation = { 1, 1, 3, 3, }, },
		[21] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.2, baseMultiplier = 1.2, levelRequirement = 72, manaCost = 11, statInterpolation = { 1, 1, 3, 3, }, },
		[22] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.21, baseMultiplier = 1.21, levelRequirement = 74, manaCost = 11, statInterpolation = { 1, 1, 3, 3, }, },
		[23] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.22, baseMultiplier = 1.22, levelRequirement = 76, manaCost = 11, statInterpolation = { 1, 1, 3, 3, }, },
		[24] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.23, baseMultiplier = 1.23, levelRequirement = 78, manaCost = 11, statInterpolation = { 1, 1, 3, 3, }, },
		[25] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.24, baseMultiplier = 1.24, levelRequirement = 80, manaCost = 11, statInterpolation = { 1, 1, 3, 3, }, },
		[26] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.25, baseMultiplier = 1.25, levelRequirement = 82, manaCost = 12, statInterpolation = { 1, 1, 3, 3, }, },
		[27] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.26, baseMultiplier = 1.26, levelRequirement = 84, manaCost = 12, statInterpolation = { 1, 1, 3, 3, }, },
		[28] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.27, baseMultiplier = 1.27, levelRequirement = 86, manaCost = 12, statInterpolation = { 1, 1, 3, 3, }, },
		[29] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.28, baseMultiplier = 1.28, levelRequirement = 88, manaCost = 12, statInterpolation = { 1, 1, 3, 3, }, },
		[30] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.29, baseMultiplier = 1.29, levelRequirement = 90, manaCost = 12, statInterpolation = { 1, 1, 3, 3, }, },
		[31] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.3, baseMultiplier = 1.295, levelRequirement = 91, manaCost = 12, statInterpolation = { 1, 1, 3, 3, }, },
		[32] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.3, baseMultiplier = 1.3, levelRequirement = 92, manaCost = 13, statInterpolation = { 1, 1, 3, 3, }, },
		[33] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.31, baseMultiplier = 1.305, levelRequirement = 93, manaCost = 13, statInterpolation = { 1, 1, 3, 3, }, },
		[34] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.31, baseMultiplier = 1.31, levelRequirement = 94, manaCost = 13, statInterpolation = { 1, 1, 3, 3, }, },
		[35] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.32, baseMultiplier = 1.315, levelRequirement = 95, manaCost = 13, statInterpolation = { 1, 1, 3, 3, }, },
		[36] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.32, baseMultiplier = 1.32, levelRequirement = 96, manaCost = 13, statInterpolation = { 1, 1, 3, 3, }, },
		[37] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.33, baseMultiplier = 1.325, levelRequirement = 97, manaCost = 13, statInterpolation = { 1, 1, 3, 3, }, },
		[38] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.33, baseMultiplier = 1.33, levelRequirement = 98, manaCost = 13, statInterpolation = { 1, 1, 3, 3, }, },
		[39] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.34, baseMultiplier = 1.335, levelRequirement = 99, manaCost = 13, statInterpolation = { 1, 1, 3, 3, }, },
		[40] = { 50, 3, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.34, baseMultiplier = 1.34, levelRequirement = 100, manaCost = 13, statInterpolation = { 1, 1, 3, 3, }, },
	},
}
skills["LightningStrike"] = {
	name = "Lightning Strike",
	color = 2,
	baseEffectiveness = 0.6700000166893,
	incrementalEffectiveness = 0.023299999535084,
	description = "Infuses your melee weapon with electrical energies as you swing. In addition to converting some of your physical damage to lightning damage, the stored energy is released from the weapon as projectiles as you strike, flying out to hit farther-away enemies. The projectiles cannot miss if the melee attack hits a target.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.ProjectileAttack] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.AttackCanRepeat] = true, [SkillType.Melee] = true, [SkillType.LightningSkill] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Melee hit",
			melee = true,
			projectile = false,
		},
		{
			name = "Projectiles",
			melee = false,
			projectile = true,
		},
	},
	statMap = {
		["active_skill_damage_over_time_from_projectile_hits_+%_final"] = {
			mod("Damage", "MORE", nil, ModFlag.Dot, 0, { type = "SkillPart", skillPart = 2 })
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "damage_+%", 1 },
		{ "base_projectile_speed_+%", 1 },
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_lightning",
		"number_of_additional_projectiles",
		"active_skill_projectile_damage_+%_final",
		"total_projectile_spread_angle_override",
		"active_skill_damage_over_time_from_projectile_hits_+%_final",
		"attack_minimum_added_lightning_damage",
		"attack_maximum_added_lightning_damage",
		"show_number_of_projectiles",
	},
	levels = {
		[1] = { 50, 4, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.35, baseMultiplier = 1.35, levelRequirement = 12, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[2] = { 50, 4, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.37, baseMultiplier = 1.374, levelRequirement = 15, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[3] = { 50, 4, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.4, baseMultiplier = 1.397, levelRequirement = 19, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[4] = { 50, 4, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.42, baseMultiplier = 1.421, levelRequirement = 23, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[5] = { 50, 4, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.44, baseMultiplier = 1.445, levelRequirement = 27, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[6] = { 50, 5, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.47, baseMultiplier = 1.468, levelRequirement = 31, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[7] = { 50, 5, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.49, baseMultiplier = 1.492, levelRequirement = 35, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[8] = { 50, 5, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.52, baseMultiplier = 1.516, levelRequirement = 38, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[9] = { 50, 5, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.54, baseMultiplier = 1.539, levelRequirement = 41, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[10] = { 50, 5, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.56, baseMultiplier = 1.563, levelRequirement = 44, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[11] = { 50, 6, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.59, baseMultiplier = 1.587, levelRequirement = 47, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[12] = { 50, 6, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.61, baseMultiplier = 1.611, levelRequirement = 50, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[13] = { 50, 6, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.63, baseMultiplier = 1.634, levelRequirement = 53, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[14] = { 50, 6, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.66, baseMultiplier = 1.658, levelRequirement = 56, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[15] = { 50, 6, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.68, baseMultiplier = 1.682, levelRequirement = 59, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[16] = { 50, 7, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.71, baseMultiplier = 1.705, levelRequirement = 62, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[17] = { 50, 7, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.73, baseMultiplier = 1.729, levelRequirement = 64, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[18] = { 50, 7, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.75, baseMultiplier = 1.753, levelRequirement = 66, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[19] = { 50, 7, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.78, baseMultiplier = 1.776, levelRequirement = 68, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[20] = { 50, 7, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.8, baseMultiplier = 1.8, levelRequirement = 70, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[21] = { 50, 8, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.82, baseMultiplier = 1.824, levelRequirement = 72, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[22] = { 50, 8, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.85, baseMultiplier = 1.847, levelRequirement = 74, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[23] = { 50, 8, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.87, baseMultiplier = 1.871, levelRequirement = 76, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[24] = { 50, 8, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.89, baseMultiplier = 1.895, levelRequirement = 78, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[25] = { 50, 8, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.92, baseMultiplier = 1.918, levelRequirement = 80, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[26] = { 50, 9, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.94, baseMultiplier = 1.942, levelRequirement = 82, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[27] = { 50, 9, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.97, baseMultiplier = 1.966, levelRequirement = 84, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[28] = { 50, 9, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.99, baseMultiplier = 1.989, levelRequirement = 86, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[29] = { 50, 9, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 2.01, baseMultiplier = 2.013, levelRequirement = 88, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[30] = { 50, 9, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 2.04, baseMultiplier = 2.037, levelRequirement = 90, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[31] = { 50, 9, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 2.05, baseMultiplier = 2.049, levelRequirement = 91, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[32] = { 50, 10, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 2.06, baseMultiplier = 2.061, levelRequirement = 92, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[33] = { 50, 10, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 2.07, baseMultiplier = 2.072, levelRequirement = 93, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[34] = { 50, 10, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 2.08, baseMultiplier = 2.084, levelRequirement = 94, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[35] = { 50, 10, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 2.1, baseMultiplier = 2.096, levelRequirement = 95, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[36] = { 50, 10, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 2.11, baseMultiplier = 2.108, levelRequirement = 96, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[37] = { 50, 10, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 2.12, baseMultiplier = 2.12, levelRequirement = 97, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[38] = { 50, 10, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 2.13, baseMultiplier = 2.132, levelRequirement = 98, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[39] = { 50, 10, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 2.14, baseMultiplier = 2.143, levelRequirement = 99, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[40] = { 50, 10, -25, 70, -25, 0.10000000149012, 1.8999999761581, damageEffectiveness = 2.16, baseMultiplier = 2.155, levelRequirement = 100, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
	},
}
skills["VaalLightningStrike"] = {
	name = "Vaal Lightning Strike",
	color = 2,
	baseEffectiveness = 0.6700000166893,
	incrementalEffectiveness = 0.023299999535084,
	description = "Infuses your melee weapon with electrical energies as you swing. In addition to converting some of your physical damage to lightning damage, the stored energy becomes an orb attached to the enemy you hit, or the ground if you don't hit an enemy. The orb will periodically fire projectiles at other nearby enemies for a duration, which will also damage the enemy the orb is attached to.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Melee] = true, [SkillType.Duration] = true, [SkillType.Vaal] = true, [SkillType.LightningSkill] = true, [SkillType.Projectile] = true, [SkillType.ProjectileAttack] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Strike",
		},
		{
			name = "Beams",
		},
	},
	statMap = {
		["vaal_lightning_strike_beam_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "SkillPart", skillPart = 2 }),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		duration = true,
		vaal = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "damage_+%", 1 },
		{ "base_projectile_speed_+%", 1 },
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_lightning",
		"base_skill_effect_duration",
		"number_of_additional_projectiles",
		"total_projectile_spread_angle_override",
		"attack_minimum_added_lightning_damage",
		"attack_maximum_added_lightning_damage",
		"global_always_hit",
		"show_number_of_projectiles",
		"modifiers_to_skill_effect_duration_also_affect_soul_prevention_duration",
		"cannot_cancel_skill_before_contact_point",
	},
	levels = {
		[1] = { 50, 8000, 4, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 0.8, baseMultiplier = 0.8, levelRequirement = 12, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[2] = { 50, 8000, 4, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 0.81, baseMultiplier = 0.81, levelRequirement = 15, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[3] = { 50, 8000, 4, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 0.82, baseMultiplier = 0.819, levelRequirement = 19, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[4] = { 50, 8000, 4, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 0.83, baseMultiplier = 0.829, levelRequirement = 23, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[5] = { 50, 8000, 4, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 0.84, baseMultiplier = 0.838, levelRequirement = 27, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[6] = { 50, 8000, 6, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 0.85, baseMultiplier = 0.848, levelRequirement = 31, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[7] = { 50, 8000, 6, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 0.86, baseMultiplier = 0.858, levelRequirement = 35, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[8] = { 50, 8000, 6, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 0.87, baseMultiplier = 0.867, levelRequirement = 38, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[9] = { 50, 8000, 6, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 0.88, baseMultiplier = 0.877, levelRequirement = 41, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[10] = { 50, 8000, 6, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 0.89, baseMultiplier = 0.886, levelRequirement = 44, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[11] = { 50, 8000, 6, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 0.9, baseMultiplier = 0.896, levelRequirement = 47, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[12] = { 50, 8000, 6, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 0.91, baseMultiplier = 0.906, levelRequirement = 50, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[13] = { 50, 8000, 6, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 0.91, baseMultiplier = 0.915, levelRequirement = 53, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[14] = { 50, 8000, 6, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 0.92, baseMultiplier = 0.925, levelRequirement = 56, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[15] = { 50, 8000, 6, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 0.93, baseMultiplier = 0.934, levelRequirement = 59, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[16] = { 50, 8000, 8, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 0.94, baseMultiplier = 0.944, levelRequirement = 62, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[17] = { 50, 8000, 8, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 0.95, baseMultiplier = 0.954, levelRequirement = 64, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[18] = { 50, 8000, 8, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 0.96, baseMultiplier = 0.963, levelRequirement = 66, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[19] = { 50, 8000, 8, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 0.97, baseMultiplier = 0.973, levelRequirement = 68, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[20] = { 50, 8000, 8, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 0.98, baseMultiplier = 0.982, levelRequirement = 70, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[21] = { 50, 8000, 8, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 0.99, baseMultiplier = 0.992, levelRequirement = 72, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[22] = { 50, 8000, 8, 180, 0.10000000149012, 1.8999999761581, baseMultiplier = 1.002, levelRequirement = 74, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[23] = { 50, 8000, 8, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.01, baseMultiplier = 1.011, levelRequirement = 76, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[24] = { 50, 8000, 8, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.02, baseMultiplier = 1.021, levelRequirement = 78, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[25] = { 50, 8000, 8, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.03, baseMultiplier = 1.03, levelRequirement = 80, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[26] = { 50, 8000, 10, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.04, baseMultiplier = 1.04, levelRequirement = 82, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[27] = { 50, 8000, 10, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.05, baseMultiplier = 1.05, levelRequirement = 84, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[28] = { 50, 8000, 10, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.06, baseMultiplier = 1.059, levelRequirement = 86, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[29] = { 50, 8000, 10, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.07, baseMultiplier = 1.069, levelRequirement = 88, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[30] = { 50, 8000, 10, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.08, baseMultiplier = 1.078, levelRequirement = 90, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[31] = { 50, 8000, 10, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.08, baseMultiplier = 1.0825, levelRequirement = 91, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[32] = { 50, 8000, 10, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.09, baseMultiplier = 1.087, levelRequirement = 92, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[33] = { 50, 8000, 10, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.09, baseMultiplier = 1.0915, levelRequirement = 93, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[34] = { 50, 8000, 10, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.1, baseMultiplier = 1.096, levelRequirement = 94, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[35] = { 50, 8000, 10, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.1, baseMultiplier = 1.1005, levelRequirement = 95, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[36] = { 50, 8000, 10, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.11, baseMultiplier = 1.105, levelRequirement = 96, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[37] = { 50, 8000, 10, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.11, baseMultiplier = 1.1095, levelRequirement = 97, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[38] = { 50, 8000, 10, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.11, baseMultiplier = 1.114, levelRequirement = 98, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[39] = { 50, 8000, 10, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.12, baseMultiplier = 1.1185, levelRequirement = 99, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
		[40] = { 50, 8000, 10, 180, 0.10000000149012, 1.8999999761581, damageEffectiveness = 1.12, baseMultiplier = 1.123, levelRequirement = 100, statInterpolation = { 1, 1, 1, 1, 3, 3, }, },
	},
}
skills["MirrorArrow"] = {
	name = "Mirror Arrow",
	color = 2,
	description = "Fires an arrow at the target destination. When the arrow lands, a clone is summoned. The clone is a minion that uses your bow and quiver.",
	skillTypes = { [SkillType.ProjectileDamage] = true, [SkillType.Attack] = true, [SkillType.Minion] = true, [SkillType.ProjectileAttack] = true, [SkillType.SkillCanMirageArcher] = true, [SkillType.CreateMinion] = true, [SkillType.Duration] = true, [SkillType.SkillCanTotem] = true, [SkillType.SkillCanTrap] = true, [SkillType.SkillCanMine] = true, [SkillType.Triggerable] = true, [SkillType.SkillCanVolley] = true, [SkillType.CreatesMinion] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.ProjectileAttack] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "minion_attack_skill_stat_descriptions",
	castTime = 1,
	minionList = {
		"Clone",
	},
	baseFlags = {
		attack = true,
		projectile = true,
		minion = true,
		duration = true,
	},
	baseMods = {
		skill("minionUseBowAndQuiver", true),
	},
	qualityStats = {
		{ "base_arrow_speed_+%", 1.5 },
	},
	stats = {
		"base_skill_effect_duration",
		"number_of_monsters_to_summon",
		"minion_damage_+%",
		"minion_maximum_life_+%",
		"active_skill_minion_damage_+%_final",
		"display_minion_monster_type",
		"display_minion_monster_level",
		"base_number_of_clones_allowed",
		"base_is_projectile",
	},
	levels = {
		[1] = { 3000, 1, 0, 0, 75, 4, 24, 0, cooldown = 3, levelRequirement = 10, manaCost = 14, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[2] = { 3000, 1, 6, 3, 75, 4, 27, 0, cooldown = 3, levelRequirement = 13, manaCost = 14, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[3] = { 3000, 1, 12, 6, 75, 4, 30, 0, cooldown = 3, levelRequirement = 17, manaCost = 15, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[4] = { 3000, 1, 18, 9, 75, 4, 33, 0, cooldown = 3, levelRequirement = 21, manaCost = 15, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[5] = { 3000, 1, 24, 12, 75, 4, 35, 0, cooldown = 3, levelRequirement = 25, manaCost = 15, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[6] = { 3000, 1, 30, 15, 75, 4, 38, 0, cooldown = 3, levelRequirement = 29, manaCost = 16, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[7] = { 3000, 1, 36, 18, 75, 4, 40, 0, cooldown = 3, levelRequirement = 33, manaCost = 16, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[8] = { 3000, 1, 42, 21, 75, 4, 43, 0, cooldown = 3, levelRequirement = 36, manaCost = 16, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[9] = { 3000, 1, 48, 24, 75, 4, 46, 0, cooldown = 3, levelRequirement = 39, manaCost = 16, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[10] = { 3000, 1, 54, 27, 75, 4, 48, 0, cooldown = 3, levelRequirement = 42, manaCost = 17, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[11] = { 3000, 1, 60, 30, 75, 4, 50, 0, cooldown = 3, levelRequirement = 45, manaCost = 17, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[12] = { 3000, 1, 66, 33, 75, 4, 52, 0, cooldown = 3, levelRequirement = 48, manaCost = 17, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[13] = { 3000, 1, 72, 36, 75, 4, 54, 0, cooldown = 3, levelRequirement = 51, manaCost = 17, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[14] = { 3000, 1, 78, 39, 75, 4, 56, 0, cooldown = 3, levelRequirement = 54, manaCost = 18, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[15] = { 3000, 1, 84, 42, 75, 4, 58, 0, cooldown = 3, levelRequirement = 57, manaCost = 18, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[16] = { 3000, 1, 90, 45, 75, 4, 60, 0, cooldown = 3, levelRequirement = 60, manaCost = 18, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[17] = { 3000, 1, 96, 48, 75, 4, 62, 0, cooldown = 3, levelRequirement = 63, manaCost = 19, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[18] = { 3000, 1, 102, 51, 75, 4, 64, 0, cooldown = 3, levelRequirement = 66, manaCost = 19, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[19] = { 3000, 1, 108, 54, 75, 4, 66, 0, cooldown = 3, levelRequirement = 68, manaCost = 20, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[20] = { 3000, 1, 114, 57, 75, 4, 68, 0, cooldown = 3, levelRequirement = 70, manaCost = 20, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[21] = { 3000, 1, 120, 60, 75, 4, 70, 0, cooldown = 3, levelRequirement = 72, manaCost = 21, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[22] = { 3000, 1, 126, 63, 75, 4, 72, 0, cooldown = 3, levelRequirement = 74, manaCost = 21, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[23] = { 3000, 1, 132, 66, 75, 4, 74, 0, cooldown = 3, levelRequirement = 76, manaCost = 22, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[24] = { 3000, 1, 138, 69, 75, 4, 76, 0, cooldown = 3, levelRequirement = 78, manaCost = 22, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[25] = { 3000, 1, 144, 72, 75, 4, 78, 0, cooldown = 3, levelRequirement = 80, manaCost = 22, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[26] = { 3000, 1, 150, 75, 75, 4, 80, 0, cooldown = 3, levelRequirement = 82, manaCost = 23, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[27] = { 3000, 1, 156, 78, 75, 4, 82, 0, cooldown = 3, levelRequirement = 84, manaCost = 23, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[28] = { 3000, 1, 162, 81, 75, 4, 84, 0, cooldown = 3, levelRequirement = 86, manaCost = 23, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[29] = { 3000, 1, 168, 84, 75, 4, 86, 0, cooldown = 3, levelRequirement = 88, manaCost = 23, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[30] = { 3000, 1, 174, 87, 75, 4, 88, 0, cooldown = 3, levelRequirement = 90, manaCost = 24, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[31] = { 3000, 1, 177, 89, 75, 4, 89, 0, cooldown = 3, levelRequirement = 91, manaCost = 24, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[32] = { 3000, 1, 180, 90, 75, 4, 90, 0, cooldown = 3, levelRequirement = 92, manaCost = 24, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[33] = { 3000, 1, 183, 92, 75, 4, 91, 0, cooldown = 3, levelRequirement = 93, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[34] = { 3000, 1, 186, 93, 75, 4, 92, 0, cooldown = 3, levelRequirement = 94, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[35] = { 3000, 1, 189, 95, 75, 4, 93, 0, cooldown = 3, levelRequirement = 95, manaCost = 25, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[36] = { 3000, 1, 192, 96, 75, 4, 94, 0, cooldown = 3, levelRequirement = 96, manaCost = 26, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[37] = { 3000, 1, 195, 98, 75, 4, 95, 0, cooldown = 3, levelRequirement = 97, manaCost = 26, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[38] = { 3000, 1, 198, 99, 75, 4, 96, 0, cooldown = 3, levelRequirement = 98, manaCost = 27, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[39] = { 3000, 1, 201, 101, 75, 4, 97, 0, cooldown = 3, levelRequirement = 99, manaCost = 27, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
		[40] = { 3000, 1, 204, 102, 75, 4, 98, 0, cooldown = 3, levelRequirement = 100, manaCost = 27, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, },
	},
}
skills["MambaStrike"] = {
	name = "Pestilent Strike",
	color = 2,
	baseEffectiveness = 1,
	incrementalEffectiveness = 0.023299999535084,
	description = "Attacks with your weapon, inflicting a debuff on enemies hit by the strike. If a debuffed enemy dies while poisoned, Pestilent Strike inflicts a secondary chaos damage over time debuff on enemies around them, based on the poisons on the slain enemy. This damage is not affected by your damage modifiers. Requires a Claw or Dagger.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.AttackCanRepeat] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.ChaosSkill] = true, },
	weaponTypes = {
		["Dagger"] = true,
		["Claw"] = true,
	},
	statDescriptionScope = "debuff_skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 27),
	},
	qualityStats = {
		{ "poison_dot_multiplier_+", 0.5 },
	},
	stats = {
		"mamba_strike_deal_%_of_all_poison_total_damage_per_minute",
		"base_secondary_skill_effect_duration",
		"base_chance_to_poison_on_hit_%",
		"skill_physical_damage_%_to_convert_to_chaos",
		"active_skill_poison_duration_+%_final",
		"attack_minimum_added_chaos_damage",
		"attack_maximum_added_chaos_damage",
	},
	levels = {
		[1] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.25, duration = 1, manaCost = 6, damageEffectiveness = 1.25, levelRequirement = 28, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[2] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.268, duration = 1, manaCost = 6, damageEffectiveness = 1.27, levelRequirement = 31, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[3] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.287, duration = 1, manaCost = 6, damageEffectiveness = 1.29, levelRequirement = 34, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[4] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.305, duration = 1, manaCost = 6, damageEffectiveness = 1.31, levelRequirement = 37, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[5] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.324, duration = 1, manaCost = 6, damageEffectiveness = 1.32, levelRequirement = 40, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[6] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.342, duration = 1, manaCost = 6, damageEffectiveness = 1.34, levelRequirement = 42, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[7] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.36, duration = 1, manaCost = 6, damageEffectiveness = 1.36, levelRequirement = 44, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[8] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.379, duration = 1, manaCost = 6, damageEffectiveness = 1.38, levelRequirement = 46, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[9] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.397, duration = 1, manaCost = 6, damageEffectiveness = 1.4, levelRequirement = 48, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[10] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.416, duration = 1, manaCost = 6, damageEffectiveness = 1.42, levelRequirement = 50, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[11] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.434, duration = 1, manaCost = 6, damageEffectiveness = 1.43, levelRequirement = 52, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[12] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.452, duration = 1, manaCost = 6, damageEffectiveness = 1.45, levelRequirement = 54, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[13] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.471, duration = 1, manaCost = 6, damageEffectiveness = 1.47, levelRequirement = 56, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[14] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.489, duration = 1, manaCost = 6, damageEffectiveness = 1.49, levelRequirement = 58, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[15] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.508, duration = 1, manaCost = 6, damageEffectiveness = 1.51, levelRequirement = 60, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[16] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.526, duration = 1, manaCost = 6, damageEffectiveness = 1.53, levelRequirement = 62, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[17] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.544, duration = 1, manaCost = 6, damageEffectiveness = 1.54, levelRequirement = 64, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[18] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.563, duration = 1, manaCost = 6, damageEffectiveness = 1.56, levelRequirement = 66, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[19] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.581, duration = 1, manaCost = 6, damageEffectiveness = 1.58, levelRequirement = 68, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[20] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.6, duration = 1, manaCost = 6, damageEffectiveness = 1.6, levelRequirement = 70, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[21] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.618, duration = 1, manaCost = 6, damageEffectiveness = 1.62, levelRequirement = 72, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[22] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.637, duration = 1, manaCost = 6, damageEffectiveness = 1.64, levelRequirement = 74, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[23] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.655, duration = 1, manaCost = 6, damageEffectiveness = 1.66, levelRequirement = 76, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[24] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.673, duration = 1, manaCost = 6, damageEffectiveness = 1.67, levelRequirement = 78, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[25] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.692, duration = 1, manaCost = 6, damageEffectiveness = 1.69, levelRequirement = 80, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[26] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.71, duration = 1, manaCost = 6, damageEffectiveness = 1.71, levelRequirement = 82, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[27] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.729, duration = 1, manaCost = 6, damageEffectiveness = 1.73, levelRequirement = 84, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[28] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.747, duration = 1, manaCost = 6, damageEffectiveness = 1.75, levelRequirement = 86, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[29] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.765, duration = 1, manaCost = 6, damageEffectiveness = 1.77, levelRequirement = 88, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[30] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.784, duration = 1, manaCost = 6, damageEffectiveness = 1.78, levelRequirement = 90, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[31] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.784, duration = 1, manaCost = 6, damageEffectiveness = 1.78, levelRequirement = 91, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[32] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.802, duration = 1, manaCost = 6, damageEffectiveness = 1.8, levelRequirement = 92, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[33] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.821, duration = 1, manaCost = 6, damageEffectiveness = 1.82, levelRequirement = 93, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[34] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.839, duration = 1, manaCost = 6, damageEffectiveness = 1.84, levelRequirement = 94, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[35] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.857, duration = 1, manaCost = 6, damageEffectiveness = 1.86, levelRequirement = 95, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[36] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.876, duration = 1, manaCost = 6, damageEffectiveness = 1.88, levelRequirement = 96, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[37] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.894, duration = 1, manaCost = 6, damageEffectiveness = 1.89, levelRequirement = 97, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[38] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.913, duration = 1, manaCost = 6, damageEffectiveness = 1.91, levelRequirement = 98, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[39] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.931, duration = 1, manaCost = 6, damageEffectiveness = 1.93, levelRequirement = 99, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[40] = { 3000, 1000, 60, 50, 30, 0.80000001192093, 1.2000000476837, baseMultiplier = 1.949, duration = 1, manaCost = 6, damageEffectiveness = 1.95, levelRequirement = 100, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
	},
}
skills["NewPhaseRun"] = {
	name = "Phase Run",
	color = 2,
	description = "Gain a buff that makes you faster, harder to detect, and grants Phasing, letting you pass through enemies. Performing any skill replaces this buff with one that boosts melee physical damage of skills you use yourself (it will not apply to your melee skills used by totems). Consumes Frenzy Charges to increase duration.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Duration] = true, [SkillType.Triggerable] = true, [SkillType.MovementSkill] = true, [SkillType.Instant] = true, [SkillType.PhysicalSkill] = true, [SkillType.TravelSkill] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0,
	statMap = {
		["phase_run_melee_physical_damage_+%_final"] = {
			mod("PhysicalDamage", "MORE", nil, ModFlag.Melee, 0, { type = "SkillType", skillType = SkillType.Totem, neg = true }, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["base_movement_velocity_+%"] = {
			mod("MovementSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
	},
	baseFlags = {
		spell = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "base_movement_velocity_+%", 0.5 },
	},
	stats = {
		"base_movement_velocity_+%",
		"phase_run_melee_physical_damage_+%_final",
		"enemy_aggro_radius_+%",
		"base_skill_effect_duration",
		"base_secondary_skill_effect_duration",
		"skill_effect_duration_+%_per_removable_frenzy_charge",
		"phase_through_objects",
		"instant_skill_is_added_to_held_skills_list",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 30, 20, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 34, manaCost = 8, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[2] = { 30, 21, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 36, manaCost = 8, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[3] = { 31, 21, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 38, manaCost = 9, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[4] = { 31, 22, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 40, manaCost = 9, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[5] = { 32, 22, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 42, manaCost = 9, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[6] = { 32, 23, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 44, manaCost = 9, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[7] = { 33, 23, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 46, manaCost = 10, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[8] = { 33, 24, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 48, manaCost = 10, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[9] = { 34, 24, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 50, manaCost = 10, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[10] = { 34, 25, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 52, manaCost = 11, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[11] = { 35, 25, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 54, manaCost = 11, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[12] = { 35, 26, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 56, manaCost = 11, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[13] = { 36, 26, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 58, manaCost = 11, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[14] = { 36, 27, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 60, manaCost = 12, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[15] = { 37, 27, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 62, manaCost = 12, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[16] = { 37, 28, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 64, manaCost = 12, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[17] = { 38, 28, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 66, manaCost = 13, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[18] = { 38, 29, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 68, manaCost = 13, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[19] = { 39, 29, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 69, manaCost = 13, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[20] = { 39, 30, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 70, manaCost = 13, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[21] = { 40, 30, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 72, manaCost = 13, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[22] = { 40, 31, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 74, manaCost = 14, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[23] = { 41, 31, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 76, manaCost = 14, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[24] = { 41, 32, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 78, manaCost = 14, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[25] = { 42, 32, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 80, manaCost = 15, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[26] = { 42, 33, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 82, manaCost = 15, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[27] = { 43, 33, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 84, manaCost = 15, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[28] = { 43, 34, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 86, manaCost = 15, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[29] = { 44, 34, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 88, manaCost = 16, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[30] = { 44, 35, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 90, manaCost = 16, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[31] = { 44, 35, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 91, manaCost = 16, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[32] = { 45, 35, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 92, manaCost = 16, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[33] = { 45, 35, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 93, manaCost = 16, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[34] = { 45, 36, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 94, manaCost = 17, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[35] = { 45, 36, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 95, manaCost = 17, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[36] = { 46, 36, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 96, manaCost = 17, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[37] = { 46, 36, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 97, manaCost = 17, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[38] = { 46, 37, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 98, manaCost = 17, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[39] = { 46, 37, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 99, manaCost = 17, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[40] = { 47, 37, -50, 1800, 200, 100, cooldown = 4, levelRequirement = 100, manaCost = 17, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
	},
}
skills["CorrosiveShroud"] = {
	name = "Plague Bearer",
	color = 2,
	baseEffectiveness = 31.920000076294,
	incrementalEffectiveness = 0.10670000314713,
	description = "Gain an Incubating buff, adding to its Plague Value as you inflict poisons. Use the skill again to begin Infecting, dealing chaos damage over time to nearby enemies until the Plague Value is depleted. Your damage modifiers don't apply to this skill's damage. Using the skill again alternates between Incubating and Infecting.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.ChaosSkill] = true, [SkillType.Area] = true, [SkillType.Instant] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0,
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
		skill("radius", 25),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 0.5 },
	},
	stats = {
		"corrosive_shroud_maximum_stored_poison_damage",
		"corrosive_shroud_gains_%_of_damage_from_inflicted_poisons",
		"corrosive_shroud_%_of_stored_poison_damage_to_deal_per_second",
		"active_skill_base_radius_+",
		"corrosive_shroud_poison_damage_+%_final_while_accumulating_poison",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 1, 40, 12, 0, -20, cooldown = 0.5, levelRequirement = 24, manaCost = 6, statInterpolation = { 3, 1, 1, 1, 1, }, },
		[2] = { 1, 40, 12, 0, -20, cooldown = 0.5, levelRequirement = 27, manaCost = 7, statInterpolation = { 3, 1, 1, 1, 1, }, },
		[3] = { 1, 40, 12, 0, -20, cooldown = 0.5, levelRequirement = 30, manaCost = 7, statInterpolation = { 3, 1, 1, 1, 1, }, },
		[4] = { 1, 40, 12, 0, -20, cooldown = 0.5, levelRequirement = 33, manaCost = 8, statInterpolation = { 3, 1, 1, 1, 1, }, },
		[5] = { 1, 40, 12, 0, -20, cooldown = 0.5, levelRequirement = 36, manaCost = 8, statInterpolation = { 3, 1, 1, 1, 1, }, },
		[6] = { 1, 40, 12, 1, -20, cooldown = 0.5, levelRequirement = 39, manaCost = 9, statInterpolation = { 3, 1, 1, 1, 1, }, },
		[7] = { 1, 40, 12, 1, -20, cooldown = 0.5, levelRequirement = 42, manaCost = 9, statInterpolation = { 3, 1, 1, 1, 1, }, },
		[8] = { 1, 40, 12, 1, -20, cooldown = 0.5, levelRequirement = 45, manaCost = 10, statInterpolation = { 3, 1, 1, 1, 1, }, },
		[9] = { 1, 40, 12, 1, -20, cooldown = 0.5, levelRequirement = 48, manaCost = 10, statInterpolation = { 3, 1, 1, 1, 1, }, },
		[10] = { 1, 40, 12, 1, -20, cooldown = 0.5, levelRequirement = 50, manaCost = 10, statInterpolation = { 3, 1, 1, 1, 1, }, },
		[11] = { 1, 40, 12, 2, -20, cooldown = 0.5, levelRequirement = 52, manaCost = 11, statInterpolation = { 3, 1, 1, 1, 1, }, },
		[12] = { 1, 40, 12, 2, -20, cooldown = 0.5, levelRequirement = 54, manaCost = 11, statInterpolation = { 3, 1, 1, 1, 1, }, },
		[13] = { 1, 40, 12, 2, -20, cooldown = 0.5, levelRequirement = 56, manaCost = 11, statInterpolation = { 3, 1, 1, 1, 1, }, },
		[14] = { 1, 40, 12, 2, -20, cooldown = 0.5, levelRequirement = 58, manaCost = 11, statInterpolation = { 3, 1, 1, 1, 1, }, },
		[15] = { 1, 40, 12, 2, -20, cooldown = 0.5, levelRequirement = 60, manaCost = 12, statInterpolation = { 3, 1, 1, 1, 1, }, },
		[16] = { 1, 40, 12, 3, -20, cooldown = 0.5, levelRequirement = 62, manaCost = 12, statInterpolation = { 3, 1, 1, 1, 1, }, },
		[17] = { 1, 40, 12, 3, -20, cooldown = 0.5, levelRequirement = 64, manaCost = 12, statInterpolation = { 3, 1, 1, 1, 1, }, },
		[18] = { 1, 40, 12, 3, -20, cooldown = 0.5, levelRequirement = 66, manaCost = 13, statInterpolation = { 3, 1, 1, 1, 1, }, },
		[19] = { 1, 40, 12, 3, -20, cooldown = 0.5, levelRequirement = 68, manaCost = 13, statInterpolation = { 3, 1, 1, 1, 1, }, },
		[20] = { 1000000, 40, 12, 3, -20, cooldown = 0.5, levelRequirement = 70, manaCost = 13, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[21] = { 1100000, 40, 12, 4, -20, cooldown = 0.5, levelRequirement = 72, manaCost = 13, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[22] = { 1180000, 40, 12, 4, -20, cooldown = 0.5, levelRequirement = 74, manaCost = 14, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[23] = { 1245000, 40, 12, 4, -20, cooldown = 0.5, levelRequirement = 76, manaCost = 14, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[24] = { 1300000, 40, 12, 4, -20, cooldown = 0.5, levelRequirement = 78, manaCost = 14, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[25] = { 1350000, 40, 12, 4, -20, cooldown = 0.5, levelRequirement = 80, manaCost = 15, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[26] = { 1400000, 40, 12, 5, -20, cooldown = 0.5, levelRequirement = 82, manaCost = 15, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[27] = { 1450000, 40, 12, 5, -20, cooldown = 0.5, levelRequirement = 84, manaCost = 15, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[28] = { 1500000, 40, 12, 5, -20, cooldown = 0.5, levelRequirement = 86, manaCost = 15, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[29] = { 1550000, 40, 12, 5, -20, cooldown = 0.5, levelRequirement = 88, manaCost = 16, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[30] = { 1600000, 40, 12, 5, -20, cooldown = 0.5, levelRequirement = 90, manaCost = 16, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[31] = { 1650000, 40, 12, 6, -20, cooldown = 0.5, levelRequirement = 91, manaCost = 16, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[32] = { 1700000, 40, 12, 6, -20, cooldown = 0.5, levelRequirement = 92, manaCost = 16, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[33] = { 1750000, 40, 12, 6, -20, cooldown = 0.5, levelRequirement = 93, manaCost = 16, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[34] = { 1800000, 40, 12, 6, -20, cooldown = 0.5, levelRequirement = 94, manaCost = 17, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[35] = { 1850000, 40, 12, 6, -20, cooldown = 0.5, levelRequirement = 95, manaCost = 17, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[36] = { 1900000, 40, 12, 7, -20, cooldown = 0.5, levelRequirement = 96, manaCost = 17, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[37] = { 1950000, 40, 12, 7, -20, cooldown = 0.5, levelRequirement = 97, manaCost = 17, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[38] = { 2000000, 40, 12, 7, -20, cooldown = 0.5, levelRequirement = 98, manaCost = 17, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[39] = { 2050000, 40, 12, 7, -20, cooldown = 0.5, levelRequirement = 99, manaCost = 17, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[40] = { 2000000, 40, 12, 7, -20, cooldown = 0.5, levelRequirement = 100, manaCost = 17, statInterpolation = { 1, 1, 1, 1, 1, }, },
	},
}
skills["PoachersMark"] = {
	name = "Poacher's Mark",
	color = 2,
	description = "Curses all targets in an area, making them less evasive. Hitting the cursed targets will grant life and mana, and killing them will result in more flask charges and a chance to gain a frenzy charge.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.SkillCanTrap] = true, [SkillType.SkillCanTotem] = true, [SkillType.SkillCanMine] = true, [SkillType.SpellCanRepeat] = true, [SkillType.Curse] = true, [SkillType.Triggerable] = true, [SkillType.SpellCanCascade] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 0.5,
	statMap = {
		["evasion_rating_+%_final_from_poachers_mark"] = {
			mod("Evasion", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
		["life_granted_when_hit_by_attacks"] = {
			mod("SelfLifeOnHit", "BASE", nil, ModFlag.Attack, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
		["mana_granted_when_hit_by_attacks"] = {
			mod("SelfManaOnHit", "BASE", nil, ModFlag.Attack, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("debuff", true),
		skill("radius", 22),
	},
	qualityStats = {
		{ "chance_to_grant_frenzy_charge_on_death_%", 0.5 },
	},
	stats = {
		"base_skill_effect_duration",
		"active_skill_base_radius_+",
		"evasion_rating_+%_final_from_poachers_mark",
		"monster_slain_flask_charges_granted_+%",
		"life_granted_when_hit_by_attacks",
		"mana_granted_when_hit_by_attacks",
		"chance_to_grant_frenzy_charge_on_death_%",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 6000, 0, -30, 100, 5, 5, 21, manaCost = 24, levelRequirement = 24, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[2] = { 6200, 1, -31, 100, 6, 6, 21, manaCost = 26, levelRequirement = 27, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[3] = { 6400, 1, -32, 100, 7, 6, 22, manaCost = 27, levelRequirement = 30, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[4] = { 6600, 2, -33, 100, 8, 6, 22, manaCost = 29, levelRequirement = 33, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[5] = { 6800, 2, -34, 100, 9, 7, 23, manaCost = 30, levelRequirement = 36, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[6] = { 7000, 3, -35, 100, 10, 7, 23, manaCost = 32, levelRequirement = 39, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[7] = { 7200, 3, -36, 100, 11, 7, 24, manaCost = 34, levelRequirement = 42, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[8] = { 7400, 4, -37, 100, 12, 8, 24, manaCost = 35, levelRequirement = 45, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[9] = { 7600, 4, -38, 100, 13, 8, 25, manaCost = 37, levelRequirement = 48, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[10] = { 7800, 5, -39, 100, 14, 8, 25, manaCost = 38, levelRequirement = 50, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[11] = { 8000, 5, -40, 100, 15, 9, 26, manaCost = 39, levelRequirement = 52, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[12] = { 8200, 6, -41, 100, 16, 9, 26, manaCost = 40, levelRequirement = 54, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[13] = { 8400, 6, -42, 100, 17, 9, 27, manaCost = 42, levelRequirement = 56, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[14] = { 8600, 7, -43, 100, 18, 10, 27, manaCost = 43, levelRequirement = 58, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[15] = { 8800, 7, -44, 100, 19, 10, 28, manaCost = 44, levelRequirement = 60, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[16] = { 9000, 8, -45, 100, 20, 10, 28, manaCost = 45, levelRequirement = 62, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[17] = { 9200, 8, -46, 100, 21, 11, 29, manaCost = 46, levelRequirement = 64, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[18] = { 9400, 9, -47, 100, 22, 11, 29, manaCost = 47, levelRequirement = 66, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[19] = { 9600, 9, -48, 100, 23, 11, 30, manaCost = 48, levelRequirement = 68, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[20] = { 9800, 10, -49, 100, 24, 12, 30, manaCost = 50, levelRequirement = 70, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[21] = { 10000, 10, -50, 100, 25, 12, 31, manaCost = 51, levelRequirement = 72, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[22] = { 10200, 11, -51, 100, 26, 12, 31, manaCost = 52, levelRequirement = 74, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[23] = { 10400, 11, -52, 100, 27, 13, 32, manaCost = 53, levelRequirement = 76, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[24] = { 10600, 12, -53, 100, 28, 13, 32, manaCost = 54, levelRequirement = 78, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[25] = { 10800, 12, -54, 100, 29, 13, 33, manaCost = 56, levelRequirement = 80, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[26] = { 11000, 13, -55, 100, 30, 14, 33, manaCost = 57, levelRequirement = 82, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[27] = { 11200, 13, -56, 100, 31, 14, 34, manaCost = 58, levelRequirement = 84, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[28] = { 11400, 14, -57, 100, 32, 14, 34, manaCost = 59, levelRequirement = 86, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[29] = { 11600, 14, -58, 100, 33, 15, 35, manaCost = 60, levelRequirement = 88, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[30] = { 11800, 15, -59, 100, 34, 15, 35, manaCost = 61, levelRequirement = 90, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[31] = { 11900, 15, -59, 100, 34, 15, 35, manaCost = 63, levelRequirement = 91, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[32] = { 12000, 15, -60, 100, 35, 15, 36, manaCost = 65, levelRequirement = 92, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[33] = { 12100, 15, -60, 100, 35, 15, 36, manaCost = 66, levelRequirement = 93, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[34] = { 12200, 16, -61, 100, 36, 16, 36, manaCost = 67, levelRequirement = 94, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[35] = { 12300, 16, -61, 100, 36, 16, 36, manaCost = 68, levelRequirement = 95, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[36] = { 12400, 16, -62, 100, 37, 16, 37, manaCost = 70, levelRequirement = 96, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[37] = { 12500, 16, -62, 100, 37, 16, 37, manaCost = 71, levelRequirement = 97, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[38] = { 12600, 17, -63, 100, 38, 16, 37, manaCost = 72, levelRequirement = 98, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[39] = { 12700, 17, -63, 100, 38, 16, 37, manaCost = 73, levelRequirement = 99, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[40] = { 12800, 17, -64, 100, 39, 17, 38, manaCost = 75, levelRequirement = 100, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
	},
}
skills["AccuracyAndCritsAura"] = {
	name = "Precision",
	color = 2,
	description = "Casts an aura that grants accuracy and critical strike chance to you and your allies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Buff] = true, [SkillType.ManaCostReserved] = true, [SkillType.Type27] = true, [SkillType.SkillCanTotem] = true, [SkillType.Aura] = true, [SkillType.Instant] = true, [SkillType.AreaSpell] = true, [SkillType.CanHaveBlessing] = true, },
	statDescriptionScope = "aura_skill_stat_descriptions",
	castTime = 0,
	statMap = {
		["accuracy_rating"] = {
			mod("Accuracy", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["critical_strike_chance_+%"] = {
			mod("CritChance", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
	},
	baseMods = {
		skill("radius", 40),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 2 },
	},
	stats = {
		"accuracy_rating",
		"critical_strike_chance_+%",
		"active_skill_base_radius_+",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 93, 40, 0, cooldown = 1.2, levelRequirement = 10, manaCost = 22, statInterpolation = { 1, 1, 1, }, },
		[2] = { 128, 41, 1, cooldown = 1.2, levelRequirement = 13, manaCost = 32, statInterpolation = { 1, 1, 1, }, },
		[3] = { 162, 42, 2, cooldown = 1.2, levelRequirement = 17, manaCost = 40, statInterpolation = { 1, 1, 1, }, },
		[4] = { 193, 43, 3, cooldown = 1.2, levelRequirement = 21, manaCost = 50, statInterpolation = { 1, 1, 1, }, },
		[5] = { 223, 44, 4, cooldown = 1.2, levelRequirement = 25, manaCost = 59, statInterpolation = { 1, 1, 1, }, },
		[6] = { 276, 45, 5, cooldown = 1.2, levelRequirement = 29, manaCost = 68, statInterpolation = { 1, 1, 1, }, },
		[7] = { 305, 46, 6, cooldown = 1.2, levelRequirement = 33, manaCost = 76, statInterpolation = { 1, 1, 1, }, },
		[8] = { 332, 47, 7, cooldown = 1.2, levelRequirement = 36, manaCost = 86, statInterpolation = { 1, 1, 1, }, },
		[9] = { 359, 48, 8, cooldown = 1.2, levelRequirement = 39, manaCost = 94, statInterpolation = { 1, 1, 1, }, },
		[10] = { 385, 49, 9, cooldown = 1.2, levelRequirement = 42, manaCost = 102, statInterpolation = { 1, 1, 1, }, },
		[11] = { 444, 50, 10, cooldown = 1.2, levelRequirement = 45, manaCost = 110, statInterpolation = { 1, 1, 1, }, },
		[12] = { 469, 51, 11, cooldown = 1.2, levelRequirement = 48, manaCost = 118, statInterpolation = { 1, 1, 1, }, },
		[13] = { 493, 52, 12, cooldown = 1.2, levelRequirement = 51, manaCost = 126, statInterpolation = { 1, 1, 1, }, },
		[14] = { 516, 53, 13, cooldown = 1.2, levelRequirement = 54, manaCost = 135, statInterpolation = { 1, 1, 1, }, },
		[15] = { 539, 54, 14, cooldown = 1.2, levelRequirement = 57, manaCost = 142, statInterpolation = { 1, 1, 1, }, },
		[16] = { 606, 55, 15, cooldown = 1.2, levelRequirement = 60, manaCost = 151, statInterpolation = { 1, 1, 1, }, },
		[17] = { 630, 56, 16, cooldown = 1.2, levelRequirement = 63, manaCost = 159, statInterpolation = { 1, 1, 1, }, },
		[18] = { 653, 57, 17, cooldown = 1.2, levelRequirement = 66, manaCost = 167, statInterpolation = { 1, 1, 1, }, },
		[19] = { 677, 58, 18, cooldown = 1.2, levelRequirement = 68, manaCost = 176, statInterpolation = { 1, 1, 1, }, },
		[20] = { 701, 59, 19, cooldown = 1.2, levelRequirement = 70, manaCost = 186, statInterpolation = { 1, 1, 1, }, },
		[21] = { 778, 60, 20, cooldown = 1.2, levelRequirement = 72, manaCost = 195, statInterpolation = { 1, 1, 1, }, },
		[22] = { 804, 61, 21, cooldown = 1.2, levelRequirement = 74, manaCost = 202, statInterpolation = { 1, 1, 1, }, },
		[23] = { 831, 62, 22, cooldown = 1.2, levelRequirement = 76, manaCost = 208, statInterpolation = { 1, 1, 1, }, },
		[24] = { 857, 63, 23, cooldown = 1.2, levelRequirement = 78, manaCost = 215, statInterpolation = { 1, 1, 1, }, },
		[25] = { 883, 64, 24, cooldown = 1.2, levelRequirement = 80, manaCost = 222, statInterpolation = { 1, 1, 1, }, },
		[26] = { 972, 65, 25, cooldown = 1.2, levelRequirement = 82, manaCost = 228, statInterpolation = { 1, 1, 1, }, },
		[27] = { 1000, 66, 26, cooldown = 1.2, levelRequirement = 84, manaCost = 235, statInterpolation = { 1, 1, 1, }, },
		[28] = { 1029, 67, 27, cooldown = 1.2, levelRequirement = 86, manaCost = 242, statInterpolation = { 1, 1, 1, }, },
		[29] = { 1058, 68, 28, cooldown = 1.2, levelRequirement = 88, manaCost = 248, statInterpolation = { 1, 1, 1, }, },
		[30] = { 1087, 69, 29, cooldown = 1.2, levelRequirement = 90, manaCost = 255, statInterpolation = { 1, 1, 1, }, },
		[31] = { 1172, 70, 29, cooldown = 1.2, levelRequirement = 91, manaCost = 270, statInterpolation = { 1, 1, 1, }, },
		[32] = { 1187, 71, 30, cooldown = 1.2, levelRequirement = 92, manaCost = 278, statInterpolation = { 1, 1, 1, }, },
		[33] = { 1203, 72, 30, cooldown = 1.2, levelRequirement = 93, manaCost = 286, statInterpolation = { 1, 1, 1, }, },
		[34] = { 1218, 73, 31, cooldown = 1.2, levelRequirement = 94, manaCost = 294, statInterpolation = { 1, 1, 1, }, },
		[35] = { 1233, 74, 31, cooldown = 1.2, levelRequirement = 95, manaCost = 303, statInterpolation = { 1, 1, 1, }, },
		[36] = { 1324, 75, 32, cooldown = 1.2, levelRequirement = 96, manaCost = 311, statInterpolation = { 1, 1, 1, }, },
		[37] = { 1340, 76, 32, cooldown = 1.2, levelRequirement = 97, manaCost = 319, statInterpolation = { 1, 1, 1, }, },
		[38] = { 1357, 77, 33, cooldown = 1.2, levelRequirement = 98, manaCost = 327, statInterpolation = { 1, 1, 1, }, },
		[39] = { 1374, 78, 33, cooldown = 1.2, levelRequirement = 99, manaCost = 335, statInterpolation = { 1, 1, 1, }, },
		[40] = { 1390, 79, 34, cooldown = 1.2, levelRequirement = 100, manaCost = 343, statInterpolation = { 1, 1, 1, }, },
	},
}
skills["ProjectileWeakness"] = {
	name = "Projectile Weakness",
	color = 2,
	description = "Curses all targets in an area, making them easier to pierce and to knock back, and increasing the damage they take from projectiles.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.SkillCanTrap] = true, [SkillType.SkillCanTotem] = true, [SkillType.SkillCanMine] = true, [SkillType.SpellCanRepeat] = true, [SkillType.Curse] = true, [SkillType.Triggerable] = true, [SkillType.SpellCanCascade] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 0.5,
	statMap = {
		["projectiles_always_pierce_you"] = {
			flag("AlwaysPierceSelf", { type = "GlobalEffect", effectType = "Curse" }),
		},
		["chance_to_be_knocked_back_%"] = {
			mod("SelfKnockbackChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
		["projectile_damage_taken_+%"] = {
			mod("ProjectileDamageTaken", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("debuff", true),
		skill("radius", 22),
	},
	qualityStats = {
		{ "projectile_damage_taken_+%", 0.5 },
	},
	stats = {
		"base_skill_effect_duration",
		"active_skill_base_radius_+",
		"projectiles_always_pierce_you",
		"chance_to_be_knocked_back_%",
		"projectile_damage_taken_+%",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 9000, 0, 1, 25, 25, manaCost = 16, levelRequirement = 24, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[2] = { 9100, 1, 1, 25, 26, manaCost = 17, levelRequirement = 27, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[3] = { 9200, 1, 1, 25, 27, manaCost = 18, levelRequirement = 30, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[4] = { 9300, 2, 1, 25, 28, manaCost = 19, levelRequirement = 33, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[5] = { 9400, 2, 1, 25, 29, manaCost = 21, levelRequirement = 36, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[6] = { 9500, 3, 1, 25, 30, manaCost = 22, levelRequirement = 39, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[7] = { 9600, 3, 1, 25, 31, manaCost = 23, levelRequirement = 42, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[8] = { 9700, 4, 1, 25, 32, manaCost = 24, levelRequirement = 45, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[9] = { 9800, 4, 1, 25, 33, manaCost = 25, levelRequirement = 48, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[10] = { 9900, 5, 1, 25, 34, manaCost = 26, levelRequirement = 50, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[11] = { 10000, 5, 1, 25, 35, manaCost = 26, levelRequirement = 52, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[12] = { 10100, 6, 1, 25, 36, manaCost = 27, levelRequirement = 54, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[13] = { 10200, 6, 1, 25, 37, manaCost = 28, levelRequirement = 56, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[14] = { 10300, 7, 1, 25, 38, manaCost = 29, levelRequirement = 58, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[15] = { 10400, 7, 1, 25, 39, manaCost = 29, levelRequirement = 60, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[16] = { 10500, 8, 1, 25, 40, manaCost = 30, levelRequirement = 62, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[17] = { 10600, 8, 1, 25, 41, manaCost = 31, levelRequirement = 64, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[18] = { 10700, 9, 1, 25, 42, manaCost = 31, levelRequirement = 66, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[19] = { 10800, 9, 1, 25, 43, manaCost = 32, levelRequirement = 68, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[20] = { 10900, 10, 1, 25, 44, manaCost = 33, levelRequirement = 70, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[21] = { 11000, 10, 1, 25, 45, manaCost = 34, levelRequirement = 72, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[22] = { 11100, 11, 1, 25, 46, manaCost = 34, levelRequirement = 74, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[23] = { 11200, 11, 1, 25, 47, manaCost = 35, levelRequirement = 76, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[24] = { 11300, 12, 1, 25, 48, manaCost = 36, levelRequirement = 78, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[25] = { 11400, 12, 1, 25, 49, manaCost = 36, levelRequirement = 80, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[26] = { 11500, 13, 1, 25, 50, manaCost = 37, levelRequirement = 82, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[27] = { 11600, 13, 1, 25, 51, manaCost = 38, levelRequirement = 84, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[28] = { 11700, 14, 1, 25, 52, manaCost = 39, levelRequirement = 86, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[29] = { 11800, 14, 1, 25, 53, manaCost = 39, levelRequirement = 88, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[30] = { 11900, 15, 1, 25, 54, manaCost = 40, levelRequirement = 90, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[31] = { 11950, 15, 1, 25, 54, manaCost = 40, levelRequirement = 91, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[32] = { 12000, 15, 1, 25, 55, manaCost = 41, levelRequirement = 92, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[33] = { 12050, 15, 1, 25, 55, manaCost = 41, levelRequirement = 93, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[34] = { 12100, 16, 1, 25, 56, manaCost = 42, levelRequirement = 94, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[35] = { 12150, 16, 1, 25, 56, manaCost = 42, levelRequirement = 95, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[36] = { 12200, 16, 1, 25, 57, manaCost = 42, levelRequirement = 96, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[37] = { 12250, 16, 1, 25, 57, manaCost = 43, levelRequirement = 97, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[38] = { 12300, 17, 1, 25, 58, manaCost = 43, levelRequirement = 98, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[39] = { 12350, 17, 1, 25, 58, manaCost = 43, levelRequirement = 99, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[40] = { 12400, 17, 1, 25, 59, manaCost = 44, levelRequirement = 100, statInterpolation = { 1, 1, 1, 1, 1, }, },
	},
}
skills["Puncture"] = {
	name = "Puncture",
	color = 2,
	baseEffectiveness = 0.6700000166893,
	incrementalEffectiveness = 0.023299999535084,
	description = "Punctures enemies, causing a bleeding debuff, which will be affected by modifiers to skill duration. Puncture works with bows, daggers, claws or swords.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.ProjectileAttack] = true, [SkillType.SkillCanMirageArcher] = true, [SkillType.Projectile] = true, [SkillType.SkillCanVolley] = true, [SkillType.Duration] = true, [SkillType.SkillCanTrap] = true, [SkillType.SkillCanMine] = true, [SkillType.SkillCanTotem] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.AttackCanRepeat] = true, [SkillType.Melee] = true, [SkillType.DamageOverTime] = true, [SkillType.Triggerable] = true, [SkillType.PhysicalSkill] = true, },
	weaponTypes = {
		["Bow"] = true,
		["Claw"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["puncture_bleeding_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, KeywordFlag.Bleed),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
		duration = true,
	},
	baseMods = {
		skill("bleedIsSkillEffect", true),
	},
	qualityStats = {
		{ "faster_bleed_%", 0.5 },
	},
	stats = {
		"base_skill_effect_duration",
		"melee_range_+",
		"attack_minimum_added_physical_damage",
		"attack_maximum_added_physical_damage",
		"puncture_bleeding_damage_+%_final",
		"skill_can_fire_arrows",
		"global_bleed_on_hit",
		"bleed_duration_is_skill_duration",
	},
	levels = {
		[1] = { 8000, 0, 0.80000001192093, 1.2000000476837, 30, baseMultiplier = 1.3474, manaCost = 6, damageEffectiveness = 1.35, attackSpeedMultiplier = -30, levelRequirement = 4, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[2] = { 8000, 0, 0.80000001192093, 1.2000000476837, 31, baseMultiplier = 1.3628, manaCost = 6, damageEffectiveness = 1.36, attackSpeedMultiplier = -30, levelRequirement = 6, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[3] = { 8000, 0, 0.80000001192093, 1.2000000476837, 32, baseMultiplier = 1.3782, manaCost = 6, damageEffectiveness = 1.38, attackSpeedMultiplier = -30, levelRequirement = 9, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[4] = { 8000, 0, 0.80000001192093, 1.2000000476837, 33, baseMultiplier = 1.3945, manaCost = 6, damageEffectiveness = 1.4, attackSpeedMultiplier = -30, levelRequirement = 12, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[5] = { 8000, 0, 0.80000001192093, 1.2000000476837, 34, baseMultiplier = 1.4099, manaCost = 6, damageEffectiveness = 1.41, attackSpeedMultiplier = -30, levelRequirement = 16, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[6] = { 8000, 0, 0.80000001192093, 1.2000000476837, 35, baseMultiplier = 1.4254, manaCost = 6, damageEffectiveness = 1.42, attackSpeedMultiplier = -30, levelRequirement = 20, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[7] = { 8000, 1, 0.80000001192093, 1.2000000476837, 36, baseMultiplier = 1.4416, manaCost = 6, damageEffectiveness = 1.44, attackSpeedMultiplier = -30, levelRequirement = 24, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[8] = { 8000, 1, 0.80000001192093, 1.2000000476837, 37, baseMultiplier = 1.4571, manaCost = 6, damageEffectiveness = 1.46, attackSpeedMultiplier = -30, levelRequirement = 28, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[9] = { 8000, 1, 0.80000001192093, 1.2000000476837, 38, baseMultiplier = 1.4725, manaCost = 6, damageEffectiveness = 1.47, attackSpeedMultiplier = -30, levelRequirement = 32, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[10] = { 8000, 1, 0.80000001192093, 1.2000000476837, 39, baseMultiplier = 1.4888, manaCost = 6, damageEffectiveness = 1.49, attackSpeedMultiplier = -30, levelRequirement = 36, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[11] = { 8000, 1, 0.80000001192093, 1.2000000476837, 40, baseMultiplier = 1.5042, manaCost = 6, damageEffectiveness = 1.51, attackSpeedMultiplier = -30, levelRequirement = 40, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[12] = { 8000, 1, 0.80000001192093, 1.2000000476837, 41, baseMultiplier = 1.5196, manaCost = 6, damageEffectiveness = 1.52, attackSpeedMultiplier = -30, levelRequirement = 44, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[13] = { 8000, 1, 0.80000001192093, 1.2000000476837, 42, baseMultiplier = 1.5359, manaCost = 6, damageEffectiveness = 1.53, attackSpeedMultiplier = -30, levelRequirement = 48, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[14] = { 8000, 2, 0.80000001192093, 1.2000000476837, 43, baseMultiplier = 1.5514, manaCost = 6, damageEffectiveness = 1.55, attackSpeedMultiplier = -30, levelRequirement = 52, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[15] = { 8000, 2, 0.80000001192093, 1.2000000476837, 44, baseMultiplier = 1.5668, manaCost = 6, damageEffectiveness = 1.57, attackSpeedMultiplier = -30, levelRequirement = 55, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[16] = { 8000, 2, 0.80000001192093, 1.2000000476837, 45, baseMultiplier = 1.5831, manaCost = 6, damageEffectiveness = 1.59, attackSpeedMultiplier = -30, levelRequirement = 58, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[17] = { 8000, 2, 0.80000001192093, 1.2000000476837, 46, baseMultiplier = 1.5985, manaCost = 6, damageEffectiveness = 1.6, attackSpeedMultiplier = -30, levelRequirement = 61, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[18] = { 8000, 2, 0.80000001192093, 1.2000000476837, 47, baseMultiplier = 1.6139, manaCost = 6, damageEffectiveness = 1.61, attackSpeedMultiplier = -30, levelRequirement = 64, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[19] = { 8000, 2, 0.80000001192093, 1.2000000476837, 48, baseMultiplier = 1.6302, manaCost = 6, damageEffectiveness = 1.63, attackSpeedMultiplier = -30, levelRequirement = 67, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[20] = { 8000, 2, 0.80000001192093, 1.2000000476837, 49, baseMultiplier = 1.6456, manaCost = 6, damageEffectiveness = 1.65, attackSpeedMultiplier = -30, levelRequirement = 70, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[21] = { 8000, 3, 0.80000001192093, 1.2000000476837, 50, baseMultiplier = 1.6611, manaCost = 6, damageEffectiveness = 1.66, attackSpeedMultiplier = -30, levelRequirement = 72, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[22] = { 8000, 3, 0.80000001192093, 1.2000000476837, 51, baseMultiplier = 1.6773, manaCost = 6, damageEffectiveness = 1.68, attackSpeedMultiplier = -30, levelRequirement = 74, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[23] = { 8000, 3, 0.80000001192093, 1.2000000476837, 52, baseMultiplier = 1.6928, manaCost = 6, damageEffectiveness = 1.7, attackSpeedMultiplier = -30, levelRequirement = 76, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[24] = { 8000, 3, 0.80000001192093, 1.2000000476837, 53, baseMultiplier = 1.7082, manaCost = 6, damageEffectiveness = 1.71, attackSpeedMultiplier = -30, levelRequirement = 78, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[25] = { 8000, 3, 0.80000001192093, 1.2000000476837, 54, baseMultiplier = 1.7245, manaCost = 6, damageEffectiveness = 1.72, attackSpeedMultiplier = -30, levelRequirement = 80, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[26] = { 8000, 3, 0.80000001192093, 1.2000000476837, 55, baseMultiplier = 1.7399, manaCost = 6, damageEffectiveness = 1.74, attackSpeedMultiplier = -30, levelRequirement = 82, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[27] = { 8000, 3, 0.80000001192093, 1.2000000476837, 56, baseMultiplier = 1.7553, manaCost = 6, damageEffectiveness = 1.76, attackSpeedMultiplier = -30, levelRequirement = 84, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[28] = { 8000, 4, 0.80000001192093, 1.2000000476837, 57, baseMultiplier = 1.7716, manaCost = 6, damageEffectiveness = 1.77, attackSpeedMultiplier = -30, levelRequirement = 86, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[29] = { 8000, 4, 0.80000001192093, 1.2000000476837, 58, baseMultiplier = 1.7871, manaCost = 6, damageEffectiveness = 1.79, attackSpeedMultiplier = -30, levelRequirement = 88, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[30] = { 8000, 4, 0.80000001192093, 1.2000000476837, 59, baseMultiplier = 1.8025, manaCost = 6, damageEffectiveness = 1.8, attackSpeedMultiplier = -30, levelRequirement = 90, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[31] = { 8000, 4, 0.80000001192093, 1.2000000476837, 60, baseMultiplier = 1.8111, manaCost = 6, damageEffectiveness = 1.81, attackSpeedMultiplier = -30, levelRequirement = 91, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[32] = { 8000, 4, 0.80000001192093, 1.2000000476837, 61, baseMultiplier = 1.8188, manaCost = 6, damageEffectiveness = 1.82, attackSpeedMultiplier = -30, levelRequirement = 92, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[33] = { 8000, 4, 0.80000001192093, 1.2000000476837, 62, baseMultiplier = 1.8265, manaCost = 6, damageEffectiveness = 1.83, attackSpeedMultiplier = -30, levelRequirement = 93, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[34] = { 8000, 4, 0.80000001192093, 1.2000000476837, 63, baseMultiplier = 1.8342, manaCost = 6, damageEffectiveness = 1.83, attackSpeedMultiplier = -30, levelRequirement = 94, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[35] = { 8000, 5, 0.80000001192093, 1.2000000476837, 64, baseMultiplier = 1.8419, manaCost = 6, damageEffectiveness = 1.84, attackSpeedMultiplier = -30, levelRequirement = 95, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[36] = { 8000, 5, 0.80000001192093, 1.2000000476837, 65, baseMultiplier = 1.8496, manaCost = 6, damageEffectiveness = 1.85, attackSpeedMultiplier = -30, levelRequirement = 96, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[37] = { 8000, 5, 0.80000001192093, 1.2000000476837, 66, baseMultiplier = 1.8582, manaCost = 6, damageEffectiveness = 1.86, attackSpeedMultiplier = -30, levelRequirement = 97, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[38] = { 8000, 5, 0.80000001192093, 1.2000000476837, 67, baseMultiplier = 1.8659, manaCost = 6, damageEffectiveness = 1.87, attackSpeedMultiplier = -30, levelRequirement = 98, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[39] = { 8000, 5, 0.80000001192093, 1.2000000476837, 68, baseMultiplier = 1.8736, manaCost = 6, damageEffectiveness = 1.88, attackSpeedMultiplier = -30, levelRequirement = 99, statInterpolation = { 1, 1, 3, 3, 1, }, },
		[40] = { 8000, 5, 0.80000001192093, 1.2000000476837, 69, baseMultiplier = 1.8813, manaCost = 6, damageEffectiveness = 1.89, attackSpeedMultiplier = -30, levelRequirement = 100, statInterpolation = { 1, 1, 3, 3, 1, }, },
	},
}
skills["ColdResistAura"] = {
	name = "Purity of Ice",
	color = 2,
	description = "Casts an aura that grants cold resistance to you and your allies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Buff] = true, [SkillType.ManaCostReserved] = true, [SkillType.Type27] = true, [SkillType.ManaCostPercent] = true, [SkillType.SkillCanTotem] = true, [SkillType.Aura] = true, [SkillType.ColdSkill] = true, [SkillType.Instant] = true, [SkillType.AreaSpell] = true, [SkillType.CanHaveBlessing] = true, },
	statDescriptionScope = "aura_skill_stat_descriptions",
	castTime = 0,
	statMap = {
		["base_cold_damage_resistance_%"] = {
			mod("ColdResist", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["base_maximum_cold_damage_resistance_%"] = {
			mod("ColdResistMax", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
	},
	baseMods = {
		skill("radius", 40),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 2 },
	},
	stats = {
		"base_cold_damage_resistance_%",
		"base_maximum_cold_damage_resistance_%",
		"active_skill_base_radius_+",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 22, 0, 0, cooldown = 1.2, levelRequirement = 24, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[2] = { 23, 0, 1, cooldown = 1.2, levelRequirement = 27, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[3] = { 24, 0, 2, cooldown = 1.2, levelRequirement = 30, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[4] = { 25, 0, 3, cooldown = 1.2, levelRequirement = 33, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[5] = { 26, 1, 4, cooldown = 1.2, levelRequirement = 36, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[6] = { 27, 1, 5, cooldown = 1.2, levelRequirement = 39, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[7] = { 28, 1, 6, cooldown = 1.2, levelRequirement = 42, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[8] = { 29, 1, 7, cooldown = 1.2, levelRequirement = 45, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[9] = { 30, 1, 8, cooldown = 1.2, levelRequirement = 48, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[10] = { 31, 1, 9, cooldown = 1.2, levelRequirement = 50, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[11] = { 32, 2, 10, cooldown = 1.2, levelRequirement = 52, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[12] = { 33, 2, 11, cooldown = 1.2, levelRequirement = 54, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[13] = { 34, 2, 12, cooldown = 1.2, levelRequirement = 56, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[14] = { 35, 2, 13, cooldown = 1.2, levelRequirement = 58, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[15] = { 36, 2, 14, cooldown = 1.2, levelRequirement = 60, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[16] = { 37, 2, 15, cooldown = 1.2, levelRequirement = 62, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[17] = { 38, 3, 16, cooldown = 1.2, levelRequirement = 64, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[18] = { 39, 3, 17, cooldown = 1.2, levelRequirement = 66, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[19] = { 40, 3, 18, cooldown = 1.2, levelRequirement = 68, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[20] = { 41, 4, 19, cooldown = 1.2, levelRequirement = 70, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[21] = { 42, 4, 20, cooldown = 1.2, levelRequirement = 72, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[22] = { 43, 4, 21, cooldown = 1.2, levelRequirement = 74, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[23] = { 44, 5, 22, cooldown = 1.2, levelRequirement = 76, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[24] = { 45, 5, 23, cooldown = 1.2, levelRequirement = 78, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[25] = { 46, 5, 24, cooldown = 1.2, levelRequirement = 80, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[26] = { 47, 5, 25, cooldown = 1.2, levelRequirement = 82, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[27] = { 48, 5, 26, cooldown = 1.2, levelRequirement = 84, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[28] = { 49, 5, 27, cooldown = 1.2, levelRequirement = 86, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[29] = { 50, 5, 28, cooldown = 1.2, levelRequirement = 88, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[30] = { 51, 5, 29, cooldown = 1.2, levelRequirement = 90, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[31] = { 51, 5, 29, cooldown = 1.2, levelRequirement = 91, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[32] = { 52, 5, 30, cooldown = 1.2, levelRequirement = 92, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[33] = { 52, 5, 30, cooldown = 1.2, levelRequirement = 93, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[34] = { 53, 5, 31, cooldown = 1.2, levelRequirement = 94, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[35] = { 53, 5, 31, cooldown = 1.2, levelRequirement = 95, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[36] = { 54, 5, 32, cooldown = 1.2, levelRequirement = 96, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[37] = { 54, 5, 32, cooldown = 1.2, levelRequirement = 97, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[38] = { 55, 5, 33, cooldown = 1.2, levelRequirement = 98, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[39] = { 55, 5, 33, cooldown = 1.2, levelRequirement = 99, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
		[40] = { 56, 5, 34, cooldown = 1.2, levelRequirement = 100, manaCost = 35, statInterpolation = { 1, 1, 1, }, },
	},
}
skills["ColdImpurity"] = {
	name = "Vaal Impurity of Ice",
	color = 2,
	description = "Casts an aura that reduces cold damage taken and provides freeze and chill immunity to you and nearby allies, and makes hits against nearby enemies ignore their cold resistance. ",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Area] = true, [SkillType.SkillCanTotem] = true, [SkillType.Type27] = true, [SkillType.Duration] = true, [SkillType.Vaal] = true, [SkillType.Aura] = true, [SkillType.AreaSpell] = true, [SkillType.ColdSkill] = true, },
	statDescriptionScope = "aura_skill_stat_descriptions",
	castTime = 0,
	statMap = {
		["hits_ignore_my_cold_resistance"] = {
			flag("SelfIgnoreColdResistance", { type = "GlobalEffect", effectType = "Debuff" }),
		},
		["impurity_cold_damage_taken_+%_final"] = {
			mod("ColdDamageTaken", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 2 },
	},
	stats = {
		"impurity_cold_damage_taken_+%_final",
		"active_skill_base_radius_+",
		"base_skill_effect_duration",
		"aura_effect_+%",
		"base_deal_no_damage",
		"base_immune_to_freeze",
		"hits_ignore_my_cold_resistance",
		"base_immune_to_chill",
		"modifiers_to_skill_effect_duration_also_affect_soul_prevention_duration",
	},
	levels = {
		[1] = { -25, 14, 3000, 0, cooldown = 0.5, levelRequirement = 24, statInterpolation = { 1, 1, 1, 1, }, },
		[2] = { -25, 14, 3000, 4, cooldown = 0.5, levelRequirement = 27, statInterpolation = { 1, 1, 1, 1, }, },
		[3] = { -25, 14, 3000, 8, cooldown = 0.5, levelRequirement = 30, statInterpolation = { 1, 1, 1, 1, }, },
		[4] = { -25, 15, 3000, 12, cooldown = 0.5, levelRequirement = 33, statInterpolation = { 1, 1, 1, 1, }, },
		[5] = { -25, 15, 3000, 16, cooldown = 0.5, levelRequirement = 36, statInterpolation = { 1, 1, 1, 1, }, },
		[6] = { -25, 15, 3000, 20, cooldown = 0.5, levelRequirement = 39, statInterpolation = { 1, 1, 1, 1, }, },
		[7] = { -25, 16, 3000, 24, cooldown = 0.5, levelRequirement = 42, statInterpolation = { 1, 1, 1, 1, }, },
		[8] = { -25, 16, 3000, 28, cooldown = 0.5, levelRequirement = 45, statInterpolation = { 1, 1, 1, 1, }, },
		[9] = { -25, 16, 3000, 32, cooldown = 0.5, levelRequirement = 48, statInterpolation = { 1, 1, 1, 1, }, },
		[10] = { -25, 17, 3000, 36, cooldown = 0.5, levelRequirement = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[11] = { -25, 17, 3000, 40, cooldown = 0.5, levelRequirement = 52, statInterpolation = { 1, 1, 1, 1, }, },
		[12] = { -25, 17, 3000, 44, cooldown = 0.5, levelRequirement = 54, statInterpolation = { 1, 1, 1, 1, }, },
		[13] = { -25, 18, 3000, 48, cooldown = 0.5, levelRequirement = 56, statInterpolation = { 1, 1, 1, 1, }, },
		[14] = { -25, 18, 3000, 52, cooldown = 0.5, levelRequirement = 58, statInterpolation = { 1, 1, 1, 1, }, },
		[15] = { -25, 18, 3000, 56, cooldown = 0.5, levelRequirement = 60, statInterpolation = { 1, 1, 1, 1, }, },
		[16] = { -25, 19, 3000, 60, cooldown = 0.5, levelRequirement = 62, statInterpolation = { 1, 1, 1, 1, }, },
		[17] = { -25, 19, 3000, 64, cooldown = 0.5, levelRequirement = 64, statInterpolation = { 1, 1, 1, 1, }, },
		[18] = { -25, 19, 3000, 68, cooldown = 0.5, levelRequirement = 66, statInterpolation = { 1, 1, 1, 1, }, },
		[19] = { -25, 20, 3000, 72, cooldown = 0.5, levelRequirement = 68, statInterpolation = { 1, 1, 1, 1, }, },
		[20] = { -25, 20, 3000, 76, cooldown = 0.5, levelRequirement = 70, statInterpolation = { 1, 1, 1, 1, }, },
		[21] = { -25, 20, 3000, 80, cooldown = 0.5, levelRequirement = 72, statInterpolation = { 1, 1, 1, 1, }, },
		[22] = { -25, 21, 3000, 84, cooldown = 0.5, levelRequirement = 74, statInterpolation = { 1, 1, 1, 1, }, },
		[23] = { -25, 21, 3000, 88, cooldown = 0.5, levelRequirement = 76, statInterpolation = { 1, 1, 1, 1, }, },
		[24] = { -25, 21, 3000, 92, cooldown = 0.5, levelRequirement = 78, statInterpolation = { 1, 1, 1, 1, }, },
		[25] = { -25, 22, 3000, 96, cooldown = 0.5, levelRequirement = 80, statInterpolation = { 1, 1, 1, 1, }, },
		[26] = { -25, 22, 3000, 100, cooldown = 0.5, levelRequirement = 82, statInterpolation = { 1, 1, 1, 1, }, },
		[27] = { -25, 22, 3000, 104, cooldown = 0.5, levelRequirement = 84, statInterpolation = { 1, 1, 1, 1, }, },
		[28] = { -25, 23, 3000, 108, cooldown = 0.5, levelRequirement = 86, statInterpolation = { 1, 1, 1, 1, }, },
		[29] = { -25, 23, 3000, 112, cooldown = 0.5, levelRequirement = 88, statInterpolation = { 1, 1, 1, 1, }, },
		[30] = { -25, 23, 3000, 116, cooldown = 0.5, levelRequirement = 90, statInterpolation = { 1, 1, 1, 1, }, },
		[31] = { -25, 23, 3000, 118, cooldown = 0.5, levelRequirement = 91, statInterpolation = { 1, 1, 1, 1, }, },
		[32] = { -25, 24, 3000, 120, cooldown = 0.5, levelRequirement = 92, statInterpolation = { 1, 1, 1, 1, }, },
		[33] = { -25, 24, 3000, 122, cooldown = 0.5, levelRequirement = 93, statInterpolation = { 1, 1, 1, 1, }, },
		[34] = { -25, 24, 3000, 124, cooldown = 0.5, levelRequirement = 94, statInterpolation = { 1, 1, 1, 1, }, },
		[35] = { -25, 24, 3000, 126, cooldown = 0.5, levelRequirement = 95, statInterpolation = { 1, 1, 1, 1, }, },
		[36] = { -25, 24, 3000, 128, cooldown = 0.5, levelRequirement = 96, statInterpolation = { 1, 1, 1, 1, }, },
		[37] = { -25, 24, 3000, 130, cooldown = 0.5, levelRequirement = 97, statInterpolation = { 1, 1, 1, 1, }, },
		[38] = { -25, 25, 3000, 132, cooldown = 0.5, levelRequirement = 98, statInterpolation = { 1, 1, 1, 1, }, },
		[39] = { -25, 25, 3000, 134, cooldown = 0.5, levelRequirement = 99, statInterpolation = { 1, 1, 1, 1, }, },
		[40] = { -25, 25, 3000, 136, cooldown = 0.5, levelRequirement = 100, statInterpolation = { 1, 1, 1, 1, }, },
	},
}
skills["RainOfArrows"] = {
	name = "Rain of Arrows",
	color = 2,
	description = "Fires multiple arrows into the air, to land in sequence after a delay, starting at the targeted location and spreading outwards in all directions. Each arrow deals damage in an area around it. Half of the arrows will land directly on targets if there are targets in their range.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.ProjectileAttack] = true, [SkillType.SkillCanMirageArcher] = true, [SkillType.Area] = true, [SkillType.ProjectileDamage] = true, [SkillType.Type73] = true, [SkillType.SkillCanTotem] = true, [SkillType.SkillCanTrap] = true, [SkillType.SkillCanMine] = true, [SkillType.Triggerable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
	},
	baseMods = {
		skill("radius", 24),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 0.5 },
	},
	stats = {
		"active_skill_base_radius_+",
		"base_number_of_additional_arrows",
		"base_is_projectile",
		"is_area_damage",
		"skill_can_fire_arrows",
		"cannot_pierce",
	},
	levels = {
		[1] = { 0, 17, damageEffectiveness = 0.4, baseMultiplier = 0.4, levelRequirement = 12, manaCost = 7, statInterpolation = { 1, 1, }, },
		[2] = { 0, 17, damageEffectiveness = 0.4, baseMultiplier = 0.405, levelRequirement = 15, manaCost = 7, statInterpolation = { 1, 1, }, },
		[3] = { 0, 17, damageEffectiveness = 0.41, baseMultiplier = 0.411, levelRequirement = 19, manaCost = 7, statInterpolation = { 1, 1, }, },
		[4] = { 0, 17, damageEffectiveness = 0.42, baseMultiplier = 0.416, levelRequirement = 23, manaCost = 8, statInterpolation = { 1, 1, }, },
		[5] = { 0, 18, damageEffectiveness = 0.42, baseMultiplier = 0.421, levelRequirement = 27, manaCost = 8, statInterpolation = { 1, 1, }, },
		[6] = { 0, 18, damageEffectiveness = 0.43, baseMultiplier = 0.426, levelRequirement = 31, manaCost = 8, statInterpolation = { 1, 1, }, },
		[7] = { 0, 18, damageEffectiveness = 0.43, baseMultiplier = 0.432, levelRequirement = 35, manaCost = 8, statInterpolation = { 1, 1, }, },
		[8] = { 0, 18, damageEffectiveness = 0.44, baseMultiplier = 0.437, levelRequirement = 38, manaCost = 8, statInterpolation = { 1, 1, }, },
		[9] = { 0, 19, damageEffectiveness = 0.44, baseMultiplier = 0.442, levelRequirement = 41, manaCost = 9, statInterpolation = { 1, 1, }, },
		[10] = { 0, 19, damageEffectiveness = 0.45, baseMultiplier = 0.448, levelRequirement = 44, manaCost = 9, statInterpolation = { 1, 1, }, },
		[11] = { 0, 19, damageEffectiveness = 0.45, baseMultiplier = 0.453, levelRequirement = 47, manaCost = 9, statInterpolation = { 1, 1, }, },
		[12] = { 0, 19, damageEffectiveness = 0.46, baseMultiplier = 0.458, levelRequirement = 50, manaCost = 9, statInterpolation = { 1, 1, }, },
		[13] = { 0, 20, damageEffectiveness = 0.46, baseMultiplier = 0.463, levelRequirement = 53, manaCost = 9, statInterpolation = { 1, 1, }, },
		[14] = { 0, 20, damageEffectiveness = 0.47, baseMultiplier = 0.469, levelRequirement = 56, manaCost = 10, statInterpolation = { 1, 1, }, },
		[15] = { 0, 20, damageEffectiveness = 0.47, baseMultiplier = 0.474, levelRequirement = 59, manaCost = 10, statInterpolation = { 1, 1, }, },
		[16] = { 0, 20, damageEffectiveness = 0.48, baseMultiplier = 0.479, levelRequirement = 62, manaCost = 10, statInterpolation = { 1, 1, }, },
		[17] = { 0, 21, damageEffectiveness = 0.48, baseMultiplier = 0.484, levelRequirement = 64, manaCost = 10, statInterpolation = { 1, 1, }, },
		[18] = { 0, 21, damageEffectiveness = 0.49, baseMultiplier = 0.49, levelRequirement = 66, manaCost = 10, statInterpolation = { 1, 1, }, },
		[19] = { 0, 21, damageEffectiveness = 0.49, baseMultiplier = 0.495, levelRequirement = 68, manaCost = 11, statInterpolation = { 1, 1, }, },
		[20] = { 0, 21, damageEffectiveness = 0.5, baseMultiplier = 0.5, levelRequirement = 70, manaCost = 11, statInterpolation = { 1, 1, }, },
		[21] = { 0, 22, damageEffectiveness = 0.51, baseMultiplier = 0.506, levelRequirement = 72, manaCost = 11, statInterpolation = { 1, 1, }, },
		[22] = { 0, 22, damageEffectiveness = 0.51, baseMultiplier = 0.511, levelRequirement = 74, manaCost = 11, statInterpolation = { 1, 1, }, },
		[23] = { 0, 22, damageEffectiveness = 0.52, baseMultiplier = 0.516, levelRequirement = 76, manaCost = 11, statInterpolation = { 1, 1, }, },
		[24] = { 0, 22, damageEffectiveness = 0.52, baseMultiplier = 0.521, levelRequirement = 78, manaCost = 11, statInterpolation = { 1, 1, }, },
		[25] = { 0, 23, damageEffectiveness = 0.53, baseMultiplier = 0.527, levelRequirement = 80, manaCost = 11, statInterpolation = { 1, 1, }, },
		[26] = { 0, 23, damageEffectiveness = 0.53, baseMultiplier = 0.532, levelRequirement = 82, manaCost = 12, statInterpolation = { 1, 1, }, },
		[27] = { 0, 23, damageEffectiveness = 0.54, baseMultiplier = 0.537, levelRequirement = 84, manaCost = 12, statInterpolation = { 1, 1, }, },
		[28] = { 0, 23, damageEffectiveness = 0.54, baseMultiplier = 0.543, levelRequirement = 86, manaCost = 12, statInterpolation = { 1, 1, }, },
		[29] = { 0, 24, damageEffectiveness = 0.55, baseMultiplier = 0.548, levelRequirement = 88, manaCost = 12, statInterpolation = { 1, 1, }, },
		[30] = { 0, 24, damageEffectiveness = 0.55, baseMultiplier = 0.553, levelRequirement = 90, manaCost = 12, statInterpolation = { 1, 1, }, },
		[31] = { 0, 24, damageEffectiveness = 0.56, baseMultiplier = 0.5555, levelRequirement = 91, manaCost = 13, statInterpolation = { 1, 1, }, },
		[32] = { 0, 24, damageEffectiveness = 0.56, baseMultiplier = 0.558, levelRequirement = 92, manaCost = 13, statInterpolation = { 1, 1, }, },
		[33] = { 0, 24, damageEffectiveness = 0.56, baseMultiplier = 0.5605, levelRequirement = 93, manaCost = 13, statInterpolation = { 1, 1, }, },
		[34] = { 0, 24, damageEffectiveness = 0.56, baseMultiplier = 0.563, levelRequirement = 94, manaCost = 13, statInterpolation = { 1, 1, }, },
		[35] = { 0, 24, damageEffectiveness = 0.57, baseMultiplier = 0.5655, levelRequirement = 95, manaCost = 13, statInterpolation = { 1, 1, }, },
		[36] = { 0, 25, damageEffectiveness = 0.57, baseMultiplier = 0.568, levelRequirement = 96, manaCost = 14, statInterpolation = { 1, 1, }, },
		[37] = { 0, 25, damageEffectiveness = 0.57, baseMultiplier = 0.5705, levelRequirement = 97, manaCost = 14, statInterpolation = { 1, 1, }, },
		[38] = { 0, 25, damageEffectiveness = 0.57, baseMultiplier = 0.573, levelRequirement = 98, manaCost = 14, statInterpolation = { 1, 1, }, },
		[39] = { 0, 25, damageEffectiveness = 0.58, baseMultiplier = 0.5755, levelRequirement = 99, manaCost = 14, statInterpolation = { 1, 1, }, },
		[40] = { 0, 25, damageEffectiveness = 0.58, baseMultiplier = 0.578, levelRequirement = 100, manaCost = 14, statInterpolation = { 1, 1, }, },
	},
}
skills["VaalRainOfArrows"] = {
	name = "Vaal Rain of Arrows",
	color = 2,
	description = "Fires multiple arrows into the air, to land in multiple sequences after a delay, each starting at the targeted location and spreading outwards in all directions. Each arrow deals damage in an area around it. Half of the arrows will land directly on targets if there are targets in their range.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.ProjectileAttack] = true, [SkillType.Area] = true, [SkillType.ProjectileDamage] = true, [SkillType.Type73] = true, [SkillType.SkillCanTotem] = true, [SkillType.SkillCanTrap] = true, [SkillType.SkillCanMine] = true, [SkillType.Vaal] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
		duration = true,
		vaal = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 0.5 },
	},
	stats = {
		"active_skill_base_radius_+",
		"base_number_of_additional_arrows",
		"rain_of_arrows_additional_sequences",
		"maim_effect_+%",
		"base_is_projectile",
		"is_area_damage",
		"global_maim_on_hit",
		"skill_can_fire_arrows",
		"cannot_pierce",
		"global_always_hit",
		"cannot_cancel_skill_before_contact_point",
	},
	levels = {
		[1] = { 0, 17, 3, 150, damageEffectiveness = 0.8, baseMultiplier = 0.8, levelRequirement = 12, statInterpolation = { 1, 1, 1, 1, }, },
		[2] = { 0, 17, 3, 150, damageEffectiveness = 0.81, baseMultiplier = 0.811, levelRequirement = 15, statInterpolation = { 1, 1, 1, 1, }, },
		[3] = { 0, 17, 3, 150, damageEffectiveness = 0.82, baseMultiplier = 0.821, levelRequirement = 19, statInterpolation = { 1, 1, 1, 1, }, },
		[4] = { 0, 17, 3, 150, damageEffectiveness = 0.83, baseMultiplier = 0.832, levelRequirement = 23, statInterpolation = { 1, 1, 1, 1, }, },
		[5] = { 0, 18, 3, 150, damageEffectiveness = 0.84, baseMultiplier = 0.842, levelRequirement = 27, statInterpolation = { 1, 1, 1, 1, }, },
		[6] = { 0, 18, 3, 150, damageEffectiveness = 0.85, baseMultiplier = 0.853, levelRequirement = 31, statInterpolation = { 1, 1, 1, 1, }, },
		[7] = { 0, 18, 3, 150, damageEffectiveness = 0.86, baseMultiplier = 0.863, levelRequirement = 35, statInterpolation = { 1, 1, 1, 1, }, },
		[8] = { 0, 18, 3, 150, damageEffectiveness = 0.87, baseMultiplier = 0.874, levelRequirement = 38, statInterpolation = { 1, 1, 1, 1, }, },
		[9] = { 0, 19, 3, 150, damageEffectiveness = 0.88, baseMultiplier = 0.884, levelRequirement = 41, statInterpolation = { 1, 1, 1, 1, }, },
		[10] = { 0, 19, 3, 150, damageEffectiveness = 0.89, baseMultiplier = 0.895, levelRequirement = 44, statInterpolation = { 1, 1, 1, 1, }, },
		[11] = { 0, 19, 3, 150, damageEffectiveness = 0.91, baseMultiplier = 0.906, levelRequirement = 47, statInterpolation = { 1, 1, 1, 1, }, },
		[12] = { 0, 19, 3, 150, damageEffectiveness = 0.92, baseMultiplier = 0.916, levelRequirement = 50, statInterpolation = { 1, 1, 1, 1, }, },
		[13] = { 0, 20, 3, 150, damageEffectiveness = 0.93, baseMultiplier = 0.927, levelRequirement = 53, statInterpolation = { 1, 1, 1, 1, }, },
		[14] = { 0, 20, 3, 150, damageEffectiveness = 0.94, baseMultiplier = 0.937, levelRequirement = 56, statInterpolation = { 1, 1, 1, 1, }, },
		[15] = { 0, 20, 3, 150, damageEffectiveness = 0.95, baseMultiplier = 0.948, levelRequirement = 59, statInterpolation = { 1, 1, 1, 1, }, },
		[16] = { 0, 20, 3, 150, damageEffectiveness = 0.96, baseMultiplier = 0.958, levelRequirement = 62, statInterpolation = { 1, 1, 1, 1, }, },
		[17] = { 0, 21, 3, 150, damageEffectiveness = 0.97, baseMultiplier = 0.969, levelRequirement = 64, statInterpolation = { 1, 1, 1, 1, }, },
		[18] = { 0, 21, 3, 150, damageEffectiveness = 0.98, baseMultiplier = 0.98, levelRequirement = 66, statInterpolation = { 1, 1, 1, 1, }, },
		[19] = { 0, 21, 3, 150, damageEffectiveness = 0.99, baseMultiplier = 0.99, levelRequirement = 68, statInterpolation = { 1, 1, 1, 1, }, },
		[20] = { 0, 21, 3, 150, baseMultiplier = 1.001, levelRequirement = 70, statInterpolation = { 1, 1, 1, 1, }, },
		[21] = { 0, 22, 3, 150, damageEffectiveness = 1.01, baseMultiplier = 1.011, levelRequirement = 72, statInterpolation = { 1, 1, 1, 1, }, },
		[22] = { 0, 22, 3, 150, damageEffectiveness = 1.02, baseMultiplier = 1.022, levelRequirement = 74, statInterpolation = { 1, 1, 1, 1, }, },
		[23] = { 0, 22, 3, 150, damageEffectiveness = 1.03, baseMultiplier = 1.032, levelRequirement = 76, statInterpolation = { 1, 1, 1, 1, }, },
		[24] = { 0, 22, 3, 150, damageEffectiveness = 1.04, baseMultiplier = 1.043, levelRequirement = 78, statInterpolation = { 1, 1, 1, 1, }, },
		[25] = { 0, 23, 3, 150, damageEffectiveness = 1.05, baseMultiplier = 1.053, levelRequirement = 80, statInterpolation = { 1, 1, 1, 1, }, },
		[26] = { 0, 23, 3, 150, damageEffectiveness = 1.06, baseMultiplier = 1.064, levelRequirement = 82, statInterpolation = { 1, 1, 1, 1, }, },
		[27] = { 0, 23, 3, 150, damageEffectiveness = 1.08, baseMultiplier = 1.075, levelRequirement = 84, statInterpolation = { 1, 1, 1, 1, }, },
		[28] = { 0, 23, 3, 150, damageEffectiveness = 1.09, baseMultiplier = 1.085, levelRequirement = 86, statInterpolation = { 1, 1, 1, 1, }, },
		[29] = { 0, 24, 3, 150, damageEffectiveness = 1.1, baseMultiplier = 1.096, levelRequirement = 88, statInterpolation = { 1, 1, 1, 1, }, },
		[30] = { 0, 24, 3, 150, damageEffectiveness = 1.11, baseMultiplier = 1.106, levelRequirement = 90, statInterpolation = { 1, 1, 1, 1, }, },
		[31] = { 0, 24, 3, 150, damageEffectiveness = 1.12, baseMultiplier = 1.117, levelRequirement = 91, statInterpolation = { 1, 1, 1, 1, }, },
		[32] = { 0, 24, 3, 150, damageEffectiveness = 1.13, baseMultiplier = 1.127, levelRequirement = 92, statInterpolation = { 1, 1, 1, 1, }, },
		[33] = { 0, 24, 3, 150, damageEffectiveness = 1.14, baseMultiplier = 1.138, levelRequirement = 93, statInterpolation = { 1, 1, 1, 1, }, },
		[34] = { 0, 24, 3, 150, damageEffectiveness = 1.15, baseMultiplier = 1.148, levelRequirement = 94, statInterpolation = { 1, 1, 1, 1, }, },
		[35] = { 0, 24, 3, 150, damageEffectiveness = 1.16, baseMultiplier = 1.159, levelRequirement = 95, statInterpolation = { 1, 1, 1, 1, }, },
		[36] = { 0, 25, 3, 150, damageEffectiveness = 1.17, baseMultiplier = 1.17, levelRequirement = 96, statInterpolation = { 1, 1, 1, 1, }, },
		[37] = { 0, 25, 3, 150, damageEffectiveness = 1.18, baseMultiplier = 1.18, levelRequirement = 97, statInterpolation = { 1, 1, 1, 1, }, },
		[38] = { 0, 25, 3, 150, damageEffectiveness = 1.19, baseMultiplier = 1.191, levelRequirement = 98, statInterpolation = { 1, 1, 1, 1, }, },
		[39] = { 0, 25, 3, 150, damageEffectiveness = 1.2, baseMultiplier = 1.201, levelRequirement = 99, statInterpolation = { 1, 1, 1, 1, }, },
		[40] = { 0, 25, 3, 150, damageEffectiveness = 1.21, baseMultiplier = 1.212, levelRequirement = 100, statInterpolation = { 1, 1, 1, 1, }, },
	},
}
skills["Reave"] = {
	name = "Reave",
	color = 2,
	description = "Attacks a small area in front of you. Each Reave that hits an enemy grants stages, which you will begin to lose after a short period without hitting anything. Only works with Daggers, Claws, and One-Handed Swords.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.AttackCanRepeat] = true, [SkillType.Melee] = true, },
	weaponTypes = {
		["Thrusting One Handed Sword"] = true,
		["One Handed Sword"] = true,
		["Dagger"] = true,
		["Claw"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "No stages",
		},
		{
			name = "4 stages",
		},
		{ 
			name = "8 stages",
		},
	},
	statMap = {
		["reave_area_of_effect_+%_final_per_stage"] = {
			mod("AreaOfEffect", "MORE", nil, 0, 0, { type = "Multiplier", var = "ReaveStage" }),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("radius", 20),
		mod("Multiplier:ReaveStage", "BASE", 4, 0, 0, { type = "SkillPart", skillPart = 2 }),
		mod("Multiplier:ReaveStage", "BASE", 8, 0, 0, { type = "SkillPart", skillPart = 3 }),
	},
	qualityStats = {
		{ "attack_speed_+%", 0.5 },
	},
	stats = {
		"reave_area_of_effect_+%_final_per_stage",
		"active_skill_base_radius_+",
		"is_area_damage",
		"console_skill_dont_chase",
	},
	levels = {
		[1] = { 50, 0, damageEffectiveness = 1.35, baseMultiplier = 1.35, levelRequirement = 12, manaCost = 6, statInterpolation = { 1, 1, }, },
		[2] = { 50, 0, damageEffectiveness = 1.36, baseMultiplier = 1.361, levelRequirement = 15, manaCost = 6, statInterpolation = { 1, 1, }, },
		[3] = { 50, 0, damageEffectiveness = 1.37, baseMultiplier = 1.371, levelRequirement = 19, manaCost = 6, statInterpolation = { 1, 1, }, },
		[4] = { 50, 0, damageEffectiveness = 1.38, baseMultiplier = 1.382, levelRequirement = 23, manaCost = 6, statInterpolation = { 1, 1, }, },
		[5] = { 50, 0, damageEffectiveness = 1.39, baseMultiplier = 1.392, levelRequirement = 27, manaCost = 6, statInterpolation = { 1, 1, }, },
		[6] = { 50, 0, damageEffectiveness = 1.4, baseMultiplier = 1.403, levelRequirement = 31, manaCost = 6, statInterpolation = { 1, 1, }, },
		[7] = { 50, 0, damageEffectiveness = 1.41, baseMultiplier = 1.413, levelRequirement = 35, manaCost = 6, statInterpolation = { 1, 1, }, },
		[8] = { 50, 0, damageEffectiveness = 1.42, baseMultiplier = 1.424, levelRequirement = 38, manaCost = 6, statInterpolation = { 1, 1, }, },
		[9] = { 50, 0, damageEffectiveness = 1.43, baseMultiplier = 1.434, levelRequirement = 41, manaCost = 6, statInterpolation = { 1, 1, }, },
		[10] = { 50, 1, damageEffectiveness = 1.44, baseMultiplier = 1.445, levelRequirement = 44, manaCost = 6, statInterpolation = { 1, 1, }, },
		[11] = { 50, 1, damageEffectiveness = 1.46, baseMultiplier = 1.455, levelRequirement = 47, manaCost = 6, statInterpolation = { 1, 1, }, },
		[12] = { 50, 1, damageEffectiveness = 1.47, baseMultiplier = 1.466, levelRequirement = 50, manaCost = 6, statInterpolation = { 1, 1, }, },
		[13] = { 50, 1, damageEffectiveness = 1.48, baseMultiplier = 1.476, levelRequirement = 53, manaCost = 6, statInterpolation = { 1, 1, }, },
		[14] = { 50, 1, damageEffectiveness = 1.49, baseMultiplier = 1.487, levelRequirement = 56, manaCost = 6, statInterpolation = { 1, 1, }, },
		[15] = { 50, 1, damageEffectiveness = 1.5, baseMultiplier = 1.497, levelRequirement = 59, manaCost = 6, statInterpolation = { 1, 1, }, },
		[16] = { 50, 1, damageEffectiveness = 1.51, baseMultiplier = 1.508, levelRequirement = 62, manaCost = 6, statInterpolation = { 1, 1, }, },
		[17] = { 50, 1, damageEffectiveness = 1.52, baseMultiplier = 1.518, levelRequirement = 64, manaCost = 6, statInterpolation = { 1, 1, }, },
		[18] = { 50, 1, damageEffectiveness = 1.53, baseMultiplier = 1.529, levelRequirement = 66, manaCost = 6, statInterpolation = { 1, 1, }, },
		[19] = { 50, 1, damageEffectiveness = 1.54, baseMultiplier = 1.539, levelRequirement = 68, manaCost = 6, statInterpolation = { 1, 1, }, },
		[20] = { 50, 2, damageEffectiveness = 1.55, baseMultiplier = 1.55, levelRequirement = 70, manaCost = 6, statInterpolation = { 1, 1, }, },
		[21] = { 50, 2, damageEffectiveness = 1.56, baseMultiplier = 1.561, levelRequirement = 72, manaCost = 6, statInterpolation = { 1, 1, }, },
		[22] = { 50, 2, damageEffectiveness = 1.57, baseMultiplier = 1.571, levelRequirement = 74, manaCost = 6, statInterpolation = { 1, 1, }, },
		[23] = { 50, 2, damageEffectiveness = 1.58, baseMultiplier = 1.582, levelRequirement = 76, manaCost = 6, statInterpolation = { 1, 1, }, },
		[24] = { 50, 2, damageEffectiveness = 1.59, baseMultiplier = 1.592, levelRequirement = 78, manaCost = 6, statInterpolation = { 1, 1, }, },
		[25] = { 50, 2, damageEffectiveness = 1.6, baseMultiplier = 1.603, levelRequirement = 80, manaCost = 6, statInterpolation = { 1, 1, }, },
		[26] = { 50, 2, damageEffectiveness = 1.61, baseMultiplier = 1.613, levelRequirement = 82, manaCost = 6, statInterpolation = { 1, 1, }, },
		[27] = { 50, 2, damageEffectiveness = 1.62, baseMultiplier = 1.624, levelRequirement = 84, manaCost = 6, statInterpolation = { 1, 1, }, },
		[28] = { 50, 2, damageEffectiveness = 1.63, baseMultiplier = 1.634, levelRequirement = 86, manaCost = 6, statInterpolation = { 1, 1, }, },
		[29] = { 50, 2, damageEffectiveness = 1.64, baseMultiplier = 1.645, levelRequirement = 88, manaCost = 6, statInterpolation = { 1, 1, }, },
		[30] = { 50, 3, damageEffectiveness = 1.66, baseMultiplier = 1.655, levelRequirement = 90, manaCost = 6, statInterpolation = { 1, 1, }, },
		[31] = { 50, 3, damageEffectiveness = 1.66, baseMultiplier = 1.661, levelRequirement = 91, manaCost = 6, statInterpolation = { 1, 1, }, },
		[32] = { 50, 3, damageEffectiveness = 1.67, baseMultiplier = 1.666, levelRequirement = 92, manaCost = 6, statInterpolation = { 1, 1, }, },
		[33] = { 50, 3, damageEffectiveness = 1.67, baseMultiplier = 1.671, levelRequirement = 93, manaCost = 6, statInterpolation = { 1, 1, }, },
		[34] = { 50, 3, damageEffectiveness = 1.68, baseMultiplier = 1.676, levelRequirement = 94, manaCost = 6, statInterpolation = { 1, 1, }, },
		[35] = { 50, 3, damageEffectiveness = 1.68, baseMultiplier = 1.682, levelRequirement = 95, manaCost = 6, statInterpolation = { 1, 1, }, },
		[36] = { 50, 3, damageEffectiveness = 1.69, baseMultiplier = 1.687, levelRequirement = 96, manaCost = 6, statInterpolation = { 1, 1, }, },
		[37] = { 50, 3, damageEffectiveness = 1.69, baseMultiplier = 1.692, levelRequirement = 97, manaCost = 6, statInterpolation = { 1, 1, }, },
		[38] = { 50, 3, damageEffectiveness = 1.7, baseMultiplier = 1.697, levelRequirement = 98, manaCost = 6, statInterpolation = { 1, 1, }, },
		[39] = { 50, 3, damageEffectiveness = 1.7, baseMultiplier = 1.703, levelRequirement = 99, manaCost = 6, statInterpolation = { 1, 1, }, },
		[40] = { 50, 3, damageEffectiveness = 1.71, baseMultiplier = 1.708, levelRequirement = 100, manaCost = 6, statInterpolation = { 1, 1, }, },
	},
}
skills["VaalReave"] = {
	name = "Vaal Reave",
	color = 2,
	description = "Repeatedly attacks a large area in different directions. Each Vaal Reave that hits an enemy grants stages, which you will begin to lose after a short period without hitting anything. Only works with Daggers, Claws, and One-Handed Swords.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Vaal] = true, },
	weaponTypes = {
		["Thrusting One Handed Sword"] = true,
		["One Handed Sword"] = true,
		["Dagger"] = true,
		["Claw"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "No Stages",
		},
		{
			name = "4 Stages",
		},
		{ 
			name = "8 Stages",
		},
	},
	statMap = {
		["reave_area_of_effect_+%_final_per_stage"] = {
			mod("AreaOfEffect", "MORE", nil, 0, 0, { type = "Multiplier", var = "ReaveStage" }),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
		vaal = true,
	},
	baseMods = {
		skill("radius", 12),
		mod("Multiplier:ReaveStage", "BASE", 4, 0, 0, { type = "SkillPart", skillPart = 2 }),
		mod("Multiplier:ReaveStage", "BASE", 8, 0, 0, { type = "SkillPart", skillPart = 3 }),
	},
	qualityStats = {
		{ "attack_speed_+%", 0.5 },
	},
	stats = {
		"reave_area_of_effect_+%_final_per_stage",
		"reave_rotation_on_repeat",
		"reave_additional_max_stacks",
		"base_attack_repeat_count",
		"reave_additional_starting_stacks",
		"active_skill_base_radius_+",
		"is_area_damage",
		"global_always_hit",
		"cannot_cancel_skill_before_contact_point",
	},
	levels = {
		[1] = { 50, 135, 4, 7, 4, 0, attackSpeedMultiplier = 150, levelRequirement = 12, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[2] = { 50, 135, 4, 7, 4, 0, damageEffectiveness = 1.01, attackSpeedMultiplier = 150, baseMultiplier = 1.012, levelRequirement = 15, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[3] = { 50, 135, 4, 7, 4, 0, damageEffectiveness = 1.02, attackSpeedMultiplier = 150, baseMultiplier = 1.024, levelRequirement = 19, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[4] = { 50, 135, 4, 7, 4, 0, damageEffectiveness = 1.04, attackSpeedMultiplier = 150, baseMultiplier = 1.036, levelRequirement = 23, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[5] = { 50, 135, 4, 7, 4, 0, damageEffectiveness = 1.05, attackSpeedMultiplier = 150, baseMultiplier = 1.048, levelRequirement = 27, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[6] = { 50, 135, 4, 7, 4, 0, damageEffectiveness = 1.06, attackSpeedMultiplier = 150, baseMultiplier = 1.06, levelRequirement = 31, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[7] = { 50, 135, 4, 7, 4, 0, damageEffectiveness = 1.07, attackSpeedMultiplier = 150, baseMultiplier = 1.072, levelRequirement = 35, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[8] = { 50, 135, 4, 7, 4, 0, damageEffectiveness = 1.08, attackSpeedMultiplier = 150, baseMultiplier = 1.084, levelRequirement = 38, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[9] = { 50, 135, 4, 7, 4, 0, damageEffectiveness = 1.1, attackSpeedMultiplier = 150, baseMultiplier = 1.096, levelRequirement = 41, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[10] = { 50, 135, 4, 7, 4, 1, damageEffectiveness = 1.11, attackSpeedMultiplier = 150, baseMultiplier = 1.108, levelRequirement = 44, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[11] = { 50, 135, 4, 7, 4, 1, damageEffectiveness = 1.12, attackSpeedMultiplier = 150, baseMultiplier = 1.12, levelRequirement = 47, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[12] = { 50, 135, 4, 7, 4, 1, damageEffectiveness = 1.13, attackSpeedMultiplier = 150, baseMultiplier = 1.132, levelRequirement = 50, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[13] = { 50, 135, 4, 7, 4, 1, damageEffectiveness = 1.14, attackSpeedMultiplier = 150, baseMultiplier = 1.144, levelRequirement = 53, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[14] = { 50, 135, 4, 7, 4, 1, damageEffectiveness = 1.16, attackSpeedMultiplier = 150, baseMultiplier = 1.156, levelRequirement = 56, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[15] = { 50, 135, 4, 7, 4, 1, damageEffectiveness = 1.17, attackSpeedMultiplier = 150, baseMultiplier = 1.168, levelRequirement = 59, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[16] = { 50, 135, 4, 7, 4, 1, damageEffectiveness = 1.18, attackSpeedMultiplier = 150, baseMultiplier = 1.18, levelRequirement = 62, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[17] = { 50, 135, 4, 7, 4, 1, damageEffectiveness = 1.19, attackSpeedMultiplier = 150, baseMultiplier = 1.192, levelRequirement = 64, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[18] = { 50, 135, 4, 7, 4, 1, damageEffectiveness = 1.2, attackSpeedMultiplier = 150, baseMultiplier = 1.204, levelRequirement = 66, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[19] = { 50, 135, 4, 7, 4, 1, damageEffectiveness = 1.22, attackSpeedMultiplier = 150, baseMultiplier = 1.216, levelRequirement = 68, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[20] = { 50, 135, 4, 7, 4, 2, damageEffectiveness = 1.23, attackSpeedMultiplier = 150, baseMultiplier = 1.228, levelRequirement = 70, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[21] = { 50, 135, 4, 7, 4, 2, damageEffectiveness = 1.24, attackSpeedMultiplier = 150, baseMultiplier = 1.24, levelRequirement = 72, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[22] = { 50, 135, 4, 7, 4, 2, damageEffectiveness = 1.25, attackSpeedMultiplier = 150, baseMultiplier = 1.252, levelRequirement = 74, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[23] = { 50, 135, 4, 7, 4, 2, damageEffectiveness = 1.26, attackSpeedMultiplier = 150, baseMultiplier = 1.264, levelRequirement = 76, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[24] = { 50, 135, 4, 7, 4, 2, damageEffectiveness = 1.28, attackSpeedMultiplier = 150, baseMultiplier = 1.276, levelRequirement = 78, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[25] = { 50, 135, 4, 7, 4, 2, damageEffectiveness = 1.29, attackSpeedMultiplier = 150, baseMultiplier = 1.288, levelRequirement = 80, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[26] = { 50, 135, 4, 7, 4, 2, damageEffectiveness = 1.3, attackSpeedMultiplier = 150, baseMultiplier = 1.3, levelRequirement = 82, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[27] = { 50, 135, 4, 7, 4, 2, damageEffectiveness = 1.31, attackSpeedMultiplier = 150, baseMultiplier = 1.312, levelRequirement = 84, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[28] = { 50, 135, 4, 7, 4, 2, damageEffectiveness = 1.32, attackSpeedMultiplier = 150, baseMultiplier = 1.324, levelRequirement = 86, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[29] = { 50, 135, 4, 7, 4, 2, damageEffectiveness = 1.34, attackSpeedMultiplier = 150, baseMultiplier = 1.336, levelRequirement = 88, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[30] = { 50, 135, 4, 7, 4, 3, damageEffectiveness = 1.35, attackSpeedMultiplier = 150, baseMultiplier = 1.348, levelRequirement = 90, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[31] = { 50, 135, 4, 7, 4, 3, damageEffectiveness = 1.35, attackSpeedMultiplier = 150, baseMultiplier = 1.354, levelRequirement = 91, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[32] = { 50, 135, 4, 7, 4, 3, damageEffectiveness = 1.36, attackSpeedMultiplier = 150, baseMultiplier = 1.36, levelRequirement = 92, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[33] = { 50, 135, 4, 7, 4, 3, damageEffectiveness = 1.37, attackSpeedMultiplier = 150, baseMultiplier = 1.366, levelRequirement = 93, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[34] = { 50, 135, 4, 7, 4, 3, damageEffectiveness = 1.37, attackSpeedMultiplier = 150, baseMultiplier = 1.372, levelRequirement = 94, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[35] = { 50, 135, 4, 7, 4, 3, damageEffectiveness = 1.38, attackSpeedMultiplier = 150, baseMultiplier = 1.378, levelRequirement = 95, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[36] = { 50, 135, 4, 7, 4, 3, damageEffectiveness = 1.38, attackSpeedMultiplier = 150, baseMultiplier = 1.384, levelRequirement = 96, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[37] = { 50, 135, 4, 7, 4, 3, damageEffectiveness = 1.39, attackSpeedMultiplier = 150, baseMultiplier = 1.39, levelRequirement = 97, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[38] = { 50, 135, 4, 7, 4, 3, damageEffectiveness = 1.4, attackSpeedMultiplier = 150, baseMultiplier = 1.396, levelRequirement = 98, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[39] = { 50, 135, 4, 7, 4, 3, damageEffectiveness = 1.4, attackSpeedMultiplier = 150, baseMultiplier = 1.402, levelRequirement = 99, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[40] = { 50, 135, 4, 7, 4, 3, damageEffectiveness = 1.41, attackSpeedMultiplier = 150, baseMultiplier = 1.408, levelRequirement = 100, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
	},
}
skills["Riposte"] = {
	name = "Riposte",
	color = 2,
	baseEffectiveness = 0.5,
	incrementalEffectiveness = 0.023299999535084,
	description = "Perform a deadly counter-attack when you block. Uses both weapons while you're dual wielding.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Triggered] = true, [SkillType.Triggerable] = true, [SkillType.TriggeredGrantedSkill] = true, [SkillType.PhysicalSkill] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "damage_+%", 1 },
	},
	stats = {
		"melee_counterattack_trigger_on_block_%",
		"melee_range_+",
		"attack_minimum_added_physical_damage",
		"attack_maximum_added_physical_damage",
		"attack_unusable_if_triggerable",
		"base_skill_show_average_damage_instead_of_dps",
		"skill_double_hits_when_dual_wielding",
	},
	levels = {
		[1] = { 100, 0, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.6, cooldown = 0.8, baseMultiplier = 1.6, levelRequirement = 4, statInterpolation = { 1, 1, 3, 3, }, },
		[2] = { 100, 0, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.64, cooldown = 0.8, baseMultiplier = 1.637, levelRequirement = 6, statInterpolation = { 1, 1, 3, 3, }, },
		[3] = { 100, 0, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.67, cooldown = 0.8, baseMultiplier = 1.674, levelRequirement = 9, statInterpolation = { 1, 1, 3, 3, }, },
		[4] = { 100, 0, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.71, cooldown = 0.8, baseMultiplier = 1.711, levelRequirement = 12, statInterpolation = { 1, 1, 3, 3, }, },
		[5] = { 100, 0, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.75, cooldown = 0.8, baseMultiplier = 1.747, levelRequirement = 16, statInterpolation = { 1, 1, 3, 3, }, },
		[6] = { 100, 0, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.78, cooldown = 0.8, baseMultiplier = 1.784, levelRequirement = 20, statInterpolation = { 1, 1, 3, 3, }, },
		[7] = { 100, 1, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.82, cooldown = 0.8, baseMultiplier = 1.821, levelRequirement = 24, statInterpolation = { 1, 1, 3, 3, }, },
		[8] = { 100, 1, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.86, cooldown = 0.8, baseMultiplier = 1.858, levelRequirement = 28, statInterpolation = { 1, 1, 3, 3, }, },
		[9] = { 100, 1, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.89, cooldown = 0.8, baseMultiplier = 1.895, levelRequirement = 32, statInterpolation = { 1, 1, 3, 3, }, },
		[10] = { 100, 1, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.93, cooldown = 0.8, baseMultiplier = 1.932, levelRequirement = 36, statInterpolation = { 1, 1, 3, 3, }, },
		[11] = { 100, 1, 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.97, cooldown = 0.8, baseMultiplier = 1.968, levelRequirement = 40, statInterpolation = { 1, 1, 3, 3, }, },
		[12] = { 100, 1, 0.80000001192093, 1.2000000476837, damageEffectiveness = 2.01, cooldown = 0.8, baseMultiplier = 2.005, levelRequirement = 44, statInterpolation = { 1, 1, 3, 3, }, },
		[13] = { 100, 1, 0.80000001192093, 1.2000000476837, damageEffectiveness = 2.04, cooldown = 0.8, baseMultiplier = 2.042, levelRequirement = 48, statInterpolation = { 1, 1, 3, 3, }, },
		[14] = { 100, 2, 0.80000001192093, 1.2000000476837, damageEffectiveness = 2.08, cooldown = 0.8, baseMultiplier = 2.079, levelRequirement = 52, statInterpolation = { 1, 1, 3, 3, }, },
		[15] = { 100, 2, 0.80000001192093, 1.2000000476837, damageEffectiveness = 2.12, cooldown = 0.8, baseMultiplier = 2.116, levelRequirement = 55, statInterpolation = { 1, 1, 3, 3, }, },
		[16] = { 100, 2, 0.80000001192093, 1.2000000476837, damageEffectiveness = 2.15, cooldown = 0.8, baseMultiplier = 2.153, levelRequirement = 58, statInterpolation = { 1, 1, 3, 3, }, },
		[17] = { 100, 2, 0.80000001192093, 1.2000000476837, damageEffectiveness = 2.19, cooldown = 0.8, baseMultiplier = 2.189, levelRequirement = 61, statInterpolation = { 1, 1, 3, 3, }, },
		[18] = { 100, 2, 0.80000001192093, 1.2000000476837, damageEffectiveness = 2.23, cooldown = 0.8, baseMultiplier = 2.226, levelRequirement = 64, statInterpolation = { 1, 1, 3, 3, }, },
		[19] = { 100, 2, 0.80000001192093, 1.2000000476837, damageEffectiveness = 2.26, cooldown = 0.8, baseMultiplier = 2.263, levelRequirement = 67, statInterpolation = { 1, 1, 3, 3, }, },
		[20] = { 100, 2, 0.80000001192093, 1.2000000476837, damageEffectiveness = 2.3, cooldown = 0.8, baseMultiplier = 2.3, levelRequirement = 70, statInterpolation = { 1, 1, 3, 3, }, },
		[21] = { 100, 3, 0.80000001192093, 1.2000000476837, damageEffectiveness = 2.34, cooldown = 0.8, baseMultiplier = 2.337, levelRequirement = 72, statInterpolation = { 1, 1, 3, 3, }, },
		[22] = { 100, 3, 0.80000001192093, 1.2000000476837, damageEffectiveness = 2.37, cooldown = 0.8, baseMultiplier = 2.374, levelRequirement = 74, statInterpolation = { 1, 1, 3, 3, }, },
		[23] = { 100, 3, 0.80000001192093, 1.2000000476837, damageEffectiveness = 2.41, cooldown = 0.8, baseMultiplier = 2.411, levelRequirement = 76, statInterpolation = { 1, 1, 3, 3, }, },
		[24] = { 100, 3, 0.80000001192093, 1.2000000476837, damageEffectiveness = 2.45, cooldown = 0.8, baseMultiplier = 2.447, levelRequirement = 78, statInterpolation = { 1, 1, 3, 3, }, },
		[25] = { 100, 3, 0.80000001192093, 1.2000000476837, damageEffectiveness = 2.48, cooldown = 0.8, baseMultiplier = 2.484, levelRequirement = 80, statInterpolation = { 1, 1, 3, 3, }, },
		[26] = { 100, 3, 0.80000001192093, 1.2000000476837, damageEffectiveness = 2.52, cooldown = 0.8, baseMultiplier = 2.521, levelRequirement = 82, statInterpolation = { 1, 1, 3, 3, }, },
		[27] = { 100, 3, 0.80000001192093, 1.2000000476837, damageEffectiveness = 2.56, cooldown = 0.8, baseMultiplier = 2.558, levelRequirement = 84, statInterpolation = { 1, 1, 3, 3, }, },
		[28] = { 100, 4, 0.80000001192093, 1.2000000476837, damageEffectiveness = 2.59, cooldown = 0.8, baseMultiplier = 2.595, levelRequirement = 86, statInterpolation = { 1, 1, 3, 3, }, },
		[29] = { 100, 4, 0.80000001192093, 1.2000000476837, damageEffectiveness = 2.63, cooldown = 0.8, baseMultiplier = 2.632, levelRequirement = 88, statInterpolation = { 1, 1, 3, 3, }, },
		[30] = { 100, 4, 0.80000001192093, 1.2000000476837, damageEffectiveness = 2.67, cooldown = 0.8, baseMultiplier = 2.668, levelRequirement = 90, statInterpolation = { 1, 1, 3, 3, }, },
		[31] = { 100, 4, 0.80000001192093, 1.2000000476837, damageEffectiveness = 2.69, cooldown = 0.8, baseMultiplier = 2.687, levelRequirement = 91, statInterpolation = { 1, 1, 3, 3, }, },
		[32] = { 100, 4, 0.80000001192093, 1.2000000476837, damageEffectiveness = 2.71, cooldown = 0.8, baseMultiplier = 2.705, levelRequirement = 92, statInterpolation = { 1, 1, 3, 3, }, },
		[33] = { 100, 4, 0.80000001192093, 1.2000000476837, damageEffectiveness = 2.72, cooldown = 0.8, baseMultiplier = 2.724, levelRequirement = 93, statInterpolation = { 1, 1, 3, 3, }, },
		[34] = { 100, 4, 0.80000001192093, 1.2000000476837, damageEffectiveness = 2.74, cooldown = 0.8, baseMultiplier = 2.742, levelRequirement = 94, statInterpolation = { 1, 1, 3, 3, }, },
		[35] = { 100, 5, 0.80000001192093, 1.2000000476837, damageEffectiveness = 2.76, cooldown = 0.8, baseMultiplier = 2.761, levelRequirement = 95, statInterpolation = { 1, 1, 3, 3, }, },
		[36] = { 100, 5, 0.80000001192093, 1.2000000476837, damageEffectiveness = 2.78, cooldown = 0.8, baseMultiplier = 2.779, levelRequirement = 96, statInterpolation = { 1, 1, 3, 3, }, },
		[37] = { 100, 5, 0.80000001192093, 1.2000000476837, damageEffectiveness = 2.8, cooldown = 0.8, baseMultiplier = 2.797, levelRequirement = 97, statInterpolation = { 1, 1, 3, 3, }, },
		[38] = { 100, 5, 0.80000001192093, 1.2000000476837, damageEffectiveness = 2.82, cooldown = 0.8, baseMultiplier = 2.816, levelRequirement = 98, statInterpolation = { 1, 1, 3, 3, }, },
		[39] = { 100, 5, 0.80000001192093, 1.2000000476837, damageEffectiveness = 2.83, cooldown = 0.8, baseMultiplier = 2.834, levelRequirement = 99, statInterpolation = { 1, 1, 3, 3, }, },
		[40] = { 100, 5, 0.80000001192093, 1.2000000476837, damageEffectiveness = 2.85, cooldown = 0.8, baseMultiplier = 2.853, levelRequirement = 100, statInterpolation = { 1, 1, 3, 3, }, },
	},
}
skills["ScourgeArrow"] = {
	name = "Scourge Arrow",
	color = 2,
	description = "Channel to infuse an arrow with chaos, gaining stages while it is held. Release to fire it, leaving spore pods in its wake. Each spore pod blooms, firing a nova of thorn arrows, which travel for a short time before dissipating. Modifiers that cause additional projectiles to be fired will only apply to the initial arrows, and the spore pods will be split between those arrows.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.ProjectileAttack] = true, [SkillType.SkillCanMirageArcher] = true, [SkillType.Projectile] = true, [SkillType.SkillCanVolley] = true, [SkillType.SkillCanTotem] = true, [SkillType.Hit] = true, [SkillType.Channelled] = true, [SkillType.ChaosSkill] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "No stages",
		},
		{
			name = "Release at 5 Stages",
		},
		{ 
			name = "Thorn Arrows"
		},
	},
	statMap = {
		["virulent_arrow_damage_+%_final_per_stage"] = {
			mod("Damage", "MORE", nil, 0, bit.bor(KeywordFlag.Hit, KeywordFlag.Ailment), { type = "Multiplier", var = "ScourgeArrowStage" }),
		},
		["virulent_arrow_pod_projectile_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type= "SkillPart", skillPart = 3 }),
		},
	},
	baseFlags = {
		attack = true,
		projectile = true,
	},
	baseMods = {
		mod("Multiplier:ScourgeArrowStage", "BASE", 5, 0, 0, { type = "SkillPart", skillPartList = { 2, 3 } }),
		skill("dpsMultiplier", 0.2, { type = "SkillPart", skillPart = 2 }),
	},
	qualityStats = {
		{ "base_projectile_speed_+%", 1 },
	},
	stats = {
		"virulent_arrow_maximum_number_of_stacks",
		"virulent_arrow_number_of_pod_projectiles",
		"skill_physical_damage_%_to_convert_to_chaos",
		"virulent_arrow_pod_projectile_damage_+%_final",
		"virulent_arrow_damage_+%_final_per_stage",
		"override_turn_duration_ms",
		"skill_can_fire_arrows",
		"base_arrows_always_pierce",
	},
	levels = {
		[1] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.4, manaCost = 4, damageEffectiveness = 0.4, attackSpeedMultiplier = 90, levelRequirement = 28, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[2] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.405, manaCost = 4, damageEffectiveness = 0.4, attackSpeedMultiplier = 90, levelRequirement = 31, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[3] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.41, manaCost = 4, damageEffectiveness = 0.41, attackSpeedMultiplier = 90, levelRequirement = 34, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[4] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.414, manaCost = 4, damageEffectiveness = 0.41, attackSpeedMultiplier = 90, levelRequirement = 37, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[5] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.419, manaCost = 4, damageEffectiveness = 0.42, attackSpeedMultiplier = 90, levelRequirement = 40, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[6] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.424, manaCost = 4, damageEffectiveness = 0.42, attackSpeedMultiplier = 90, levelRequirement = 42, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[7] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.429, manaCost = 4, damageEffectiveness = 0.43, attackSpeedMultiplier = 90, levelRequirement = 44, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[8] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.434, manaCost = 4, damageEffectiveness = 0.43, attackSpeedMultiplier = 90, levelRequirement = 46, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[9] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.438, manaCost = 4, damageEffectiveness = 0.44, attackSpeedMultiplier = 90, levelRequirement = 48, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[10] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.443, manaCost = 4, damageEffectiveness = 0.44, attackSpeedMultiplier = 90, levelRequirement = 50, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[11] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.448, manaCost = 4, damageEffectiveness = 0.45, attackSpeedMultiplier = 90, levelRequirement = 52, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[12] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.453, manaCost = 5, damageEffectiveness = 0.45, attackSpeedMultiplier = 90, levelRequirement = 54, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[13] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.458, manaCost = 5, damageEffectiveness = 0.46, attackSpeedMultiplier = 90, levelRequirement = 56, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[14] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.462, manaCost = 5, damageEffectiveness = 0.46, attackSpeedMultiplier = 90, levelRequirement = 58, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[15] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.467, manaCost = 5, damageEffectiveness = 0.47, attackSpeedMultiplier = 90, levelRequirement = 60, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[16] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.472, manaCost = 5, damageEffectiveness = 0.47, attackSpeedMultiplier = 90, levelRequirement = 62, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[17] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.477, manaCost = 5, damageEffectiveness = 0.48, attackSpeedMultiplier = 90, levelRequirement = 64, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[18] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.482, manaCost = 5, damageEffectiveness = 0.48, attackSpeedMultiplier = 90, levelRequirement = 66, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[19] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.486, manaCost = 5, damageEffectiveness = 0.49, attackSpeedMultiplier = 90, levelRequirement = 68, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[20] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.491, manaCost = 5, damageEffectiveness = 0.49, attackSpeedMultiplier = 90, levelRequirement = 70, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[21] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.496, manaCost = 5, damageEffectiveness = 0.5, attackSpeedMultiplier = 90, levelRequirement = 72, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[22] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.501, manaCost = 5, damageEffectiveness = 0.5, attackSpeedMultiplier = 90, levelRequirement = 74, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[23] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.506, manaCost = 5, damageEffectiveness = 0.51, attackSpeedMultiplier = 90, levelRequirement = 76, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[24] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.51, manaCost = 5, damageEffectiveness = 0.51, attackSpeedMultiplier = 90, levelRequirement = 78, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[25] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.515, manaCost = 5, damageEffectiveness = 0.51, attackSpeedMultiplier = 90, levelRequirement = 80, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[26] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.52, manaCost = 5, damageEffectiveness = 0.52, attackSpeedMultiplier = 90, levelRequirement = 82, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[27] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.525, manaCost = 5, damageEffectiveness = 0.52, attackSpeedMultiplier = 90, levelRequirement = 84, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[28] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.53, manaCost = 6, damageEffectiveness = 0.53, attackSpeedMultiplier = 90, levelRequirement = 86, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[29] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.534, manaCost = 6, damageEffectiveness = 0.53, attackSpeedMultiplier = 90, levelRequirement = 88, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[30] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.539, manaCost = 6, damageEffectiveness = 0.54, attackSpeedMultiplier = 90, levelRequirement = 90, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[31] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.544, manaCost = 6, damageEffectiveness = 0.54, attackSpeedMultiplier = 90, levelRequirement = 91, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[32] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.549, manaCost = 6, damageEffectiveness = 0.55, attackSpeedMultiplier = 90, levelRequirement = 92, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[33] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.554, manaCost = 6, damageEffectiveness = 0.55, attackSpeedMultiplier = 90, levelRequirement = 93, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[34] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.558, manaCost = 6, damageEffectiveness = 0.56, attackSpeedMultiplier = 90, levelRequirement = 94, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[35] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.563, manaCost = 6, damageEffectiveness = 0.56, attackSpeedMultiplier = 90, levelRequirement = 95, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[36] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.568, manaCost = 6, damageEffectiveness = 0.57, attackSpeedMultiplier = 90, levelRequirement = 96, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[37] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.573, manaCost = 6, damageEffectiveness = 0.57, attackSpeedMultiplier = 90, levelRequirement = 97, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[38] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.578, manaCost = 6, damageEffectiveness = 0.58, attackSpeedMultiplier = 90, levelRequirement = 98, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[39] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.582, manaCost = 6, damageEffectiveness = 0.58, attackSpeedMultiplier = 90, levelRequirement = 99, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[40] = { 5, 9, 60, -50, 150, 100, baseMultiplier = 0.587, manaCost = 6, damageEffectiveness = 0.59, attackSpeedMultiplier = 90, levelRequirement = 100, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
	},
}
skills["ShatteringSteel"] = {
	name = "Shattering Steel",
	color = 2,
	baseEffectiveness = 1,
	incrementalEffectiveness = 0.023299999535084,
	description = "Swing an Axe or Sword, releasing projectiles in sequence. The projectiles shatter when colliding with an enemy or travelling a short distance. The shattered pieces deal damage in an area in front of the impact location.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.Hit] = true, [SkillType.ProjectileDamage] = true, [SkillType.ProjectileAttack] = true, [SkillType.Area] = true, [SkillType.PhysicalSkill] = true, },
	weaponTypes = {
		["Two Handed Axe"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["One Handed Axe"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Projectile",
			area = false,
		},
		{
			name = "Cone",
			area = true,
		},
	},
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "impale_debuff_effect_+%", 1 },
	},
	stats = {
		"attacks_impale_on_hit_%_chance",
		"number_of_additional_projectiles",
		"fixed_projectile_spread",
		"shattering_steel_damage_+%_final_scaled_by_projectile_distance",
		"projectile_angle_variance",
		"attack_minimum_added_physical_damage",
		"attack_maximum_added_physical_damage",
		"base_is_projectile",
		"projectiles_can_shotgun",
	},
	levels = {
		[1] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.45, manaCost = 7, damageEffectiveness = 0.45, attackSpeedMultiplier = -20, levelRequirement = 12, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[2] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.453, manaCost = 7, damageEffectiveness = 0.45, attackSpeedMultiplier = -20, levelRequirement = 15, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[3] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.455, manaCost = 7, damageEffectiveness = 0.46, attackSpeedMultiplier = -20, levelRequirement = 19, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[4] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.458, manaCost = 7, damageEffectiveness = 0.46, attackSpeedMultiplier = -20, levelRequirement = 23, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[5] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.461, manaCost = 7, damageEffectiveness = 0.46, attackSpeedMultiplier = -20, levelRequirement = 27, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[6] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.463, manaCost = 7, damageEffectiveness = 0.46, attackSpeedMultiplier = -20, levelRequirement = 31, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[7] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.466, manaCost = 7, damageEffectiveness = 0.47, attackSpeedMultiplier = -20, levelRequirement = 35, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[8] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.468, manaCost = 7, damageEffectiveness = 0.47, attackSpeedMultiplier = -20, levelRequirement = 38, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[9] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.471, manaCost = 7, damageEffectiveness = 0.47, attackSpeedMultiplier = -20, levelRequirement = 41, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[10] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.474, manaCost = 7, damageEffectiveness = 0.47, attackSpeedMultiplier = -20, levelRequirement = 44, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[11] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.476, manaCost = 8, damageEffectiveness = 0.48, attackSpeedMultiplier = -20, levelRequirement = 47, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[12] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.479, manaCost = 8, damageEffectiveness = 0.48, attackSpeedMultiplier = -20, levelRequirement = 50, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[13] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.482, manaCost = 8, damageEffectiveness = 0.48, attackSpeedMultiplier = -20, levelRequirement = 53, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[14] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.484, manaCost = 8, damageEffectiveness = 0.48, attackSpeedMultiplier = -20, levelRequirement = 56, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[15] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.487, manaCost = 8, damageEffectiveness = 0.49, attackSpeedMultiplier = -20, levelRequirement = 59, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[16] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.489, manaCost = 9, damageEffectiveness = 0.49, attackSpeedMultiplier = -20, levelRequirement = 62, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[17] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.492, manaCost = 9, damageEffectiveness = 0.49, attackSpeedMultiplier = -20, levelRequirement = 64, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[18] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.495, manaCost = 9, damageEffectiveness = 0.49, attackSpeedMultiplier = -20, levelRequirement = 66, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[19] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.497, manaCost = 9, damageEffectiveness = 0.5, attackSpeedMultiplier = -20, levelRequirement = 68, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[20] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.5, manaCost = 9, damageEffectiveness = 0.5, attackSpeedMultiplier = -20, levelRequirement = 70, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[21] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.503, manaCost = 10, damageEffectiveness = 0.5, attackSpeedMultiplier = -20, levelRequirement = 72, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[22] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.505, manaCost = 10, damageEffectiveness = 0.51, attackSpeedMultiplier = -20, levelRequirement = 74, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[23] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.508, manaCost = 10, damageEffectiveness = 0.51, attackSpeedMultiplier = -20, levelRequirement = 76, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[24] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.511, manaCost = 10, damageEffectiveness = 0.51, attackSpeedMultiplier = -20, levelRequirement = 78, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[25] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.513, manaCost = 10, damageEffectiveness = 0.51, attackSpeedMultiplier = -20, levelRequirement = 80, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[26] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.516, manaCost = 10, damageEffectiveness = 0.52, attackSpeedMultiplier = -20, levelRequirement = 82, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[27] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.518, manaCost = 10, damageEffectiveness = 0.52, attackSpeedMultiplier = -20, levelRequirement = 84, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[28] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.521, manaCost = 10, damageEffectiveness = 0.52, attackSpeedMultiplier = -20, levelRequirement = 86, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[29] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.524, manaCost = 10, damageEffectiveness = 0.52, attackSpeedMultiplier = -20, levelRequirement = 88, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[30] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.526, manaCost = 10, damageEffectiveness = 0.53, attackSpeedMultiplier = -20, levelRequirement = 90, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[31] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.528, manaCost = 11, damageEffectiveness = 0.53, attackSpeedMultiplier = -20, levelRequirement = 91, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[32] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.529, manaCost = 11, damageEffectiveness = 0.53, attackSpeedMultiplier = -20, levelRequirement = 92, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[33] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.53, manaCost = 11, damageEffectiveness = 0.53, attackSpeedMultiplier = -20, levelRequirement = 93, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[34] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.532, manaCost = 11, damageEffectiveness = 0.53, attackSpeedMultiplier = -20, levelRequirement = 94, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[35] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.533, manaCost = 11, damageEffectiveness = 0.53, attackSpeedMultiplier = -20, levelRequirement = 95, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[36] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.534, manaCost = 11, damageEffectiveness = 0.53, attackSpeedMultiplier = -20, levelRequirement = 96, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[37] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.536, manaCost = 11, damageEffectiveness = 0.54, attackSpeedMultiplier = -20, levelRequirement = 97, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[38] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.537, manaCost = 12, damageEffectiveness = 0.54, attackSpeedMultiplier = -20, levelRequirement = 98, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[39] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.538, manaCost = 12, damageEffectiveness = 0.54, attackSpeedMultiplier = -20, levelRequirement = 99, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
		[40] = { 40, 2, 90, 100, 10, 0.80000001192093, 1.2000000476837, baseMultiplier = 0.539, manaCost = 12, damageEffectiveness = 0.54, attackSpeedMultiplier = -20, levelRequirement = 100, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, }, },
	},
}
skills["PhysCascadeTrap"] = {
	name = "Seismic Trap",
	color = 2,
	baseEffectiveness = 1.452299952507,
	incrementalEffectiveness = 0.040899999439716,
	description = "Throws a trap which, once triggered, repeatedly releases a number of waves for a duration. Each wave deals damage in a series of small bursts in a line, ending with a larger burst. Modifiers to cast speed affects how frequently it releases waves.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Duration] = true, [SkillType.Hit] = true, [SkillType.SkillCanMine] = true, [SkillType.Area] = true, [SkillType.Trap] = true, [SkillType.AreaSpell] = true, [SkillType.PhysicalSkill] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		area = true,
		trap = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "physical_damage_+%", 1 },
	},
	stats = {
		"base_trap_duration",
		"base_skill_effect_duration",
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"phys_cascade_trap_number_of_cascades",
		"phys_cascade_trap_base_interval_duration_ms",
		"is_area_damage",
		"base_skill_is_trapped",
		"base_skill_show_average_damage_instead_of_dps",
		"is_trap",
	},
	levels = {
		[1] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 13, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 28, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[2] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 13, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 31, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[3] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 14, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 34, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[4] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 16, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 37, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[5] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 17, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 40, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[6] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 17, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 42, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[7] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 18, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 44, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[8] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 18, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 46, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[9] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 19, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 48, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[10] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 19, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 50, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[11] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 19, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 52, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[12] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 20, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 54, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[13] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 20, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 56, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[14] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 22, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 58, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[15] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 22, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 60, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[16] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 23, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 62, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[17] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 23, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 64, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[18] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 24, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 66, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[19] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 24, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 68, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[20] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 25, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 70, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[21] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 25, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 72, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[22] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 26, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 74, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[23] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 26, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 76, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[24] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 28, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 78, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[25] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 28, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 80, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[26] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 29, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 82, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[27] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 29, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 84, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[28] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 30, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 86, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[29] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 30, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 88, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[30] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 31, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 90, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[31] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 32, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 91, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[32] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 32, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 92, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[33] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 33, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 93, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[34] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 33, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 94, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[35] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 34, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 95, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[36] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 35, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 96, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[37] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 35, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 97, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[38] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 36, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 98, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[39] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 36, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 99, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
		[40] = { 4000, 3500, 0.80000001192093, 1.2000000476837, 5, 900, critChance = 5, manaCost = 37, damageEffectiveness = 1.2, cooldown = 8, levelRequirement = 100, statInterpolation = { 1, 1, 3, 3, 1, 1, }, },
	},
}
skills["ShrapnelShot"] = {
	name = "Shrapnel Shot",
	color = 2,
	description = "Fires an arrow that pierces through enemies. Arrows are fired with such force that they create a burst of lightning, damaging all enemies in a cone in front of the archer.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.SkillCanVolley] = true, [SkillType.Area] = true, [SkillType.SkillCanTotem] = true, [SkillType.SkillCanTrap] = true, [SkillType.SkillCanMine] = true, [SkillType.LightningSkill] = true, [SkillType.ProjectileAttack] = true, [SkillType.SkillCanMirageArcher] = true, [SkillType.Triggerable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Arrow",
			area = false,
		},
		{
			name = "Cone",
			area = true,
		},
	},
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 0.5 },
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_lightning",
		"active_skill_base_radius_+",
		"arrow_base_number_of_targets_to_pierce",
		"base_is_projectile",
		"skill_can_fire_arrows",
	},
	levels = {
		[1] = { 50, 0, 4, damageEffectiveness = 0.8, baseMultiplier = 0.8, levelRequirement = 1, manaCost = 6, statInterpolation = { 1, 1, 1, }, },
		[2] = { 50, 0, 4, damageEffectiveness = 0.81, baseMultiplier = 0.81, levelRequirement = 2, manaCost = 6, statInterpolation = { 1, 1, 1, }, },
		[3] = { 50, 0, 4, damageEffectiveness = 0.82, baseMultiplier = 0.82, levelRequirement = 4, manaCost = 6, statInterpolation = { 1, 1, 1, }, },
		[4] = { 50, 1, 4, damageEffectiveness = 0.83, baseMultiplier = 0.83, levelRequirement = 7, manaCost = 7, statInterpolation = { 1, 1, 1, }, },
		[5] = { 50, 1, 4, damageEffectiveness = 0.84, baseMultiplier = 0.84, levelRequirement = 11, manaCost = 7, statInterpolation = { 1, 1, 1, }, },
		[6] = { 50, 1, 5, damageEffectiveness = 0.85, baseMultiplier = 0.85, levelRequirement = 16, manaCost = 7, statInterpolation = { 1, 1, 1, }, },
		[7] = { 50, 1, 5, damageEffectiveness = 0.86, baseMultiplier = 0.86, levelRequirement = 20, manaCost = 7, statInterpolation = { 1, 1, 1, }, },
		[8] = { 50, 2, 5, damageEffectiveness = 0.87, baseMultiplier = 0.87, levelRequirement = 24, manaCost = 8, statInterpolation = { 1, 1, 1, }, },
		[9] = { 50, 2, 5, damageEffectiveness = 0.88, baseMultiplier = 0.88, levelRequirement = 28, manaCost = 8, statInterpolation = { 1, 1, 1, }, },
		[10] = { 50, 2, 5, damageEffectiveness = 0.89, baseMultiplier = 0.89, levelRequirement = 32, manaCost = 8, statInterpolation = { 1, 1, 1, }, },
		[11] = { 50, 2, 6, damageEffectiveness = 0.9, baseMultiplier = 0.9, levelRequirement = 36, manaCost = 8, statInterpolation = { 1, 1, 1, }, },
		[12] = { 50, 3, 6, damageEffectiveness = 0.91, baseMultiplier = 0.91, levelRequirement = 40, manaCost = 8, statInterpolation = { 1, 1, 1, }, },
		[13] = { 50, 3, 6, damageEffectiveness = 0.92, baseMultiplier = 0.92, levelRequirement = 44, manaCost = 9, statInterpolation = { 1, 1, 1, }, },
		[14] = { 50, 3, 6, damageEffectiveness = 0.93, baseMultiplier = 0.93, levelRequirement = 48, manaCost = 9, statInterpolation = { 1, 1, 1, }, },
		[15] = { 50, 3, 6, damageEffectiveness = 0.94, baseMultiplier = 0.94, levelRequirement = 52, manaCost = 9, statInterpolation = { 1, 1, 1, }, },
		[16] = { 50, 4, 7, damageEffectiveness = 0.95, baseMultiplier = 0.95, levelRequirement = 56, manaCost = 9, statInterpolation = { 1, 1, 1, }, },
		[17] = { 50, 4, 7, damageEffectiveness = 0.96, baseMultiplier = 0.96, levelRequirement = 60, manaCost = 9, statInterpolation = { 1, 1, 1, }, },
		[18] = { 50, 4, 7, damageEffectiveness = 0.97, baseMultiplier = 0.97, levelRequirement = 64, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[19] = { 50, 4, 7, damageEffectiveness = 0.98, baseMultiplier = 0.98, levelRequirement = 67, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[20] = { 50, 5, 7, damageEffectiveness = 0.99, baseMultiplier = 0.99, levelRequirement = 70, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[21] = { 50, 5, 8, manaCost = 10, levelRequirement = 72, statInterpolation = { 1, 1, 1, }, },
		[22] = { 50, 5, 8, damageEffectiveness = 1.01, baseMultiplier = 1.01, levelRequirement = 74, manaCost = 10, statInterpolation = { 1, 1, 1, }, },
		[23] = { 50, 5, 8, damageEffectiveness = 1.02, baseMultiplier = 1.02, levelRequirement = 76, manaCost = 11, statInterpolation = { 1, 1, 1, }, },
		[24] = { 50, 6, 8, damageEffectiveness = 1.03, baseMultiplier = 1.03, levelRequirement = 78, manaCost = 11, statInterpolation = { 1, 1, 1, }, },
		[25] = { 50, 6, 8, damageEffectiveness = 1.04, baseMultiplier = 1.04, levelRequirement = 80, manaCost = 11, statInterpolation = { 1, 1, 1, }, },
		[26] = { 50, 6, 9, damageEffectiveness = 1.05, baseMultiplier = 1.05, levelRequirement = 82, manaCost = 11, statInterpolation = { 1, 1, 1, }, },
		[27] = { 50, 6, 9, damageEffectiveness = 1.06, baseMultiplier = 1.06, levelRequirement = 84, manaCost = 11, statInterpolation = { 1, 1, 1, }, },
		[28] = { 50, 7, 9, damageEffectiveness = 1.07, baseMultiplier = 1.07, levelRequirement = 86, manaCost = 12, statInterpolation = { 1, 1, 1, }, },
		[29] = { 50, 7, 9, damageEffectiveness = 1.08, baseMultiplier = 1.08, levelRequirement = 88, manaCost = 12, statInterpolation = { 1, 1, 1, }, },
		[30] = { 50, 7, 9, damageEffectiveness = 1.09, baseMultiplier = 1.09, levelRequirement = 90, manaCost = 12, statInterpolation = { 1, 1, 1, }, },
		[31] = { 50, 7, 9, damageEffectiveness = 1.1, baseMultiplier = 1.095, levelRequirement = 91, manaCost = 12, statInterpolation = { 1, 1, 1, }, },
		[32] = { 50, 7, 10, damageEffectiveness = 1.1, baseMultiplier = 1.1, levelRequirement = 92, manaCost = 13, statInterpolation = { 1, 1, 1, }, },
		[33] = { 50, 7, 10, damageEffectiveness = 1.11, baseMultiplier = 1.105, levelRequirement = 93, manaCost = 13, statInterpolation = { 1, 1, 1, }, },
		[34] = { 50, 8, 10, damageEffectiveness = 1.11, baseMultiplier = 1.11, levelRequirement = 94, manaCost = 13, statInterpolation = { 1, 1, 1, }, },
		[35] = { 50, 8, 10, damageEffectiveness = 1.12, baseMultiplier = 1.115, levelRequirement = 95, manaCost = 13, statInterpolation = { 1, 1, 1, }, },
		[36] = { 50, 8, 10, damageEffectiveness = 1.12, baseMultiplier = 1.12, levelRequirement = 96, manaCost = 13, statInterpolation = { 1, 1, 1, }, },
		[37] = { 50, 8, 10, damageEffectiveness = 1.13, baseMultiplier = 1.125, levelRequirement = 97, manaCost = 14, statInterpolation = { 1, 1, 1, }, },
		[38] = { 50, 8, 10, damageEffectiveness = 1.13, baseMultiplier = 1.13, levelRequirement = 98, manaCost = 14, statInterpolation = { 1, 1, 1, }, },
		[39] = { 50, 8, 10, damageEffectiveness = 1.14, baseMultiplier = 1.135, levelRequirement = 99, manaCost = 14, statInterpolation = { 1, 1, 1, }, },
		[40] = { 50, 8, 10, damageEffectiveness = 1.14, baseMultiplier = 1.14, levelRequirement = 100, manaCost = 14, statInterpolation = { 1, 1, 1, }, },
	},
}
skills["SiegeBallista"] = {
	name = "Siege Ballista",
	color = 2,
	description = "Summons a totem that attacks with piercing arrows. It attacks slowly, but deals increased damage.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.SkillCanVolley] = true, [SkillType.ProjectileAttack] = true, [SkillType.SkillCanTrap] = true, [SkillType.SkillCanMine] = true, [SkillType.Totem] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	skillTotemId = 12,
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		totem = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "summon_totem_cast_speed_+%", 1 },
	},
	stats = {
		"base_totem_range",
		"base_totem_duration",
		"base_active_skill_totem_level",
		"arrow_base_number_of_targets_to_pierce",
		"base_is_projectile",
		"base_skill_is_totemified",
		"is_totem",
		"skill_can_fire_arrows",
	},
	levels = {
		[1] = { 80, 8000, 4, 6, baseMultiplier = 1.4, manaCost = 8, damageEffectiveness = 1.4, attackSpeedMultiplier = -50, levelRequirement = 4, statInterpolation = { 1, 1, 1, 1, }, },
		[2] = { 80, 8000, 6, 6, baseMultiplier = 1.416, manaCost = 8, damageEffectiveness = 1.42, attackSpeedMultiplier = -50, levelRequirement = 6, statInterpolation = { 1, 1, 1, 1, }, },
		[3] = { 80, 8000, 9, 6, baseMultiplier = 1.432, manaCost = 8, damageEffectiveness = 1.43, attackSpeedMultiplier = -50, levelRequirement = 9, statInterpolation = { 1, 1, 1, 1, }, },
		[4] = { 80, 8000, 12, 6, baseMultiplier = 1.448, manaCost = 9, damageEffectiveness = 1.45, attackSpeedMultiplier = -50, levelRequirement = 12, statInterpolation = { 1, 1, 1, 1, }, },
		[5] = { 80, 8000, 16, 6, baseMultiplier = 1.464, manaCost = 9, damageEffectiveness = 1.46, attackSpeedMultiplier = -50, levelRequirement = 16, statInterpolation = { 1, 1, 1, 1, }, },
		[6] = { 80, 8000, 20, 7, baseMultiplier = 1.48, manaCost = 9, damageEffectiveness = 1.48, attackSpeedMultiplier = -50, levelRequirement = 20, statInterpolation = { 1, 1, 1, 1, }, },
		[7] = { 80, 8000, 24, 7, baseMultiplier = 1.496, manaCost = 9, damageEffectiveness = 1.5, attackSpeedMultiplier = -50, levelRequirement = 24, statInterpolation = { 1, 1, 1, 1, }, },
		[8] = { 80, 8000, 28, 7, baseMultiplier = 1.512, manaCost = 9, damageEffectiveness = 1.51, attackSpeedMultiplier = -50, levelRequirement = 28, statInterpolation = { 1, 1, 1, 1, }, },
		[9] = { 80, 8000, 32, 7, baseMultiplier = 1.528, manaCost = 9, damageEffectiveness = 1.53, attackSpeedMultiplier = -50, levelRequirement = 32, statInterpolation = { 1, 1, 1, 1, }, },
		[10] = { 80, 8000, 36, 7, baseMultiplier = 1.544, manaCost = 10, damageEffectiveness = 1.54, attackSpeedMultiplier = -50, levelRequirement = 36, statInterpolation = { 1, 1, 1, 1, }, },
		[11] = { 80, 8000, 40, 8, baseMultiplier = 1.56, manaCost = 10, damageEffectiveness = 1.56, attackSpeedMultiplier = -50, levelRequirement = 40, statInterpolation = { 1, 1, 1, 1, }, },
		[12] = { 80, 8000, 44, 8, baseMultiplier = 1.576, manaCost = 10, damageEffectiveness = 1.58, attackSpeedMultiplier = -50, levelRequirement = 44, statInterpolation = { 1, 1, 1, 1, }, },
		[13] = { 80, 8000, 48, 8, baseMultiplier = 1.592, manaCost = 10, damageEffectiveness = 1.59, attackSpeedMultiplier = -50, levelRequirement = 48, statInterpolation = { 1, 1, 1, 1, }, },
		[14] = { 80, 8000, 52, 8, baseMultiplier = 1.608, manaCost = 10, damageEffectiveness = 1.61, attackSpeedMultiplier = -50, levelRequirement = 52, statInterpolation = { 1, 1, 1, 1, }, },
		[15] = { 80, 8000, 55, 8, baseMultiplier = 1.624, manaCost = 11, damageEffectiveness = 1.62, attackSpeedMultiplier = -50, levelRequirement = 55, statInterpolation = { 1, 1, 1, 1, }, },
		[16] = { 80, 8000, 58, 9, baseMultiplier = 1.64, manaCost = 11, damageEffectiveness = 1.64, attackSpeedMultiplier = -50, levelRequirement = 58, statInterpolation = { 1, 1, 1, 1, }, },
		[17] = { 80, 8000, 61, 9, baseMultiplier = 1.656, manaCost = 12, damageEffectiveness = 1.66, attackSpeedMultiplier = -50, levelRequirement = 61, statInterpolation = { 1, 1, 1, 1, }, },
		[18] = { 80, 8000, 64, 9, baseMultiplier = 1.672, manaCost = 12, damageEffectiveness = 1.67, attackSpeedMultiplier = -50, levelRequirement = 64, statInterpolation = { 1, 1, 1, 1, }, },
		[19] = { 80, 8000, 67, 9, baseMultiplier = 1.688, manaCost = 12, damageEffectiveness = 1.69, attackSpeedMultiplier = -50, levelRequirement = 67, statInterpolation = { 1, 1, 1, 1, }, },
		[20] = { 80, 8000, 70, 9, baseMultiplier = 1.704, manaCost = 13, damageEffectiveness = 1.7, attackSpeedMultiplier = -50, levelRequirement = 70, statInterpolation = { 1, 1, 1, 1, }, },
		[21] = { 80, 8000, 72, 10, baseMultiplier = 1.72, manaCost = 13, damageEffectiveness = 1.72, attackSpeedMultiplier = -50, levelRequirement = 72, statInterpolation = { 1, 1, 1, 1, }, },
		[22] = { 80, 8000, 74, 10, baseMultiplier = 1.736, manaCost = 13, damageEffectiveness = 1.74, attackSpeedMultiplier = -50, levelRequirement = 74, statInterpolation = { 1, 1, 1, 1, }, },
		[23] = { 80, 8000, 76, 10, baseMultiplier = 1.752, manaCost = 14, damageEffectiveness = 1.75, attackSpeedMultiplier = -50, levelRequirement = 76, statInterpolation = { 1, 1, 1, 1, }, },
		[24] = { 80, 8000, 78, 10, baseMultiplier = 1.768, manaCost = 14, damageEffectiveness = 1.77, attackSpeedMultiplier = -50, levelRequirement = 78, statInterpolation = { 1, 1, 1, 1, }, },
		[25] = { 80, 8000, 80, 10, baseMultiplier = 1.784, manaCost = 14, damageEffectiveness = 1.78, attackSpeedMultiplier = -50, levelRequirement = 80, statInterpolation = { 1, 1, 1, 1, }, },
		[26] = { 80, 8000, 82, 11, baseMultiplier = 1.8, manaCost = 14, damageEffectiveness = 1.8, attackSpeedMultiplier = -50, levelRequirement = 82, statInterpolation = { 1, 1, 1, 1, }, },
		[27] = { 80, 8000, 84, 11, baseMultiplier = 1.816, manaCost = 14, damageEffectiveness = 1.82, attackSpeedMultiplier = -50, levelRequirement = 84, statInterpolation = { 1, 1, 1, 1, }, },
		[28] = { 80, 8000, 86, 11, baseMultiplier = 1.832, manaCost = 14, damageEffectiveness = 1.83, attackSpeedMultiplier = -50, levelRequirement = 86, statInterpolation = { 1, 1, 1, 1, }, },
		[29] = { 80, 8000, 88, 11, baseMultiplier = 1.848, manaCost = 15, damageEffectiveness = 1.85, attackSpeedMultiplier = -50, levelRequirement = 88, statInterpolation = { 1, 1, 1, 1, }, },
		[30] = { 80, 8000, 90, 11, baseMultiplier = 1.864, manaCost = 15, damageEffectiveness = 1.86, attackSpeedMultiplier = -50, levelRequirement = 90, statInterpolation = { 1, 1, 1, 1, }, },
		[31] = { 80, 8000, 91, 11, baseMultiplier = 1.872, manaCost = 15, damageEffectiveness = 1.87, attackSpeedMultiplier = -50, levelRequirement = 91, statInterpolation = { 1, 1, 1, 1, }, },
		[32] = { 80, 8000, 92, 12, baseMultiplier = 1.88, manaCost = 15, damageEffectiveness = 1.88, attackSpeedMultiplier = -50, levelRequirement = 92, statInterpolation = { 1, 1, 1, 1, }, },
		[33] = { 80, 8000, 93, 12, baseMultiplier = 1.888, manaCost = 15, damageEffectiveness = 1.89, attackSpeedMultiplier = -50, levelRequirement = 93, statInterpolation = { 1, 1, 1, 1, }, },
		[34] = { 80, 8000, 94, 12, baseMultiplier = 1.896, manaCost = 15, damageEffectiveness = 1.9, attackSpeedMultiplier = -50, levelRequirement = 94, statInterpolation = { 1, 1, 1, 1, }, },
		[35] = { 80, 8000, 95, 12, baseMultiplier = 1.904, manaCost = 15, damageEffectiveness = 1.9, attackSpeedMultiplier = -50, levelRequirement = 95, statInterpolation = { 1, 1, 1, 1, }, },
		[36] = { 80, 8000, 96, 12, baseMultiplier = 1.912, manaCost = 15, damageEffectiveness = 1.91, attackSpeedMultiplier = -50, levelRequirement = 96, statInterpolation = { 1, 1, 1, 1, }, },
		[37] = { 80, 8000, 97, 12, baseMultiplier = 1.92, manaCost = 15, damageEffectiveness = 1.92, attackSpeedMultiplier = -50, levelRequirement = 97, statInterpolation = { 1, 1, 1, 1, }, },
		[38] = { 80, 8000, 98, 12, baseMultiplier = 1.928, manaCost = 16, damageEffectiveness = 1.93, attackSpeedMultiplier = -50, levelRequirement = 98, statInterpolation = { 1, 1, 1, 1, }, },
		[39] = { 80, 8000, 99, 12, baseMultiplier = 1.936, manaCost = 16, damageEffectiveness = 1.94, attackSpeedMultiplier = -50, levelRequirement = 99, statInterpolation = { 1, 1, 1, 1, }, },
		[40] = { 80, 8000, 100, 12, baseMultiplier = 1.944, manaCost = 16, damageEffectiveness = 1.94, attackSpeedMultiplier = -50, levelRequirement = 100, statInterpolation = { 1, 1, 1, 1, }, },
	},
}
skills["SmokeMine"] = {
	name = "Smoke Mine",
	color = 2,
	description = "Throws  a mine that will teleport you to it when detonated. It covers both your escape and arrival with a cloud of smoke that blinds enemies, and gives you a temporary buff to movement speed. Shares a cooldown with other Blink skills.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.MovementSkill] = true, [SkillType.Mine] = true, [SkillType.AreaSpell] = true, [SkillType.TravelSkill] = true, [SkillType.ManaCostReserved] = true, [SkillType.BlinkSkill] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.5,
	statMap = {
		["base_movement_velocity_+%"] = {
			mod("MovementSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
	},
	baseFlags = {
		spell = true,
		mine = true,
		area = true,
		buff = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 2 },
	},
	stats = {
		"base_mine_duration",
		"base_skill_effect_duration",
		"base_movement_velocity_+%",
		"base_skill_area_of_effect_+%",
		"base_secondary_skill_effect_duration",
		"base_cooldown_speed_+%",
		"is_remote_mine",
		"base_skill_is_mined",
		"base_deal_no_damage",
		"disable_mine_detonation_cascade",
		"mine_detonates_instantly",
		"additive_mine_duration_modifiers_apply_to_buff_effect_duration",
	},
	levels = {
		[1] = { 8000, 4000, 20, 0, 4000, 0, cooldown = 2.5, levelRequirement = 10, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[2] = { 8000, 4100, 20, 4, 4100, 3, cooldown = 2.5, levelRequirement = 13, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[3] = { 8000, 4100, 21, 8, 4100, 6, cooldown = 2.5, levelRequirement = 17, manaCost = 7, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[4] = { 8000, 4200, 21, 12, 4200, 9, cooldown = 2.5, levelRequirement = 21, manaCost = 7, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[5] = { 8000, 4200, 22, 16, 4200, 12, cooldown = 2.5, levelRequirement = 25, manaCost = 8, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[6] = { 8000, 4300, 22, 20, 4300, 15, cooldown = 2.5, levelRequirement = 29, manaCost = 8, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[7] = { 8000, 4300, 23, 24, 4300, 18, cooldown = 2.5, levelRequirement = 33, manaCost = 9, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[8] = { 8000, 4400, 23, 28, 4400, 21, cooldown = 2.5, levelRequirement = 36, manaCost = 9, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[9] = { 8000, 4400, 24, 32, 4400, 24, cooldown = 2.5, levelRequirement = 39, manaCost = 9, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[10] = { 8000, 4500, 24, 36, 4500, 27, cooldown = 2.5, levelRequirement = 42, manaCost = 10, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[11] = { 8000, 4500, 25, 40, 4500, 30, cooldown = 2.5, levelRequirement = 45, manaCost = 10, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[12] = { 8000, 4600, 25, 44, 4600, 33, cooldown = 2.5, levelRequirement = 48, manaCost = 10, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[13] = { 8000, 4600, 26, 48, 4600, 36, cooldown = 2.5, levelRequirement = 51, manaCost = 10, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[14] = { 8000, 4700, 26, 52, 4700, 39, cooldown = 2.5, levelRequirement = 54, manaCost = 11, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[15] = { 8000, 4700, 27, 56, 4700, 42, cooldown = 2.5, levelRequirement = 57, manaCost = 11, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[16] = { 8000, 4800, 27, 60, 4800, 45, cooldown = 2.5, levelRequirement = 60, manaCost = 11, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[17] = { 8000, 4800, 28, 64, 4800, 48, cooldown = 2.5, levelRequirement = 63, manaCost = 12, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[18] = { 8000, 4900, 28, 68, 4900, 51, cooldown = 2.5, levelRequirement = 66, manaCost = 12, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[19] = { 8000, 4900, 29, 72, 4900, 54, cooldown = 2.5, levelRequirement = 68, manaCost = 12, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[20] = { 8000, 5000, 29, 76, 5000, 57, cooldown = 2.5, levelRequirement = 70, manaCost = 13, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[21] = { 8000, 5000, 30, 80, 5000, 60, cooldown = 2.5, levelRequirement = 72, manaCost = 13, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[22] = { 8000, 5100, 30, 84, 5100, 63, cooldown = 2.5, levelRequirement = 74, manaCost = 13, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[23] = { 8000, 5100, 31, 88, 5100, 66, cooldown = 2.5, levelRequirement = 76, manaCost = 14, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[24] = { 8000, 5200, 31, 92, 5200, 69, cooldown = 2.5, levelRequirement = 78, manaCost = 14, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[25] = { 8000, 5200, 32, 96, 5200, 72, cooldown = 2.5, levelRequirement = 80, manaCost = 14, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[26] = { 8000, 5300, 32, 100, 5300, 75, cooldown = 2.5, levelRequirement = 82, manaCost = 14, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[27] = { 8000, 5300, 33, 104, 5300, 78, cooldown = 2.5, levelRequirement = 84, manaCost = 14, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[28] = { 8000, 5400, 33, 108, 5400, 81, cooldown = 2.5, levelRequirement = 86, manaCost = 14, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[29] = { 8000, 5400, 34, 112, 5400, 84, cooldown = 2.5, levelRequirement = 88, manaCost = 15, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[30] = { 8000, 5500, 34, 116, 5500, 87, cooldown = 2.5, levelRequirement = 90, manaCost = 15, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[31] = { 8000, 5500, 35, 120, 5500, 90, cooldown = 2.5, levelRequirement = 91, manaCost = 16, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[32] = { 8000, 5600, 35, 124, 5600, 93, cooldown = 2.5, levelRequirement = 92, manaCost = 16, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[33] = { 8000, 5600, 36, 128, 5600, 96, cooldown = 2.5, levelRequirement = 93, manaCost = 16, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[34] = { 8000, 5700, 36, 132, 5700, 99, cooldown = 2.5, levelRequirement = 94, manaCost = 17, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[35] = { 8000, 5700, 37, 136, 5700, 102, cooldown = 2.5, levelRequirement = 95, manaCost = 17, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[36] = { 8000, 5800, 37, 140, 5800, 105, cooldown = 2.5, levelRequirement = 96, manaCost = 17, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[37] = { 8000, 5800, 38, 144, 5800, 108, cooldown = 2.5, levelRequirement = 97, manaCost = 18, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[38] = { 8000, 5900, 38, 148, 5900, 111, cooldown = 2.5, levelRequirement = 98, manaCost = 18, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[39] = { 8000, 5900, 39, 152, 5900, 114, cooldown = 2.5, levelRequirement = 99, manaCost = 18, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[40] = { 8000, 6000, 39, 156, 6000, 117, cooldown = 2.5, levelRequirement = 100, manaCost = 19, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
	},
}
skills["ThrownShield"] = {
	name = "Spectral Shield Throw",
	color = 2,
	baseEffectiveness = 2.3375000953674,
	incrementalEffectiveness = 0.017799999564886,
	description = "Throws a spectral copy of your shield as a projectile which cannot pierce, and deals off-hand damage augmented by the defences of the shield. When it collides with something it will shatter, launching a number of smaller shards as projectiles in all directions. Modifiers that cause additional projectiles to be fired will add more shards, not more copies of the shield.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.ProjectileAttack] = true, [SkillType.Projectile] = true, [SkillType.SkillCanVolley] = true, [SkillType.Type71] = true, [SkillType.PhysicalSkill] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Shield",
		},
		{
			name = "Shards",
		},
	},
	statMap = {
		["thrown_shield_secondary_projectile_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "SkillPart", skillPart = 2 }),
		},
	},
	baseFlags = {
		attack = true,
		projectile = true,
		shieldAttack = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "base_projectile_speed_+%", 2 },
	},
	stats = {
		"off_hand_local_minimum_added_physical_damage",
		"off_hand_local_maximum_added_physical_damage",
		"off_hand_minimum_added_physical_damage_per_15_shield_armour_and_evasion_rating",
		"off_hand_maximum_added_physical_damage_per_15_shield_armour_and_evasion_rating",
		"number_of_additional_projectiles",
		"thrown_shield_secondary_projectile_damage_+%_final",
		"off_hand_base_weapon_attack_duration_ms",
		"additional_critical_strike_chance_per_10_shield_maximum_energy_shield_permyriad",
		"base_is_projectile",
		"thrown_shield_projectile_fire_random_directions",
		"override_off_hand_base_critical_strike_chance_to_5%",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 2, 3, 8, -25, 700, 10, manaCost = 7, levelRequirement = 12, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[2] = { 0.80000001192093, 1.2000000476837, 2, 3, 9, -25, 695, 10, manaCost = 7, levelRequirement = 15, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[3] = { 0.80000001192093, 1.2000000476837, 2, 3, 9, -25, 689, 10, manaCost = 7, levelRequirement = 19, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[4] = { 0.80000001192093, 1.2000000476837, 2, 3, 9, -25, 684, 10, manaCost = 7, levelRequirement = 23, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[5] = { 0.80000001192093, 1.2000000476837, 2, 3, 9, -25, 679, 10, manaCost = 7, levelRequirement = 27, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[6] = { 0.80000001192093, 1.2000000476837, 2, 3, 10, -25, 674, 10, manaCost = 7, levelRequirement = 31, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[7] = { 0.80000001192093, 1.2000000476837, 2, 3, 10, -25, 668, 10, manaCost = 8, levelRequirement = 35, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[8] = { 0.80000001192093, 1.2000000476837, 2, 3, 10, -25, 663, 10, manaCost = 8, levelRequirement = 38, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[9] = { 0.80000001192093, 1.2000000476837, 2, 3, 10, -25, 658, 10, manaCost = 8, levelRequirement = 41, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[10] = { 0.80000001192093, 1.2000000476837, 2, 3, 11, -25, 653, 10, manaCost = 8, levelRequirement = 44, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[11] = { 0.80000001192093, 1.2000000476837, 2, 3, 11, -25, 647, 10, manaCost = 8, levelRequirement = 47, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[12] = { 0.80000001192093, 1.2000000476837, 2, 3, 11, -25, 642, 10, manaCost = 8, levelRequirement = 50, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[13] = { 0.80000001192093, 1.2000000476837, 2, 3, 11, -25, 637, 10, manaCost = 9, levelRequirement = 53, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[14] = { 0.80000001192093, 1.2000000476837, 2, 3, 12, -25, 632, 10, manaCost = 9, levelRequirement = 56, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[15] = { 0.80000001192093, 1.2000000476837, 2, 3, 12, -25, 626, 10, manaCost = 9, levelRequirement = 59, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[16] = { 0.80000001192093, 1.2000000476837, 2, 3, 12, -25, 621, 10, manaCost = 9, levelRequirement = 62, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[17] = { 0.80000001192093, 1.2000000476837, 2, 3, 12, -25, 616, 10, manaCost = 9, levelRequirement = 64, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[18] = { 0.80000001192093, 1.2000000476837, 2, 3, 13, -25, 611, 10, manaCost = 9, levelRequirement = 66, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[19] = { 0.80000001192093, 1.2000000476837, 2, 3, 13, -25, 605, 10, manaCost = 10, levelRequirement = 68, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 2, 3, 13, -25, 600, 10, manaCost = 10, levelRequirement = 70, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 2, 3, 13, -25, 595, 10, manaCost = 10, levelRequirement = 72, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 2, 3, 14, -25, 589, 10, manaCost = 10, levelRequirement = 74, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 2, 3, 14, -25, 584, 10, manaCost = 10, levelRequirement = 76, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 2, 3, 14, -25, 579, 10, manaCost = 10, levelRequirement = 78, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 2, 3, 14, -25, 574, 10, manaCost = 11, levelRequirement = 80, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 2, 3, 15, -25, 568, 10, manaCost = 11, levelRequirement = 82, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 2, 3, 15, -25, 563, 10, manaCost = 11, levelRequirement = 84, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 2, 3, 15, -25, 558, 10, manaCost = 11, levelRequirement = 86, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 2, 3, 15, -25, 553, 10, manaCost = 11, levelRequirement = 88, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 2, 3, 16, -25, 547, 10, manaCost = 11, levelRequirement = 90, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 2, 3, 16, -25, 542, 10, manaCost = 11, levelRequirement = 91, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 2, 3, 16, -25, 537, 10, manaCost = 12, levelRequirement = 92, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 2, 3, 16, -25, 532, 10, manaCost = 12, levelRequirement = 93, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[34] = { 0.80000001192093, 1.2000000476837, 2, 3, 17, -25, 526, 10, manaCost = 12, levelRequirement = 94, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[35] = { 0.80000001192093, 1.2000000476837, 2, 3, 17, -25, 521, 10, manaCost = 12, levelRequirement = 95, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[36] = { 0.80000001192093, 1.2000000476837, 2, 3, 17, -25, 516, 10, manaCost = 12, levelRequirement = 96, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[37] = { 0.80000001192093, 1.2000000476837, 2, 3, 17, -25, 511, 10, manaCost = 12, levelRequirement = 97, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[38] = { 0.80000001192093, 1.2000000476837, 2, 3, 18, -25, 505, 10, manaCost = 13, levelRequirement = 98, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[39] = { 0.80000001192093, 1.2000000476837, 2, 3, 18, -25, 500, 10, manaCost = 13, levelRequirement = 99, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
		[40] = { 0.80000001192093, 1.2000000476837, 2, 3, 18, -25, 495, 10, manaCost = 13, levelRequirement = 100, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, },
	},
}
skills["ThrownWeapon"] = {
	name = "Spectral Throw",
	color = 2,
	description = "Throws a spectral copy of your melee weapon. It flies out and then returns to you, in a spinning attack that damages enemies in its path.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.ProjectileAttack] = true, [SkillType.Projectile] = true, [SkillType.SkillCanVolley] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	baseMods = {
		mod("PierceChance", "BASE", 100),
	},
	qualityStats = {
		{ "attack_speed_+%", 0.5 },
	},
	stats = {
		"base_is_projectile",
	},
	levels = {
		[1] = { damageEffectiveness = 0.8, baseMultiplier = 0.8, levelRequirement = 1, manaCost = 7, statInterpolation = { }, },
		[2] = { damageEffectiveness = 0.81, baseMultiplier = 0.811, levelRequirement = 2, manaCost = 7, statInterpolation = { }, },
		[3] = { damageEffectiveness = 0.82, baseMultiplier = 0.821, levelRequirement = 4, manaCost = 7, statInterpolation = { }, },
		[4] = { damageEffectiveness = 0.83, baseMultiplier = 0.832, levelRequirement = 7, manaCost = 7, statInterpolation = { }, },
		[5] = { damageEffectiveness = 0.84, baseMultiplier = 0.842, levelRequirement = 11, manaCost = 7, statInterpolation = { }, },
		[6] = { damageEffectiveness = 0.85, baseMultiplier = 0.853, levelRequirement = 16, manaCost = 7, statInterpolation = { }, },
		[7] = { damageEffectiveness = 0.86, baseMultiplier = 0.863, levelRequirement = 20, manaCost = 7, statInterpolation = { }, },
		[8] = { damageEffectiveness = 0.87, baseMultiplier = 0.874, levelRequirement = 24, manaCost = 7, statInterpolation = { }, },
		[9] = { damageEffectiveness = 0.88, baseMultiplier = 0.884, levelRequirement = 28, manaCost = 7, statInterpolation = { }, },
		[10] = { damageEffectiveness = 0.89, baseMultiplier = 0.895, levelRequirement = 32, manaCost = 7, statInterpolation = { }, },
		[11] = { damageEffectiveness = 0.91, baseMultiplier = 0.905, levelRequirement = 36, manaCost = 8, statInterpolation = { }, },
		[12] = { damageEffectiveness = 0.92, baseMultiplier = 0.916, levelRequirement = 40, manaCost = 8, statInterpolation = { }, },
		[13] = { damageEffectiveness = 0.93, baseMultiplier = 0.926, levelRequirement = 44, manaCost = 8, statInterpolation = { }, },
		[14] = { damageEffectiveness = 0.94, baseMultiplier = 0.937, levelRequirement = 48, manaCost = 8, statInterpolation = { }, },
		[15] = { damageEffectiveness = 0.95, baseMultiplier = 0.947, levelRequirement = 52, manaCost = 8, statInterpolation = { }, },
		[16] = { damageEffectiveness = 0.96, baseMultiplier = 0.958, levelRequirement = 56, manaCost = 9, statInterpolation = { }, },
		[17] = { damageEffectiveness = 0.97, baseMultiplier = 0.968, levelRequirement = 60, manaCost = 9, statInterpolation = { }, },
		[18] = { damageEffectiveness = 0.98, baseMultiplier = 0.979, levelRequirement = 64, manaCost = 9, statInterpolation = { }, },
		[19] = { damageEffectiveness = 0.99, baseMultiplier = 0.989, levelRequirement = 67, manaCost = 9, statInterpolation = { }, },
		[20] = { manaCost = 9, levelRequirement = 70, statInterpolation = { }, },
		[21] = { damageEffectiveness = 1.01, baseMultiplier = 1.011, levelRequirement = 72, manaCost = 10, statInterpolation = { }, },
		[22] = { damageEffectiveness = 1.02, baseMultiplier = 1.021, levelRequirement = 74, manaCost = 10, statInterpolation = { }, },
		[23] = { damageEffectiveness = 1.03, baseMultiplier = 1.032, levelRequirement = 76, manaCost = 10, statInterpolation = { }, },
		[24] = { damageEffectiveness = 1.04, baseMultiplier = 1.042, levelRequirement = 78, manaCost = 10, statInterpolation = { }, },
		[25] = { damageEffectiveness = 1.05, baseMultiplier = 1.053, levelRequirement = 80, manaCost = 10, statInterpolation = { }, },
		[26] = { damageEffectiveness = 1.06, baseMultiplier = 1.063, levelRequirement = 82, manaCost = 10, statInterpolation = { }, },
		[27] = { damageEffectiveness = 1.07, baseMultiplier = 1.074, levelRequirement = 84, manaCost = 10, statInterpolation = { }, },
		[28] = { damageEffectiveness = 1.08, baseMultiplier = 1.084, levelRequirement = 86, manaCost = 10, statInterpolation = { }, },
		[29] = { damageEffectiveness = 1.09, baseMultiplier = 1.095, levelRequirement = 88, manaCost = 10, statInterpolation = { }, },
		[30] = { damageEffectiveness = 1.11, baseMultiplier = 1.105, levelRequirement = 90, manaCost = 10, statInterpolation = { }, },
		[31] = { damageEffectiveness = 1.11, baseMultiplier = 1.111, levelRequirement = 91, manaCost = 11, statInterpolation = { }, },
		[32] = { damageEffectiveness = 1.12, baseMultiplier = 1.116, levelRequirement = 92, manaCost = 11, statInterpolation = { }, },
		[33] = { damageEffectiveness = 1.12, baseMultiplier = 1.121, levelRequirement = 93, manaCost = 11, statInterpolation = { }, },
		[34] = { damageEffectiveness = 1.13, baseMultiplier = 1.126, levelRequirement = 94, manaCost = 11, statInterpolation = { }, },
		[35] = { damageEffectiveness = 1.13, baseMultiplier = 1.132, levelRequirement = 95, manaCost = 11, statInterpolation = { }, },
		[36] = { damageEffectiveness = 1.14, baseMultiplier = 1.137, levelRequirement = 96, manaCost = 11, statInterpolation = { }, },
		[37] = { damageEffectiveness = 1.14, baseMultiplier = 1.142, levelRequirement = 97, manaCost = 11, statInterpolation = { }, },
		[38] = { damageEffectiveness = 1.15, baseMultiplier = 1.147, levelRequirement = 98, manaCost = 12, statInterpolation = { }, },
		[39] = { damageEffectiveness = 1.15, baseMultiplier = 1.153, levelRequirement = 99, manaCost = 12, statInterpolation = { }, },
		[40] = { damageEffectiveness = 1.16, baseMultiplier = 1.158, levelRequirement = 100, manaCost = 12, statInterpolation = { }, },
	},
}
skills["VaalThrownWeapon"] = {
	name = "Vaal Spectral Throw",
	color = 2,
	description = "Throws a spectral copy of your melee weapon. It spirals out in a spinning attack that strikes enemies in its path.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.ProjectileAttack] = true, [SkillType.Projectile] = true, [SkillType.SkillCanVolley] = true, [SkillType.Vaal] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		vaal = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "attack_speed_+%", 0.5 },
	},
	stats = {
		"number_of_additional_projectiles",
		"projectiles_nova",
		"base_is_projectile",
		"global_always_hit",
		"projectiles_not_offset",
		"cannot_cancel_skill_before_contact_point",
	},
	levels = {
		[1] = { 4, damageEffectiveness = 0.91, baseMultiplier = 0.91, levelRequirement = 1, statInterpolation = { 1, }, },
		[2] = { 4, damageEffectiveness = 0.93, baseMultiplier = 0.9334, levelRequirement = 2, statInterpolation = { 1, }, },
		[3] = { 4, damageEffectiveness = 0.96, baseMultiplier = 0.9568, levelRequirement = 4, statInterpolation = { 1, }, },
		[4] = { 4, damageEffectiveness = 0.98, baseMultiplier = 0.9802, levelRequirement = 7, statInterpolation = { 1, }, },
		[5] = { 4, baseMultiplier = 1.0036, levelRequirement = 11, statInterpolation = { 1, }, },
		[6] = { 4, damageEffectiveness = 1.03, baseMultiplier = 1.027, levelRequirement = 16, statInterpolation = { 1, }, },
		[7] = { 4, damageEffectiveness = 1.05, baseMultiplier = 1.0504, levelRequirement = 20, statInterpolation = { 1, }, },
		[8] = { 4, damageEffectiveness = 1.07, baseMultiplier = 1.0738, levelRequirement = 24, statInterpolation = { 1, }, },
		[9] = { 4, damageEffectiveness = 1.1, baseMultiplier = 1.0972, levelRequirement = 28, statInterpolation = { 1, }, },
		[10] = { 4, damageEffectiveness = 1.12, baseMultiplier = 1.1206, levelRequirement = 32, statInterpolation = { 1, }, },
		[11] = { 4, damageEffectiveness = 1.14, baseMultiplier = 1.144, levelRequirement = 36, statInterpolation = { 1, }, },
		[12] = { 4, damageEffectiveness = 1.17, baseMultiplier = 1.1674, levelRequirement = 40, statInterpolation = { 1, }, },
		[13] = { 4, damageEffectiveness = 1.19, baseMultiplier = 1.1908, levelRequirement = 44, statInterpolation = { 1, }, },
		[14] = { 4, damageEffectiveness = 1.21, baseMultiplier = 1.2142, levelRequirement = 48, statInterpolation = { 1, }, },
		[15] = { 4, damageEffectiveness = 1.24, baseMultiplier = 1.2376, levelRequirement = 52, statInterpolation = { 1, }, },
		[16] = { 4, damageEffectiveness = 1.26, baseMultiplier = 1.261, levelRequirement = 56, statInterpolation = { 1, }, },
		[17] = { 4, damageEffectiveness = 1.28, baseMultiplier = 1.2844, levelRequirement = 60, statInterpolation = { 1, }, },
		[18] = { 4, damageEffectiveness = 1.31, baseMultiplier = 1.3078, levelRequirement = 64, statInterpolation = { 1, }, },
		[19] = { 4, damageEffectiveness = 1.33, baseMultiplier = 1.3312, levelRequirement = 67, statInterpolation = { 1, }, },
		[20] = { 4, damageEffectiveness = 1.35, baseMultiplier = 1.3546, levelRequirement = 70, statInterpolation = { 1, }, },
		[21] = { 4, damageEffectiveness = 1.38, baseMultiplier = 1.378, levelRequirement = 72, statInterpolation = { 1, }, },
		[22] = { 4, damageEffectiveness = 1.4, baseMultiplier = 1.4014, levelRequirement = 74, statInterpolation = { 1, }, },
		[23] = { 4, damageEffectiveness = 1.42, baseMultiplier = 1.4248, levelRequirement = 76, statInterpolation = { 1, }, },
		[24] = { 4, damageEffectiveness = 1.45, baseMultiplier = 1.4482, levelRequirement = 78, statInterpolation = { 1, }, },
		[25] = { 4, damageEffectiveness = 1.47, baseMultiplier = 1.4716, levelRequirement = 80, statInterpolation = { 1, }, },
		[26] = { 4, damageEffectiveness = 1.5, baseMultiplier = 1.495, levelRequirement = 82, statInterpolation = { 1, }, },
		[27] = { 4, damageEffectiveness = 1.52, baseMultiplier = 1.5184, levelRequirement = 84, statInterpolation = { 1, }, },
		[28] = { 4, damageEffectiveness = 1.54, baseMultiplier = 1.5418, levelRequirement = 86, statInterpolation = { 1, }, },
		[29] = { 4, damageEffectiveness = 1.57, baseMultiplier = 1.5652, levelRequirement = 88, statInterpolation = { 1, }, },
		[30] = { 4, damageEffectiveness = 1.59, baseMultiplier = 1.5886, levelRequirement = 90, statInterpolation = { 1, }, },
		[31] = { 4, damageEffectiveness = 1.6, baseMultiplier = 1.6003, levelRequirement = 91, statInterpolation = { 1, }, },
		[32] = { 4, damageEffectiveness = 1.61, baseMultiplier = 1.612, levelRequirement = 92, statInterpolation = { 1, }, },
		[33] = { 4, damageEffectiveness = 1.62, baseMultiplier = 1.6237, levelRequirement = 93, statInterpolation = { 1, }, },
		[34] = { 4, damageEffectiveness = 1.64, baseMultiplier = 1.6354, levelRequirement = 94, statInterpolation = { 1, }, },
		[35] = { 4, damageEffectiveness = 1.65, baseMultiplier = 1.6471, levelRequirement = 95, statInterpolation = { 1, }, },
		[36] = { 4, damageEffectiveness = 1.66, baseMultiplier = 1.6588, levelRequirement = 96, statInterpolation = { 1, }, },
		[37] = { 4, damageEffectiveness = 1.67, baseMultiplier = 1.6705, levelRequirement = 97, statInterpolation = { 1, }, },
		[38] = { 4, damageEffectiveness = 1.68, baseMultiplier = 1.6822, levelRequirement = 98, statInterpolation = { 1, }, },
		[39] = { 4, damageEffectiveness = 1.69, baseMultiplier = 1.6939, levelRequirement = 99, statInterpolation = { 1, }, },
		[40] = { 4, damageEffectiveness = 1.71, baseMultiplier = 1.7056, levelRequirement = 100, statInterpolation = { 1, }, },
	},
}
skills["RainOfSpores"] = {
	name = "Toxic Rain",
	color = 2,
	baseEffectiveness = 1.6000000238419,
	incrementalEffectiveness = 0.043200001120567,
	description = "Fire arrows into the air that rain down around the targeted area, dealing damage to enemies they hit and creating spore pods where they land. Each spore pod deals chaos damage over time to nearby enemies and slows their movement speed. The pods last for a duration before bursting, dealing area damage.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.ProjectileAttack] = true, [SkillType.SkillCanMirageArcher] = true, [SkillType.Area] = true, [SkillType.ProjectileDamage] = true, [SkillType.SkillCanTotem] = true, [SkillType.SkillCanTrap] = true, [SkillType.SkillCanMine] = true, [SkillType.Hit] = true, [SkillType.ChaosSkill] = true, [SkillType.Duration] = true, [SkillType.DamageOverTime] = true, [SkillType.Type73] = true, [SkillType.ChaosSkill] = true, [SkillType.Triggerable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "debuff_skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
	},
	baseMods = {
		skill("dotIsArea", true),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 0.5 },
	},
	stats = {
		"base_skill_effect_duration",
		"base_chaos_damage_to_deal_per_minute",
		"base_number_of_additional_arrows",
		"skill_physical_damage_%_to_convert_to_chaos",
		"rain_of_spores_vines_movement_speed_+%_final",
		"minimum_rain_of_spores_movement_speed_+%_final_cap",
		"base_is_projectile",
		"is_area_damage",
		"skill_can_fire_arrows",
		"cannot_pierce",
		"projectile_damage_modifiers_apply_to_skill_dot",
	},
	levels = {
		[1] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.5, baseMultiplier = 0.5, levelRequirement = 12, manaCost = 7, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[2] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.51, baseMultiplier = 0.512, levelRequirement = 15, manaCost = 7, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[3] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.52, baseMultiplier = 0.524, levelRequirement = 19, manaCost = 7, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[4] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.54, baseMultiplier = 0.536, levelRequirement = 23, manaCost = 8, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[5] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.55, baseMultiplier = 0.548, levelRequirement = 27, manaCost = 8, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[6] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.56, baseMultiplier = 0.56, levelRequirement = 31, manaCost = 8, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[7] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.57, baseMultiplier = 0.572, levelRequirement = 35, manaCost = 8, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[8] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.58, baseMultiplier = 0.584, levelRequirement = 38, manaCost = 8, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[9] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.6, baseMultiplier = 0.596, levelRequirement = 41, manaCost = 9, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[10] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.61, baseMultiplier = 0.608, levelRequirement = 44, manaCost = 9, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[11] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.62, baseMultiplier = 0.62, levelRequirement = 47, manaCost = 9, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[12] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.63, baseMultiplier = 0.632, levelRequirement = 50, manaCost = 9, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[13] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.64, baseMultiplier = 0.644, levelRequirement = 53, manaCost = 9, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[14] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.66, baseMultiplier = 0.656, levelRequirement = 56, manaCost = 10, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[15] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.67, baseMultiplier = 0.668, levelRequirement = 59, manaCost = 10, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[16] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.68, baseMultiplier = 0.68, levelRequirement = 62, manaCost = 10, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[17] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.69, baseMultiplier = 0.692, levelRequirement = 64, manaCost = 10, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[18] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.7, baseMultiplier = 0.704, levelRequirement = 66, manaCost = 10, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[19] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.72, baseMultiplier = 0.716, levelRequirement = 68, manaCost = 11, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[20] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.73, baseMultiplier = 0.728, levelRequirement = 70, manaCost = 11, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[21] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.74, baseMultiplier = 0.74, levelRequirement = 72, manaCost = 11, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[22] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.75, baseMultiplier = 0.752, levelRequirement = 74, manaCost = 11, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[23] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.76, baseMultiplier = 0.764, levelRequirement = 76, manaCost = 11, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[24] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.78, baseMultiplier = 0.776, levelRequirement = 78, manaCost = 11, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[25] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.79, baseMultiplier = 0.788, levelRequirement = 80, manaCost = 11, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[26] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.8, baseMultiplier = 0.8, levelRequirement = 82, manaCost = 12, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[27] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.81, baseMultiplier = 0.812, levelRequirement = 84, manaCost = 12, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[28] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.82, baseMultiplier = 0.824, levelRequirement = 86, manaCost = 12, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[29] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.84, baseMultiplier = 0.836, levelRequirement = 88, manaCost = 12, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[30] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.85, baseMultiplier = 0.848, levelRequirement = 90, manaCost = 12, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[31] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.85, baseMultiplier = 0.854, levelRequirement = 91, manaCost = 13, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[32] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.86, baseMultiplier = 0.86, levelRequirement = 92, manaCost = 13, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[33] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.87, baseMultiplier = 0.866, levelRequirement = 93, manaCost = 13, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[34] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.87, baseMultiplier = 0.872, levelRequirement = 94, manaCost = 13, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[35] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.88, baseMultiplier = 0.878, levelRequirement = 95, manaCost = 13, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[36] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.88, baseMultiplier = 0.884, levelRequirement = 96, manaCost = 14, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[37] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.89, baseMultiplier = 0.89, levelRequirement = 97, manaCost = 14, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[38] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.9, baseMultiplier = 0.896, levelRequirement = 98, manaCost = 14, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[39] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.9, baseMultiplier = 0.902, levelRequirement = 99, manaCost = 14, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
		[40] = { 1000, 20.000001241763, 4, 50, -10, -60, damageEffectiveness = 0.91, baseMultiplier = 0.908, levelRequirement = 100, manaCost = 14, statInterpolation = { 1, 3, 1, 1, 1, 1, }, },
	},
}
skills["SplitArrow"] = {
	name = "Split Arrow",
	color = 2,
	description = "Fires multiple arrows at different targets.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.ProjectileAttack] = true, [SkillType.SkillCanMirageArcher] = true, [SkillType.Projectile] = true, [SkillType.SkillCanVolley] = true, [SkillType.SkillCanTotem] = true, [SkillType.SkillCanTrap] = true, [SkillType.SkillCanMine] = true, [SkillType.Triggerable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "attack_speed_+%", 0.5 },
	},
	stats = {
		"base_number_of_additional_arrows",
		"skill_can_fire_arrows",
	},
	levels = {
		[1] = { 4, manaCost = 6, levelRequirement = 1, statInterpolation = { 1, }, },
		[2] = { 4, damageEffectiveness = 1.01, baseMultiplier = 1.01, levelRequirement = 2, manaCost = 6, statInterpolation = { 1, }, },
		[3] = { 4, damageEffectiveness = 1.02, baseMultiplier = 1.02, levelRequirement = 4, manaCost = 6, statInterpolation = { 1, }, },
		[4] = { 5, damageEffectiveness = 1.03, baseMultiplier = 1.03, levelRequirement = 7, manaCost = 7, statInterpolation = { 1, }, },
		[5] = { 5, damageEffectiveness = 1.04, baseMultiplier = 1.04, levelRequirement = 11, manaCost = 7, statInterpolation = { 1, }, },
		[6] = { 5, damageEffectiveness = 1.05, baseMultiplier = 1.05, levelRequirement = 16, manaCost = 7, statInterpolation = { 1, }, },
		[7] = { 5, damageEffectiveness = 1.06, baseMultiplier = 1.06, levelRequirement = 20, manaCost = 7, statInterpolation = { 1, }, },
		[8] = { 6, damageEffectiveness = 1.07, baseMultiplier = 1.07, levelRequirement = 24, manaCost = 8, statInterpolation = { 1, }, },
		[9] = { 6, damageEffectiveness = 1.08, baseMultiplier = 1.08, levelRequirement = 28, manaCost = 8, statInterpolation = { 1, }, },
		[10] = { 6, damageEffectiveness = 1.09, baseMultiplier = 1.09, levelRequirement = 32, manaCost = 8, statInterpolation = { 1, }, },
		[11] = { 6, damageEffectiveness = 1.1, baseMultiplier = 1.1, levelRequirement = 36, manaCost = 8, statInterpolation = { 1, }, },
		[12] = { 7, damageEffectiveness = 1.11, baseMultiplier = 1.11, levelRequirement = 40, manaCost = 8, statInterpolation = { 1, }, },
		[13] = { 7, damageEffectiveness = 1.12, baseMultiplier = 1.12, levelRequirement = 44, manaCost = 9, statInterpolation = { 1, }, },
		[14] = { 7, damageEffectiveness = 1.13, baseMultiplier = 1.13, levelRequirement = 48, manaCost = 9, statInterpolation = { 1, }, },
		[15] = { 7, damageEffectiveness = 1.14, baseMultiplier = 1.14, levelRequirement = 52, manaCost = 9, statInterpolation = { 1, }, },
		[16] = { 7, damageEffectiveness = 1.15, baseMultiplier = 1.15, levelRequirement = 56, manaCost = 9, statInterpolation = { 1, }, },
		[17] = { 8, damageEffectiveness = 1.16, baseMultiplier = 1.16, levelRequirement = 60, manaCost = 9, statInterpolation = { 1, }, },
		[18] = { 8, damageEffectiveness = 1.17, baseMultiplier = 1.17, levelRequirement = 64, manaCost = 10, statInterpolation = { 1, }, },
		[19] = { 8, damageEffectiveness = 1.18, baseMultiplier = 1.18, levelRequirement = 67, manaCost = 10, statInterpolation = { 1, }, },
		[20] = { 8, damageEffectiveness = 1.19, baseMultiplier = 1.19, levelRequirement = 70, manaCost = 10, statInterpolation = { 1, }, },
		[21] = { 9, damageEffectiveness = 1.2, baseMultiplier = 1.2, levelRequirement = 72, manaCost = 10, statInterpolation = { 1, }, },
		[22] = { 9, damageEffectiveness = 1.21, baseMultiplier = 1.21, levelRequirement = 74, manaCost = 10, statInterpolation = { 1, }, },
		[23] = { 9, damageEffectiveness = 1.22, baseMultiplier = 1.22, levelRequirement = 76, manaCost = 11, statInterpolation = { 1, }, },
		[24] = { 9, damageEffectiveness = 1.23, baseMultiplier = 1.23, levelRequirement = 78, manaCost = 11, statInterpolation = { 1, }, },
		[25] = { 10, damageEffectiveness = 1.24, baseMultiplier = 1.24, levelRequirement = 80, manaCost = 11, statInterpolation = { 1, }, },
		[26] = { 10, damageEffectiveness = 1.25, baseMultiplier = 1.25, levelRequirement = 82, manaCost = 11, statInterpolation = { 1, }, },
		[27] = { 10, damageEffectiveness = 1.26, baseMultiplier = 1.26, levelRequirement = 84, manaCost = 11, statInterpolation = { 1, }, },
		[28] = { 10, damageEffectiveness = 1.27, baseMultiplier = 1.27, levelRequirement = 86, manaCost = 12, statInterpolation = { 1, }, },
		[29] = { 10, damageEffectiveness = 1.28, baseMultiplier = 1.28, levelRequirement = 88, manaCost = 12, statInterpolation = { 1, }, },
		[30] = { 11, damageEffectiveness = 1.29, baseMultiplier = 1.29, levelRequirement = 90, manaCost = 12, statInterpolation = { 1, }, },
		[31] = { 11, damageEffectiveness = 1.3, baseMultiplier = 1.295, levelRequirement = 91, manaCost = 12, statInterpolation = { 1, }, },
		[32] = { 11, damageEffectiveness = 1.3, baseMultiplier = 1.3, levelRequirement = 92, manaCost = 12, statInterpolation = { 1, }, },
		[33] = { 11, damageEffectiveness = 1.31, baseMultiplier = 1.305, levelRequirement = 93, manaCost = 13, statInterpolation = { 1, }, },
		[34] = { 11, damageEffectiveness = 1.31, baseMultiplier = 1.31, levelRequirement = 94, manaCost = 13, statInterpolation = { 1, }, },
		[35] = { 11, damageEffectiveness = 1.32, baseMultiplier = 1.315, levelRequirement = 95, manaCost = 13, statInterpolation = { 1, }, },
		[36] = { 11, damageEffectiveness = 1.32, baseMultiplier = 1.32, levelRequirement = 96, manaCost = 13, statInterpolation = { 1, }, },
		[37] = { 12, damageEffectiveness = 1.33, baseMultiplier = 1.325, levelRequirement = 97, manaCost = 13, statInterpolation = { 1, }, },
		[38] = { 12, damageEffectiveness = 1.33, baseMultiplier = 1.33, levelRequirement = 98, manaCost = 14, statInterpolation = { 1, }, },
		[39] = { 12, damageEffectiveness = 1.34, baseMultiplier = 1.335, levelRequirement = 99, manaCost = 14, statInterpolation = { 1, }, },
		[40] = { 12, damageEffectiveness = 1.34, baseMultiplier = 1.34, levelRequirement = 100, manaCost = 14, statInterpolation = { 1, }, },
	},
}
skills["SummonIceGolem"] = {
	name = "Summon Ice Golem",
	color = 2,
	description = "Summons an Ice Golem that grants you increased Critical Strike Chance and Accuracy. The Ice Golem can use an icy barrage spell and a chilling spinning dash in addition to its melee attack.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.ColdSkill] = true, [SkillType.SkillCanMine] = true, [SkillType.Minion] = true, [SkillType.CreateMinion] = true, [SkillType.SpellCanRepeat] = true, [SkillType.Spell] = true, [SkillType.SkillCanTotem] = true, [SkillType.SkillCanTrap] = true, [SkillType.Golem] = true, [SkillType.CreatesMinion] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Projectile] = true, [SkillType.SkillCanVolley] = true, [SkillType.Spell] = true, [SkillType.Hit] = true, [SkillType.MovementSkill] = true, [SkillType.AttackCanRepeat] = true, [SkillType.ChillingArea] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	minionList = {
		"SummonedIceGolem",
	},
	statMap = {
		["ice_golem_grants_critical_strike_chance_+%"] = {
			mod("CritChance", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["ice_golem_grants_accuracy_+%"] = {
			mod("Accuracy", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
	},
	baseFlags = {
		spell = true,
		minion = true,
		golem = true,
	},
	baseMods = {
		skill("allowTotemBuff", true),
		flag("Condition:HaveColdGolem", { type = "GlobalEffect", effectType = "Buff" }),
	},
	qualityStats = {
		{ "minion_maximum_life_+%", 1 },
		{ "minion_damage_+%", 1 },
	},
	stats = {
		"base_actor_scale_+%",
		"base_number_of_golems_allowed",
		"ice_golem_grants_critical_strike_chance_+%",
		"ice_golem_grants_accuracy_+%",
		"minion_maximum_life_+%",
		"display_minion_monster_type",
		"display_minion_monster_level",
	},
	levels = {
		[1] = { 0, 1, 20, 20, 30, 6, 34, cooldown = 6, levelRequirement = 34, manaCost = 30, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[2] = { 1, 1, 21, 21, 32, 6, 36, cooldown = 6, levelRequirement = 36, manaCost = 32, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[3] = { 1, 1, 21, 21, 34, 6, 38, cooldown = 6, levelRequirement = 38, manaCost = 34, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[4] = { 2, 1, 22, 22, 36, 6, 40, cooldown = 6, levelRequirement = 40, manaCost = 36, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[5] = { 2, 1, 22, 22, 38, 6, 42, cooldown = 6, levelRequirement = 42, manaCost = 38, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[6] = { 3, 1, 23, 23, 40, 6, 44, cooldown = 6, levelRequirement = 44, manaCost = 40, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[7] = { 3, 1, 23, 23, 42, 6, 46, cooldown = 6, levelRequirement = 46, manaCost = 42, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[8] = { 4, 1, 24, 24, 44, 6, 48, cooldown = 6, levelRequirement = 48, manaCost = 44, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[9] = { 4, 1, 24, 24, 46, 6, 50, cooldown = 6, levelRequirement = 50, manaCost = 44, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[10] = { 5, 1, 25, 25, 48, 6, 52, cooldown = 6, levelRequirement = 52, manaCost = 46, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[11] = { 5, 1, 25, 25, 50, 6, 54, cooldown = 6, levelRequirement = 54, manaCost = 48, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[12] = { 6, 1, 26, 26, 52, 6, 56, cooldown = 6, levelRequirement = 56, manaCost = 48, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[13] = { 6, 1, 26, 26, 54, 6, 58, cooldown = 6, levelRequirement = 58, manaCost = 50, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[14] = { 7, 1, 27, 27, 56, 6, 60, cooldown = 6, levelRequirement = 60, manaCost = 50, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[15] = { 7, 1, 27, 27, 58, 6, 62, cooldown = 6, levelRequirement = 62, manaCost = 52, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[16] = { 8, 1, 28, 28, 60, 6, 64, cooldown = 6, levelRequirement = 64, manaCost = 52, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[17] = { 8, 1, 28, 28, 62, 6, 66, cooldown = 6, levelRequirement = 66, manaCost = 52, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[18] = { 9, 1, 29, 29, 64, 6, 68, cooldown = 6, levelRequirement = 68, manaCost = 52, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[19] = { 9, 1, 29, 29, 66, 6, 69, cooldown = 6, levelRequirement = 69, manaCost = 54, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[20] = { 10, 1, 30, 30, 68, 6, 70, cooldown = 6, levelRequirement = 70, manaCost = 54, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[21] = { 10, 1, 30, 30, 70, 6, 72, cooldown = 6, levelRequirement = 72, manaCost = 56, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[22] = { 11, 1, 31, 31, 72, 6, 74, cooldown = 6, levelRequirement = 74, manaCost = 56, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[23] = { 11, 1, 31, 31, 74, 6, 76, cooldown = 6, levelRequirement = 76, manaCost = 58, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[24] = { 12, 1, 32, 32, 76, 6, 78, cooldown = 6, levelRequirement = 78, manaCost = 58, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[25] = { 12, 1, 32, 32, 78, 6, 80, cooldown = 6, levelRequirement = 80, manaCost = 60, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[26] = { 13, 1, 33, 33, 80, 6, 82, cooldown = 6, levelRequirement = 82, manaCost = 60, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[27] = { 13, 1, 33, 33, 82, 6, 84, cooldown = 6, levelRequirement = 84, manaCost = 60, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[28] = { 14, 1, 34, 34, 84, 6, 86, cooldown = 6, levelRequirement = 86, manaCost = 60, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[29] = { 14, 1, 34, 34, 86, 6, 88, cooldown = 6, levelRequirement = 88, manaCost = 62, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[30] = { 15, 1, 35, 35, 88, 6, 90, cooldown = 6, levelRequirement = 90, manaCost = 62, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[31] = { 15, 1, 35, 35, 89, 6, 91, cooldown = 6, levelRequirement = 91, manaCost = 62, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[32] = { 15, 1, 35, 35, 90, 6, 92, cooldown = 6, levelRequirement = 92, manaCost = 63, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[33] = { 15, 1, 35, 35, 91, 6, 93, cooldown = 6, levelRequirement = 93, manaCost = 63, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[34] = { 16, 1, 36, 36, 92, 6, 94, cooldown = 6, levelRequirement = 94, manaCost = 63, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[35] = { 16, 1, 36, 36, 93, 6, 95, cooldown = 6, levelRequirement = 95, manaCost = 63, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[36] = { 16, 1, 36, 36, 94, 6, 96, cooldown = 6, levelRequirement = 96, manaCost = 64, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[37] = { 16, 1, 36, 36, 95, 6, 97, cooldown = 6, levelRequirement = 97, manaCost = 64, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[38] = { 17, 1, 37, 37, 96, 6, 98, cooldown = 6, levelRequirement = 98, manaCost = 64, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[39] = { 17, 1, 37, 37, 97, 6, 99, cooldown = 6, levelRequirement = 99, manaCost = 64, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
		[40] = { 17, 1, 37, 37, 98, 6, 100, cooldown = 6, levelRequirement = 100, manaCost = 64, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, },
	},
}
skills["TemporalChains"] = {
	name = "Temporal Chains",
	color = 2,
	description = "Curses all targets in an area, Slowing them, and making effects on them expire more slowly.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.SkillCanTrap] = true, [SkillType.SkillCanTotem] = true, [SkillType.SkillCanMine] = true, [SkillType.SpellCanRepeat] = true, [SkillType.Curse] = true, [SkillType.Triggerable] = true, [SkillType.SpellCanCascade] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 0.5,
	statMap = {
		["temporal_chains_action_speed_+%_final"] = {
			mod("TemporalChainsActionSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }, { type = "Condition", var = "RareOrUnique", neg = true }),
		},
		["buff_time_passed_+%_other_than_temporal_chains"] = {
			mod("BuffExpireFaster", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
		["curse_effect_+%_vs_players"] = {
			mod("CurseEffectAgainstPlayer", "INC", nil),
		},
		["temporal_chains_action_speed_+%_vs_rare_or_unique_final"] = {
			mod("TemporalChainsActionSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }, { type = "Condition", var = "RareOrUnique" }),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("debuff", true),
		skill("radius", 22),
	},
	qualityStats = {
		{ "temporal_chains_action_speed_+%_final", -0.5 },
	},
	stats = {
		"base_skill_effect_duration",
		"active_skill_base_radius_+",
		"temporal_chains_action_speed_+%_final",
		"buff_time_passed_+%_other_than_temporal_chains",
		"curse_effect_+%_vs_players",
		"temporal_chains_action_speed_+%_vs_rare_or_unique_final",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 5000, 0, -20, -40, -40, -10, manaCost = 16, levelRequirement = 24, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[2] = { 5050, 1, -20, -40, -40, -10, manaCost = 17, levelRequirement = 27, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[3] = { 5100, 1, -21, -40, -40, -10, manaCost = 18, levelRequirement = 30, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[4] = { 5150, 1, -21, -40, -40, -10, manaCost = 19, levelRequirement = 33, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[5] = { 5200, 2, -22, -40, -40, -11, manaCost = 21, levelRequirement = 36, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[6] = { 5250, 2, -22, -40, -40, -11, manaCost = 22, levelRequirement = 39, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[7] = { 5300, 2, -23, -40, -40, -11, manaCost = 23, levelRequirement = 42, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[8] = { 5350, 3, -23, -40, -40, -11, manaCost = 24, levelRequirement = 45, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[9] = { 5400, 3, -24, -40, -40, -12, manaCost = 25, levelRequirement = 48, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[10] = { 5450, 3, -24, -40, -40, -12, manaCost = 26, levelRequirement = 50, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[11] = { 5500, 4, -25, -40, -40, -12, manaCost = 26, levelRequirement = 52, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[12] = { 5550, 4, -25, -40, -40, -12, manaCost = 27, levelRequirement = 54, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[13] = { 5600, 4, -26, -40, -40, -13, manaCost = 28, levelRequirement = 56, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[14] = { 5650, 5, -26, -40, -40, -13, manaCost = 29, levelRequirement = 58, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[15] = { 5700, 5, -27, -40, -40, -13, manaCost = 29, levelRequirement = 60, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[16] = { 5750, 5, -27, -40, -40, -13, manaCost = 30, levelRequirement = 62, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[17] = { 5800, 6, -28, -40, -40, -14, manaCost = 31, levelRequirement = 64, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[18] = { 5850, 6, -28, -40, -40, -14, manaCost = 31, levelRequirement = 66, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[19] = { 5900, 6, -29, -40, -40, -14, manaCost = 32, levelRequirement = 68, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[20] = { 5950, 7, -29, -40, -40, -14, manaCost = 33, levelRequirement = 70, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[21] = { 6000, 7, -30, -40, -40, -15, manaCost = 34, levelRequirement = 72, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[22] = { 6050, 7, -30, -40, -40, -15, manaCost = 34, levelRequirement = 74, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[23] = { 6100, 8, -31, -40, -40, -15, manaCost = 35, levelRequirement = 76, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[24] = { 6150, 8, -31, -40, -40, -15, manaCost = 36, levelRequirement = 78, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[25] = { 6200, 8, -32, -40, -40, -16, manaCost = 36, levelRequirement = 80, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[26] = { 6250, 9, -32, -40, -40, -16, manaCost = 37, levelRequirement = 82, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[27] = { 6300, 9, -33, -40, -40, -16, manaCost = 38, levelRequirement = 84, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[28] = { 6350, 9, -33, -40, -40, -16, manaCost = 39, levelRequirement = 86, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[29] = { 6400, 10, -34, -40, -40, -17, manaCost = 39, levelRequirement = 88, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[30] = { 6450, 10, -34, -40, -40, -17, manaCost = 40, levelRequirement = 90, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[31] = { 6450, 10, -34, -40, -40, -17, manaCost = 40, levelRequirement = 91, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[32] = { 6500, 10, -35, -40, -40, -17, manaCost = 41, levelRequirement = 92, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[33] = { 6500, 10, -35, -40, -40, -17, manaCost = 41, levelRequirement = 93, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[34] = { 6550, 11, -35, -40, -40, -17, manaCost = 42, levelRequirement = 94, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[35] = { 6550, 11, -35, -40, -40, -17, manaCost = 42, levelRequirement = 95, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[36] = { 6600, 11, -36, -40, -40, -18, manaCost = 42, levelRequirement = 96, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[37] = { 6600, 11, -36, -40, -40, -18, manaCost = 43, levelRequirement = 97, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[38] = { 6650, 11, -36, -40, -40, -18, manaCost = 43, levelRequirement = 98, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[39] = { 6650, 11, -36, -40, -40, -18, manaCost = 43, levelRequirement = 99, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[40] = { 6700, 12, -37, -40, -40, -18, manaCost = 44, levelRequirement = 100, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
	},
}
skills["TornadoShot"] = {
	name = "Tornado Shot",
	color = 2,
	description = "Fires a piercing shot that travels until it reaches the targeted location. It will then fire projectiles out in all directions from that point.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.SkillCanVolley] = true, [SkillType.SkillCanTrap] = true, [SkillType.SkillCanMine] = true, [SkillType.SkillCanTotem] = true, [SkillType.ProjectileAttack] = true, [SkillType.SkillCanMirageArcher] = true, [SkillType.Triggerable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "projectile_damage_+%", 1 },
	},
	stats = {
		"tornado_shot_num_of_secondary_projectiles",
		"base_is_projectile",
		"skill_can_fire_arrows",
	},
	levels = {
		[1] = { 3, damageEffectiveness = 0.9, baseMultiplier = 0.9, levelRequirement = 28, manaCost = 8, statInterpolation = { 1, }, },
		[2] = { 3, damageEffectiveness = 0.91, baseMultiplier = 0.91, levelRequirement = 31, manaCost = 8, statInterpolation = { 1, }, },
		[3] = { 3, damageEffectiveness = 0.92, baseMultiplier = 0.92, levelRequirement = 34, manaCost = 8, statInterpolation = { 1, }, },
		[4] = { 3, damageEffectiveness = 0.93, baseMultiplier = 0.93, levelRequirement = 37, manaCost = 8, statInterpolation = { 1, }, },
		[5] = { 3, damageEffectiveness = 0.94, baseMultiplier = 0.94, levelRequirement = 40, manaCost = 9, statInterpolation = { 1, }, },
		[6] = { 3, damageEffectiveness = 0.95, baseMultiplier = 0.95, levelRequirement = 42, manaCost = 9, statInterpolation = { 1, }, },
		[7] = { 3, damageEffectiveness = 0.96, baseMultiplier = 0.96, levelRequirement = 44, manaCost = 9, statInterpolation = { 1, }, },
		[8] = { 3, damageEffectiveness = 0.97, baseMultiplier = 0.97, levelRequirement = 46, manaCost = 9, statInterpolation = { 1, }, },
		[9] = { 3, damageEffectiveness = 0.98, baseMultiplier = 0.98, levelRequirement = 48, manaCost = 9, statInterpolation = { 1, }, },
		[10] = { 3, damageEffectiveness = 0.99, baseMultiplier = 0.99, levelRequirement = 50, manaCost = 9, statInterpolation = { 1, }, },
		[11] = { 3, manaCost = 9, levelRequirement = 52, statInterpolation = { 1, }, },
		[12] = { 3, damageEffectiveness = 1.01, baseMultiplier = 1.01, levelRequirement = 54, manaCost = 10, statInterpolation = { 1, }, },
		[13] = { 3, damageEffectiveness = 1.02, baseMultiplier = 1.02, levelRequirement = 56, manaCost = 10, statInterpolation = { 1, }, },
		[14] = { 3, damageEffectiveness = 1.03, baseMultiplier = 1.03, levelRequirement = 58, manaCost = 10, statInterpolation = { 1, }, },
		[15] = { 3, damageEffectiveness = 1.04, baseMultiplier = 1.04, levelRequirement = 60, manaCost = 10, statInterpolation = { 1, }, },
		[16] = { 3, damageEffectiveness = 1.05, baseMultiplier = 1.05, levelRequirement = 62, manaCost = 10, statInterpolation = { 1, }, },
		[17] = { 3, damageEffectiveness = 1.06, baseMultiplier = 1.06, levelRequirement = 64, manaCost = 10, statInterpolation = { 1, }, },
		[18] = { 3, damageEffectiveness = 1.07, baseMultiplier = 1.07, levelRequirement = 66, manaCost = 10, statInterpolation = { 1, }, },
		[19] = { 3, damageEffectiveness = 1.08, baseMultiplier = 1.08, levelRequirement = 68, manaCost = 10, statInterpolation = { 1, }, },
		[20] = { 3, damageEffectiveness = 1.09, baseMultiplier = 1.09, levelRequirement = 70, manaCost = 10, statInterpolation = { 1, }, },
		[21] = { 3, damageEffectiveness = 1.1, baseMultiplier = 1.1, levelRequirement = 72, manaCost = 10, statInterpolation = { 1, }, },
		[22] = { 3, damageEffectiveness = 1.11, baseMultiplier = 1.11, levelRequirement = 74, manaCost = 10, statInterpolation = { 1, }, },
		[23] = { 3, damageEffectiveness = 1.12, baseMultiplier = 1.12, levelRequirement = 76, manaCost = 11, statInterpolation = { 1, }, },
		[24] = { 3, damageEffectiveness = 1.13, baseMultiplier = 1.13, levelRequirement = 78, manaCost = 11, statInterpolation = { 1, }, },
		[25] = { 3, damageEffectiveness = 1.14, baseMultiplier = 1.14, levelRequirement = 80, manaCost = 11, statInterpolation = { 1, }, },
		[26] = { 3, damageEffectiveness = 1.15, baseMultiplier = 1.15, levelRequirement = 82, manaCost = 11, statInterpolation = { 1, }, },
		[27] = { 3, damageEffectiveness = 1.16, baseMultiplier = 1.16, levelRequirement = 84, manaCost = 11, statInterpolation = { 1, }, },
		[28] = { 3, damageEffectiveness = 1.17, baseMultiplier = 1.17, levelRequirement = 86, manaCost = 12, statInterpolation = { 1, }, },
		[29] = { 3, damageEffectiveness = 1.18, baseMultiplier = 1.18, levelRequirement = 88, manaCost = 12, statInterpolation = { 1, }, },
		[30] = { 3, damageEffectiveness = 1.19, baseMultiplier = 1.19, levelRequirement = 90, manaCost = 12, statInterpolation = { 1, }, },
		[31] = { 3, damageEffectiveness = 1.2, baseMultiplier = 1.195, levelRequirement = 91, manaCost = 12, statInterpolation = { 1, }, },
		[32] = { 3, damageEffectiveness = 1.2, baseMultiplier = 1.2, levelRequirement = 92, manaCost = 12, statInterpolation = { 1, }, },
		[33] = { 3, damageEffectiveness = 1.21, baseMultiplier = 1.205, levelRequirement = 93, manaCost = 12, statInterpolation = { 1, }, },
		[34] = { 3, damageEffectiveness = 1.21, baseMultiplier = 1.21, levelRequirement = 94, manaCost = 12, statInterpolation = { 1, }, },
		[35] = { 3, damageEffectiveness = 1.22, baseMultiplier = 1.215, levelRequirement = 95, manaCost = 12, statInterpolation = { 1, }, },
		[36] = { 3, damageEffectiveness = 1.22, baseMultiplier = 1.22, levelRequirement = 96, manaCost = 12, statInterpolation = { 1, }, },
		[37] = { 3, damageEffectiveness = 1.23, baseMultiplier = 1.225, levelRequirement = 97, manaCost = 13, statInterpolation = { 1, }, },
		[38] = { 3, damageEffectiveness = 1.23, baseMultiplier = 1.23, levelRequirement = 98, manaCost = 13, statInterpolation = { 1, }, },
		[39] = { 3, damageEffectiveness = 1.24, baseMultiplier = 1.235, levelRequirement = 99, manaCost = 13, statInterpolation = { 1, }, },
		[40] = { 3, damageEffectiveness = 1.24, baseMultiplier = 1.24, levelRequirement = 100, manaCost = 13, statInterpolation = { 1, }, },
	},
}
skills["BoneLance"] = {
	name = "Unearth",
	color = 2,
	baseEffectiveness = 3.2646999359131,
	incrementalEffectiveness = 0.032499998807907,
	description = "Fires a projectile that will pierce through enemies to impact the ground at the targeted location, creating a Bone Archer corpse where it lands.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.SkillCanVolley] = true, [SkillType.SkillCanTotem] = true, [SkillType.SkillCanMine] = true, [SkillType.SkillCanTrap] = true, [SkillType.Triggerable] = true, [SkillType.Hit] = true, [SkillType.SpellCanRepeat] = true, [SkillType.CanRapidFire] = true, [SkillType.Area] = true, [SkillType.AreaSpell] = true, [SkillType.PhysicalSkill] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.6,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "base_cast_speed_+%", 0.5 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"unearth_base_corpse_level",
		"desecrate_maximum_number_of_corpses",
		"active_skill_base_radius_+",
		"base_is_projectile",
		"always_pierce",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 12, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 10, manaCost = 7, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[2] = { 0.80000001192093, 1.2000000476837, 15, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 13, manaCost = 7, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[3] = { 0.80000001192093, 1.2000000476837, 19, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 17, manaCost = 8, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[4] = { 0.80000001192093, 1.2000000476837, 24, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 21, manaCost = 9, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[5] = { 0.80000001192093, 1.2000000476837, 28, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 25, manaCost = 10, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[6] = { 0.80000001192093, 1.2000000476837, 32, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 29, manaCost = 11, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[7] = { 0.80000001192093, 1.2000000476837, 37, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 33, manaCost = 12, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[8] = { 0.80000001192093, 1.2000000476837, 40, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 36, manaCost = 12, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[9] = { 0.80000001192093, 1.2000000476837, 43, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 39, manaCost = 13, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[10] = { 0.80000001192093, 1.2000000476837, 47, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 42, manaCost = 14, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[11] = { 0.80000001192093, 1.2000000476837, 50, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 45, manaCost = 14, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[12] = { 0.80000001192093, 1.2000000476837, 53, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 48, manaCost = 15, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[13] = { 0.80000001192093, 1.2000000476837, 57, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 51, manaCost = 16, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[14] = { 0.80000001192093, 1.2000000476837, 60, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 54, manaCost = 16, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[15] = { 0.80000001192093, 1.2000000476837, 64, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 57, manaCost = 17, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[16] = { 0.80000001192093, 1.2000000476837, 67, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 60, manaCost = 18, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[17] = { 0.80000001192093, 1.2000000476837, 71, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 63, manaCost = 18, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[18] = { 0.80000001192093, 1.2000000476837, 74, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 66, manaCost = 19, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[19] = { 0.80000001192093, 1.2000000476837, 77, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 68, manaCost = 19, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 80, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 70, manaCost = 20, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 81, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 72, manaCost = 20, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 82, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 74, manaCost = 21, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 83, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 76, manaCost = 21, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 84, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 78, manaCost = 21, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 85, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 80, manaCost = 22, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 86, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 82, manaCost = 22, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 87, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 84, manaCost = 23, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 88, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 86, manaCost = 23, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 89, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 88, manaCost = 24, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 90, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 90, manaCost = 24, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 90, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 91, manaCost = 24, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 91, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 92, manaCost = 25, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 91, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 93, manaCost = 25, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[34] = { 0.80000001192093, 1.2000000476837, 92, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 94, manaCost = 25, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[35] = { 0.80000001192093, 1.2000000476837, 92, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 95, manaCost = 25, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[36] = { 0.80000001192093, 1.2000000476837, 93, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 96, manaCost = 25, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[37] = { 0.80000001192093, 1.2000000476837, 93, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 97, manaCost = 26, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[38] = { 0.80000001192093, 1.2000000476837, 94, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 98, manaCost = 26, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[39] = { 0.80000001192093, 1.2000000476837, 94, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 99, manaCost = 26, statInterpolation = { 3, 3, 1, 1, 1, }, },
		[40] = { 0.80000001192093, 1.2000000476837, 95, 10, 0, damageEffectiveness = 1.25, critChance = 6, levelRequirement = 100, manaCost = 26, statInterpolation = { 3, 3, 1, 1, 1, }, },
	},
}
skills["SnappingAdder"] = {
	name = "Venom Gyre",
	color = 2,
	baseEffectiveness = 1.25,
	incrementalEffectiveness = 0.023299999535084,
	description = "Fires a returning projectile that can be caught. Caught projectiles spiral outwards when you use Whirling Blades and do not return. Requires a Dagger or Claw.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.ProjectileAttack] = true, [SkillType.Projectile] = true, [SkillType.SkillCanVolley] = true, [SkillType.ChaosSkill] = true, },
	weaponTypes = {
		["Dagger"] = true,
		["Claw"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Outgoing Projectile",
		},
		{
			name = "Returning Projectile",
		},
	},
	baseFlags = {
		attack = true,
		projectile = true,
	},
	baseMods = {
		flag("Condition:ReturningProjectile", { type = "SkillPart", skillPart = 2 }),
	},
	qualityStats = {
		{ "base_poison_duration_+%", 1 },
	},
	stats = {
		"maximum_number_of_snapping_adder_projectiles",
		"skill_physical_damage_%_to_convert_to_chaos",
		"base_chance_to_poison_on_hit_%",
		"projectile_speed_variation_+%",
		"attack_minimum_added_chaos_damage",
		"attack_maximum_added_chaos_damage",
		"snapping_adder_maximum_projectiles_released",
		"snapping_adder_released_projectile_damage_+%_final",
		"active_skill_returning_projectile_damage_+%_final",
		"base_is_projectile",
		"returning_projectiles_always_pierce",
		"projectiles_return",
		"projectiles_return_if_no_hit_object",
	},
	levels = {
		[1] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 0.8, duration = 12, manaCost = 5, damageEffectiveness = 0.8, attackSpeedMultiplier = 20, levelRequirement = 12, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[2] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 0.812, duration = 12, manaCost = 5, damageEffectiveness = 0.81, attackSpeedMultiplier = 20, levelRequirement = 15, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[3] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 0.825, duration = 12, manaCost = 5, damageEffectiveness = 0.82, attackSpeedMultiplier = 20, levelRequirement = 19, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[4] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 0.837, duration = 12, manaCost = 5, damageEffectiveness = 0.84, attackSpeedMultiplier = 20, levelRequirement = 23, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[5] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 0.85, duration = 12, manaCost = 5, damageEffectiveness = 0.85, attackSpeedMultiplier = 20, levelRequirement = 27, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[6] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 0.862, duration = 12, manaCost = 5, damageEffectiveness = 0.86, attackSpeedMultiplier = 20, levelRequirement = 31, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[7] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 0.875, duration = 12, manaCost = 5, damageEffectiveness = 0.87, attackSpeedMultiplier = 20, levelRequirement = 35, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[8] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 0.887, duration = 12, manaCost = 5, damageEffectiveness = 0.89, attackSpeedMultiplier = 20, levelRequirement = 38, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[9] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 0.9, duration = 12, manaCost = 6, damageEffectiveness = 0.9, attackSpeedMultiplier = 20, levelRequirement = 41, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[10] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 0.912, duration = 12, manaCost = 6, damageEffectiveness = 0.91, attackSpeedMultiplier = 20, levelRequirement = 44, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[11] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 0.925, duration = 12, manaCost = 6, damageEffectiveness = 0.92, attackSpeedMultiplier = 20, levelRequirement = 47, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[12] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 0.937, duration = 12, manaCost = 6, damageEffectiveness = 0.94, attackSpeedMultiplier = 20, levelRequirement = 50, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[13] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 0.95, duration = 12, manaCost = 6, damageEffectiveness = 0.95, attackSpeedMultiplier = 20, levelRequirement = 53, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[14] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 0.962, duration = 12, manaCost = 6, damageEffectiveness = 0.96, attackSpeedMultiplier = 20, levelRequirement = 56, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[15] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 0.975, duration = 12, manaCost = 6, damageEffectiveness = 0.97, attackSpeedMultiplier = 20, levelRequirement = 59, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[16] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 0.987, duration = 12, manaCost = 6, damageEffectiveness = 0.99, attackSpeedMultiplier = 20, levelRequirement = 62, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[17] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, attackSpeedMultiplier = 20, levelRequirement = 64, duration = 12, manaCost = 7, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[18] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 1.012, duration = 12, manaCost = 7, damageEffectiveness = 1.01, attackSpeedMultiplier = 20, levelRequirement = 66, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[19] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 1.025, duration = 12, manaCost = 7, damageEffectiveness = 1.03, attackSpeedMultiplier = 20, levelRequirement = 68, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[20] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 1.037, duration = 12, manaCost = 7, damageEffectiveness = 1.04, attackSpeedMultiplier = 20, levelRequirement = 70, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[21] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 1.05, duration = 12, manaCost = 7, damageEffectiveness = 1.05, attackSpeedMultiplier = 20, levelRequirement = 72, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[22] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 1.062, duration = 12, manaCost = 7, damageEffectiveness = 1.06, attackSpeedMultiplier = 20, levelRequirement = 74, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[23] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 1.075, duration = 12, manaCost = 7, damageEffectiveness = 1.08, attackSpeedMultiplier = 20, levelRequirement = 76, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[24] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 1.087, duration = 12, manaCost = 7, damageEffectiveness = 1.09, attackSpeedMultiplier = 20, levelRequirement = 78, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[25] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 1.1, duration = 12, manaCost = 8, damageEffectiveness = 1.1, attackSpeedMultiplier = 20, levelRequirement = 80, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[26] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 1.112, duration = 12, manaCost = 8, damageEffectiveness = 1.11, attackSpeedMultiplier = 20, levelRequirement = 82, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[27] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 1.124, duration = 12, manaCost = 8, damageEffectiveness = 1.12, attackSpeedMultiplier = 20, levelRequirement = 84, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[28] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 1.137, duration = 12, manaCost = 8, damageEffectiveness = 1.14, attackSpeedMultiplier = 20, levelRequirement = 86, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[29] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 1.149, duration = 12, manaCost = 8, damageEffectiveness = 1.15, attackSpeedMultiplier = 20, levelRequirement = 88, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[30] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 1.162, duration = 12, manaCost = 8, damageEffectiveness = 1.16, attackSpeedMultiplier = 20, levelRequirement = 90, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[31] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 1.162, duration = 12, manaCost = 8, damageEffectiveness = 1.16, attackSpeedMultiplier = 20, levelRequirement = 91, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[32] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 1.174, duration = 12, manaCost = 8, damageEffectiveness = 1.17, attackSpeedMultiplier = 20, levelRequirement = 92, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[33] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 1.187, duration = 12, manaCost = 8, damageEffectiveness = 1.19, attackSpeedMultiplier = 20, levelRequirement = 93, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[34] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 1.199, duration = 12, manaCost = 8, damageEffectiveness = 1.2, attackSpeedMultiplier = 20, levelRequirement = 94, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[35] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 1.212, duration = 12, manaCost = 8, damageEffectiveness = 1.21, attackSpeedMultiplier = 20, levelRequirement = 95, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[36] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 1.224, duration = 12, manaCost = 9, damageEffectiveness = 1.22, attackSpeedMultiplier = 20, levelRequirement = 96, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[37] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 1.237, duration = 12, manaCost = 9, damageEffectiveness = 1.24, attackSpeedMultiplier = 20, levelRequirement = 97, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[38] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 1.249, duration = 12, manaCost = 9, damageEffectiveness = 1.25, attackSpeedMultiplier = 20, levelRequirement = 98, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[39] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 1.262, duration = 12, manaCost = 9, damageEffectiveness = 1.26, attackSpeedMultiplier = 20, levelRequirement = 99, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
		[40] = { 30, 50, 40, 15, 0.80000001192093, 1.2000000476837, 30, 0, -75, baseMultiplier = 1.274, duration = 12, manaCost = 9, damageEffectiveness = 1.27, attackSpeedMultiplier = 20, levelRequirement = 100, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, 1, }, },
	},
}
skills["ViperStrike"] = {
	name = "Viper Strike",
	color = 2,
	baseEffectiveness = 1.5,
	incrementalEffectiveness = 0.023299999535084,
	description = "Hits enemies, adding some of your physical damage as chaos damage and inflicting poison which will be affected by modifiers to skill duration. If dual wielding, will strike with both weapons. Requires a claw, dagger or sword.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Duration] = true, [SkillType.AttackCanRepeat] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.DamageOverTime] = true, [SkillType.ChaosSkill] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "debuff_skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["viper_strike_dual_wield_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "Condition", var = "DualWielding" }),
		},
		["viper_strike_dual_wield_attack_speed_+%_final"] = {
			mod("Speed", "MORE", nil, ModFlag.Attack, 0, { type = "Condition", var = "DualWielding" }),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		duration = true,
		chaos = true,
	},
	baseMods = {
		skill("poisonIsSkillEffect", true),
	},
	qualityStats = {
		{ "attack_speed_+%", 0.5 },
		{ "base_poison_duration_+%", 0.5 },
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_chaos",
		"base_chance_to_poison_on_hit_%",
		"base_skill_effect_duration",
		"melee_range_+",
		"attack_minimum_added_chaos_damage",
		"attack_maximum_added_chaos_damage",
		"viper_strike_dual_wield_damage_+%_final",
		"viper_strike_dual_wield_attack_speed_+%_final",
		"poison_duration_is_skill_duration",
		"skill_double_hits_when_dual_wielding",
	},
	levels = {
		[1] = { 50, 60, 4000, 0, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 0.9, baseMultiplier = 0.9, levelRequirement = 1, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[2] = { 50, 60, 4000, 0, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 0.92, baseMultiplier = 0.924, levelRequirement = 2, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[3] = { 50, 60, 4000, 0, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 0.95, baseMultiplier = 0.947, levelRequirement = 4, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[4] = { 50, 60, 4000, 0, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 0.97, baseMultiplier = 0.971, levelRequirement = 7, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[5] = { 50, 60, 4000, 0, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 0.99, baseMultiplier = 0.995, levelRequirement = 11, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[6] = { 50, 60, 4000, 0, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 1.02, baseMultiplier = 1.019, levelRequirement = 16, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[7] = { 50, 60, 4000, 1, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 1.04, baseMultiplier = 1.042, levelRequirement = 20, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[8] = { 50, 60, 4000, 1, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 1.07, baseMultiplier = 1.066, levelRequirement = 24, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[9] = { 50, 60, 4000, 1, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 1.09, baseMultiplier = 1.09, levelRequirement = 28, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[10] = { 50, 60, 4000, 1, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 1.11, baseMultiplier = 1.113, levelRequirement = 32, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[11] = { 50, 60, 4000, 1, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 1.14, baseMultiplier = 1.137, levelRequirement = 36, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[12] = { 50, 60, 4000, 1, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 1.16, baseMultiplier = 1.161, levelRequirement = 40, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[13] = { 50, 60, 4000, 1, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 1.18, baseMultiplier = 1.184, levelRequirement = 44, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[14] = { 50, 60, 4000, 2, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 1.21, baseMultiplier = 1.208, levelRequirement = 48, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[15] = { 50, 60, 4000, 2, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 1.23, baseMultiplier = 1.232, levelRequirement = 52, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[16] = { 50, 60, 4000, 2, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 1.26, baseMultiplier = 1.256, levelRequirement = 56, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[17] = { 50, 60, 4000, 2, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 1.28, baseMultiplier = 1.279, levelRequirement = 60, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[18] = { 50, 60, 4000, 2, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 1.3, baseMultiplier = 1.303, levelRequirement = 64, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[19] = { 50, 60, 4000, 2, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 1.33, baseMultiplier = 1.327, levelRequirement = 67, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[20] = { 50, 60, 4000, 2, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 1.35, baseMultiplier = 1.35, levelRequirement = 70, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[21] = { 50, 60, 4000, 3, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 1.37, baseMultiplier = 1.374, levelRequirement = 72, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[22] = { 50, 60, 4000, 3, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 1.4, baseMultiplier = 1.398, levelRequirement = 74, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[23] = { 50, 60, 4000, 3, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 1.42, baseMultiplier = 1.422, levelRequirement = 76, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[24] = { 50, 60, 4000, 3, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 1.45, baseMultiplier = 1.445, levelRequirement = 78, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[25] = { 50, 60, 4000, 3, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 1.47, baseMultiplier = 1.469, levelRequirement = 80, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[26] = { 50, 60, 4000, 3, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 1.49, baseMultiplier = 1.493, levelRequirement = 82, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[27] = { 50, 60, 4000, 3, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 1.52, baseMultiplier = 1.516, levelRequirement = 84, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[28] = { 50, 60, 4000, 4, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 1.54, baseMultiplier = 1.54, levelRequirement = 86, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[29] = { 50, 60, 4000, 4, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 1.56, baseMultiplier = 1.564, levelRequirement = 88, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[30] = { 50, 60, 4000, 4, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 1.59, baseMultiplier = 1.587, levelRequirement = 90, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[31] = { 50, 60, 4000, 4, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 1.59, baseMultiplier = 1.587, levelRequirement = 91, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[32] = { 50, 60, 4000, 4, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 1.61, baseMultiplier = 1.611, levelRequirement = 92, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[33] = { 50, 60, 4000, 4, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 1.64, baseMultiplier = 1.635, levelRequirement = 93, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[34] = { 50, 60, 4000, 4, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 1.66, baseMultiplier = 1.659, levelRequirement = 94, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[35] = { 50, 60, 4000, 5, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 1.68, baseMultiplier = 1.682, levelRequirement = 95, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[36] = { 50, 60, 4000, 5, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 1.71, baseMultiplier = 1.706, levelRequirement = 96, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[37] = { 50, 60, 4000, 5, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 1.73, baseMultiplier = 1.73, levelRequirement = 97, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[38] = { 50, 60, 4000, 5, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 1.75, baseMultiplier = 1.753, levelRequirement = 98, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[39] = { 50, 60, 4000, 5, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 1.78, baseMultiplier = 1.777, levelRequirement = 99, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
		[40] = { 50, 60, 4000, 5, 0.80000001192093, 1.2000000476837, -20, -30, damageEffectiveness = 1.8, baseMultiplier = 1.801, levelRequirement = 100, manaCost = 5, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, },
	},
}
skills["VolatileDead"] = {
	name = "Volatile Dead",
	color = 2,
	baseEffectiveness = 2.2228999137878,
	incrementalEffectiveness = 0.0337999984622,
	description = "Corpses near the targeted location explode, dealing damage in a small area and creating an orb which moves towards nearby enemies before dealing spell damage in a larger area. The explosion of the corpse is not affected by modifiers to spell damage, and cannot be reflected.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Hit] = true, [SkillType.Area] = true, [SkillType.SkillCanTrap] = true, [SkillType.SkillCanTotem] = true, [SkillType.SkillCanMine] = true, [SkillType.SpellCanRepeat] = true, [SkillType.Triggerable] = true, [SkillType.FireSkill] = true, [SkillType.SpellCanCascade] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.8,
	parts = {
		{
			name = "Spell",
			spell = true,
			cast = false,
		},
		{
			name = "Corpse Explosion",
			spell = false,
			cast =  true,
		},
	},
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
		skill("explodeCorpse", true, { type = "SkillPart", skillPart = 2 }),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 0.5 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"volatile_dead_base_number_of_corpses_to_consume",
		"corpse_explosion_monster_life_%",
		"is_area_damage",
		"base_skill_show_average_damage_instead_of_dps",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 12, manaCost = 9, statInterpolation = { 3, 3, 1, 1, }, },
		[2] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 15, manaCost = 10, statInterpolation = { 3, 3, 1, 1, }, },
		[3] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 19, manaCost = 12, statInterpolation = { 3, 3, 1, 1, }, },
		[4] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 23, manaCost = 13, statInterpolation = { 3, 3, 1, 1, }, },
		[5] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 27, manaCost = 14, statInterpolation = { 3, 3, 1, 1, }, },
		[6] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 31, manaCost = 15, statInterpolation = { 3, 3, 1, 1, }, },
		[7] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 35, manaCost = 16, statInterpolation = { 3, 3, 1, 1, }, },
		[8] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 38, manaCost = 17, statInterpolation = { 3, 3, 1, 1, }, },
		[9] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 41, manaCost = 18, statInterpolation = { 3, 3, 1, 1, }, },
		[10] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 44, manaCost = 19, statInterpolation = { 3, 3, 1, 1, }, },
		[11] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 47, manaCost = 20, statInterpolation = { 3, 3, 1, 1, }, },
		[12] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 50, manaCost = 20, statInterpolation = { 3, 3, 1, 1, }, },
		[13] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 53, manaCost = 21, statInterpolation = { 3, 3, 1, 1, }, },
		[14] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 56, manaCost = 22, statInterpolation = { 3, 3, 1, 1, }, },
		[15] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 59, manaCost = 23, statInterpolation = { 3, 3, 1, 1, }, },
		[16] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 62, manaCost = 24, statInterpolation = { 3, 3, 1, 1, }, },
		[17] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 64, manaCost = 25, statInterpolation = { 3, 3, 1, 1, }, },
		[18] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 66, manaCost = 25, statInterpolation = { 3, 3, 1, 1, }, },
		[19] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 68, manaCost = 26, statInterpolation = { 3, 3, 1, 1, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 70, manaCost = 26, statInterpolation = { 3, 3, 1, 1, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 72, manaCost = 27, statInterpolation = { 3, 3, 1, 1, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 74, manaCost = 27, statInterpolation = { 3, 3, 1, 1, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 76, manaCost = 28, statInterpolation = { 3, 3, 1, 1, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 78, manaCost = 29, statInterpolation = { 3, 3, 1, 1, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 80, manaCost = 29, statInterpolation = { 3, 3, 1, 1, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 82, manaCost = 30, statInterpolation = { 3, 3, 1, 1, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 84, manaCost = 30, statInterpolation = { 3, 3, 1, 1, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 86, manaCost = 31, statInterpolation = { 3, 3, 1, 1, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 88, manaCost = 32, statInterpolation = { 3, 3, 1, 1, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 90, manaCost = 32, statInterpolation = { 3, 3, 1, 1, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 91, manaCost = 32, statInterpolation = { 3, 3, 1, 1, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 92, manaCost = 33, statInterpolation = { 3, 3, 1, 1, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 93, manaCost = 33, statInterpolation = { 3, 3, 1, 1, }, },
		[34] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 94, manaCost = 33, statInterpolation = { 3, 3, 1, 1, }, },
		[35] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 95, manaCost = 34, statInterpolation = { 3, 3, 1, 1, }, },
		[36] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 96, manaCost = 34, statInterpolation = { 3, 3, 1, 1, }, },
		[37] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 97, manaCost = 34, statInterpolation = { 3, 3, 1, 1, }, },
		[38] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 98, manaCost = 34, statInterpolation = { 3, 3, 1, 1, }, },
		[39] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 99, manaCost = 35, statInterpolation = { 3, 3, 1, 1, }, },
		[40] = { 0.80000001192093, 1.2000000476837, 3, 3, damageEffectiveness = 1.2, critChance = 5, levelRequirement = 100, manaCost = 35, statInterpolation = { 3, 3, 1, 1, }, },
	},
}
skills["WhirlingBlades"] = {
	name = "Whirling Blades",
	color = 2,
	description = "Dive through enemies, dealing weapon damage. Only works with daggers, claws and one handed swords. Cannot be supported by Multistrike.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MovementSkill] = true, [SkillType.TravelSkill] = true, },
	weaponTypes = {
		["Thrusting One Handed Sword"] = true,
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.6,
	baseFlags = {
		attack = true,
		melee = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "attack_speed_+%", 0.5 },
	},
	stats = {
		"additional_weapon_base_attack_time_ms",
		"ignores_proximity_shield",
		"base_skill_show_average_damage_instead_of_dps",
	},
	levels = {
		[1] = { 600, manaCost = 10, levelRequirement = 10, statInterpolation = { 1, }, },
		[2] = { 600, damageEffectiveness = 1.01, baseMultiplier = 1.011, levelRequirement = 13, manaCost = 10, statInterpolation = { 1, }, },
		[3] = { 600, damageEffectiveness = 1.02, baseMultiplier = 1.021, levelRequirement = 17, manaCost = 10, statInterpolation = { 1, }, },
		[4] = { 600, damageEffectiveness = 1.03, baseMultiplier = 1.032, levelRequirement = 21, manaCost = 10, statInterpolation = { 1, }, },
		[5] = { 600, damageEffectiveness = 1.04, baseMultiplier = 1.042, levelRequirement = 25, manaCost = 10, statInterpolation = { 1, }, },
		[6] = { 600, damageEffectiveness = 1.05, baseMultiplier = 1.053, levelRequirement = 29, manaCost = 10, statInterpolation = { 1, }, },
		[7] = { 600, damageEffectiveness = 1.06, baseMultiplier = 1.063, levelRequirement = 33, manaCost = 10, statInterpolation = { 1, }, },
		[8] = { 600, damageEffectiveness = 1.07, baseMultiplier = 1.074, levelRequirement = 36, manaCost = 10, statInterpolation = { 1, }, },
		[9] = { 600, damageEffectiveness = 1.08, baseMultiplier = 1.084, levelRequirement = 39, manaCost = 10, statInterpolation = { 1, }, },
		[10] = { 600, damageEffectiveness = 1.09, baseMultiplier = 1.095, levelRequirement = 42, manaCost = 10, statInterpolation = { 1, }, },
		[11] = { 600, damageEffectiveness = 1.11, baseMultiplier = 1.105, levelRequirement = 45, manaCost = 10, statInterpolation = { 1, }, },
		[12] = { 600, damageEffectiveness = 1.12, baseMultiplier = 1.116, levelRequirement = 48, manaCost = 10, statInterpolation = { 1, }, },
		[13] = { 600, damageEffectiveness = 1.13, baseMultiplier = 1.126, levelRequirement = 51, manaCost = 10, statInterpolation = { 1, }, },
		[14] = { 600, damageEffectiveness = 1.14, baseMultiplier = 1.137, levelRequirement = 54, manaCost = 10, statInterpolation = { 1, }, },
		[15] = { 600, damageEffectiveness = 1.15, baseMultiplier = 1.147, levelRequirement = 57, manaCost = 10, statInterpolation = { 1, }, },
		[16] = { 600, damageEffectiveness = 1.16, baseMultiplier = 1.158, levelRequirement = 60, manaCost = 10, statInterpolation = { 1, }, },
		[17] = { 600, damageEffectiveness = 1.17, baseMultiplier = 1.168, levelRequirement = 63, manaCost = 10, statInterpolation = { 1, }, },
		[18] = { 600, damageEffectiveness = 1.18, baseMultiplier = 1.179, levelRequirement = 66, manaCost = 10, statInterpolation = { 1, }, },
		[19] = { 600, damageEffectiveness = 1.19, baseMultiplier = 1.189, levelRequirement = 68, manaCost = 10, statInterpolation = { 1, }, },
		[20] = { 600, damageEffectiveness = 1.2, baseMultiplier = 1.2, levelRequirement = 70, manaCost = 10, statInterpolation = { 1, }, },
		[21] = { 600, damageEffectiveness = 1.21, baseMultiplier = 1.211, levelRequirement = 72, manaCost = 10, statInterpolation = { 1, }, },
		[22] = { 600, damageEffectiveness = 1.22, baseMultiplier = 1.221, levelRequirement = 74, manaCost = 10, statInterpolation = { 1, }, },
		[23] = { 600, damageEffectiveness = 1.23, baseMultiplier = 1.232, levelRequirement = 76, manaCost = 10, statInterpolation = { 1, }, },
		[24] = { 600, damageEffectiveness = 1.24, baseMultiplier = 1.242, levelRequirement = 78, manaCost = 10, statInterpolation = { 1, }, },
		[25] = { 600, damageEffectiveness = 1.25, baseMultiplier = 1.253, levelRequirement = 80, manaCost = 10, statInterpolation = { 1, }, },
		[26] = { 600, damageEffectiveness = 1.26, baseMultiplier = 1.263, levelRequirement = 82, manaCost = 10, statInterpolation = { 1, }, },
		[27] = { 600, damageEffectiveness = 1.27, baseMultiplier = 1.274, levelRequirement = 84, manaCost = 10, statInterpolation = { 1, }, },
		[28] = { 600, damageEffectiveness = 1.28, baseMultiplier = 1.284, levelRequirement = 86, manaCost = 10, statInterpolation = { 1, }, },
		[29] = { 600, damageEffectiveness = 1.29, baseMultiplier = 1.295, levelRequirement = 88, manaCost = 10, statInterpolation = { 1, }, },
		[30] = { 600, damageEffectiveness = 1.31, baseMultiplier = 1.305, levelRequirement = 90, manaCost = 10, statInterpolation = { 1, }, },
		[31] = { 600, damageEffectiveness = 1.31, baseMultiplier = 1.311, levelRequirement = 91, manaCost = 10, statInterpolation = { 1, }, },
		[32] = { 600, damageEffectiveness = 1.32, baseMultiplier = 1.316, levelRequirement = 92, manaCost = 10, statInterpolation = { 1, }, },
		[33] = { 600, damageEffectiveness = 1.32, baseMultiplier = 1.321, levelRequirement = 93, manaCost = 10, statInterpolation = { 1, }, },
		[34] = { 600, damageEffectiveness = 1.33, baseMultiplier = 1.326, levelRequirement = 94, manaCost = 10, statInterpolation = { 1, }, },
		[35] = { 600, damageEffectiveness = 1.33, baseMultiplier = 1.332, levelRequirement = 95, manaCost = 10, statInterpolation = { 1, }, },
		[36] = { 600, damageEffectiveness = 1.34, baseMultiplier = 1.337, levelRequirement = 96, manaCost = 10, statInterpolation = { 1, }, },
		[37] = { 600, damageEffectiveness = 1.34, baseMultiplier = 1.342, levelRequirement = 97, manaCost = 10, statInterpolation = { 1, }, },
		[38] = { 600, damageEffectiveness = 1.35, baseMultiplier = 1.347, levelRequirement = 98, manaCost = 10, statInterpolation = { 1, }, },
		[39] = { 600, damageEffectiveness = 1.35, baseMultiplier = 1.353, levelRequirement = 99, manaCost = 10, statInterpolation = { 1, }, },
		[40] = { 600, damageEffectiveness = 1.36, baseMultiplier = 1.358, levelRequirement = 100, manaCost = 10, statInterpolation = { 1, }, },
	},
}
skills["WildStrike"] = {
	name = "Wild Strike",
	color = 2,
	description = "Your melee weapon strikes enemies, converting physical damage to a random element. Then, depending on the element chosen, it releases a fiery explosion, an arcing bolt of lightning, or an icy wave.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.AttackCanRepeat] = true, [SkillType.Melee] = true, [SkillType.LightningSkill] = true, [SkillType.ColdSkill] = true, [SkillType.FireSkill] = true, [SkillType.Projectile] = true, [SkillType.Area] = true, [SkillType.Chaining] = true, [SkillType.ProjectileAttack] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Fire hit",
			melee = true,
			projectile = false,
			chaining = false,
			area = false,
		},
		{
			name = "Fire explosion",
			melee = false,
			projectile = false,
			chaining = false,
			area = true,
		},
		{
			name = "Lightning hit",
			melee = true,
			projectile = false,
			chaining = false,
			area = false,
		},
		{
			name = "Lightning bolt",
			melee = false,
			projectile = false,
			chaining = true,
			area = false,
		},
		{
			name = "Cold hit",
			melee = true,
			projectile = false,
			chaining = false,
			area = false,
		},
		{
			name = "Icy wave",
			melee = false,
			projectile = true,
			chaining = false,
			area = false,
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
		chaining = true,
		area = true,
	},
	baseMods = {
		mod("PhysicalDamageConvertToFire", "BASE", 100, 0, 0, { type = "SkillPart", skillPartList =  { 1, 2 } }),
		mod("PhysicalDamageConvertToLightning", "BASE", 100, 0, 0, { type = "SkillPart", skillPartList =  { 3, 4 } }),
		mod("PhysicalDamageConvertToCold", "BASE", 100, 0, 0, { type = "SkillPart", skillPartList =  { 5, 6 } }),
	},
	qualityStats = {
		{ "elemental_damage_+%", 1 },
	},
	stats = {
		"elemental_strike_physical_damage_%_to_convert",
		"number_of_chains",
		"fixed_projectile_spread",
		"number_of_additional_projectiles",
		"base_skill_area_of_effect_+%",
		"melee_range_+",
		"show_number_of_projectiles",
		"always_pierce",
	},
	levels = {
		[1] = { 100, 4, 70, 2, 0, 0, damageEffectiveness = 1.6, baseMultiplier = 1.6, levelRequirement = 28, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[2] = { 100, 4, 70, 2, 1, 0, damageEffectiveness = 1.61, baseMultiplier = 1.613, levelRequirement = 31, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[3] = { 100, 4, 70, 2, 2, 0, damageEffectiveness = 1.63, baseMultiplier = 1.626, levelRequirement = 34, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[4] = { 100, 4, 70, 2, 3, 0, damageEffectiveness = 1.64, baseMultiplier = 1.639, levelRequirement = 37, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[5] = { 100, 4, 70, 2, 4, 0, damageEffectiveness = 1.65, baseMultiplier = 1.653, levelRequirement = 40, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[6] = { 100, 4, 70, 2, 5, 0, damageEffectiveness = 1.67, baseMultiplier = 1.666, levelRequirement = 42, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[7] = { 100, 5, 70, 2, 6, 1, damageEffectiveness = 1.68, baseMultiplier = 1.679, levelRequirement = 44, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[8] = { 100, 5, 70, 2, 7, 1, damageEffectiveness = 1.69, baseMultiplier = 1.692, levelRequirement = 46, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[9] = { 100, 5, 70, 2, 8, 1, damageEffectiveness = 1.71, baseMultiplier = 1.705, levelRequirement = 48, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[10] = { 100, 5, 70, 2, 9, 1, damageEffectiveness = 1.72, baseMultiplier = 1.718, levelRequirement = 50, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[11] = { 100, 5, 70, 2, 10, 1, damageEffectiveness = 1.73, baseMultiplier = 1.732, levelRequirement = 52, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[12] = { 100, 5, 70, 2, 11, 1, damageEffectiveness = 1.74, baseMultiplier = 1.745, levelRequirement = 54, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[13] = { 100, 6, 70, 2, 12, 1, damageEffectiveness = 1.76, baseMultiplier = 1.758, levelRequirement = 56, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[14] = { 100, 6, 70, 2, 13, 2, damageEffectiveness = 1.77, baseMultiplier = 1.771, levelRequirement = 58, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[15] = { 100, 6, 70, 2, 14, 2, damageEffectiveness = 1.78, baseMultiplier = 1.784, levelRequirement = 60, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[16] = { 100, 6, 70, 2, 15, 2, damageEffectiveness = 1.8, baseMultiplier = 1.797, levelRequirement = 62, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[17] = { 100, 6, 70, 2, 16, 2, damageEffectiveness = 1.81, baseMultiplier = 1.811, levelRequirement = 64, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[18] = { 100, 6, 70, 2, 17, 2, damageEffectiveness = 1.82, baseMultiplier = 1.824, levelRequirement = 66, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[19] = { 100, 7, 70, 2, 18, 2, damageEffectiveness = 1.84, baseMultiplier = 1.837, levelRequirement = 68, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[20] = { 100, 7, 70, 2, 19, 2, damageEffectiveness = 1.85, baseMultiplier = 1.85, levelRequirement = 70, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[21] = { 100, 7, 70, 2, 20, 3, damageEffectiveness = 1.86, baseMultiplier = 1.863, levelRequirement = 72, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[22] = { 100, 7, 70, 2, 21, 3, damageEffectiveness = 1.88, baseMultiplier = 1.876, levelRequirement = 74, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[23] = { 100, 7, 70, 2, 22, 3, damageEffectiveness = 1.89, baseMultiplier = 1.889, levelRequirement = 76, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[24] = { 100, 7, 70, 2, 23, 3, damageEffectiveness = 1.9, baseMultiplier = 1.903, levelRequirement = 78, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[25] = { 100, 8, 70, 2, 24, 3, damageEffectiveness = 1.92, baseMultiplier = 1.916, levelRequirement = 80, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[26] = { 100, 8, 70, 2, 25, 3, damageEffectiveness = 1.93, baseMultiplier = 1.929, levelRequirement = 82, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[27] = { 100, 8, 70, 2, 26, 3, damageEffectiveness = 1.94, baseMultiplier = 1.942, levelRequirement = 84, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[28] = { 100, 8, 70, 2, 27, 4, damageEffectiveness = 1.96, baseMultiplier = 1.955, levelRequirement = 86, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[29] = { 100, 8, 70, 2, 28, 4, damageEffectiveness = 1.97, baseMultiplier = 1.968, levelRequirement = 88, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[30] = { 100, 8, 70, 2, 29, 4, damageEffectiveness = 1.98, baseMultiplier = 1.982, levelRequirement = 90, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[31] = { 100, 8, 70, 2, 29, 4, damageEffectiveness = 1.99, baseMultiplier = 1.988, levelRequirement = 91, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[32] = { 100, 9, 70, 2, 30, 4, damageEffectiveness = 1.99, baseMultiplier = 1.995, levelRequirement = 92, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[33] = { 100, 9, 70, 2, 30, 4, damageEffectiveness = 2, baseMultiplier = 2.001, levelRequirement = 93, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[34] = { 100, 9, 70, 2, 31, 4, damageEffectiveness = 2.01, baseMultiplier = 2.008, levelRequirement = 94, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[35] = { 100, 9, 70, 2, 31, 5, damageEffectiveness = 2.01, baseMultiplier = 2.014, levelRequirement = 95, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[36] = { 100, 9, 70, 2, 32, 5, damageEffectiveness = 2.02, baseMultiplier = 2.021, levelRequirement = 96, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[37] = { 100, 9, 70, 2, 32, 5, damageEffectiveness = 2.03, baseMultiplier = 2.028, levelRequirement = 97, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[38] = { 100, 9, 70, 2, 33, 5, damageEffectiveness = 2.03, baseMultiplier = 2.034, levelRequirement = 98, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[39] = { 100, 9, 70, 2, 33, 5, damageEffectiveness = 2.04, baseMultiplier = 2.041, levelRequirement = 99, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
		[40] = { 100, 9, 70, 2, 34, 5, damageEffectiveness = 2.05, baseMultiplier = 2.047, levelRequirement = 100, manaCost = 6, statInterpolation = { 1, 1, 1, 1, 1, 1, }, },
	},
}
skills["Slither"] = {
	name = "Withering Step",
	color = 2,
	description = "Removes any existing Elusive buff before applying both Elusive and a buff that grants Phasing. While you have this buff, monsters that enter an area around you will be Withered. Using a skill or losing the Elusive buff ends this skill's effects. Shares a cooldown with other Blink skills.",
	skillTypes = { [SkillType.TravelSkill] = true, [SkillType.Buff] = true, [SkillType.Instant] = true, [SkillType.Area] = true, [SkillType.ChaosSkill] = true, [SkillType.MovementSkill] = true, [SkillType.BlinkSkill] = true, [SkillType.Spell] = true, [SkillType.Triggerable] = true, [SkillType.Duration] = true, },
	statDescriptionScope = "buff_skill_stat_descriptions",
	castTime = 0,
	baseFlags = {
		spell = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "elusive_effect_+%", 0.5 },
	},
	stats = {
		"active_skill_base_radius_+",
		"slither_wither_stacks",
		"elusive_effect_+%",
		"active_skill_withered_base_duration_ms",
		"phase_through_objects",
		"instant_skill_is_added_to_held_skills_list",
		"display_this_skill_cooldown_does_not_recover_during_buff",
		"display_removes_and_grants_elusive_when_used",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 0, 4, 0, 3000, cooldown = 3, levelRequirement = 10, manaCost = 8, statInterpolation = { 1, 1, 1, 1, }, },
		[2] = { 0, 4, 2, 3000, cooldown = 3, levelRequirement = 13, manaCost = 9, statInterpolation = { 1, 1, 1, 1, }, },
		[3] = { 1, 4, 4, 3000, cooldown = 3, levelRequirement = 17, manaCost = 10, statInterpolation = { 1, 1, 1, 1, }, },
		[4] = { 1, 4, 6, 3000, cooldown = 3, levelRequirement = 21, manaCost = 11, statInterpolation = { 1, 1, 1, 1, }, },
		[5] = { 1, 4, 8, 3000, cooldown = 3, levelRequirement = 25, manaCost = 12, statInterpolation = { 1, 1, 1, 1, }, },
		[6] = { 2, 4, 10, 3000, cooldown = 3, levelRequirement = 29, manaCost = 13, statInterpolation = { 1, 1, 1, 1, }, },
		[7] = { 2, 5, 12, 3000, cooldown = 3, levelRequirement = 33, manaCost = 14, statInterpolation = { 1, 1, 1, 1, }, },
		[8] = { 2, 5, 14, 3000, cooldown = 3, levelRequirement = 36, manaCost = 14, statInterpolation = { 1, 1, 1, 1, }, },
		[9] = { 3, 5, 16, 3000, cooldown = 3, levelRequirement = 39, manaCost = 15, statInterpolation = { 1, 1, 1, 1, }, },
		[10] = { 3, 5, 18, 3000, cooldown = 3, levelRequirement = 42, manaCost = 16, statInterpolation = { 1, 1, 1, 1, }, },
		[11] = { 3, 5, 20, 3000, cooldown = 3, levelRequirement = 45, manaCost = 17, statInterpolation = { 1, 1, 1, 1, }, },
		[12] = { 4, 5, 22, 3000, cooldown = 3, levelRequirement = 48, manaCost = 17, statInterpolation = { 1, 1, 1, 1, }, },
		[13] = { 4, 5, 24, 3000, cooldown = 3, levelRequirement = 51, manaCost = 18, statInterpolation = { 1, 1, 1, 1, }, },
		[14] = { 4, 6, 26, 3000, cooldown = 3, levelRequirement = 54, manaCost = 19, statInterpolation = { 1, 1, 1, 1, }, },
		[15] = { 5, 6, 28, 3000, cooldown = 3, levelRequirement = 57, manaCost = 20, statInterpolation = { 1, 1, 1, 1, }, },
		[16] = { 5, 6, 30, 3000, cooldown = 3, levelRequirement = 60, manaCost = 20, statInterpolation = { 1, 1, 1, 1, }, },
		[17] = { 5, 6, 32, 3000, cooldown = 3, levelRequirement = 63, manaCost = 21, statInterpolation = { 1, 1, 1, 1, }, },
		[18] = { 6, 6, 34, 3000, cooldown = 3, levelRequirement = 66, manaCost = 22, statInterpolation = { 1, 1, 1, 1, }, },
		[19] = { 6, 6, 36, 3000, cooldown = 3, levelRequirement = 68, manaCost = 22, statInterpolation = { 1, 1, 1, 1, }, },
		[20] = { 6, 6, 38, 3000, cooldown = 3, levelRequirement = 70, manaCost = 23, statInterpolation = { 1, 1, 1, 1, }, },
		[21] = { 7, 7, 40, 3000, cooldown = 3, levelRequirement = 72, manaCost = 24, statInterpolation = { 1, 1, 1, 1, }, },
		[22] = { 7, 7, 42, 3000, cooldown = 3, levelRequirement = 74, manaCost = 24, statInterpolation = { 1, 1, 1, 1, }, },
		[23] = { 7, 7, 44, 3000, cooldown = 3, levelRequirement = 76, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[24] = { 8, 7, 46, 3000, cooldown = 3, levelRequirement = 78, manaCost = 25, statInterpolation = { 1, 1, 1, 1, }, },
		[25] = { 8, 7, 48, 3000, cooldown = 3, levelRequirement = 80, manaCost = 26, statInterpolation = { 1, 1, 1, 1, }, },
		[26] = { 8, 7, 50, 3000, cooldown = 3, levelRequirement = 82, manaCost = 26, statInterpolation = { 1, 1, 1, 1, }, },
		[27] = { 9, 7, 52, 3000, cooldown = 3, levelRequirement = 84, manaCost = 27, statInterpolation = { 1, 1, 1, 1, }, },
		[28] = { 9, 8, 54, 3000, cooldown = 3, levelRequirement = 86, manaCost = 27, statInterpolation = { 1, 1, 1, 1, }, },
		[29] = { 9, 8, 56, 3000, cooldown = 3, levelRequirement = 88, manaCost = 28, statInterpolation = { 1, 1, 1, 1, }, },
		[30] = { 10, 8, 58, 3000, cooldown = 3, levelRequirement = 90, manaCost = 28, statInterpolation = { 1, 1, 1, 1, }, },
		[31] = { 10, 8, 59, 3000, cooldown = 3, levelRequirement = 91, manaCost = 28, statInterpolation = { 1, 1, 1, 1, }, },
		[32] = { 10, 8, 60, 3000, cooldown = 3, levelRequirement = 92, manaCost = 29, statInterpolation = { 1, 1, 1, 1, }, },
		[33] = { 11, 8, 61, 3000, cooldown = 3, levelRequirement = 93, manaCost = 29, statInterpolation = { 1, 1, 1, 1, }, },
		[34] = { 11, 8, 62, 3000, cooldown = 3, levelRequirement = 94, manaCost = 29, statInterpolation = { 1, 1, 1, 1, }, },
		[35] = { 11, 8, 63, 3000, cooldown = 3, levelRequirement = 95, manaCost = 29, statInterpolation = { 1, 1, 1, 1, }, },
		[36] = { 12, 8, 64, 3000, cooldown = 3, levelRequirement = 96, manaCost = 30, statInterpolation = { 1, 1, 1, 1, }, },
		[37] = { 12, 8, 65, 3000, cooldown = 3, levelRequirement = 97, manaCost = 30, statInterpolation = { 1, 1, 1, 1, }, },
		[38] = { 12, 8, 66, 3000, cooldown = 3, levelRequirement = 98, manaCost = 30, statInterpolation = { 1, 1, 1, 1, }, },
		[39] = { 13, 8, 67, 3000, cooldown = 3, levelRequirement = 99, manaCost = 30, statInterpolation = { 1, 1, 1, 1, }, },
		[40] = { 13, 9, 68, 3000, cooldown = 3, levelRequirement = 100, manaCost = 31, statInterpolation = { 1, 1, 1, 1, }, },
	},
}